/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.rendering.api;

import com.android.ide.common.rendering.api.PluralsResourceValue;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValueImpl;
import com.android.resources.ResourceType;
import java.util.ArrayList;
import java.util.List;

public class PluralsResourceValueImpl
extends ResourceValueImpl
implements PluralsResourceValue {
    private final List<String> quantities = new ArrayList<String>();
    private final List<String> values = new ArrayList<String>();

    public PluralsResourceValueImpl(ResourceNamespace namespace, String name, String value, String libraryName) {
        super(namespace, ResourceType.PLURALS, name, value, libraryName);
    }

    public PluralsResourceValueImpl(ResourceReference reference, String value, String libraryName) {
        super(reference, value, libraryName);
        assert (reference.getResourceType() == ResourceType.PLURALS);
    }

    public void addPlural(String quantity, String value) {
        this.quantities.add(quantity);
        this.values.add(value);
    }

    @Override
    public int getPluralsCount() {
        return this.quantities.size();
    }

    @Override
    public String getQuantity(int index) {
        return this.quantities.get(index);
    }

    @Override
    public String getValue(int index) {
        return this.values.get(index);
    }

    @Override
    public String getValue(String quantity) {
        assert (this.quantities.size() == this.values.size());
        int n = this.quantities.size();
        for (int i = 0; i < n; ++i) {
            if (!quantity.equals(this.quantities.get(i))) continue;
            return this.values.get(i);
        }
        return null;
    }

    @Override
    public String getValue() {
        if (super.getValue() == null && !this.values.isEmpty()) {
            return this.getValue(0);
        }
        return super.getValue();
    }
}

