/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.devkit.toolwindow;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.ide.DataManager;
import com.intellij.internal.statistic.StatisticsBundle;
import com.intellij.internal.statistic.devkit.toolwindow.StatisticsLogGroupActionsProvider;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.awt.RelativePoint;
import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JFrame;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0012B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001a\u0010\u000f\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/internal/statistic/devkit/toolwindow/StatisticsGroupHyperlinkInfo;", "Lcom/intellij/execution/filters/HyperlinkInfo;", "groupId", "", "eventId", "eventData", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "lineNumber", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/openapi/vfs/VirtualFile;I)V", "navigate", "", "project", "Lcom/intellij/openapi/project/Project;", "showPopup", "actionGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "OpenGroupScheme", "intellij.platform.statistics.devkit"})
public final class StatisticsGroupHyperlinkInfo
implements HyperlinkInfo {
    private final String groupId;
    private final String eventId;
    private final String eventData;
    private final VirtualFile file;
    private final int lineNumber;

    /*
     * WARNING - void declaration
     */
    public void navigate(@NotNull Project project) {
        void $this$flatMapTo$iv$iv;
        StatisticsLogGroupActionsProvider it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        List list = StatisticsLogGroupActionsProvider.Companion.getEP_NAME().getExtensionList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"StatisticsLogGroupAction\u2026der.EP_NAME.extensionList");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (StatisticsLogGroupActionsProvider)element$iv$iv;
            boolean bl = false;
            if (!PluginInfoDetectorKt.getPluginInfo(it.getClass()).isDevelopedByJetBrains()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (StatisticsLogGroupActionsProvider)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getActions(this.groupId, this.eventId, this.eventData);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List actions = (List)destination$iv$iv;
        if (actions.isEmpty()) {
            new OpenFileHyperlinkInfo(project, this.file, this.lineNumber).navigate(project);
        } else {
            DefaultActionGroup group = new DefaultActionGroup();
            group.addAll((Collection)actions);
            group.add((AnAction)new OpenGroupScheme(project, this.file, this.lineNumber));
            this.showPopup(project, (ActionGroup)group);
        }
    }

    private final void showPopup(Project project, ActionGroup actionGroup) {
        DataManager dataManager = DataManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)dataManager, (String)"DataManager.getInstance()");
        dataManager.getDataContextFromFocusAsync().onSuccess(new Consumer(actionGroup, project){
            final /* synthetic */ ActionGroup $actionGroup;
            final /* synthetic */ Project $project;

            public final void accept(DataContext dataContext) {
                Point mousePosition;
                ListPopup listPopup = JBPopupFactory.getInstance().createActionGroupPopup(null, this.$actionGroup, dataContext, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true);
                Intrinsics.checkNotNullExpressionValue((Object)listPopup, (String)"JBPopupFactory.getInstan\u2026ionAid.SPEEDSEARCH, true)");
                ListPopup popup = listPopup;
                JFrame frame = WindowManager.getInstance().getFrame(this.$project);
                if (frame != null && (mousePosition = frame.getMousePosition()) != null) {
                    popup.show(new RelativePoint((Component)frame, mousePosition));
                }
            }
            {
                this.$actionGroup = actionGroup;
                this.$project = project;
            }
        });
    }

    public StatisticsGroupHyperlinkInfo(@NotNull String groupId, @NotNull String eventId, @NotNull String eventData, @NotNull VirtualFile file, int lineNumber) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        Intrinsics.checkNotNullParameter((Object)eventData, (String)"eventData");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.groupId = groupId;
        this.eventId = eventId;
        this.eventData = eventData;
        this.file = file;
        this.lineNumber = lineNumber;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/internal/statistic/devkit/toolwindow/StatisticsGroupHyperlinkInfo$OpenGroupScheme;", "Lcom/intellij/openapi/actionSystem/AnAction;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "lineNumber", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;I)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.platform.statistics.devkit"})
    public static final class OpenGroupScheme
    extends AnAction {
        private final Project project;
        private final VirtualFile file;
        private final int lineNumber;

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            new OpenFileHyperlinkInfo(this.project, this.file, this.lineNumber).navigate(this.project);
        }

        public OpenGroupScheme(@NotNull Project project, @NotNull VirtualFile file, int lineNumber) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            super(StatisticsBundle.message((String)"stats.navigate.to.group.scheme", (Object[])new Object[0]));
            this.project = project;
            this.file = file;
            this.lineNumber = lineNumber;
        }
    }
}

