### Copyright  (C) 2018 Intel Corporation. All rights reserved.
###
### The information and source code contained herein is the exclusive
### property of Intel Corporation and may not be disclosed, examined
### or reproduced in whole or in part without explicit written authorization
### from the company.
###
###

include(CMakeParseArguments)

# Clears subset list
macro( def_init_install_subsets )
  if (IL0_PREBUILT_COMPONENTS_STRUCTURE STREQUAL "install")
     set(COPY_FROM_INSTALL TRUE)
  else()
     set(COPY_FROM_INSTALL FALSE)
  endif()
  set(TARG_SUBSET_LIST)
endmacro( def_init_install_subsets )


# Walk subsets and create install targets for lib and headers
# TARG_SUBSET_LIST - list of file subsets to install. A subset is just some confinient identifier name.
# Per each "subset" in TARG_SUBSET_LIST the followng two groups of variables expected to be defined.
# 1) library files
# COMMONLIB_SRCDIR_${subset}  - source directory for lib files (relative to CRUNLIB_DIR)
# COMMONLIB_INSTDIR_${subset} - install directory for lib files (relative to install prefix)
# COMMONLIB_FILES_${subset}   - list of lib files to install
#
# 2) header files
# COMMONINC_SRCDIR_${subset}    - source directory for header files (relative to CRUNLIB_DIR)
# COMMONINC_INSTDIR_${subset}   - install directory for header files (relative to install prefix)
# COMMONINC_FILES_${subset}     - list of headers installed

# The macro uses variable IL0_PREBUILT_COMPONENTS_PREFIX which is full path to prebuilt
# components.
# For example "/archive/deploy_mainline/efi2linux/20180603_000000/build/linux_prod/linux/"
# when source of IL0 compiler components is some archieved compiler build
# or "/rdrive/crunlib/mainline_20180603" for crunlib.
#
# For the former case IL0_PREBUILT_COMPONENTS_STRUCTURE variable should be
# set to "install" value which practically means that we use *_INSTDIR_${subset}
# to locate files at source rather than *_SRCDIR_${subset}.
# Internal COPY_FROM_INSTALL variable is set based on it which tells us
# that we are copying from same directory structre as installation structure.
#

macro( def_add_install_targets )
  foreach( subset ${TARG_SUBSET_LIST} )
    set( src_files)
    foreach( f ${COMMONLIB_FILES_${subset}} )
      if ( ${COPY_FROM_INSTALL})
        if ( (subset MATCHES "intel64") AND (DEFINED IL0_PREBUILT_LIBIRC_COMPONENTS_PREFIX) )
          set( src ${IL0_PREBUILT_LIBIRC_COMPONENTS_PREFIX}/${COMMONLIB_INSTDIR_${subset}}/${f})
        else()
          set( src ${IL0_PREBUILT_COMPONENTS_PREFIX}/${COMMONLIB_INSTDIR_${subset}}/${f})
        endif()
      else()
        if ( (subset MATCHES "intel64") AND (DEFINED IL0_PREBUILT_LIBIRC_COMPONENTS_PREFIX) )
          set( src ${IL0_PREBUILT_LIBIRC_COMPONENTS_PREFIX}/${COMMONLIB_SRCDIR_${subset}}/${f})
        else()
          set( src ${IL0_PREBUILT_COMPONENTS_PREFIX}/${COMMONLIB_SRCDIR_${subset}}/${f})
        endif()
      endif()

      list(APPEND src_files ${src})
    endforeach( f )

    if ( src_files )
      install( FILES ${src_files}
               COMPONENT xdev-il0-llvm-common-lib
               DESTINATION ${COMMONLIB_INSTDIR_${subset}} )
    endif()

    set( src_files )
    foreach( f ${COMMONINC_FILES_${subset}} )
      if ( ${COPY_FROM_INSTALL})
        set( src ${IL0_PREBUILT_COMPONENTS_PREFIX}/${COMMONINC_INSTDIR_${subset}}/${f})
      else()
        set( src ${IL0_PREBUILT_COMPONENTS_PREFIX}/${COMMONINC_SRCDIR_${subset}}/${f})
      endif()


      list(APPEND src_files ${src})
    endforeach( f )

    if ( src_files )
      install( FILES ${src_files}
               COMPONENT xdev-il0-llvm-common-headers
               DESTINATION ${COMMONINC_INSTDIR_${subset}} )
    endif()
  endforeach( subset )
endmacro( def_add_install_targets )


# Add install files subsets
#  Here are two possible uses of this macro
#  1) Add subset of header files to install
#  def_add_install_subset( x86 INC
#         SRCDIR "include"
#         INSTDIR "compiler/include"
#         ${compiler_header_files} )
#
#  2) Add subset of lib files to install
#
# Differentiation between LIB vs INC is conventional: they finally split
# into two install components (see def_add_install_targets for details)

macro( def_add_install_subset subset )
  cmake_parse_arguments(ARG "LIB;INC" "SRCDIR;INSTDIR" "" ${ARGN})

  list( FIND TARG_SUBSET_LIST ${subset} idx )
  if( idx LESS 0 )
    list( APPEND TARG_SUBSET_LIST ${subset} )
  endif()

  if( NOT ARG_SRCDIR )
    message(FATAL_ERROR "def_add_install_subset: SRCDIR argument is required")
  endif()

  if( NOT ARG_INSTDIR )
    message(FATAL_ERROR "def_add_install_subset: INSTDIR argument is required" )
  endif()

  if( ARG_LIB )
    if ( DEFINED COMMONLIB_SRCDIR_${subset} )
       message(FATAL_ERROR "def_add_install_subset: LIB subset ${subset} has already been added" )
    endif()

    set( COMMONLIB_SRCDIR_${subset} ${ARG_SRCDIR} )
    set( COMMONLIB_INSTDIR_${subset} ${ARG_INSTDIR} )
    set( COMMONLIB_FILES_${subset} ${ARG_UNPARSED_ARGUMENTS} )

  elseif( ARG_INC )

    if ( DEFINED COMMONINC_SRCDIR_${subset} )
       message(FATAL_ERROR "def_add_install_subset: INC subset ${subset} has already been added" )
    endif()

    set( COMMONINC_SRCDIR_${subset} ${ARG_SRCDIR} )
    set( COMMONINC_INSTDIR_${subset} ${ARG_INSTDIR} )
    set( COMMONINC_FILES_${subset} ${ARG_UNPARSED_ARGUMENTS} )

  else()
       message(FATAL_ERROR "def_add_install_subset: unspecified type for subset ${subset}" )
  endif()
endmacro( def_add_install_subset subset )

