#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 hledger-iadd
version:              1.3.17
visibility:           public
id:                   hledger-iadd-1.3.17-JMz011ZGJKJ9aZ2PWP11VO
key:                  hledger-iadd-1.3.17-JMz011ZGJKJ9aZ2PWP11VO
license:              BSD-3-Clause
copyright:            2018 Hans-Peter Deifel
maintainer:           Hans-Peter Deifel <hpd@hpdeifel.de>
author:               Hans-Peter Deifel <hpd@hpdeifel.de>
homepage:             https://github.com/hpdeifel/hledger-iadd#readme
synopsis:             A terminal UI as drop-in replacement for hledger add
description:
    This is a terminal UI as drop-in replacement for hledger add.

    It improves in the following ways on hledger'\''s add command:

    * Interactive as-you-type completion for
    account names and descriptions with optional
    fuzzy matching.

    * Integrated calculator: Amounts can be written
    as simple sums with real-time feedback on the
    result.

    * All actions while entering a transaction can
    be undone

    * Configurable format for date input. Instead
    of @y\/m\/d@ it is also possible to use other
    formats like the german @d.m.y@.

category:             Finance, Console
abi:                  49d46cdb3fe5eb5b5027150c6b828fd6
exposed:              True
exposed-modules:
    AmountParser Brick.Widgets.BetterDialog Brick.Widgets.Border.Utils
    Brick.Widgets.CommentDialog Brick.Widgets.Edit.EmacsBindings
    Brick.Widgets.HelpMessage Brick.Widgets.List.Utils
    Brick.Widgets.WrappedText ConfigParser Data.Time.Ext DateParser
    Model View

import-dirs:          /usr/lib/ghc-9.0.2/site-local/hledger-iadd-1.3.17
library-dirs:         /usr/lib/ghc-9.0.2/site-local/hledger-iadd-1.3.17
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-iadd
hs-libraries:         HShledger-iadd-1.3.17-JMz011ZGJKJ9aZ2PWP11VO
depends:
    base-4.15.1.0 brick-0.71.1-49Y9o8PFMmSGtzMSMiJZDD
    containers-0.6.4.1 directory-1.3.6.2
    free-5.1.9-41zgDvzFzX17DfjTczd8jf
    hledger-lib-1.27.1-I6srZPrZvPGDtcWI2Kweqy
    megaparsec-9.2.2-9J8e8j7w3nJKAXfYAylaYf
    microlens-0.4.13.0-8kbZITwqGed8vNsPXOVOwI
    microlens-th-0.4.3.10-H2JRp2jh1X4pUCK34kQqn
    optparse-applicative-0.17.0.0-5RAB8jXJau3LDHQVpRHOkD text-1.2.5.0
    text-zipper-0.12-1thMmpl1u893jakHqMBDwj time-1.9.3
    transformers-0.5.6.2
    unordered-containers-0.2.19.1-1t66PwyRMuzEgWVME6Xx4r
    vector-0.13.0.0-80dNWv5W93FGfZf7Ao5mAf
    vty-5.37-1rv9lU8B4Qi2YtOoZDnRw2
    xdg-basedir-0.2.2-DeGg1ryr7ndmwRYCQYweT

haddock-interfaces:   /usr/share/doc/hledger-iadd/html/hledger-iadd.haddock
haddock-html:         /usr/share/doc/hledger-iadd/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

