#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 wizards
version:              1.0.3
visibility:           public
id:                   wizards-1.0.3-1RnzFufEITLBaBp65cnTUp
key:                  wizards-1.0.3-1RnzFufEITLBaBp65cnTUp
license:              BSD-3-Clause
maintainer:           liamoc@cse.unsw.edu.au
author:               Liam O'\''Connor-Davis
synopsis:
    High level, generic library for interrogative user interfaces

description:
    @wizards@ is a package designed for the quick and painless development of /interrogative/ programs, which
    revolve around a \"dialogue\" with the user, who is asked a series of questions in a sequence much like an
    installation wizard.

    Everything from interactive system scripts, to installation wizards, to full-blown shells can be implemented with
    the support of @wizards@.

    It is developed transparently on top of a free monad, which separates out the semantics of the program from any
    particular interface. A variety of backends exist, including console-based "System.Console.Wizard.Haskeline" and
    "System.Console.Wizard.BasicIO", and the pure "System.Console.Wizard.Pure". It is also possible to write your
    own backends, or extend existing back-ends with new features. While both built-in IO backends operate on a
    console, there is no reason why @wizards@ cannot also be used for making GUI wizard interfaces.


    See the github page for examples on usage:

    <http://www.github.com/liamoc/wizards>

    For creating backends, the module "System.Console.Wizard.Internal" has a brief tutorial.

category:             User Interfaces
abi:                  71f22fca066c7e69dbd72c87061a6f2a
exposed:              True
exposed-modules:
    System.Console.Wizard System.Console.Wizard.BasicIO
    System.Console.Wizard.Haskeline System.Console.Wizard.Internal
    System.Console.Wizard.Pure

import-dirs:          /usr/lib/ghc-9.0.2/site-local/wizards-1.0.3
library-dirs:         /usr/lib/ghc-9.0.2/site-local/wizards-1.0.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.2/wizards-1.0.3
hs-libraries:         HSwizards-1.0.3-1RnzFufEITLBaBp65cnTUp
depends:
    base-4.15.1.0 containers-0.6.4.1
    control-monad-free-0.6.2-EJKsSR16nS4LmOlWKhXJwz haskeline-0.8.2
    mtl-2.2.2 transformers-0.5.6.2

haddock-interfaces:   /usr/share/doc/haskell-wizards/html/wizards.haddock
haddock-html:         /usr/share/doc/haskell-wizards/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

