#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 versions
version:              5.0.4
visibility:           public
id:                   versions-5.0.4-311z5UF5aIw1ZCaWnETFJs
key:                  versions-5.0.4-311z5UF5aIw1ZCaWnETFJs
license:              BSD-3-Clause
maintainer:           colin@fosskers.ca
author:               Colin Woodbury
homepage:             https://github.com/fosskers/versions
synopsis:             Types and parsers for software version numbers.
description:
    A library for parsing and comparing software version numbers. We like to give
    version numbers to our software in a myriad of ways. Some ways follow strict
    guidelines for incrementing and comparison. Some follow conventional wisdom
    and are generally self-consistent. Some are just plain asinine. This library
    provides a means of parsing and comparing /any/ style of versioning, be it a
    nice Semantic Version like this:

    > 1.2.3-r1+git123

    ...or a monstrosity like this:

    > 2:10.2+0.0093r3+1-1

    Please switch to <http://semver.org Semantic Versioning> if you aren'\''t
    currently using it. It provides consistency in version incrementing and has
    the best constraints on comparisons.

    This library implements version @2.0.0@ of the SemVer spec.

category:             Data
abi:                  94ac0450f46afd3dc2e0ed13348bfa9d
exposed:              True
exposed-modules:      Data.Versions
import-dirs:          /usr/lib/ghc-9.0.2/site-local/versions-5.0.4
library-dirs:         /usr/lib/ghc-9.0.2/site-local/versions-5.0.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-versions
hs-libraries:         HSversions-5.0.4-311z5UF5aIw1ZCaWnETFJs
depends:
    base-4.15.1.0 deepseq-1.4.5.0
    hashable-1.4.1.0-LUNCtsUMK7L3ZB2KEKWF7F
    megaparsec-9.2.2-9J8e8j7w3nJKAXfYAylaYf
    parser-combinators-1.3.0-FL5bcA6sX4a2ejs4tDtkjB text-1.2.5.0

haddock-interfaces:   /usr/share/doc/haskell-versions/html/versions.haddock
haddock-html:         /usr/share/doc/haskell-versions/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

