#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 uuid-types
version:              1.0.5
visibility:           public
id:                   uuid-types-1.0.5-Icgszg4dLRWTkInDrIcfE
key:                  uuid-types-1.0.5-Icgszg4dLRWTkInDrIcfE
license:              BSD-3-Clause
copyright:
    (c) 2017-2018 Herbert Valerio Riedel
    (c) 2008-2014 Antoine Latter

maintainer:           Oleg Grenrus <oleg.grenrus@iki.fi>
author:               Antoine Latter
homepage:             https://github.com/haskell-hvr/uuid
synopsis:             Type definitions for Universally Unique Identifiers
description:
    This library contains type definitions for
    <https://en.wikipedia.org/wiki/UUID Universally Unique Identifiers (UUID)>
    (as specified in
    <http://tools.ietf.org/html/rfc4122 RFC 4122>)
    and basic conversion functions.

    See also the <https://hackage.haskell.org/package/uuid '\''uuid'\'' package>
    providing a high-level API for managing the different UUID versions.

category:             Data
abi:                  2e73c734d3df06a0716fbda4def20516
exposed:              True
exposed-modules:
    Data.UUID.Types Data.UUID.Types.Internal
    Data.UUID.Types.Internal.Builder

import-dirs:          /usr/lib/ghc-9.0.2/site-local/uuid-types-1.0.5
library-dirs:         /usr/lib/ghc-9.0.2/site-local/uuid-types-1.0.5
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-uuid-types
hs-libraries:         HSuuid-types-1.0.5-Icgszg4dLRWTkInDrIcfE
depends:
    base-4.15.1.0 binary-0.8.8.0 bytestring-0.10.12.1 deepseq-1.4.5.0
    hashable-1.4.1.0-LUNCtsUMK7L3ZB2KEKWF7F
    random-1.2.1.1-LHneN0qmdBg2HhYYKMDrs5 template-haskell-2.17.0.0
    text-1.2.5.0

haddock-interfaces:   /usr/share/doc/haskell-uuid-types/html/uuid-types.haddock
haddock-html:         /usr/share/doc/haskell-uuid-types/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

