#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 universe-base
version:              1.1.3
visibility:           public
id:                   universe-base-1.1.3-9L2jHTazOaVBrJVpaBD7dP
key:                  universe-base-1.1.3-9L2jHTazOaVBrJVpaBD7dP
license:              BSD-3-Clause
copyright:            2014 Daniel Wagner
maintainer:           me@dmwit.com
author:               Daniel Wagner
homepage:             https://github.com/dmwit/universe
synopsis:             A class for finite and recursively enumerable types.
description:
    A class for finite and recursively enumerable types and some helper functions for enumerating them.

    @
    class Universe a where universe :: [a]
    class Universe a => Finite a where universeF :: [a]; universeF = universe
    @

    This is slim package definiting only the type-classes and instances
    for types in GHC boot libraries.
    For more instances check @universe-instances-*@ packages.

category:             Data
abi:                  12fd9b9109a39f16a0e6c80124c7a88d
exposed:              True
exposed-modules:
    Data.Universe.Class Data.Universe.Generic Data.Universe.Helpers

import-dirs:          /usr/lib/ghc-9.0.2/site-local/universe-base-1.1.3
library-dirs:         /usr/lib/ghc-9.0.2/site-local/universe-base-1.1.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-universe-base
hs-libraries:         HSuniverse-base-1.1.3-9L2jHTazOaVBrJVpaBD7dP
depends:
    base-4.15.1.0 containers-0.6.4.1 ghc-prim-0.7.0
    tagged-0.8.6.1-79gYUUazit6EfoPS33FHdR transformers-0.5.6.2

haddock-interfaces:
    /usr/share/doc/haskell-universe-base/html/universe-base.haddock

haddock-html:         /usr/share/doc/haskell-universe-base/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

