#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 trifecta
version:              2.1.2
visibility:           public
id:                   trifecta-2.1.2-3aD2Lxwj3TZ8Q7VnrmhIPh
key:                  trifecta-2.1.2-3aD2Lxwj3TZ8Q7VnrmhIPh
license:              BSD-3-Clause
copyright:            Copyright (C) 2010-2017 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            experimental
homepage:             http://github.com/ekmett/trifecta/
synopsis:
    A modern parser combinator library with convenient diagnostics

description:
    A modern parser combinator library with slicing and Clang-style colored diagnostics

    For example:

    <<https://i.imgur.com/ZyzUSSn.png>>

    <images/example.png (Local Copy)>

category:             Text, Parsing, Diagnostics, Pretty Printer, Logging
abi:                  ce07b754b0ff8af54b7a1ad29c30d6e7
exposed:              True
exposed-modules:
    Text.Trifecta Text.Trifecta.Combinators Text.Trifecta.Delta
    Text.Trifecta.Highlight Text.Trifecta.Parser
    Text.Trifecta.Rendering Text.Trifecta.Result Text.Trifecta.Rope
    Text.Trifecta.Tutorial Text.Trifecta.Util.IntervalMap
    Text.Trifecta.Util.It

hidden-modules:
    Text.Trifecta.Util.Combinators Text.Trifecta.Util.Pretty

import-dirs:          /usr/lib/ghc-9.0.2/site-local/trifecta-2.1.2
library-dirs:         /usr/lib/ghc-9.0.2/site-local/trifecta-2.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-trifecta
hs-libraries:         HStrifecta-2.1.2-3aD2Lxwj3TZ8Q7VnrmhIPh
depends:
    ansi-terminal-0.11.3-4sOL9w5QIphDlJIIpaWFJL array-0.5.4.0
    base-4.15.1.0 blaze-builder-0.4.2.2-2gLNFpRfQ1I6uT3J9lURjU
    blaze-html-0.9.1.2-AIRGwJuJakcDOfrsYtfKDl
    blaze-markup-0.8.2.8-3wZdN7kDxS97Q5eM0mxELA bytestring-0.10.12.1
    charset-0.3.9-Cu3xyJxa32LCpyTXboA2UF
    comonad-5.0.8-Jb01JIbkjpK9yzpetzUNIv containers-0.6.4.1
    deepseq-1.4.5.0 fingertree-0.1.5.0-GuU5MGfdwFs7iiA40OQObo
    ghc-prim-0.7.0 hashable-1.4.1.0-LUNCtsUMK7L3ZB2KEKWF7F
    indexed-traversable-0.1.2-55rCITp0bj2K4TSTU28RrG
    lens-5.1.1-8cVW77ucFRGIbO4yMEfpoM mtl-2.2.2
    parsers-0.12.11-AI6ghXXC7XpBDY10swIT2W
    prettyprinter-1.7.1-Kh082I8LQyjLFudtJnG2xP
    prettyprinter-ansi-terminal-1.1.3-1EdU9xpSi4b31RFlIAEoGC
    profunctors-5.6.2-3xiO6DN2a4J67KN3MHdaHJ
    reducers-3.12.4-EdI4d7OPKAaBct6wrK77Yh transformers-0.5.6.2
    unordered-containers-0.2.19.1-1t66PwyRMuzEgWVME6Xx4r
    utf8-string-1.0.2-Fg3PN5UX3ZfnukMwwaDpj

haddock-interfaces:   /usr/share/doc/haskell-trifecta/html/trifecta.haddock
haddock-html:         /usr/share/doc/haskell-trifecta/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

