#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 tree-diff
version:              0.2.2
visibility:           public
id:                   tree-diff-0.2.2-H1P3hcmUHxX58vgB9R1Qjk
key:                  tree-diff-0.2.2-H1P3hcmUHxX58vgB9R1Qjk
license:              GPL-2.0-or-later
copyright:            (c) 2017-2021 Oleg Grenrus
maintainer:           Oleg.Grenrus <oleg.grenrus@iki.fi>
author:               Oleg Grenrus <oleg.grenrus@iki.fi>
homepage:             https://github.com/phadej/tree-diff
synopsis:             Diffing of (expression) trees.
description:
    Common diff algorithm works on list structures:

    @
    diff :: Eq a => [a] -> [a] -> [Edit a]
    @

    This package works on trees.

    @
    treeDiff :: Eq a => Tree a -> Tree a -> Edit (EditTree a)
    @

    This package also provides a way to diff arbitrary ADTs,
    using @Generics@-derivable helpers.

    This package differs from <http://hackage.haskell.org/package/gdiff gdiff>,
    in a two ways: @tree-diff@ doesn'\''t have patch function,
    and the "edit-script" is a tree itself, which is useful for pretty-printing.

    @
    >>> prettyEditExpr $ ediff (Foo 42 [True, False] "old") (Foo 42 [False, False, True] "new")
    Foo
    \  {fooBool = [-True, +False, False, +True],
    \   fooInt = 42,
    \   fooString = -"old" +"new"}
    @

category:             Data, Testing
abi:                  3ed2c2a255ee931bad2e0b648ce9f6c6
exposed:              True
exposed-modules:
    Data.TreeDiff Data.TreeDiff.Class Data.TreeDiff.Expr
    Data.TreeDiff.Golden Data.TreeDiff.List Data.TreeDiff.OMap
    Data.TreeDiff.Parser Data.TreeDiff.Pretty Data.TreeDiff.QuickCheck
    Data.TreeDiff.Tree

import-dirs:          /usr/lib/ghc-9.0.2/site-local/tree-diff-0.2.2
library-dirs:         /usr/lib/ghc-9.0.2/site-local/tree-diff-0.2.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-tree-diff
hs-libraries:         HStree-diff-0.2.2-H1P3hcmUHxX58vgB9R1Qjk
depends:
    QuickCheck-2.14.2-JoFwhdHSVnjCwZaPGQEEzD
    aeson-2.1.0.0-3wSqLBA0fU13NhfXDmBpwT
    ansi-terminal-0.11.3-4sOL9w5QIphDlJIIpaWFJL
    ansi-wl-pprint-0.6.9-J38Hi5Z6ALfKDwm9oxcbks base-4.15.1.0
    base-compat-0.12.2-l1EqrM7Qwu6Pq9d4drKFu bytestring-0.10.12.1
    containers-0.6.4.1 deepseq-1.4.5.0
    hashable-1.4.1.0-LUNCtsUMK7L3ZB2KEKWF7F parsec-3.1.14.0
    parsers-0.12.11-AI6ghXXC7XpBDY10swIT2W pretty-1.1.3.6
    primitive-0.7.4.0-CfTIpXUHtu665Ilg6bT1BW
    scientific-0.3.7.0-1l3L5iYBn9JD8GP8kLjgG7
    semialign-1.2.0.1-BNKrR9Ml2CXKwv64Fd8kGF
    strict-0.4.0.1-2mY0lBYSyne2S4tzH93Ukt
    tagged-0.8.6.1-79gYUUazit6EfoPS33FHdR text-1.2.5.0
    these-1.1.1.1-Gw2H7nY5XI7gYndk3FRxI time-1.9.3
    unordered-containers-0.2.19.1-1t66PwyRMuzEgWVME6Xx4r
    uuid-types-1.0.5-Icgszg4dLRWTkInDrIcfE
    vector-0.13.0.0-80dNWv5W93FGfZf7Ao5mAf

haddock-interfaces:   /usr/share/doc/haskell-tree-diff/html/tree-diff.haddock
haddock-html:         /usr/share/doc/haskell-tree-diff/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

