#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 th-desugar
version:              1.14
visibility:           public
id:                   th-desugar-1.14-4ljnpx9EUaZKAdWegYGPRC
key:                  th-desugar-1.14-4ljnpx9EUaZKAdWegYGPRC
license:              BSD-3-Clause
maintainer:           Ryan Scott <ryan.gl.scott@gmail.com>
author:               Richard Eisenberg <rae@cs.brynmawr.edu>
stability:            experimental
homepage:             https://github.com/goldfirere/th-desugar
synopsis:             Functions to desugar Template Haskell
description:
    This package provides the Language.Haskell.TH.Desugar module, which desugars
    Template Haskell'\''s rich encoding of Haskell syntax into a simpler encoding.
    This desugaring discards surface syntax information (such as the use of infix
    operators) but retains the original meaning of the TH code. The intended use
    of this package is as a preprocessor for more advanced code manipulation
    tools. Note that the input to any of the ds... functions should be produced
    from a TH quote, using the syntax [| ... |]. If the input to these functions
    is a hand-coded TH syntax tree, the results may be unpredictable. In
    particular, it is likely that promoted datatypes will not work as expected.

category:             Template Haskell
abi:                  c71795f6f3f6d1fc6f96de72df719997
exposed:              True
exposed-modules:
    Language.Haskell.TH.Desugar Language.Haskell.TH.Desugar.Expand
    Language.Haskell.TH.Desugar.Lift Language.Haskell.TH.Desugar.OMap
    Language.Haskell.TH.Desugar.OMap.Strict
    Language.Haskell.TH.Desugar.OSet Language.Haskell.TH.Desugar.Subst
    Language.Haskell.TH.Desugar.Sweeten

hidden-modules:
    Language.Haskell.TH.Desugar.AST Language.Haskell.TH.Desugar.Core
    Language.Haskell.TH.Desugar.FV Language.Haskell.TH.Desugar.Match
    Language.Haskell.TH.Desugar.Reify Language.Haskell.TH.Desugar.Util

import-dirs:          /usr/lib/ghc-9.0.2/site-local/th-desugar-1.14
library-dirs:         /usr/lib/ghc-9.0.2/site-local/th-desugar-1.14
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-th-desugar
hs-libraries:         HSth-desugar-1.14-4ljnpx9EUaZKAdWegYGPRC
depends:
    base-4.15.1.0 containers-0.6.4.1 ghc-prim-0.7.0 mtl-2.2.2
    ordered-containers-0.2.2-3ZJFCOHv4Xt5NYft4y5Gmm
    syb-0.7.2.2-JvKYfJw95RM7Y4GXhTvfdV template-haskell-2.17.0.0
    th-abstraction-0.4.5.0-CPrpKcr2W2S31K8QsJKgDp
    th-lift-0.8.2-47INKJD6iIF1IlUc8HcOrC
    th-orphans-0.13.14-A560uYuUztCAxDgqKPJmM8
    transformers-compat-0.7.2-ZzSHjvD4flB2ChCq5TVbH

haddock-interfaces:   /usr/share/doc/haskell-th-desugar/html/th-desugar.haddock
haddock-html:         /usr/share/doc/haskell-th-desugar/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

