#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 tamarin-prover-utils
version:              1.6.1
visibility:           public
id:                   tamarin-prover-utils-1.6.1-HYLrwrfeZg6LwzWSuEs9EF
key:                  tamarin-prover-utils-1.6.1-HYLrwrfeZg6LwzWSuEs9EF
license:              LicenseRef-GPL
copyright:
    Benedikt Schmidt, Simon Meier, Jannik Dreier, Ralf Sasse, ETH Zurich, 2010-2018

maintainer:
    Simon Meier <simon.meier@inf.ethz.ch>,
    Jannik Dreier <research@jannikdreier.net>,
    Ralf Sasse <ralf.sasse@gmail.com>

author:
    Benedikt Schmidt <benedikt.schmidt@inf.ethz.ch>,
    Simon Meier <simon.meier@inf.ethz.ch>,
    Jannik Dreier <research@jannikdreier.net>,
    Ralf Sasse <ralf.sasse@gmail.com>

homepage:             https://tamarin-prover.github.io/
synopsis:             Utility library for the tamarin prover.
description:
    This is an internal library of the Tamarin prover for
    security protocol verification
    (<hackage.haskell.org/package/tamarin-prover>).

category:             Theorem Provers
abi:                  4af49831e5aebcef355871dc5cb025e9
exposed:              True
exposed-modules:
    Control.Basics Control.Monad.Bind Control.Monad.Disj
    Control.Monad.Fresh Control.Monad.Trans.FastFresh
    Control.Monad.Trans.PreciseFresh Data.Color Data.DAG.Simple
    Debug.Trace.Ignore Extension.Data.ByteString Extension.Data.Label
    Extension.Data.Monoid Extension.Prelude Logic.Connectives
    System.Timing Text.Dot Text.PrettyPrint.Class
    Text.PrettyPrint.Highlight Text.PrettyPrint.Html Text.Unicode
    Utils.Misc

hidden-modules:
    Control.Monad.Fresh.Class Control.Monad.Trans.Disj
    Control.Monad.Disj.Class

import-dirs:          /usr/lib/ghc-9.0.2/site-local/tamarin-prover-utils-1.6.1
library-dirs:         /usr/lib/ghc-9.0.2/site-local/tamarin-prover-utils-1.6.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-tamarin-prover-utils
hs-libraries:         HStamarin-prover-utils-1.6.1-HYLrwrfeZg6LwzWSuEs9EF
depends:
    SHA-1.6.4.4-1UNVNO3JXJdDGqRoMkntZx base-4.15.1.0
    base64-bytestring-1.2.1.0-iG6YBGhLkRJagBsFqRAI2 binary-0.8.8.0
    blaze-builder-0.4.2.2-2gLNFpRfQ1I6uT3J9lURjU bytestring-0.10.12.1
    containers-0.6.4.1 deepseq-1.4.5.0 dlist-1.0-ImNlUre2rHgIkuGbqNQCOO
    exceptions-0.10.4 fclabels-2.0.5.1-9a5T1hXanLx1UTTIEKz4w4 mtl-2.2.2
    pretty-1.1.3.6 safe-0.3.19-2aVM1fCfxX88jnlVeNbd8Q
    syb-0.7.2.2-JvKYfJw95RM7Y4GXhTvfdV time-1.9.3 transformers-0.5.6.2

haddock-interfaces:
    /usr/share/doc/haskell-tamarin-prover-utils/html/tamarin-prover-utils.haddock

haddock-html:         /usr/share/doc/haskell-tamarin-prover-utils/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

