#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 tamarin-prover-sapic
version:              1.6.1
visibility:           public
id:                   tamarin-prover-sapic-1.6.1-EDALMF2UCccAnwmzJStksB
key:                  tamarin-prover-sapic-1.6.1-EDALMF2UCccAnwmzJStksB
license:              LicenseRef-GPL
copyright:
    Robert Künnemann, Alexander Dax, CISPA-Helmholtz-Centre Saarbrücken, 2019

maintainer:           Robert Künnemann <robert@kunnemann.de>
author:
    Robert Künnemann <robert@kunnemann.de>,
    Alexander Dax <alexander.dax@cispa.saarland>

homepage:             https://tamarin-prover.github.io/
synopsis:
    Library for input processes in SAPIC calculus for the tamarin prover.

description:
    This is an internal library of the Tamarin prover for
    security protocol verification
    (<hackage.haskell.org/package/tamarin-prover>).

    This library provides a translation from processes stated in the SAPIC calculus into multiset rewrite rules.

category:             Theorem Provers
abi:                  151471715a65f0d46ad6ec3c31fbf169
exposed:              True
exposed-modules:
    Sapic Sapic.Annotation Sapic.Basetranslation Sapic.Exceptions
    Sapic.Facts Sapic.Locks Sapic.ProcessUtils Sapic.ProgressFunction
    Sapic.ProgressTranslation Sapic.ReliableChannelTranslation
    Sapic.Report Sapic.SecretChannels

import-dirs:          /usr/lib/ghc-9.0.2/site-local/tamarin-prover-sapic-1.6.1
library-dirs:         /usr/lib/ghc-9.0.2/site-local/tamarin-prover-sapic-1.6.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-tamarin-prover-sapic
hs-libraries:         HStamarin-prover-sapic-1.6.1-EDALMF2UCccAnwmzJStksB
depends:
    aeson-2.1.0.0-3wSqLBA0fU13NhfXDmBpwT
    aeson-pretty-0.8.9-HIKDmSQGmI0DQYiuXhljjd base-4.15.1.0
    binary-0.8.8.0 bytestring-0.10.12.1 containers-0.6.4.1
    deepseq-1.4.5.0 dlist-1.0-ImNlUre2rHgIkuGbqNQCOO exceptions-0.10.4
    fclabels-2.0.5.1-9a5T1hXanLx1UTTIEKz4w4 mtl-2.2.2
    parallel-3.2.2.0-D2aleEa2VnPBr164BdKnms parsec-3.1.14.0
    process-1.6.13.2 raw-strings-qq-1.1-HLwmcxYcuIJGkfZmLVBhgc
    safe-0.3.19-2aVM1fCfxX88jnlVeNbd8Q
    tamarin-prover-term-1.6.1-EyEQB5GDUPTH1FqgaxfCpM
    tamarin-prover-theory-1.6.1-HnDdiU7DkhrHyaG73ac8hg
    tamarin-prover-utils-1.6.1-HYLrwrfeZg6LwzWSuEs9EF text-1.2.5.0
    transformers-0.5.6.2 uniplate-1.6.13-Bz3m6aJYQrB6IKo2ZbSAY5

haddock-interfaces:
    /usr/share/doc/haskell-tamarin-prover-sapic/html/tamarin-prover-sapic.haddock

haddock-html:         /usr/share/doc/haskell-tamarin-prover-sapic/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

