#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 stateref
version:              0.3
visibility:           public
id:                   stateref-0.3-9u9QCRlvo9dHk1YF6aLbH9
key:                  stateref-0.3-9u9QCRlvo9dHk1YF6aLbH9
license:              LicenseRef-PublicDomain
maintainer:           James Cook <mokus@deepbondi.net>
author:               James Cook <mokus@deepbondi.net>
stability:            provisional
homepage:             http://code.haskell.org/~mokus/stateref/
synopsis:             Abstraction for things that work like IORef.
description:
    A collection of type-classes generalizing the
    read\/write\/modify operations for stateful variables
    provided by things like IORef, TVar, &c.
    Note that The interface has changed a bit from the
    0.2.* version.  \"*Ref\" functions are now called
    \"*Reference\" and new \"*Ref\" function exist with
    simpler signatures.
    The new '\''Ref'\'' existential type provides a convenient
    monad-indexed reference type, and the HasRef class
    indicates monads for which there is a default
    reference type for every referent.

category:             Data
abi:                  8323e57faa43c08ca7f1be5a1d9bfc42
exposed:              True
exposed-modules:
    Data.Accessor Data.MRef Data.MRef.Instances Data.MRef.Types
    Data.StateRef Data.StateRef.Instances Data.StateRef.Types

hidden-modules:
    Data.StateRef.Instances.Undecidable Data.StateRef.Instances.STM
    Data.MRef.Instances.STM

import-dirs:          /usr/lib/ghc-9.0.2/site-local/stateref-0.3
library-dirs:         /usr/lib/ghc-9.0.2/site-local/stateref-0.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.2/stateref-0.3
hs-libraries:         HSstateref-0.3-9u9QCRlvo9dHk1YF6aLbH9
depends:              base-4.15.1.0 mtl-2.2.2 stm-2.5.0.0
haddock-interfaces:   /usr/share/doc/haskell-stateref/html/stateref.haddock
haddock-html:         /usr/share/doc/haskell-stateref/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

