#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 snap-core
version:              1.0.5.0
visibility:           public
id:                   snap-core-1.0.5.0-7gioLDKffGBKyoJGAiuwKJ
key:                  snap-core-1.0.5.0-7gioLDKffGBKyoJGAiuwKJ
license:              BSD-3-Clause
maintainer:           snap@snapframework.com
author:               Snap Framework Authors (see CONTRIBUTORS)
homepage:             http://snapframework.com/
synopsis:             Snap: A Haskell Web Framework (core interfaces and types)
description:
    Snap is a simple and fast web development framework and server written in
    Haskell. For more information or to download the latest version, you can
    visit the Snap project website at <http://snapframework.com/>.

    This library contains the core definitions and types for the Snap framework,
    including:

    1. Primitive types and functions for HTTP (requests, responses, cookies,
    post/query parameters, etc)

    2. A monad for programming web handlers called \"Snap\", which allows:

    * Stateful access to the HTTP request and response objects

    * Monadic failure (i.e. MonadPlus/Alternative instances) for declining
    to handle requests and chaining handlers together

    * Early termination of the computation if you know early what you want
    to return and want to prevent further monadic processing

    /Quick start/: The '\''Snap'\'' monad and HTTP definitions are in "Snap.Core".

category:             Web, Snap, IO-Streams
abi:                  d2c09281d39f1eff0a5ba9867f258b49
exposed:              True
exposed-modules:
    Snap.Core Snap.Internal.Core Snap.Internal.Debug
    Snap.Internal.Http.Types Snap.Internal.Parsing
    Snap.Internal.Util.FileServe Snap.Test Snap.Types.Headers
    Snap.Util.CORS Snap.Util.FileServe Snap.Util.FileUploads
    Snap.Util.GZip Snap.Util.Proxy

hidden-modules:
    Snap.Internal.Instances Snap.Internal.Routing
    Snap.Internal.Test.RequestBuilder Snap.Internal.Test.Assertions
    Snap.Internal.Util.FileUploads

import-dirs:          /usr/lib/ghc-9.0.2/site-local/snap-core-1.0.5.0
library-dirs:         /usr/lib/ghc-9.0.2/site-local/snap-core-1.0.5.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-snap-core
hs-libraries:         HSsnap-core-1.0.5.0-7gioLDKffGBKyoJGAiuwKJ
depends:
    HUnit-1.6.2.0-2gufKd42xUzCpoVbpNtVHq
    attoparsec-0.14.4-9SQv4o2tq0k4n7CegIwza1 base-4.15.1.0
    bytestring-0.10.12.1
    case-insensitive-1.2.1.0-9P0gl8mW2it6Cg0EClpHns containers-0.6.4.1
    directory-1.3.6.2 filepath-1.4.2.1
    hashable-1.4.1.0-LUNCtsUMK7L3ZB2KEKWF7F
    io-streams-1.5.2.2-1rmTTD5GyAiGY9hmphDOxR
    lifted-base-0.2.3.12-AYPww8ZnbOZ1klpxoyOwkC
    monad-control-1.0.3.1-21gUZpZbgH5KO3QvMCPaGC mtl-2.2.2
    network-3.1.2.7-2x6X3kWddA03AmOITnySLy
    network-uri-2.6.4.1-CJy9K6CUGBYDMBcoIm8TMq
    old-locale-1.0.0.7-B94o3sNLYrV8oE3WO2rqHh
    random-1.2.1.1-LHneN0qmdBg2HhYYKMDrs5
    readable-0.3.1-8qk55zLnPf8IWPnnTbUyya
    regex-posix-0.96.0.1-3tnfXrSqQrb7MJMFtuTwG8 text-1.2.5.0 time-1.9.3
    transformers-0.5.6.2 transformers-base-0.4.6-2M49J28Ed0L2XQvH4AySxP
    unix-compat-0.6-ItrkFOIKc9mI0qPePSsUjW
    unordered-containers-0.2.19.1-1t66PwyRMuzEgWVME6Xx4r
    vector-0.13.0.0-80dNWv5W93FGfZf7Ao5mAf

haddock-interfaces:   /usr/share/doc/haskell-snap-core/html/snap-core.haddock
haddock-html:         /usr/share/doc/haskell-snap-core/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

