#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 SHA
version:              1.6.4.4
visibility:           public
id:                   SHA-1.6.4.4-1UNVNO3JXJdDGqRoMkntZx
key:                  SHA-1.6.4.4-1UNVNO3JXJdDGqRoMkntZx
license:              BSD-3-Clause
maintainer:
    Adam Wick <awick@galois.com>,
    Raphael Javaux <raphaeljavaux@gmail.com>

author:               Adam Wick <awick@galois.com>, Brian Lewis <brian@lorf.org>
stability:            stable
synopsis:
    Implementations of the SHA suite of message digest functions

description:
    This library implements the SHA suite of message digest functions,
    according to NIST FIPS 180-2 (with the SHA-224 addendum), as well
    as the SHA-based HMAC routines. The functions have been tested
    against most of the NIST and RFC test vectors for the various
    functions. While some attention has been paid to performance,
    these do not presently reach the speed of well-tuned libraries,
    like OpenSSL.

category:             Cryptography, Codec
abi:                  e1fefe204aa1562b125713e500e1663c
exposed:              True
exposed-modules:      Data.Digest.Pure.SHA
import-dirs:          /usr/lib/ghc-9.0.2/site-local/SHA-1.6.4.4
library-dirs:         /usr/lib/ghc-9.0.2/site-local/SHA-1.6.4.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.2/SHA-1.6.4.4
hs-libraries:         HSSHA-1.6.4.4-1UNVNO3JXJdDGqRoMkntZx
depends:
    array-0.5.4.0 base-4.15.1.0 binary-0.8.8.0 bytestring-0.10.12.1

haddock-interfaces:   /usr/share/doc/haskell-sha/html/SHA.haddock
haddock-html:         /usr/share/doc/haskell-sha/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

