#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 serialise
version:              0.2.6.0
visibility:           public
id:                   serialise-0.2.6.0-7M0taRnX2M5IWZQAWPOVep
key:                  serialise-0.2.6.0-7M0taRnX2M5IWZQAWPOVep
license:              BSD-3-Clause
copyright:
    2015-2017 Duncan Coutts,
    2015-2017 Well-Typed LLP,
    2015 IRIS Connect Ltd

maintainer:           duncan@community.haskell.org, ben@smart-cactus.org
author:               Duncan Coutts
homepage:             https://github.com/well-typed/cborg
synopsis:             A binary serialisation library for Haskell values.
description:
    This package (formerly @binary-serialise-cbor@) provides pure, efficient
    serialization of Haskell values directly into @ByteString@s for storage or
    transmission purposes. By providing a set of type class instances, you can
    also serialise any custom data type you have as well.

    The underlying binary format used is the '\''Concise Binary Object
    Representation'\'', or CBOR, specified in RFC 7049. As a result,
    serialised Haskell values have implicit structure outside of the
    Haskell program itself, meaning they can be inspected or analyzed
    without custom tools.

    An implementation of the standard bijection between CBOR and JSON is provided
    by the [cborg-json](/package/cborg-json) package. Also see
    [cbor-tool](/package/cbor-tool) for a convenient command-line utility for
    working with CBOR data.

category:             Codec
abi:                  1cc786253fbd36c4eae1391ec5c0e100
exposed:              True
exposed-modules:
    Codec.Serialise Codec.Serialise.Class Codec.Serialise.Decoding
    Codec.Serialise.Encoding Codec.Serialise.IO
    Codec.Serialise.Internal.GeneralisedUTF8 Codec.Serialise.Properties
    Codec.Serialise.Tutorial

import-dirs:          /usr/lib/ghc-9.0.2/site-local/serialise-0.2.6.0
library-dirs:         /usr/lib/ghc-9.0.2/site-local/serialise-0.2.6.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-serialise
hs-libraries:         HSserialise-0.2.6.0-7M0taRnX2M5IWZQAWPOVep
depends:
    array-0.5.4.0 base-4.15.1.0 bytestring-0.10.12.1
    cborg-0.2.8.0-7CnZXeqqwb6HAtO8qRWSoe containers-0.6.4.1
    ghc-prim-0.7.0 half-0.3.1-EPYmmhgK6855HBsjgKDFZS
    hashable-1.4.1.0-LUNCtsUMK7L3ZB2KEKWF7F
    primitive-0.7.4.0-CfTIpXUHtu665Ilg6bT1BW
    strict-0.4.0.1-2mY0lBYSyne2S4tzH93Ukt text-1.2.5.0
    these-1.1.1.1-Gw2H7nY5XI7gYndk3FRxI time-1.9.3
    unordered-containers-0.2.19.1-1t66PwyRMuzEgWVME6Xx4r
    vector-0.13.0.0-80dNWv5W93FGfZf7Ao5mAf

haddock-interfaces:   /usr/share/doc/haskell-serialise/html/serialise.haddock
haddock-html:         /usr/share/doc/haskell-serialise/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

