#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 semigroupoids
version:              5.3.7
visibility:           public
id:                   semigroupoids-5.3.7-HwCM6hSIfxCIEi8aYGOr6m
key:                  semigroupoids-5.3.7-HwCM6hSIfxCIEi8aYGOr6m
license:              BSD-2-Clause
copyright:            Copyright (C) 2011-2015 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            provisional
homepage:             http://github.com/ekmett/semigroupoids
synopsis:             Semigroupoids: Category sans id
description:
    Provides a wide array of (semi)groupoids and operations for working with them.

    A '\''Semigroupoid'\'' is a '\''Category'\'' without the requirement of identity arrows for every object in the category.

    A '\''Category'\'' is any '\''Semigroupoid'\'' for which the Yoneda lemma holds.

    When working with comonads you often have the @\<*\>@ portion of an @Applicative@, but
    not the @pure@. This was captured in Uustalu and Vene'\''s \"Essence of Dataflow Programming\"
    in the form of the @ComonadZip@ class in the days before @Applicative@. Apply provides a weaker invariant, but for the comonads used for data flow programming (found in the streams package), this invariant is preserved. Applicative function composition forms a semigroupoid.

    Similarly many structures are nearly a comonad, but not quite, for instance lists provide a reasonable '\''extend'\'' operation in the form of '\''tails'\'', but do not always contain a value.

    We describe the relationships between the type classes defined in this package
    and those from `base` (and some from `contravariant`) in the diagram below.
    Thick-bordered nodes correspond to type classes defined in this package;
    thin-bordered ones correspond to type classes from elsewhere. Solid edges
    indicate a subclass relationship that actually exists; dashed edges indicate a
    subclass relationship that /should/ exist, but currently doesn'\''t.

    <<https://raw.githubusercontent.com/ekmett/semigroupoids/master/img/classes.svg Relationships among type classes from this package and others>>

    Apply, Bind, and Extend (not shown) give rise the Static, Kleisli and Cokleisli semigroupoids respectively.

    This lets us remove many of the restrictions from various monad transformers
    as in many cases the binding operation or @\<*\>@ operation does not require them.

    Finally, to work with these weaker structures it is beneficial to have containers
    that can provide stronger guarantees about their contents, so versions of '\''Traversable'\''
    and '\''Foldable'\'' that can be folded with just a '\''Semigroup'\'' are added.

category:             Control, Comonads
abi:                  db152aa11e5141a2f6f1f8b4cf7253d0
exposed:              True
exposed-modules:
    Data.Bifunctor.Apply Data.Functor.Alt Data.Functor.Apply
    Data.Functor.Bind Data.Functor.Bind.Class Data.Functor.Bind.Trans
    Data.Functor.Contravariant.Conclude
    Data.Functor.Contravariant.Decide Data.Functor.Contravariant.Divise
    Data.Functor.Extend Data.Functor.Plus Data.Groupoid
    Data.Isomorphism Data.Semigroup.Bifoldable
    Data.Semigroup.Bitraversable Data.Semigroup.Foldable
    Data.Semigroup.Foldable.Class Data.Semigroup.Traversable
    Data.Semigroup.Traversable.Class Data.Semigroupoid
    Data.Semigroupoid.Categorical Data.Semigroupoid.Dual
    Data.Semigroupoid.Ob Data.Semigroupoid.Static
    Data.Traversable.Instances Semigroupoids.Do

hidden-modules:       Semigroupoids.Internal
import-dirs:          /usr/lib/ghc-9.0.2/site-local/semigroupoids-5.3.7
library-dirs:         /usr/lib/ghc-9.0.2/site-local/semigroupoids-5.3.7
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-semigroupoids
hs-libraries:         HSsemigroupoids-5.3.7-HwCM6hSIfxCIEi8aYGOr6m
depends:
    base-4.15.1.0 base-orphans-0.8.7-ExGEIraIdYM5imPv9ZUf9M
    bifunctors-5.5.13-JsL8XwnIyaF7mMrittTFB9
    comonad-5.0.8-Jb01JIbkjpK9yzpetzUNIv containers-0.6.4.1
    contravariant-1.5.5-FtJyCLyWfutGN2UWoJs8qd
    distributive-0.6.2.1-9wcbdvxUhl373VFDpLmb6H
    hashable-1.4.1.0-LUNCtsUMK7L3ZB2KEKWF7F
    tagged-0.8.6.1-79gYUUazit6EfoPS33FHdR template-haskell-2.17.0.0
    transformers-0.5.6.2
    transformers-compat-0.7.2-ZzSHjvD4flB2ChCq5TVbH
    unordered-containers-0.2.19.1-1t66PwyRMuzEgWVME6Xx4r

haddock-interfaces:
    /usr/share/doc/haskell-semigroupoids/html/semigroupoids.haddock

haddock-html:         /usr/share/doc/haskell-semigroupoids/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

