#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 safe
version:              0.3.19
visibility:           public
id:                   safe-0.3.19-2aVM1fCfxX88jnlVeNbd8Q
key:                  safe-0.3.19-2aVM1fCfxX88jnlVeNbd8Q
license:              BSD-3-Clause
copyright:            Neil Mitchell 2007-2020
maintainer:           Neil Mitchell <ndmitchell@gmail.com>
author:               Neil Mitchell <ndmitchell@gmail.com>
homepage:             https://github.com/ndmitchell/safe#readme
synopsis:             Library of safe (exception free) functions
description:
    A library wrapping @Prelude@/@Data.List@ functions that can throw exceptions, such as @head@ and @!!@.
    Each unsafe function has up to four variants, e.g. with @tail@:

    * @tail :: [a] -> [a]@, raises an error on @tail []@.

    * @tailMay :: [a] -> /Maybe/ [a]@, turns errors into @Nothing@.

    * @tailDef :: /[a]/ -> [a] -> [a]@, takes a default to return on errors.

    * @tailNote :: /String/ -> [a] -> [a]@, takes an extra argument which supplements the error message.

    * @tailSafe :: [a] -> [a]@, returns some sensible default if possible, @[]@ in the case of @tail@.

    This package is divided into three modules:

    * "Safe" contains safe variants of @Prelude@ and @Data.List@ functions.

    * "Safe.Foldable" contains safe variants of @Foldable@ functions.

    * "Safe.Exact" creates crashing versions of functions like @zip@ (errors if the lists are not equal) and @take@ (errors if there are not enough elements), then wraps them to provide safe variants.

category:             Unclassified
abi:                  3437f03b8b6e826c2db050a72a58869e
exposed:              True
exposed-modules:      Safe Safe.Exact Safe.Foldable Safe.Partial
hidden-modules:       Safe.Util
import-dirs:          /usr/lib/ghc-9.0.2/site-local/safe-0.3.19
library-dirs:         /usr/lib/ghc-9.0.2/site-local/safe-0.3.19
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.2/safe-0.3.19
hs-libraries:         HSsafe-0.3.19-2aVM1fCfxX88jnlVeNbd8Q
depends:              base-4.15.1.0
haddock-interfaces:   /usr/share/doc/haskell-safe/html/safe.haddock
haddock-html:         /usr/share/doc/haskell-safe/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

