#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 quickcheck-instances
version:              0.3.28
visibility:           public
id:                   quickcheck-instances-0.3.28-Ldy6NrsoeRA250ojkCE8oN
key:                  quickcheck-instances-0.3.28-Ldy6NrsoeRA250ojkCE8oN
license:              BSD-3-Clause
copyright:            Copyright 2012-2016 Antoine Latter, 2017-2019 Oleg Grenrus
maintainer:           Oleg Grenrus <oleg.grenrus@iki.fi>
author:
    Antoine Latter <aslatter@gmail.com>, Oleg Grenrus <oleg.grenrus@iki.fi>

homepage:             https://github.com/haskellari/qc-instances
synopsis:             Common quickcheck instances
description:
    QuickCheck instances.

    The goal is to supply QuickCheck instances for
    types provided by the Haskell Platform.

    Since all of these instances are provided as
    orphans, I recommend that you do not use this library
    within another library module, so that you don'\''t
    impose these instances on down-stream consumers of
    your code.

    For information on writing a test-suite with Cabal
    see <https://www.haskell.org/cabal/users-guide/developing-packages.html#test-suites>

category:             Testing
abi:                  cfb25be43d126ed065522186c765c9d0
exposed:              True
exposed-modules:
    Test.QuickCheck.Instances Test.QuickCheck.Instances.Array
    Test.QuickCheck.Instances.Array.Byte
    Test.QuickCheck.Instances.ByteString
    Test.QuickCheck.Instances.CaseInsensitive
    Test.QuickCheck.Instances.Containers
    Test.QuickCheck.Instances.DataFix
    Test.QuickCheck.Instances.Hashable
    Test.QuickCheck.Instances.Natural Test.QuickCheck.Instances.OldTime
    Test.QuickCheck.Instances.Primitive
    Test.QuickCheck.Instances.Scientific
    Test.QuickCheck.Instances.Semigroup Test.QuickCheck.Instances.Solo
    Test.QuickCheck.Instances.Strict Test.QuickCheck.Instances.Tagged
    Test.QuickCheck.Instances.Text Test.QuickCheck.Instances.Text.Short
    Test.QuickCheck.Instances.These Test.QuickCheck.Instances.Time
    Test.QuickCheck.Instances.Transformer
    Test.QuickCheck.Instances.UUID
    Test.QuickCheck.Instances.UnorderedContainers
    Test.QuickCheck.Instances.Vector Test.QuickCheck.Instances.Void

hidden-modules:       Test.QuickCheck.Instances.CustomPrelude
import-dirs:          /usr/lib/ghc-9.0.2/site-local/quickcheck-instances-0.3.28
library-dirs:         /usr/lib/ghc-9.0.2/site-local/quickcheck-instances-0.3.28
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-quickcheck-instances
hs-libraries:         HSquickcheck-instances-0.3.28-Ldy6NrsoeRA250ojkCE8oN
depends:
    OneTuple-0.3.1-LqMWID2APZeHDX3OGY8gDy
    QuickCheck-2.14.2-JoFwhdHSVnjCwZaPGQEEzD array-0.5.4.0
    base-4.15.1.0 bytestring-0.10.12.1
    case-insensitive-1.2.1.0-9P0gl8mW2it6Cg0EClpHns containers-0.6.4.1
    data-fix-0.3.2-LxCSJ0DXV5oBUng5yBCchq
    hashable-1.4.1.0-LUNCtsUMK7L3ZB2KEKWF7F
    integer-logarithms-1.0.3.1-5kS6jNbEsIJGKjr4VAkZqE
    old-time-1.1.0.3-B4Ro2AUl5kn1VzPHPQkaoe
    primitive-0.7.4.0-CfTIpXUHtu665Ilg6bT1BW
    scientific-0.3.7.0-1l3L5iYBn9JD8GP8kLjgG7
    splitmix-0.1.0.4-Ekcjoaio8AJ1Z4nSJbcogE
    strict-0.4.0.1-2mY0lBYSyne2S4tzH93Ukt
    tagged-0.8.6.1-79gYUUazit6EfoPS33FHdR text-1.2.5.0
    text-short-0.1.5-BpUmYQpnlq5B0lAlfuthm
    these-1.1.1.1-Gw2H7nY5XI7gYndk3FRxI time-1.9.3
    time-compat-1.9.6.1-DA8T260lEen7hxdNGxn7Jq transformers-0.5.6.2
    transformers-compat-0.7.2-ZzSHjvD4flB2ChCq5TVbH
    unordered-containers-0.2.19.1-1t66PwyRMuzEgWVME6Xx4r
    uuid-types-1.0.5-Icgszg4dLRWTkInDrIcfE
    vector-0.13.0.0-80dNWv5W93FGfZf7Ao5mAf

haddock-interfaces:
    /usr/share/doc/haskell-quickcheck-instances/html/quickcheck-instances.haddock

haddock-html:         /usr/share/doc/haskell-quickcheck-instances/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

