#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 parameterized-utils
version:              2.1.5.0
visibility:           public
id:                   parameterized-utils-2.1.5.0-CmlKiUF7QEHGJKHwPvS6eP
key:                  parameterized-utils-2.1.5.0-CmlKiUF7QEHGJKHwPvS6eP
license:              BSD-3-Clause
copyright:            ©2016-2022 Galois, Inc.
maintainer:           kquick@galois.com
author:               Galois Inc.
stability:            stable
homepage:             https://github.com/GaloisInc/parameterized-utils
synopsis:
    Classes and data structures for working with data-kind indexed types

description:
    This package contains collection classes and type representations
    used for working with values that have a single parameter.  It'\''s
    intended for things like expression libraries where one wishes
    to leverage the Haskell type-checker to improve type-safety by encoding
    the object language type system into data kinds.

category:             Data Structures, Dependent Types
abi:                  eb09f68f18cdf9cf4c37e79a68e0a80a
exposed:              True
exposed-modules:
    Data.Parameterized Data.Parameterized.All Data.Parameterized.Axiom
    Data.Parameterized.BoolRepr Data.Parameterized.Classes
    Data.Parameterized.ClassesC Data.Parameterized.Compose
    Data.Parameterized.Context Data.Parameterized.Context.Safe
    Data.Parameterized.Context.Unsafe Data.Parameterized.Ctx
    Data.Parameterized.Ctx.Proofs Data.Parameterized.DataKind
    Data.Parameterized.DecidableEq Data.Parameterized.Fin
    Data.Parameterized.HashTable Data.Parameterized.List
    Data.Parameterized.Map Data.Parameterized.NatRepr
    Data.Parameterized.Nonce Data.Parameterized.Nonce.Transformers
    Data.Parameterized.Nonce.Unsafe Data.Parameterized.Pair
    Data.Parameterized.Peano Data.Parameterized.Some
    Data.Parameterized.SymbolRepr Data.Parameterized.TH.GADT
    Data.Parameterized.TraversableF Data.Parameterized.TraversableFC
    Data.Parameterized.TraversableFC.WithIndex
    Data.Parameterized.Utils.BinTree Data.Parameterized.Utils.Endian
    Data.Parameterized.Vector Data.Parameterized.WithRepr

hidden-modules:       Data.Parameterized.NatRepr.Internal
import-dirs:          /usr/lib/ghc-9.0.2/site-local/parameterized-utils-2.1.5.0
library-dirs:         /usr/lib/ghc-9.0.2/site-local/parameterized-utils-2.1.5.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-parameterized-utils
hs-libraries:         HSparameterized-utils-2.1.5.0-CmlKiUF7QEHGJKHwPvS6eP
depends:
    base-4.15.1.0 base-orphans-0.8.7-ExGEIraIdYM5imPv9ZUf9M
    constraints-0.13.4-EP04dodd4em2GV3r2raZRS containers-0.6.4.1
    deepseq-1.4.5.0 ghc-prim-0.7.0
    hashable-1.4.1.0-LUNCtsUMK7L3ZB2KEKWF7F
    hashtables-1.3.1-CYzHUQOg5RG9TFA6ECvfn8
    indexed-traversable-0.1.2-55rCITp0bj2K4TSTU28RrG
    lens-5.1.1-8cVW77ucFRGIbO4yMEfpoM mtl-2.2.2
    profunctors-5.6.2-3xiO6DN2a4J67KN3MHdaHJ template-haskell-2.17.0.0
    text-1.2.5.0 th-abstraction-0.4.5.0-CPrpKcr2W2S31K8QsJKgDp
    vector-0.13.0.0-80dNWv5W93FGfZf7Ao5mAf

haddock-interfaces:
    /usr/share/doc/haskell-parameterized-utils/html/parameterized-utils.haddock

haddock-html:         /usr/share/doc/haskell-parameterized-utils/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

