#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 lsp-types
version:              1.3.0.1
visibility:           public
id:                   lsp-types-1.3.0.1-A9OBFtru06V7IJgWtqPrq4
key:                  lsp-types-1.3.0.1-A9OBFtru06V7IJgWtqPrq4
license:              MIT
copyright:            Alan Zimmerman, 2016-2021
maintainer:           alan.zimm@gmail.com
author:               Alan Zimmerman
homepage:             https://github.com/haskell/lsp
synopsis:
    Haskell library for the Microsoft Language Server Protocol, data types

description:
    An implementation of the types to allow language implementors to
    support the Language Server Protocol for their specific language.

category:             Development
abi:                  292bb956e4cbb3ac8141e21cf7cb99fa
exposed:              True
exposed-modules:
    Data.IxMap Language.LSP.Types Language.LSP.Types.Capabilities
    Language.LSP.Types.Lens Language.LSP.VFS

hidden-modules:
    Language.LSP.Types.CallHierarchy Language.LSP.Types.Cancellation
    Language.LSP.Types.ClientCapabilities Language.LSP.Types.CodeAction
    Language.LSP.Types.CodeLens Language.LSP.Types.Command
    Language.LSP.Types.Common Language.LSP.Types.Completion
    Language.LSP.Types.Configuration Language.LSP.Types.Declaration
    Language.LSP.Types.Definition Language.LSP.Types.Diagnostic
    Language.LSP.Types.DocumentColor Language.LSP.Types.DocumentFilter
    Language.LSP.Types.DocumentHighlight
    Language.LSP.Types.DocumentLink Language.LSP.Types.DocumentSymbol
    Language.LSP.Types.FoldingRange Language.LSP.Types.Formatting
    Language.LSP.Types.Hover Language.LSP.Types.Implementation
    Language.LSP.Types.Initialize Language.LSP.Types.Location
    Language.LSP.Types.LspId Language.LSP.Types.MarkupContent
    Language.LSP.Types.Method Language.LSP.Types.Message
    Language.LSP.Types.Parsing Language.LSP.Types.Progress
    Language.LSP.Types.Registration Language.LSP.Types.References
    Language.LSP.Types.Rename Language.LSP.Types.SelectionRange
    Language.LSP.Types.ServerCapabilities
    Language.LSP.Types.SemanticTokens Language.LSP.Types.SignatureHelp
    Language.LSP.Types.StaticRegistrationOptions
    Language.LSP.Types.TextDocument Language.LSP.Types.TypeDefinition
    Language.LSP.Types.Uri Language.LSP.Types.Utils
    Language.LSP.Types.Window Language.LSP.Types.WatchedFiles
    Language.LSP.Types.WorkspaceEdit
    Language.LSP.Types.WorkspaceFolders
    Language.LSP.Types.WorkspaceSymbol

import-dirs:          /usr/lib/ghc-9.0.2/site-local/lsp-types-1.3.0.1
library-dirs:         /usr/lib/ghc-9.0.2/site-local/lsp-types-1.3.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lsp-types
hs-libraries:         HSlsp-types-1.3.0.1-A9OBFtru06V7IJgWtqPrq4
depends:
    Diff-0.4.1-2jMKpzJJQmAHzE6LyB7Qjk
    aeson-2.1.0.0-3wSqLBA0fU13NhfXDmBpwT base-4.15.1.0 binary-0.8.8.0
    bytestring-0.10.12.1 containers-0.6.4.1
    data-default-0.7.1.1-BkZarJ3J3008hHF2JOuYeW deepseq-1.4.5.0
    dependent-sum-0.7.1.0-5cVuFUxtTBz51MaigKE0Ld
    dependent-sum-template-0.1.1.1-IPlxVzO8nM1D4AFTPtTgLw
    directory-1.3.6.2 dlist-1.0-ImNlUre2rHgIkuGbqNQCOO filepath-1.4.2.1
    hashable-1.4.1.0-LUNCtsUMK7L3ZB2KEKWF7F
    hslogger-1.3.1.0-KzlhBMOSSdaFDR3rkwktqA
    lens-5.1.1-8cVW77ucFRGIbO4yMEfpoM mtl-2.2.2
    network-uri-2.6.4.1-CJy9K6CUGBYDMBcoIm8TMq
    rope-utf16-splay-0.3.2.0-JTWJbC9FmEXGY8HF1NJNnQ
    scientific-0.3.7.0-1l3L5iYBn9JD8GP8kLjgG7
    some-1.0.4.1-3oTC5bddeLcpEd54xiVBi template-haskell-2.17.0.0
    temporary-1.3-HXIdO020OG29nAlGx7vsUT text-1.2.5.0
    unordered-containers-0.2.19.1-1t66PwyRMuzEgWVME6Xx4r

haddock-interfaces:   /usr/share/doc/haskell-lsp-types/html/lsp-types.haddock
haddock-html:         /usr/share/doc/haskell-lsp-types/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

