#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 lsp-test
version:              0.14.0.1
visibility:           public
id:                   lsp-test-0.14.0.1-LEfmDfG6CYQ1owzQduPwvk
key:                  lsp-test-0.14.0.1-LEfmDfG6CYQ1owzQduPwvk
license:              BSD-3-Clause
copyright:            2021 Luke Lau
maintainer:           luke_lau@icloud.com
author:               Luke Lau
homepage:
    https://github.com/haskell/lsp/blob/master/lsp-test/README.md

synopsis:             Functional test framework for LSP servers.
description:
    A test framework for writing tests against
    <https://microsoft.github.io/language-server-protocol/ Language Server Protocol servers>.
    @Language.LSP.Test@ launches your server as a subprocess and allows you to simulate a session
    down to the wire.
    To see examples of it in action, check out <https://github.com/haskell/haskell-ide-engine haskell-ide-engine>,
    <https://github.com/haskell/haskell-language-server haskell-language-server> and
    <https://github.com/digital-asset/ghcide ghcide>.

category:             Testing
abi:                  b9eeff074e71c8941e312d48c911c474
exposed:              True
exposed-modules:
    Control.Applicative.Combinators from parser-combinators-1.3.0-FL5bcA6sX4a2ejs4tDtkjB:Control.Applicative.Combinators,
    Language.LSP.Test,
    Language.LSP.Types from lsp-types-1.3.0.1-A9OBFtru06V7IJgWtqPrq4:Language.LSP.Types,
    Language.LSP.Types.Capabilities from lsp-types-1.3.0.1-A9OBFtru06V7IJgWtqPrq4:Language.LSP.Types.Capabilities

hidden-modules:
    Language.LSP.Test.Compat Language.LSP.Test.Decoding
    Language.LSP.Test.Exceptions Language.LSP.Test.Files
    Language.LSP.Test.Parsing Language.LSP.Test.Server
    Language.LSP.Test.Session

import-dirs:          /usr/lib/ghc-9.0.2/site-local/lsp-test-0.14.0.1
library-dirs:         /usr/lib/ghc-9.0.2/site-local/lsp-test-0.14.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lsp-test
hs-libraries:         HSlsp-test-0.14.0.1-LEfmDfG6CYQ1owzQduPwvk
depends:
    Diff-0.4.1-2jMKpzJJQmAHzE6LyB7Qjk
    Glob-0.10.2-2hpHTQOFOu786tzr1Hmjwm
    aeson-2.1.0.0-3wSqLBA0fU13NhfXDmBpwT
    aeson-pretty-0.8.9-HIKDmSQGmI0DQYiuXhljjd
    ansi-terminal-0.11.3-4sOL9w5QIphDlJIIpaWFJL
    async-2.2.4-9EoKZTgytm43s60GeTAIZR base-4.15.1.0
    bytestring-0.10.12.1 conduit-1.3.4.3-8itn5Qj41ZSLgRSjBhzqyF
    conduit-parse-0.2.1.1-C4p3R4eayrt5Ow3V2K379J containers-0.6.4.1
    data-default-0.7.1.1-BkZarJ3J3008hHF2JOuYeW directory-1.3.6.2
    filepath-1.4.2.1 lens-5.1.1-8cVW77ucFRGIbO4yMEfpoM
    lsp-types-1.3.0.1-A9OBFtru06V7IJgWtqPrq4 mtl-2.2.2
    parser-combinators-1.3.0-FL5bcA6sX4a2ejs4tDtkjB process-1.6.13.2
    some-1.0.4.1-3oTC5bddeLcpEd54xiVBi text-1.2.5.0 time-1.9.3
    transformers-0.5.6.2 unix-2.7.2.2
    unordered-containers-0.2.19.1-1t66PwyRMuzEgWVME6Xx4r

haddock-interfaces:   /usr/share/doc/haskell-lsp-test/html/lsp-test.haddock
haddock-html:         /usr/share/doc/haskell-lsp-test/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

