#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 http-client-restricted
version:              0.0.5
visibility:           public
id:                   http-client-restricted-0.0.5-G5REIqXkZzPKCLCvLDjOyI
key:                  http-client-restricted-0.0.5-G5REIqXkZzPKCLCvLDjOyI
license:              MIT
copyright:            2018 Joey Hess, 2013 Michael Snoyman
maintainer:           Joey Hess <id@joeyh.name>
author:               Joey Hess
synopsis:             restricting the servers that http-client will use
description:
    Addition to the http-client and http-client-tls
    libraries, that restricts the HTTP servers that can be used.

    This is useful when a security policy needs to eg, prevent connections to
    HTTP servers on localhost or a local network, or only allow connections
    to a specific HTTP server.

    It handles restricting redirects as well as the initial HTTP connection,
    and it also guards against DNS poisoning attacks.

category:             Network
abi:                  04e1d51ea3975ea66da6879aa7bc5fe4
exposed:              True
exposed-modules:      Network.HTTP.Client.Restricted
import-dirs:          /usr/lib/ghc-9.0.2/site-local/http-client-restricted-0.0.5
library-dirs:         /usr/lib/ghc-9.0.2/site-local/http-client-restricted-0.0.5
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-http-client-restricted
hs-libraries:         HShttp-client-restricted-0.0.5-G5REIqXkZzPKCLCvLDjOyI
depends:
    base-4.15.1.0 connection-0.3.1-JYI1k0aRYnU8j2StkrJ4ln
    data-default-0.7.1.1-BkZarJ3J3008hHF2JOuYeW
    http-client-0.7.13.1-IUPmZAWhHcS7Jd2UKXuikW
    http-client-tls-0.3.6.1-KvEPoRWqIbH3HwtuX8a907
    network-3.1.2.7-2x6X3kWddA03AmOITnySLy
    network-bsd-2.8.1.0-G0YJ261wCUj2KpPFdlo1O4
    utf8-string-1.0.2-Fg3PN5UX3ZfnukMwwaDpj

haddock-interfaces:
    /usr/share/doc/haskell-http-client-restricted/html/http-client-restricted.haddock

haddock-html:         /usr/share/doc/haskell-http-client-restricted/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

