#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 hslua
version:              2.2.1
visibility:           public
id:                   hslua-2.2.1-44kucnvr9vu7w7UJh4vcRs
key:                  hslua-2.2.1-44kucnvr9vu7w7UJh4vcRs
license:              MIT
copyright:
    © 2007–2012 Gracjan Polak;
    © 2012–2016 Ömer Sinan Ağacan;
    © 2017-2022 Albert Krewinkel

maintainer:           albert+hslua@zeitkraut.de
author:               Albert Krewinkel, Gracjan Polak, Ömer Sinan Ağacan
homepage:             https://hslua.org/
synopsis:             Bindings to Lua, an embeddable scripting language
description:
    HsLua provides wrappers and helpers
    to bridge Haskell and <https://www.lua.org/ Lua>.

    It builds upon the /lua/ package, which allows to bundle
    a Lua interpreter with a Haskell program.

    Example programs are can be found in the @hslua-examples@
    subdir of the project
    <https://github.com/hslua/hslua repository>.

category:             Foreign
abi:                  12735198b07fd75b6c929174d77867be
exposed:              True
exposed-modules:
    HsLua,
    HsLua.Aeson from hslua-aeson-2.2.1-E1DrwEfFWv05RV5MuO20de:HsLua.Aeson,
    HsLua.Class.Exposable from hslua-classes-2.2.0-GevJmT4JD8w7YousOsqDtc:HsLua.Class.Exposable,
    HsLua.Class.Invokable from hslua-classes-2.2.0-GevJmT4JD8w7YousOsqDtc:HsLua.Class.Invokable,
    HsLua.Class.Peekable from hslua-classes-2.2.0-GevJmT4JD8w7YousOsqDtc:HsLua.Class.Peekable,
    HsLua.Class.Pushable from hslua-classes-2.2.0-GevJmT4JD8w7YousOsqDtc:HsLua.Class.Pushable,
    HsLua.Class.Util from hslua-classes-2.2.0-GevJmT4JD8w7YousOsqDtc:HsLua.Class.Util,
    HsLua.Core from hslua-core-2.2.1-6WQedKe1YRAomlPNCzRv2:HsLua.Core,
    HsLua.Core.Error from hslua-core-2.2.1-6WQedKe1YRAomlPNCzRv2:HsLua.Core.Error,
    HsLua.Core.Types from hslua-core-2.2.1-6WQedKe1YRAomlPNCzRv2:HsLua.Core.Types,
    HsLua.Core.Utf8 from hslua-core-2.2.1-6WQedKe1YRAomlPNCzRv2:HsLua.Core.Utf8,
    HsLua.Marshalling from hslua-marshalling-2.2.1-EeEmfmTmrwkJWLfmnZtave:HsLua.Marshalling,
    HsLua.ObjectOrientation from hslua-objectorientation-2.2.1-CLyGlRkFiUfKqOEGw5m3mo:HsLua.ObjectOrientation,
    HsLua.Packaging from hslua-packaging-2.2.1-1zK1XGBqEoD7PjQx9lUfAu:HsLua.Packaging,
    HsLua.Packaging.Function from hslua-packaging-2.2.1-1zK1XGBqEoD7PjQx9lUfAu:HsLua.Packaging.Function,
    HsLua.Packaging.Module from hslua-packaging-2.2.1-1zK1XGBqEoD7PjQx9lUfAu:HsLua.Packaging.Module,
    HsLua.Packaging.Rendering from hslua-packaging-2.2.1-1zK1XGBqEoD7PjQx9lUfAu:HsLua.Packaging.Rendering,
    HsLua.Util

import-dirs:          /usr/lib/ghc-9.0.2/site-local/hslua-2.2.1
library-dirs:         /usr/lib/ghc-9.0.2/site-local/hslua-2.2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hslua
hs-libraries:         HShslua-2.2.1-44kucnvr9vu7w7UJh4vcRs
depends:
    base-4.15.1.0 bytestring-0.10.12.1 containers-0.6.4.1
    exceptions-0.10.4 hslua-aeson-2.2.1-E1DrwEfFWv05RV5MuO20de
    hslua-classes-2.2.0-GevJmT4JD8w7YousOsqDtc
    hslua-core-2.2.1-6WQedKe1YRAomlPNCzRv2
    hslua-marshalling-2.2.1-EeEmfmTmrwkJWLfmnZtave
    hslua-objectorientation-2.2.1-CLyGlRkFiUfKqOEGw5m3mo
    hslua-packaging-2.2.1-1zK1XGBqEoD7PjQx9lUfAu mtl-2.2.2 text-1.2.5.0

haddock-interfaces:   /usr/share/doc/haskell-hslua/html/hslua.haddock
haddock-html:         /usr/share/doc/haskell-hslua/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

