#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 hledger-lib
version:              1.27.1
visibility:           public
id:                   hledger-lib-1.27.1-I6srZPrZvPGDtcWI2Kweqy
key:                  hledger-lib-1.27.1-I6srZPrZvPGDtcWI2Kweqy
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:
    A reusable library providing the core functionality of hledger

description:
    A reusable library containing hledger'\''s core functionality.
    This is used by most hledger* packages so that they support the same
    common file formats, command line options, reports etc.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  8ebe147abb211aded289fccbe121ef8b
exposed:              True
exposed-modules:
    Hledger Hledger.Data Hledger.Data.Account Hledger.Data.AccountName
    Hledger.Data.Amount Hledger.Data.Balancing Hledger.Data.Dates
    Hledger.Data.Errors Hledger.Data.Journal Hledger.Data.JournalChecks
    Hledger.Data.JournalChecks.Ordereddates
    Hledger.Data.JournalChecks.Uniqueleafnames Hledger.Data.Json
    Hledger.Data.Ledger Hledger.Data.Period
    Hledger.Data.PeriodicTransaction Hledger.Data.Posting
    Hledger.Data.RawOptions Hledger.Data.StringFormat
    Hledger.Data.Timeclock Hledger.Data.Transaction
    Hledger.Data.TransactionModifier Hledger.Data.Types
    Hledger.Data.Valuation Hledger.Query Hledger.Read
    Hledger.Read.Common Hledger.Read.CsvReader
    Hledger.Read.InputOptions Hledger.Read.JournalReader
    Hledger.Read.TimeclockReader Hledger.Read.TimedotReader
    Hledger.Reports Hledger.Reports.AccountTransactionsReport
    Hledger.Reports.BalanceReport Hledger.Reports.BudgetReport
    Hledger.Reports.EntriesReport Hledger.Reports.MultiBalanceReport
    Hledger.Reports.PostingsReport Hledger.Reports.ReportOptions
    Hledger.Reports.ReportTypes Hledger.Utils Hledger.Utils.Debug
    Hledger.Utils.Parse Hledger.Utils.Regex Hledger.Utils.String
    Hledger.Utils.Test Hledger.Utils.Text Text.Tabular.AsciiWide

hidden-modules:
    Text.Megaparsec.Custom Text.WideString Paths_hledger_lib

import-dirs:          /usr/lib/ghc-9.0.2/site-local/hledger-lib-1.27.1
library-dirs:         /usr/lib/ghc-9.0.2/site-local/hledger-lib-1.27.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hledger-lib
hs-libraries:         HShledger-lib-1.27.1-I6srZPrZvPGDtcWI2Kweqy
depends:
    Decimal-0.5.2-5TmJb6Vs4Vl5bvz4dK9QdP
    Glob-0.10.2-2hpHTQOFOu786tzr1Hmjwm
    aeson-2.1.0.0-3wSqLBA0fU13NhfXDmBpwT
    aeson-pretty-0.8.9-HIKDmSQGmI0DQYiuXhljjd
    ansi-terminal-0.11.3-4sOL9w5QIphDlJIIpaWFJL array-0.5.4.0
    base-4.15.1.0 blaze-markup-0.8.2.8-3wZdN7kDxS97Q5eM0mxELA
    breakpoint-0.1.0.0-Kyer6t83p0EufYOaIHkOT bytestring-0.10.12.1
    call-stack-0.4.0-GzzQb9Lrk0g4HpVkjTQ3aR
    cassava-0.5.3.0-HVRt9Yganpl4Iw2TRL91p
    cassava-megaparsec-2.0.4-I6pavWm5DU9D7rLQxIttCJ
    cmdargs-0.10.21-5dEStss8OK87s5amCxsPTV containers-0.6.4.1
    data-default-0.7.1.1-BkZarJ3J3008hHF2JOuYeW deepseq-1.4.5.0
    directory-1.3.6.2 doclayout-0.4-JUNdJMPDpmeDSop0PqDUQK
    extra-1.7.12-DPTGYhuNp118MPDFhQYU8g
    file-embed-0.0.15.0-FF5xUPWKaB3GI64c6hgPnn filepath-1.4.2.1
    hashtables-1.3.1-CYzHUQOg5RG9TFA6ECvfn8
    megaparsec-9.2.2-9J8e8j7w3nJKAXfYAylaYf
    microlens-0.4.13.0-8kbZITwqGed8vNsPXOVOwI
    microlens-th-0.4.3.10-H2JRp2jh1X4pUCK34kQqn mtl-2.2.2
    parser-combinators-1.3.0-FL5bcA6sX4a2ejs4tDtkjB
    pretty-simple-4.1.2.0-1OeFrj2zLl44a5ajMTxBMM
    regex-tdfa-1.3.2-tNtR2SpOBLAbbzDX5vBu9
    safe-0.3.19-2aVM1fCfxX88jnlVeNbd8Q
    tabular-0.2.2.8-3mznlUNrnmF8EH6LDY9YkX
    tasty-1.4.2.3-5g26BST7AomGP7PDx0otzq
    tasty-hunit-0.10.0.3-CEwjgm394VI2zE6CfGs6kZ
    template-haskell-2.17.0.0 text-1.2.5.0 time-1.9.3
    timeit-2.0-13BYXbUXu2MJzbvDZuPEww transformers-0.5.6.2
    uglymemo-0.1.0.1-K7bsHpbExS57pk9A4akql7
    unordered-containers-0.2.19.1-1t66PwyRMuzEgWVME6Xx4r
    utf8-string-1.0.2-Fg3PN5UX3ZfnukMwwaDpj

haddock-interfaces:   /usr/share/doc/haskell-hledger-lib/html/hledger-lib.haddock
haddock-html:         /usr/share/doc/haskell-hledger-lib/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

