#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 hasql
version:              1.5.0.4
visibility:           public
id:                   hasql-1.5.0.4-8duhy22wZmW90v3JUTLLQO
key:                  hasql-1.5.0.4-8duhy22wZmW90v3JUTLLQO
license:              MIT
copyright:            (c) 2014, Nikita Volkov
maintainer:           Nikita Volkov <nikita.y.volkov@mail.ru>
author:               Nikita Volkov <nikita.y.volkov@mail.ru>
homepage:             https://github.com/nikita-volkov/hasql
synopsis:             An efficient PostgreSQL driver with a flexible mapping API
description:
    Root of the \"hasql\" ecosystem.
    For details and tutorials see
    <https://github.com/nikita-volkov/hasql the readme>.

    The API comes free from all kinds of exceptions. All error-reporting is explicit and is presented using the '\''Either'\'' type.

category:             Hasql, Database, PostgreSQL
abi:                  007bee314ae8e0a34f9e2376e96e31a7
exposed:              True
exposed-modules:
    Hasql.Connection Hasql.Decoders Hasql.Encoders Hasql.Session
    Hasql.Statement

hidden-modules:
    Hasql.Private.Prelude Hasql.Private.Errors Hasql.Private.PTI
    Hasql.Private.IO Hasql.Private.Session Hasql.Private.Connection
    Hasql.Private.PreparedStatementRegistry Hasql.Private.Settings
    Hasql.Private.Commands Hasql.Private.Decoders
    Hasql.Private.Decoders.Array Hasql.Private.Decoders.Composite
    Hasql.Private.Decoders.Value Hasql.Private.Decoders.Row
    Hasql.Private.Decoders.Result Hasql.Private.Decoders.Results
    Hasql.Private.Encoders Hasql.Private.Encoders.Array
    Hasql.Private.Encoders.Value Hasql.Private.Encoders.Params

import-dirs:          /usr/lib/ghc-9.0.2/site-local/hasql-1.5.0.4
library-dirs:         /usr/lib/ghc-9.0.2/site-local/hasql-1.5.0.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hasql
hs-libraries:         HShasql-1.5.0.4-8duhy22wZmW90v3JUTLLQO
depends:
    attoparsec-0.14.4-9SQv4o2tq0k4n7CegIwza1 base-4.15.1.0
    bytestring-0.10.12.1
    bytestring-strict-builder-0.4.5.6-14KCOk3Zzo2FBldBfWH02P
    contravariant-1.5.5-FtJyCLyWfutGN2UWoJs8qd
    dlist-1.0-ImNlUre2rHgIkuGbqNQCOO
    hashable-1.4.1.0-LUNCtsUMK7L3ZB2KEKWF7F
    hashtables-1.3.1-CYzHUQOg5RG9TFA6ECvfn8 mtl-2.2.2
    postgresql-binary-0.12.5-BjnwCSfqQLG9uVoBmLlkJ1
    postgresql-libpq-0.9.4.3-IkP6G59sk5XEvvBwPSqWYy
    profunctors-5.6.2-3xiO6DN2a4J67KN3MHdaHJ text-1.2.5.0
    text-builder-0.6.7-6SO05xBWFwv8MLBHkvjfIw transformers-0.5.6.2
    vector-0.13.0.0-80dNWv5W93FGfZf7Ao5mAf

haddock-interfaces:   /usr/share/doc/haskell-hasql/html/hasql.haddock
haddock-html:         /usr/share/doc/haskell-hasql/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

