#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 free
version:              5.1.9
visibility:           public
id:                   free-5.1.9-41zgDvzFzX17DfjTczd8jf
key:                  free-5.1.9-41zgDvzFzX17DfjTczd8jf
license:              BSD-3-Clause
copyright:            Copyright (C) 2008-2015 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            provisional
homepage:             http://github.com/ekmett/free/
synopsis:             Monads for free
description:
    Free monads are useful for many tree-like structures and domain specific languages.

    If @f@ is a '\''Functor'\'' then the free '\''Monad'\'' on @f@ is the type
    of trees whose nodes are labeled with the constructors of @f@. The word
    \"free\" is used in the sense of \"unrestricted\" rather than \"zero-cost\":
    @Free f@ makes no constraining assumptions beyond those given by @f@ and the
    definition of '\''Monad'\''. As used here it is a standard term from the
    mathematical theory of adjoint functors.

    Cofree comonads are dual to free monads. They provide convenient ways to talk
    about branching streams and rose-trees, and can be used to annotate syntax
    trees. The cofree comonad can be seen as a stream parameterized by a '\''Functor'\''
    that controls its branching factor.

    More information on free monads, including examples, can be found in the
    following blog posts:
    <http://comonad.com/reader/2008/monads-for-free/>
    <http://comonad.com/reader/2011/free-monads-for-less/>

category:             Control, Monads
abi:                  922b90e63f09fdedb0b67421072188cf
exposed:              True
exposed-modules:
    Control.Alternative.Free Control.Alternative.Free.Final
    Control.Applicative.Free Control.Applicative.Free.Fast
    Control.Applicative.Free.Final Control.Applicative.Trans.Free
    Control.Comonad.Cofree Control.Comonad.Cofree.Class
    Control.Comonad.Trans.Cofree Control.Comonad.Trans.Coiter
    Control.Monad.Free Control.Monad.Free.Ap Control.Monad.Free.Church
    Control.Monad.Free.Class Control.Monad.Free.TH
    Control.Monad.Trans.Free Control.Monad.Trans.Free.Ap
    Control.Monad.Trans.Free.Church Control.Monad.Trans.Iter

hidden-modules:       Data.Functor.Classes.Compat
import-dirs:          /usr/lib/ghc-9.0.2/site-local/free-5.1.9
library-dirs:         /usr/lib/ghc-9.0.2/site-local/free-5.1.9
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-free
hs-libraries:         HSfree-5.1.9-41zgDvzFzX17DfjTczd8jf
includes:             free-common.h
depends:
    base-4.15.1.0 comonad-5.0.8-Jb01JIbkjpK9yzpetzUNIv
    containers-0.6.4.1 distributive-0.6.2.1-9wcbdvxUhl373VFDpLmb6H
    exceptions-0.10.4 indexed-traversable-0.1.2-55rCITp0bj2K4TSTU28RrG
    mtl-2.2.2 profunctors-5.6.2-3xiO6DN2a4J67KN3MHdaHJ
    semigroupoids-5.3.7-HwCM6hSIfxCIEi8aYGOr6m
    template-haskell-2.17.0.0
    th-abstraction-0.4.5.0-CPrpKcr2W2S31K8QsJKgDp transformers-0.5.6.2
    transformers-base-0.4.6-2M49J28Ed0L2XQvH4AySxP

haddock-interfaces:   /usr/share/doc/haskell-free/html/free.haddock
haddock-html:         /usr/share/doc/haskell-free/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

