#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 direct-sqlite
version:              2.3.27
visibility:           public
id:                   direct-sqlite-2.3.27-JFOyYFlQ2p4FeReuyQXGhs
key:                  direct-sqlite-2.3.27-JFOyYFlQ2p4FeReuyQXGhs
license:              BSD-3-Clause
copyright:
    Copyright (c) 2012 - 2014 Irene Knapp,
    2014 - 2018 Janne Hellsten,
    2018 - 2020 Sergey Bushnyak,
    2022        Joshua Chia

maintainer:           Joshua Chia <joshchia@gmail.com>
author:               Irene Knapp <irene.knapp@icloud.com>
homepage:             https://github.com/IreneKnapp/direct-sqlite
synopsis:
    Low-level binding to SQLite3.  Includes UTF8 and BLOB support.

description:
    This package is not very different from the other SQLite3 bindings out
    there, but it fixes a few deficiencies I was finding.  As compared to
    bindings-sqlite3, it is slightly higher-level, in that it supports
    marshalling of data values to and from the database.  In particular,
    it supports strings encoded as UTF8, and BLOBs represented as
    ByteStrings.

category:             Database
abi:                  d739abee86bbfeb885716cd0ec2d805f
exposed:              True
exposed-modules:
    Database.SQLite3 Database.SQLite3.Bindings
    Database.SQLite3.Bindings.Types Database.SQLite3.Direct

import-dirs:          /usr/lib/ghc-9.0.2/site-local/direct-sqlite-2.3.27
library-dirs:         /usr/lib/ghc-9.0.2/site-local/direct-sqlite-2.3.27
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-direct-sqlite
hs-libraries:         HSdirect-sqlite-2.3.27-JFOyYFlQ2p4FeReuyQXGhs
extra-libraries:      sqlite3
depends:              base-4.15.1.0 bytestring-0.10.12.1 text-1.2.5.0
haddock-interfaces:
    /usr/share/doc/haskell-direct-sqlite/html/direct-sqlite.haddock

haddock-html:         /usr/share/doc/haskell-direct-sqlite/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

