#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 dependent-sum
version:              0.7.1.0
visibility:           public
id:                   dependent-sum-0.7.1.0-5cVuFUxtTBz51MaigKE0Ld
key:                  dependent-sum-0.7.1.0-5cVuFUxtTBz51MaigKE0Ld
license:              LicenseRef-PublicDomain
maintainer:           Obsidian Systems, LLC <maintainer@obsidian.systems>
author:               James Cook <mokus@deepbondi.net>
stability:            provisional
homepage:             https://github.com/obsidiansystems/dependent-sum
synopsis:             Dependent sum type
description:
    A dependent sum is a generalization of a
    particular way of thinking about the @Either@
    type.  @Either a b@ can be thought of as a
    2-tuple @(tag, value)@, where the value of the
    tag determines the type of the value.  In
    particular, either @tag = Left@ and @value :: a@
    or @tag = Right@ and @value :: b@.

    This package allows you to define your own
    dependent sum types by using your own \"tag\"
    types.

category:             Data, Dependent Types
abi:                  931991ea649fbbeb2ec167eed4b5b9b8
exposed:              True
exposed-modules:
    Data.Dependent.Sum,
    Data.GADT.Compare from some-1.0.4.1-3oTC5bddeLcpEd54xiVBi:Data.GADT.Compare,
    Data.GADT.Show from some-1.0.4.1-3oTC5bddeLcpEd54xiVBi:Data.GADT.Show,
    Data.Some from some-1.0.4.1-3oTC5bddeLcpEd54xiVBi:Data.Some

import-dirs:          /usr/lib/ghc-9.0.2/site-local/dependent-sum-0.7.1.0
library-dirs:         /usr/lib/ghc-9.0.2/site-local/dependent-sum-0.7.1.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-dependent-sum
hs-libraries:         HSdependent-sum-0.7.1.0-5cVuFUxtTBz51MaigKE0Ld
depends:
    base-4.15.1.0 constraints-extras-0.3.2.1-F3vmWcXcDkx8Fh5jHMQnk9
    some-1.0.4.1-3oTC5bddeLcpEd54xiVBi

haddock-interfaces:
    /usr/share/doc/haskell-dependent-sum/html/dependent-sum.haddock

haddock-html:         /usr/share/doc/haskell-dependent-sum/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

