#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 cpphs
version:              1.20.9.1
visibility:           public
id:                   cpphs-1.20.9.1-1jAFiSyqcHj3RbgQIQP02q
key:                  cpphs-1.20.9.1-1jAFiSyqcHj3RbgQIQP02q
license:              LicenseRef-LGPL
copyright:            2004-2017, Malcolm Wallace
maintainer:           Malcolm Wallace <Malcolm.Wallace@me.com>
author:               Malcolm Wallace <Malcolm.Wallace@me.com>
homepage:             http://projects.haskell.org/cpphs/
synopsis:
    A liberalised re-implementation of cpp, the C pre-processor.

description:
    Cpphs is a re-implementation of the C pre-processor that is both
    more compatible with Haskell, and itself written in Haskell so
    that it can be distributed with compilers.

    This version of the C pre-processor is pretty-much
    feature-complete and compatible with traditional (K&R)
    pre-processors.  Additional features include: a plain-text mode;
    an option to unlit literate code files; and an option to turn
    off macro-expansion.

category:             Development
abi:                  6050cf2a4171bc43cbe7097b7215fb20
exposed:              True
exposed-modules:
    Language.Preprocessor.Cpphs Language.Preprocessor.Unlit

hidden-modules:
    Language.Preprocessor.Cpphs.CppIfdef
    Language.Preprocessor.Cpphs.HashDefine
    Language.Preprocessor.Cpphs.MacroPass
    Language.Preprocessor.Cpphs.Options
    Language.Preprocessor.Cpphs.Position
    Language.Preprocessor.Cpphs.ReadFirst
    Language.Preprocessor.Cpphs.RunCpphs
    Language.Preprocessor.Cpphs.SymTab
    Language.Preprocessor.Cpphs.Tokenise TimeCompat

import-dirs:          /usr/lib/ghc-9.0.2/site-local/cpphs-1.20.9.1
library-dirs:         /usr/lib/ghc-9.0.2/site-local/cpphs-1.20.9.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.2/cpphs-1.20.9.1
hs-libraries:         HScpphs-1.20.9.1-1jAFiSyqcHj3RbgQIQP02q
depends:
    base-4.15.1.0 directory-1.3.6.2
    polyparse-1.13-6qWX0TBgzpT5PvWL8guBB0 time-1.9.3

haddock-interfaces:   /usr/share/doc/haskell-cpphs/html/cpphs.haddock
haddock-html:         /usr/share/doc/haskell-cpphs/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

