#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 config-ini
version:              0.2.5.0
visibility:           public
id:                   config-ini-0.2.5.0-9Ttdmhpqs5gCIBKBq91klk
key:                  config-ini-0.2.5.0-9Ttdmhpqs5gCIBKBq91klk
license:              BSD-3-Clause
copyright:            ©2018 Getty Ritter
maintainer:           Getty Ritter <config-ini@infinitenegativeutility.com>
author:               Getty Ritter <config-ini@infinitenegativeutility.com>
homepage:             https://github.com/aisamanra/config-ini
synopsis:             A library for simple INI-based configuration files.
description:
    The @config-ini@ library is a set of small monadic languages
    for writing simple configuration languages with convenient,
    human-readable error messages.

    > parseConfig :: IniParser (Text, Int, Bool)
    > parseConfig = section "NETWORK" $ do
    >   user <- field        "user"
    >   port <- fieldOf      "port" number
    >   enc  <- fieldFlagDef "encryption" True
    >   return (user, port, enc)

category:             Configuration
abi:                  c1bedf9440b3d22deb7406e3f021799b
exposed:              True
exposed-modules:
    Data.Ini.Config Data.Ini.Config.Bidir Data.Ini.Config.Raw

import-dirs:          /usr/lib/ghc-9.0.2/site-local/config-ini-0.2.5.0
library-dirs:         /usr/lib/ghc-9.0.2/site-local/config-ini-0.2.5.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-config-ini
hs-libraries:         HSconfig-ini-0.2.5.0-9Ttdmhpqs5gCIBKBq91klk
depends:
    base-4.15.1.0 containers-0.6.4.1
    megaparsec-9.2.2-9J8e8j7w3nJKAXfYAylaYf text-1.2.5.0
    transformers-0.5.6.2
    unordered-containers-0.2.19.1-1t66PwyRMuzEgWVME6Xx4r

haddock-interfaces:   /usr/share/doc/haskell-config-ini/html/config-ini.haddock
haddock-html:         /usr/share/doc/haskell-config-ini/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

