#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 conduit
version:              1.3.4.3
visibility:           public
id:                   conduit-1.3.4.3-8itn5Qj41ZSLgRSjBhzqyF
key:                  conduit-1.3.4.3-8itn5Qj41ZSLgRSjBhzqyF
license:              MIT
maintainer:           michael@snoyman.com
author:               Michael Snoyman
homepage:             http://github.com/snoyberg/conduit
synopsis:             Streaming data processing library.
description:
    `conduit` is a solution to the streaming data problem, allowing for production,
    transformation, and consumption of streams of data in constant memory. It is an
    alternative to lazy I\/O which guarantees deterministic resource handling.

    For more information about conduit in general, and how this package in
    particular fits into the ecosystem, see [the conduit
    homepage](https://github.com/snoyberg/conduit#readme).

    Hackage documentation generation is not reliable. For up to date documentation, please see: <http://www.stackage.org/package/conduit>.

category:             Data, Conduit
abi:                  ae9d79a80c26aa52d7dbf1c066f19951
exposed:              True
exposed-modules:
    Conduit Data.Conduit Data.Conduit.Combinators
    Data.Conduit.Combinators.Stream Data.Conduit.Internal
    Data.Conduit.Internal.Fusion Data.Conduit.Internal.List.Stream
    Data.Conduit.Lift Data.Conduit.List

hidden-modules:
    Data.Conduit.Internal.Pipe Data.Conduit.Internal.Conduit
    Data.Conduit.Combinators.Unqualified Data.Streaming.FileRead
    Data.Streaming.Filesystem

import-dirs:          /usr/lib/ghc-9.0.2/site-local/conduit-1.3.4.3
library-dirs:         /usr/lib/ghc-9.0.2/site-local/conduit-1.3.4.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-conduit
hs-libraries:         HSconduit-1.3.4.3-8itn5Qj41ZSLgRSjBhzqyF
depends:
    base-4.15.1.0 bytestring-0.10.12.1 directory-1.3.6.2
    exceptions-0.10.4 filepath-1.4.2.1
    mono-traversable-1.0.15.3-K7wBJJGcegwIjNdRUDxR8g mtl-2.2.2
    primitive-0.7.4.0-CfTIpXUHtu665Ilg6bT1BW
    resourcet-1.2.6-3amKdWDZReE3TYUO4zdEYT text-1.2.5.0
    transformers-0.5.6.2 unix-2.7.2.2
    unliftio-core-0.2.0.1-HjGpVpPktr5Bc3kYrL6LtS
    vector-0.13.0.0-80dNWv5W93FGfZf7Ao5mAf

haddock-interfaces:   /usr/share/doc/haskell-conduit/html/conduit.haddock
haddock-html:         /usr/share/doc/haskell-conduit/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

