#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 concurrent-output
version:              1.10.16
visibility:           public
id:                   concurrent-output-1.10.16-8Tm6NakcZAl2rsJ6riL3qW
key:                  concurrent-output-1.10.16-8Tm6NakcZAl2rsJ6riL3qW
license:              BSD-2-Clause
copyright:            2015-2021 Joey Hess, 2009 Joachim Breitner
maintainer:           Joey Hess <id@joeyh.name>
author:               Joey Hess, Joachim Breitner
stability:            Stable
synopsis:             Ungarble output from several threads or commands
description:
    Lets multiple threads and external processes concurrently output to the
    console, without it getting all garbled up.

    Built on top of that is a way of defining multiple output regions,
    which are automatically laid out on the screen and can be individually
    updated by concurrent threads. Can be used for progress displays etc.

    <<https://joeyh.name/code/concurrent-output/demo2.gif>>

category:             User Interfaces
abi:                  1f143ac5ed94ded901e5185ec43f783d
exposed:              True
exposed-modules:
    System.Console.Concurrent System.Console.Concurrent.Internal
    System.Console.Regions System.Process.Concurrent

hidden-modules:       Utility.Monad Utility.Exception
import-dirs:          /usr/lib/ghc-9.0.2/site-local/concurrent-output-1.10.16
library-dirs:         /usr/lib/ghc-9.0.2/site-local/concurrent-output-1.10.16
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-concurrent-output
hs-libraries:         HSconcurrent-output-1.10.16-8Tm6NakcZAl2rsJ6riL3qW
depends:
    ansi-terminal-0.11.3-4sOL9w5QIphDlJIIpaWFJL
    async-2.2.4-9EoKZTgytm43s60GeTAIZR base-4.15.1.0 directory-1.3.6.2
    exceptions-0.10.4 process-1.6.13.2 stm-2.5.0.0
    terminal-size-0.3.3-9JiTHA73QXVH7lW7Leoqqc text-1.2.5.0
    transformers-0.5.6.2 unix-2.7.2.2

haddock-interfaces:
    /usr/share/doc/haskell-concurrent-output/html/concurrent-output.haddock

haddock-html:         /usr/share/doc/haskell-concurrent-output/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

