#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 cassava
version:              0.5.3.0
visibility:           public
id:                   cassava-0.5.3.0-HVRt9Yganpl4Iw2TRL91p
key:                  cassava-0.5.3.0-HVRt9Yganpl4Iw2TRL91p
license:              BSD-3-Clause
copyright:
    (c) 2012 Johan Tibell
    (c) 2012 Bryan O'\''Sullivan
    (c) 2011 MailRank, Inc.

maintainer:           https://github.com/haskell-hvr/cassava
author:               Johan Tibell
homepage:             https://github.com/haskell-hvr/cassava
synopsis:             A CSV parsing and encoding library
description:
    @cassava@ is a library for parsing and encoding [RFC 4180](https://tools.ietf.org/html/rfc4180)
    compliant [comma-separated values (CSV)](https://en.wikipedia.org/wiki/Comma-separated_values) data,
    which is a textual line-oriented format commonly used for exchanging tabular data.

    @cassava@'\''s API includes support for

    - Index-based record-conversion
    - Name-based record-conversion
    - Typeclass directed conversion of fields and records
    - Built-in field-conversion instances for standard types
    - Customizable record-conversion instance derivation via GHC generics
    - Low-level [bytestring](https://hackage.haskell.org/package/bytestring) builders (see "Data.Csv.Builder")
    - Incremental decoding and encoding API (see "Data.Csv.Incremental")
    - Streaming API for constant-space decoding (see "Data.Csv.Streaming")

    Moreover, this library is designed to be easy to use; for instance, here'\''s a
    very simple example of encoding CSV data:

    >>> Data.Csv.encode [("John",27),("Jane",28)]
    "John,27\r\nJane,28\r\n"

    Please refer to the documentation in "Data.Csv" and the included [README](#readme) for more usage examples.

category:             Text, Web, CSV
abi:                  71353ea5b4ae204decb1e098c952b0cd
exposed:              True
exposed-modules:
    Data.Csv Data.Csv.Builder Data.Csv.Incremental Data.Csv.Parser
    Data.Csv.Streaming

hidden-modules:
    Data.Csv.Conversion Data.Csv.Conversion.Internal Data.Csv.Encoding
    Data.Csv.Types Data.Csv.Util

import-dirs:          /usr/lib/ghc-9.0.2/site-local/cassava-0.5.3.0
library-dirs:         /usr/lib/ghc-9.0.2/site-local/cassava-0.5.3.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-cassava
hs-libraries:         HScassava-0.5.3.0-HVRt9Yganpl4Iw2TRL91p
depends:
    Only-0.1-L8QgoWg4Wjg75H1UNFo3nI array-0.5.4.0
    attoparsec-0.14.4-9SQv4o2tq0k4n7CegIwza1 base-4.15.1.0
    bytestring-0.10.12.1 containers-0.6.4.1 deepseq-1.4.5.0
    hashable-1.4.1.0-LUNCtsUMK7L3ZB2KEKWF7F
    scientific-0.3.7.0-1l3L5iYBn9JD8GP8kLjgG7 text-1.2.5.0
    text-short-0.1.5-BpUmYQpnlq5B0lAlfuthm transformers-0.5.6.2
    unordered-containers-0.2.19.1-1t66PwyRMuzEgWVME6Xx4r
    vector-0.13.0.0-80dNWv5W93FGfZf7Ao5mAf

haddock-interfaces:   /usr/share/doc/haskell-cassava/html/cassava.haddock
haddock-html:         /usr/share/doc/haskell-cassava/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

