#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 async
version:              2.2.4
visibility:           public
id:                   async-2.2.4-9EoKZTgytm43s60GeTAIZR
key:                  async-2.2.4-9EoKZTgytm43s60GeTAIZR
license:              BSD-3-Clause
copyright:            (c) Simon Marlow 2012
maintainer:           Simon Marlow <marlowsd@gmail.com>
author:               Simon Marlow
homepage:             https://github.com/simonmar/async
synopsis:             Run IO operations asynchronously and wait for their results
description:
    This package provides a higher-level interface over
    threads, in which an @Async a@ is a concurrent
    thread that will eventually deliver a value of
    type @a@.  The package provides ways to create
    @Async@ computations, wait for their results, and
    cancel them.

    Using @Async@ is safer than using threads in two
    ways:

    * When waiting for a thread to return a result,
    if the thread dies with an exception then the
    caller must either re-throw the exception
    ('\''wait'\'') or handle it ('\''waitCatch'\''); the
    exception cannot be ignored.

    * The API makes it possible to build a tree of
    threads that are automatically killed when
    their parent dies (see '\''withAsync'\'').

category:             Concurrency
abi:                  d67709dea7036861d6e9da38f391e1a1
exposed:              True
exposed-modules:      Control.Concurrent.Async
import-dirs:          /usr/lib/ghc-9.0.2/site-local/async-2.2.4
library-dirs:         /usr/lib/ghc-9.0.2/site-local/async-2.2.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-async
hs-libraries:         HSasync-2.2.4-9EoKZTgytm43s60GeTAIZR
depends:
    base-4.15.1.0 hashable-1.4.1.0-LUNCtsUMK7L3ZB2KEKWF7F stm-2.5.0.0

haddock-interfaces:   /usr/share/doc/haskell-async/html/async.haddock
haddock-html:         /usr/share/doc/haskell-async/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

