// Code generated by "./generator com.deepin.daemon.kwayland"; DO NOT EDIT.

package kwayland

import (
	"errors"
	"fmt"
	"unsafe"

	"github.com/godbus/dbus"
	"github.com/linuxdeepin/go-lib/dbusutil"
	"github.com/linuxdeepin/go-lib/dbusutil/proxy"
)

type OutputManagement interface {
	outputManagement // interface com.deepin.daemon.KWayland.Output
	proxy.Object
}

type objectOutputManagement struct {
	interfaceOutputManagement // interface com.deepin.daemon.KWayland.Output
	proxy.ImplObject
}

func NewOutputManagement(conn *dbus.Conn) OutputManagement {
	obj := new(objectOutputManagement)
	obj.ImplObject.Init_(conn, "com.deepin.daemon.KWayland", "/com/deepin/daemon/KWayland/Output")
	return obj
}

type outputManagement interface {
	GoListOutput(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	ListOutput(flags dbus.Flags) (string, error)
	GoGetOutput(flags dbus.Flags, ch chan *dbus.Call, arg1 string) *dbus.Call
	GetOutput(flags dbus.Flags, arg1 string) (string, error)
	GoApply(flags dbus.Flags, ch chan *dbus.Call, outputs string) *dbus.Call
	Apply(flags dbus.Flags, outputs string) error
	GoWlSimulateKey(flags dbus.Flags, ch chan *dbus.Call, state int32) *dbus.Call
	WlSimulateKey(flags dbus.Flags, state int32) error
	ConnectOutputAdded(cb func(output string)) (dbusutil.SignalHandlerId, error)
	ConnectOutputRemoved(cb func(output string)) (dbusutil.SignalHandlerId, error)
	ConnectOutputChanged(cb func(output string)) (dbusutil.SignalHandlerId, error)
}

type interfaceOutputManagement struct{}

func (v *interfaceOutputManagement) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceOutputManagement) GetInterfaceName_() string {
	return "com.deepin.daemon.KWayland.Output"
}

// method ListOutput

func (v *interfaceOutputManagement) GoListOutput(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".ListOutput", flags, ch)
}

func (*interfaceOutputManagement) StoreListOutput(call *dbus.Call) (arg0 string, err error) {
	err = call.Store(&arg0)
	return
}

func (v *interfaceOutputManagement) ListOutput(flags dbus.Flags) (string, error) {
	return v.StoreListOutput(
		<-v.GoListOutput(flags, make(chan *dbus.Call, 1)).Done)
}

// method GetOutput

func (v *interfaceOutputManagement) GoGetOutput(flags dbus.Flags, ch chan *dbus.Call, arg1 string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".GetOutput", flags, ch, arg1)
}

func (*interfaceOutputManagement) StoreGetOutput(call *dbus.Call) (arg0 string, err error) {
	err = call.Store(&arg0)
	return
}

func (v *interfaceOutputManagement) GetOutput(flags dbus.Flags, arg1 string) (string, error) {
	return v.StoreGetOutput(
		<-v.GoGetOutput(flags, make(chan *dbus.Call, 1), arg1).Done)
}

// method Apply

func (v *interfaceOutputManagement) GoApply(flags dbus.Flags, ch chan *dbus.Call, outputs string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Apply", flags, ch, outputs)
}

func (v *interfaceOutputManagement) Apply(flags dbus.Flags, outputs string) error {
	return (<-v.GoApply(flags, make(chan *dbus.Call, 1), outputs).Done).Err
}

// method WlSimulateKey

func (v *interfaceOutputManagement) GoWlSimulateKey(flags dbus.Flags, ch chan *dbus.Call, state int32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".WlSimulateKey", flags, ch, state)
}

func (v *interfaceOutputManagement) WlSimulateKey(flags dbus.Flags, state int32) error {
	return (<-v.GoWlSimulateKey(flags, make(chan *dbus.Call, 1), state).Done).Err
}

// signal OutputAdded

func (v *interfaceOutputManagement) ConnectOutputAdded(cb func(output string)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "OutputAdded", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".OutputAdded",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var output string
		err := dbus.Store(sig.Body, &output)
		if err == nil {
			cb(output)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal OutputRemoved

func (v *interfaceOutputManagement) ConnectOutputRemoved(cb func(output string)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "OutputRemoved", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".OutputRemoved",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var output string
		err := dbus.Store(sig.Body, &output)
		if err == nil {
			cb(output)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal OutputChanged

func (v *interfaceOutputManagement) ConnectOutputChanged(cb func(output string)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "OutputChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".OutputChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var output string
		err := dbus.Store(sig.Body, &output)
		if err == nil {
			cb(output)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

type WindowManager interface {
	windowManager // interface com.deepin.daemon.KWayland.WindowManager
	proxy.Object
}

type objectWindowManager struct {
	interfaceWindowManager // interface com.deepin.daemon.KWayland.WindowManager
	proxy.ImplObject
}

func NewWindowManager(conn *dbus.Conn) WindowManager {
	obj := new(objectWindowManager)
	obj.ImplObject.Init_(conn, "com.deepin.daemon.KWayland", "/com/deepin/daemon/KWayland/WindowManager")
	return obj
}

type windowManager interface {
	GoActiveWindow(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	ActiveWindow(flags dbus.Flags) (uint32, error)
	GoIsShowingDesktop(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	IsShowingDesktop(flags dbus.Flags) (bool, error)
	GoWindows(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	Windows(flags dbus.Flags) ([]dbus.Variant, error)
	ConnectWindowCreated(cb func(ObjPath string)) (dbusutil.SignalHandlerId, error)
	ConnectWindowRemove(cb func(ObjPath string)) (dbusutil.SignalHandlerId, error)
	ConnectActiveWindowChanged(cb func()) (dbusutil.SignalHandlerId, error)
}

type interfaceWindowManager struct{}

func (v *interfaceWindowManager) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceWindowManager) GetInterfaceName_() string {
	return "com.deepin.daemon.KWayland.WindowManager"
}

// method ActiveWindow

func (v *interfaceWindowManager) GoActiveWindow(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".ActiveWindow", flags, ch)
}

func (*interfaceWindowManager) StoreActiveWindow(call *dbus.Call) (argout0 uint32, err error) {
	err = call.Store(&argout0)
	return
}

func (v *interfaceWindowManager) ActiveWindow(flags dbus.Flags) (uint32, error) {
	return v.StoreActiveWindow(
		<-v.GoActiveWindow(flags, make(chan *dbus.Call, 1)).Done)
}

// method IsShowingDesktop

func (v *interfaceWindowManager) GoIsShowingDesktop(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".IsShowingDesktop", flags, ch)
}

func (*interfaceWindowManager) StoreIsShowingDesktop(call *dbus.Call) (argout0 bool, err error) {
	err = call.Store(&argout0)
	return
}

func (v *interfaceWindowManager) IsShowingDesktop(flags dbus.Flags) (bool, error) {
	return v.StoreIsShowingDesktop(
		<-v.GoIsShowingDesktop(flags, make(chan *dbus.Call, 1)).Done)
}

// method Windows

func (v *interfaceWindowManager) GoWindows(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Windows", flags, ch)
}

func (*interfaceWindowManager) StoreWindows(call *dbus.Call) (argout0 []dbus.Variant, err error) {
	err = call.Store(&argout0)
	return
}

func (v *interfaceWindowManager) Windows(flags dbus.Flags) ([]dbus.Variant, error) {
	return v.StoreWindows(
		<-v.GoWindows(flags, make(chan *dbus.Call, 1)).Done)
}

// signal WindowCreated

func (v *interfaceWindowManager) ConnectWindowCreated(cb func(ObjPath string)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "WindowCreated", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".WindowCreated",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var ObjPath string
		err := dbus.Store(sig.Body, &ObjPath)
		if err == nil {
			cb(ObjPath)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal WindowRemove

func (v *interfaceWindowManager) ConnectWindowRemove(cb func(ObjPath string)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "WindowRemove", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".WindowRemove",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var ObjPath string
		err := dbus.Store(sig.Body, &ObjPath)
		if err == nil {
			cb(ObjPath)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal ActiveWindowChanged

func (v *interfaceWindowManager) ConnectActiveWindowChanged(cb func()) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "ActiveWindowChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".ActiveWindowChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		cb()
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

type Window interface {
	window // interface com.deepin.daemon.KWayland.PlasmaWindow
	proxy.Object
}

type objectWindow struct {
	interfaceWindow // interface com.deepin.daemon.KWayland.PlasmaWindow
	proxy.ImplObject
}

func NewWindow(conn *dbus.Conn, path dbus.ObjectPath) (Window, error) {
	if !path.IsValid() {
		return nil, errors.New("path is invalid")
	}
	obj := new(objectWindow)
	obj.ImplObject.Init_(conn, "com.deepin.daemon.KWayland", path)
	return obj, nil
}

type window interface {
	GoAppId(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	AppId(flags dbus.Flags) (string, error)
	GoGeometry(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	Geometry(flags dbus.Flags) (Rect, error)
	GoIcon(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	Icon(flags dbus.Flags) (string, error)
	GoInternalId(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	InternalId(flags dbus.Flags) (uint32, error)
	GoIsActive(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	IsActive(flags dbus.Flags) (bool, error)
	GoIsCloseable(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	IsCloseable(flags dbus.Flags) (bool, error)
	GoIsDemandingAttention(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	IsDemandingAttention(flags dbus.Flags) (bool, error)
	GoIsFullscreen(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	IsFullscreen(flags dbus.Flags) (bool, error)
	GoIsFullscreenable(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	IsFullscreenable(flags dbus.Flags) (bool, error)
	GoIsKeepAbove(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	IsKeepAbove(flags dbus.Flags) (bool, error)
	GoIsMaximizeable(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	IsMaximizeable(flags dbus.Flags) (bool, error)
	GoIsMaximized(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	IsMaximized(flags dbus.Flags) (bool, error)
	GoIsMinimizeable(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	IsMinimizeable(flags dbus.Flags) (bool, error)
	GoIsMinimized(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	IsMinimized(flags dbus.Flags) (bool, error)
	GoIsMovable(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	IsMovable(flags dbus.Flags) (bool, error)
	GoIsOnAllDesktops(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	IsOnAllDesktops(flags dbus.Flags) (bool, error)
	GoIsResizable(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	IsResizable(flags dbus.Flags) (bool, error)
	GoIsShadeable(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	IsShadeable(flags dbus.Flags) (bool, error)
	GoIsShaded(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	IsShaded(flags dbus.Flags) (bool, error)
	GoIsValid(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	IsValid(flags dbus.Flags) (bool, error)
	GoIsVirtualDesktopChangeable(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	IsVirtualDesktopChangeable(flags dbus.Flags) (bool, error)
	GoPid(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	Pid(flags dbus.Flags) (uint32, error)
	GoRequestActivate(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	RequestActivate(flags dbus.Flags) error
	GoRequestClose(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	RequestClose(flags dbus.Flags) error
	GoRequestEnterNewVirtualDesktop(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	RequestEnterNewVirtualDesktop(flags dbus.Flags) error
	GoRequestEnterVirtualDesktop(flags dbus.Flags, ch chan *dbus.Call, argin0 string) *dbus.Call
	RequestEnterVirtualDesktop(flags dbus.Flags, argin0 string) error
	GoRequestLeaveVirtualDesktop(flags dbus.Flags, ch chan *dbus.Call, argin0 string) *dbus.Call
	RequestLeaveVirtualDesktop(flags dbus.Flags, argin0 string) error
	GoRequestMove(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	RequestMove(flags dbus.Flags) error
	GoRequestResize(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	RequestResize(flags dbus.Flags) error
	GoRequestToggleKeepAbove(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	RequestToggleKeepAbove(flags dbus.Flags) error
	GoRequestToggleKeepBelow(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	RequestToggleKeepBelow(flags dbus.Flags) error
	GoRequestToggleMaximized(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	RequestToggleMaximized(flags dbus.Flags) error
	GoRequestToggleMinimized(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	RequestToggleMinimized(flags dbus.Flags) error
	GoRequestToggleShaded(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	RequestToggleShaded(flags dbus.Flags) error
	GoRequestVirtualDesktop(flags dbus.Flags, ch chan *dbus.Call, argin0 uint32) *dbus.Call
	RequestVirtualDesktop(flags dbus.Flags, argin0 uint32) error
	GoSkipSwitcher(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	SkipSwitcher(flags dbus.Flags) (bool, error)
	GoSkipTaskbar(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	SkipTaskbar(flags dbus.Flags) (bool, error)
	GoTitle(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	Title(flags dbus.Flags) (string, error)
	GoVirtualDesktop(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	VirtualDesktop(flags dbus.Flags) (uint32, error)
	GoWindowId(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	WindowId(flags dbus.Flags) (uint32, error)
	ConnectActiveChanged(cb func()) (dbusutil.SignalHandlerId, error)
	ConnectAppIdChanged(cb func()) (dbusutil.SignalHandlerId, error)
	ConnectCloseableChanged(cb func()) (dbusutil.SignalHandlerId, error)
	ConnectDemandsAttentionChanged(cb func()) (dbusutil.SignalHandlerId, error)
	ConnectFullscreenableChanged(cb func()) (dbusutil.SignalHandlerId, error)
	ConnectFullscreenChanged(cb func()) (dbusutil.SignalHandlerId, error)
	ConnectGeometryChanged(cb func()) (dbusutil.SignalHandlerId, error)
	ConnectIconChanged(cb func()) (dbusutil.SignalHandlerId, error)
	ConnectKeepAboveChanged(cb func()) (dbusutil.SignalHandlerId, error)
	ConnectKeepBelowChanged(cb func()) (dbusutil.SignalHandlerId, error)
	ConnectMaximizeableChanged(cb func()) (dbusutil.SignalHandlerId, error)
	ConnectMaximizedChanged(cb func()) (dbusutil.SignalHandlerId, error)
	ConnectMinimizeableChanged(cb func()) (dbusutil.SignalHandlerId, error)
	ConnectMinimizedChanged(cb func()) (dbusutil.SignalHandlerId, error)
	ConnectMovableChanged(cb func()) (dbusutil.SignalHandlerId, error)
	ConnectOnAllDesktopsChanged(cb func()) (dbusutil.SignalHandlerId, error)
	ConnectParentWindowChanged(cb func()) (dbusutil.SignalHandlerId, error)
	ConnectResizableChanged(cb func()) (dbusutil.SignalHandlerId, error)
	ConnectShadeableChanged(cb func()) (dbusutil.SignalHandlerId, error)
	ConnectShadedChanged(cb func()) (dbusutil.SignalHandlerId, error)
	ConnectSkipSwitcherChanged(cb func()) (dbusutil.SignalHandlerId, error)
	ConnectSkipTaskbarChanged(cb func()) (dbusutil.SignalHandlerId, error)
	ConnectTitleChanged(cb func()) (dbusutil.SignalHandlerId, error)
	ConnectUnmapped(cb func()) (dbusutil.SignalHandlerId, error)
	ConnectVirtualDesktopChangeableChanged(cb func()) (dbusutil.SignalHandlerId, error)
	ConnectVirtualDesktopChanged(cb func()) (dbusutil.SignalHandlerId, error)
	ConnectWindowIdChanged(cb func(wid uint32)) (dbusutil.SignalHandlerId, error)
}

type interfaceWindow struct{}

func (v *interfaceWindow) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceWindow) GetInterfaceName_() string {
	return "com.deepin.daemon.KWayland.PlasmaWindow"
}

// method AppId

func (v *interfaceWindow) GoAppId(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".AppId", flags, ch)
}

func (*interfaceWindow) StoreAppId(call *dbus.Call) (argout0 string, err error) {
	err = call.Store(&argout0)
	return
}

func (v *interfaceWindow) AppId(flags dbus.Flags) (string, error) {
	return v.StoreAppId(
		<-v.GoAppId(flags, make(chan *dbus.Call, 1)).Done)
}

// method Geometry

func (v *interfaceWindow) GoGeometry(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Geometry", flags, ch)
}

func (*interfaceWindow) StoreGeometry(call *dbus.Call) (argout0 Rect, err error) {
	err = call.Store(&argout0)
	return
}

func (v *interfaceWindow) Geometry(flags dbus.Flags) (Rect, error) {
	return v.StoreGeometry(
		<-v.GoGeometry(flags, make(chan *dbus.Call, 1)).Done)
}

// method Icon

func (v *interfaceWindow) GoIcon(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Icon", flags, ch)
}

func (*interfaceWindow) StoreIcon(call *dbus.Call) (argout0 string, err error) {
	err = call.Store(&argout0)
	return
}

func (v *interfaceWindow) Icon(flags dbus.Flags) (string, error) {
	return v.StoreIcon(
		<-v.GoIcon(flags, make(chan *dbus.Call, 1)).Done)
}

// method InternalId

func (v *interfaceWindow) GoInternalId(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".InternalId", flags, ch)
}

func (*interfaceWindow) StoreInternalId(call *dbus.Call) (argout0 uint32, err error) {
	err = call.Store(&argout0)
	return
}

func (v *interfaceWindow) InternalId(flags dbus.Flags) (uint32, error) {
	return v.StoreInternalId(
		<-v.GoInternalId(flags, make(chan *dbus.Call, 1)).Done)
}

// method IsActive

func (v *interfaceWindow) GoIsActive(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".IsActive", flags, ch)
}

func (*interfaceWindow) StoreIsActive(call *dbus.Call) (argout0 bool, err error) {
	err = call.Store(&argout0)
	return
}

func (v *interfaceWindow) IsActive(flags dbus.Flags) (bool, error) {
	return v.StoreIsActive(
		<-v.GoIsActive(flags, make(chan *dbus.Call, 1)).Done)
}

// method IsCloseable

func (v *interfaceWindow) GoIsCloseable(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".IsCloseable", flags, ch)
}

func (*interfaceWindow) StoreIsCloseable(call *dbus.Call) (argout0 bool, err error) {
	err = call.Store(&argout0)
	return
}

func (v *interfaceWindow) IsCloseable(flags dbus.Flags) (bool, error) {
	return v.StoreIsCloseable(
		<-v.GoIsCloseable(flags, make(chan *dbus.Call, 1)).Done)
}

// method IsDemandingAttention

func (v *interfaceWindow) GoIsDemandingAttention(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".IsDemandingAttention", flags, ch)
}

func (*interfaceWindow) StoreIsDemandingAttention(call *dbus.Call) (argout0 bool, err error) {
	err = call.Store(&argout0)
	return
}

func (v *interfaceWindow) IsDemandingAttention(flags dbus.Flags) (bool, error) {
	return v.StoreIsDemandingAttention(
		<-v.GoIsDemandingAttention(flags, make(chan *dbus.Call, 1)).Done)
}

// method IsFullscreen

func (v *interfaceWindow) GoIsFullscreen(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".IsFullscreen", flags, ch)
}

func (*interfaceWindow) StoreIsFullscreen(call *dbus.Call) (argout0 bool, err error) {
	err = call.Store(&argout0)
	return
}

func (v *interfaceWindow) IsFullscreen(flags dbus.Flags) (bool, error) {
	return v.StoreIsFullscreen(
		<-v.GoIsFullscreen(flags, make(chan *dbus.Call, 1)).Done)
}

// method IsFullscreenable

func (v *interfaceWindow) GoIsFullscreenable(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".IsFullscreenable", flags, ch)
}

func (*interfaceWindow) StoreIsFullscreenable(call *dbus.Call) (argout0 bool, err error) {
	err = call.Store(&argout0)
	return
}

func (v *interfaceWindow) IsFullscreenable(flags dbus.Flags) (bool, error) {
	return v.StoreIsFullscreenable(
		<-v.GoIsFullscreenable(flags, make(chan *dbus.Call, 1)).Done)
}

// method IsKeepAbove

func (v *interfaceWindow) GoIsKeepAbove(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".IsKeepAbove", flags, ch)
}

func (*interfaceWindow) StoreIsKeepAbove(call *dbus.Call) (argout0 bool, err error) {
	err = call.Store(&argout0)
	return
}

func (v *interfaceWindow) IsKeepAbove(flags dbus.Flags) (bool, error) {
	return v.StoreIsKeepAbove(
		<-v.GoIsKeepAbove(flags, make(chan *dbus.Call, 1)).Done)
}

// method IsMaximizeable

func (v *interfaceWindow) GoIsMaximizeable(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".IsMaximizeable", flags, ch)
}

func (*interfaceWindow) StoreIsMaximizeable(call *dbus.Call) (argout0 bool, err error) {
	err = call.Store(&argout0)
	return
}

func (v *interfaceWindow) IsMaximizeable(flags dbus.Flags) (bool, error) {
	return v.StoreIsMaximizeable(
		<-v.GoIsMaximizeable(flags, make(chan *dbus.Call, 1)).Done)
}

// method IsMaximized

func (v *interfaceWindow) GoIsMaximized(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".IsMaximized", flags, ch)
}

func (*interfaceWindow) StoreIsMaximized(call *dbus.Call) (argout0 bool, err error) {
	err = call.Store(&argout0)
	return
}

func (v *interfaceWindow) IsMaximized(flags dbus.Flags) (bool, error) {
	return v.StoreIsMaximized(
		<-v.GoIsMaximized(flags, make(chan *dbus.Call, 1)).Done)
}

// method IsMinimizeable

func (v *interfaceWindow) GoIsMinimizeable(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".IsMinimizeable", flags, ch)
}

func (*interfaceWindow) StoreIsMinimizeable(call *dbus.Call) (argout0 bool, err error) {
	err = call.Store(&argout0)
	return
}

func (v *interfaceWindow) IsMinimizeable(flags dbus.Flags) (bool, error) {
	return v.StoreIsMinimizeable(
		<-v.GoIsMinimizeable(flags, make(chan *dbus.Call, 1)).Done)
}

// method IsMinimized

func (v *interfaceWindow) GoIsMinimized(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".IsMinimized", flags, ch)
}

func (*interfaceWindow) StoreIsMinimized(call *dbus.Call) (argout0 bool, err error) {
	err = call.Store(&argout0)
	return
}

func (v *interfaceWindow) IsMinimized(flags dbus.Flags) (bool, error) {
	return v.StoreIsMinimized(
		<-v.GoIsMinimized(flags, make(chan *dbus.Call, 1)).Done)
}

// method IsMovable

func (v *interfaceWindow) GoIsMovable(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".IsMovable", flags, ch)
}

func (*interfaceWindow) StoreIsMovable(call *dbus.Call) (argout0 bool, err error) {
	err = call.Store(&argout0)
	return
}

func (v *interfaceWindow) IsMovable(flags dbus.Flags) (bool, error) {
	return v.StoreIsMovable(
		<-v.GoIsMovable(flags, make(chan *dbus.Call, 1)).Done)
}

// method IsOnAllDesktops

func (v *interfaceWindow) GoIsOnAllDesktops(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".IsOnAllDesktops", flags, ch)
}

func (*interfaceWindow) StoreIsOnAllDesktops(call *dbus.Call) (argout0 bool, err error) {
	err = call.Store(&argout0)
	return
}

func (v *interfaceWindow) IsOnAllDesktops(flags dbus.Flags) (bool, error) {
	return v.StoreIsOnAllDesktops(
		<-v.GoIsOnAllDesktops(flags, make(chan *dbus.Call, 1)).Done)
}

// method IsResizable

func (v *interfaceWindow) GoIsResizable(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".IsResizable", flags, ch)
}

func (*interfaceWindow) StoreIsResizable(call *dbus.Call) (argout0 bool, err error) {
	err = call.Store(&argout0)
	return
}

func (v *interfaceWindow) IsResizable(flags dbus.Flags) (bool, error) {
	return v.StoreIsResizable(
		<-v.GoIsResizable(flags, make(chan *dbus.Call, 1)).Done)
}

// method IsShadeable

func (v *interfaceWindow) GoIsShadeable(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".IsShadeable", flags, ch)
}

func (*interfaceWindow) StoreIsShadeable(call *dbus.Call) (argout0 bool, err error) {
	err = call.Store(&argout0)
	return
}

func (v *interfaceWindow) IsShadeable(flags dbus.Flags) (bool, error) {
	return v.StoreIsShadeable(
		<-v.GoIsShadeable(flags, make(chan *dbus.Call, 1)).Done)
}

// method IsShaded

func (v *interfaceWindow) GoIsShaded(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".IsShaded", flags, ch)
}

func (*interfaceWindow) StoreIsShaded(call *dbus.Call) (argout0 bool, err error) {
	err = call.Store(&argout0)
	return
}

func (v *interfaceWindow) IsShaded(flags dbus.Flags) (bool, error) {
	return v.StoreIsShaded(
		<-v.GoIsShaded(flags, make(chan *dbus.Call, 1)).Done)
}

// method IsValid

func (v *interfaceWindow) GoIsValid(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".IsValid", flags, ch)
}

func (*interfaceWindow) StoreIsValid(call *dbus.Call) (argout0 bool, err error) {
	err = call.Store(&argout0)
	return
}

func (v *interfaceWindow) IsValid(flags dbus.Flags) (bool, error) {
	return v.StoreIsValid(
		<-v.GoIsValid(flags, make(chan *dbus.Call, 1)).Done)
}

// method IsVirtualDesktopChangeable

func (v *interfaceWindow) GoIsVirtualDesktopChangeable(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".IsVirtualDesktopChangeable", flags, ch)
}

func (*interfaceWindow) StoreIsVirtualDesktopChangeable(call *dbus.Call) (argout0 bool, err error) {
	err = call.Store(&argout0)
	return
}

func (v *interfaceWindow) IsVirtualDesktopChangeable(flags dbus.Flags) (bool, error) {
	return v.StoreIsVirtualDesktopChangeable(
		<-v.GoIsVirtualDesktopChangeable(flags, make(chan *dbus.Call, 1)).Done)
}

// method Pid

func (v *interfaceWindow) GoPid(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Pid", flags, ch)
}

func (*interfaceWindow) StorePid(call *dbus.Call) (argout0 uint32, err error) {
	err = call.Store(&argout0)
	return
}

func (v *interfaceWindow) Pid(flags dbus.Flags) (uint32, error) {
	return v.StorePid(
		<-v.GoPid(flags, make(chan *dbus.Call, 1)).Done)
}

// method RequestActivate

func (v *interfaceWindow) GoRequestActivate(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".RequestActivate", flags, ch)
}

func (v *interfaceWindow) RequestActivate(flags dbus.Flags) error {
	return (<-v.GoRequestActivate(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method RequestClose

func (v *interfaceWindow) GoRequestClose(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".RequestClose", flags, ch)
}

func (v *interfaceWindow) RequestClose(flags dbus.Flags) error {
	return (<-v.GoRequestClose(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method RequestEnterNewVirtualDesktop

func (v *interfaceWindow) GoRequestEnterNewVirtualDesktop(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".RequestEnterNewVirtualDesktop", flags, ch)
}

func (v *interfaceWindow) RequestEnterNewVirtualDesktop(flags dbus.Flags) error {
	return (<-v.GoRequestEnterNewVirtualDesktop(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method RequestEnterVirtualDesktop

func (v *interfaceWindow) GoRequestEnterVirtualDesktop(flags dbus.Flags, ch chan *dbus.Call, argin0 string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".RequestEnterVirtualDesktop", flags, ch, argin0)
}

func (v *interfaceWindow) RequestEnterVirtualDesktop(flags dbus.Flags, argin0 string) error {
	return (<-v.GoRequestEnterVirtualDesktop(flags, make(chan *dbus.Call, 1), argin0).Done).Err
}

// method RequestLeaveVirtualDesktop

func (v *interfaceWindow) GoRequestLeaveVirtualDesktop(flags dbus.Flags, ch chan *dbus.Call, argin0 string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".RequestLeaveVirtualDesktop", flags, ch, argin0)
}

func (v *interfaceWindow) RequestLeaveVirtualDesktop(flags dbus.Flags, argin0 string) error {
	return (<-v.GoRequestLeaveVirtualDesktop(flags, make(chan *dbus.Call, 1), argin0).Done).Err
}

// method RequestMove

func (v *interfaceWindow) GoRequestMove(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".RequestMove", flags, ch)
}

func (v *interfaceWindow) RequestMove(flags dbus.Flags) error {
	return (<-v.GoRequestMove(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method RequestResize

func (v *interfaceWindow) GoRequestResize(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".RequestResize", flags, ch)
}

func (v *interfaceWindow) RequestResize(flags dbus.Flags) error {
	return (<-v.GoRequestResize(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method RequestToggleKeepAbove

func (v *interfaceWindow) GoRequestToggleKeepAbove(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".RequestToggleKeepAbove", flags, ch)
}

func (v *interfaceWindow) RequestToggleKeepAbove(flags dbus.Flags) error {
	return (<-v.GoRequestToggleKeepAbove(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method RequestToggleKeepBelow

func (v *interfaceWindow) GoRequestToggleKeepBelow(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".RequestToggleKeepBelow", flags, ch)
}

func (v *interfaceWindow) RequestToggleKeepBelow(flags dbus.Flags) error {
	return (<-v.GoRequestToggleKeepBelow(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method RequestToggleMaximized

func (v *interfaceWindow) GoRequestToggleMaximized(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".RequestToggleMaximized", flags, ch)
}

func (v *interfaceWindow) RequestToggleMaximized(flags dbus.Flags) error {
	return (<-v.GoRequestToggleMaximized(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method RequestToggleMinimized

func (v *interfaceWindow) GoRequestToggleMinimized(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".RequestToggleMinimized", flags, ch)
}

func (v *interfaceWindow) RequestToggleMinimized(flags dbus.Flags) error {
	return (<-v.GoRequestToggleMinimized(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method RequestToggleShaded

func (v *interfaceWindow) GoRequestToggleShaded(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".RequestToggleShaded", flags, ch)
}

func (v *interfaceWindow) RequestToggleShaded(flags dbus.Flags) error {
	return (<-v.GoRequestToggleShaded(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method RequestVirtualDesktop

func (v *interfaceWindow) GoRequestVirtualDesktop(flags dbus.Flags, ch chan *dbus.Call, argin0 uint32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".RequestVirtualDesktop", flags, ch, argin0)
}

func (v *interfaceWindow) RequestVirtualDesktop(flags dbus.Flags, argin0 uint32) error {
	return (<-v.GoRequestVirtualDesktop(flags, make(chan *dbus.Call, 1), argin0).Done).Err
}

// method SkipSwitcher

func (v *interfaceWindow) GoSkipSwitcher(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SkipSwitcher", flags, ch)
}

func (*interfaceWindow) StoreSkipSwitcher(call *dbus.Call) (argout0 bool, err error) {
	err = call.Store(&argout0)
	return
}

func (v *interfaceWindow) SkipSwitcher(flags dbus.Flags) (bool, error) {
	return v.StoreSkipSwitcher(
		<-v.GoSkipSwitcher(flags, make(chan *dbus.Call, 1)).Done)
}

// method SkipTaskbar

func (v *interfaceWindow) GoSkipTaskbar(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SkipTaskbar", flags, ch)
}

func (*interfaceWindow) StoreSkipTaskbar(call *dbus.Call) (argout0 bool, err error) {
	err = call.Store(&argout0)
	return
}

func (v *interfaceWindow) SkipTaskbar(flags dbus.Flags) (bool, error) {
	return v.StoreSkipTaskbar(
		<-v.GoSkipTaskbar(flags, make(chan *dbus.Call, 1)).Done)
}

// method Title

func (v *interfaceWindow) GoTitle(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Title", flags, ch)
}

func (*interfaceWindow) StoreTitle(call *dbus.Call) (argout0 string, err error) {
	err = call.Store(&argout0)
	return
}

func (v *interfaceWindow) Title(flags dbus.Flags) (string, error) {
	return v.StoreTitle(
		<-v.GoTitle(flags, make(chan *dbus.Call, 1)).Done)
}

// method VirtualDesktop

func (v *interfaceWindow) GoVirtualDesktop(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".VirtualDesktop", flags, ch)
}

func (*interfaceWindow) StoreVirtualDesktop(call *dbus.Call) (argout0 uint32, err error) {
	err = call.Store(&argout0)
	return
}

func (v *interfaceWindow) VirtualDesktop(flags dbus.Flags) (uint32, error) {
	return v.StoreVirtualDesktop(
		<-v.GoVirtualDesktop(flags, make(chan *dbus.Call, 1)).Done)
}

// method WindowId

func (v *interfaceWindow) GoWindowId(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".WindowId", flags, ch)
}

func (*interfaceWindow) StoreWindowId(call *dbus.Call) (argout0 uint32, err error) {
	err = call.Store(&argout0)
	return
}

func (v *interfaceWindow) WindowId(flags dbus.Flags) (uint32, error) {
	return v.StoreWindowId(
		<-v.GoWindowId(flags, make(chan *dbus.Call, 1)).Done)
}

// signal ActiveChanged

func (v *interfaceWindow) ConnectActiveChanged(cb func()) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "ActiveChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".ActiveChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		cb()
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal AppIdChanged

func (v *interfaceWindow) ConnectAppIdChanged(cb func()) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "AppIdChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".AppIdChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		cb()
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal CloseableChanged

func (v *interfaceWindow) ConnectCloseableChanged(cb func()) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "CloseableChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".CloseableChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		cb()
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal DemandsAttentionChanged

func (v *interfaceWindow) ConnectDemandsAttentionChanged(cb func()) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "DemandsAttentionChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".DemandsAttentionChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		cb()
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal FullscreenableChanged

func (v *interfaceWindow) ConnectFullscreenableChanged(cb func()) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "FullscreenableChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".FullscreenableChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		cb()
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal FullscreenChanged

func (v *interfaceWindow) ConnectFullscreenChanged(cb func()) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "FullscreenChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".FullscreenChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		cb()
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal GeometryChanged

func (v *interfaceWindow) ConnectGeometryChanged(cb func()) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "GeometryChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".GeometryChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		cb()
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal IconChanged

func (v *interfaceWindow) ConnectIconChanged(cb func()) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "IconChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".IconChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		cb()
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal KeepAboveChanged

func (v *interfaceWindow) ConnectKeepAboveChanged(cb func()) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "KeepAboveChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".KeepAboveChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		cb()
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal KeepBelowChanged

func (v *interfaceWindow) ConnectKeepBelowChanged(cb func()) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "KeepBelowChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".KeepBelowChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		cb()
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal MaximizeableChanged

func (v *interfaceWindow) ConnectMaximizeableChanged(cb func()) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "MaximizeableChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".MaximizeableChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		cb()
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal MaximizedChanged

func (v *interfaceWindow) ConnectMaximizedChanged(cb func()) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "MaximizedChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".MaximizedChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		cb()
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal MinimizeableChanged

func (v *interfaceWindow) ConnectMinimizeableChanged(cb func()) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "MinimizeableChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".MinimizeableChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		cb()
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal MinimizedChanged

func (v *interfaceWindow) ConnectMinimizedChanged(cb func()) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "MinimizedChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".MinimizedChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		cb()
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal MovableChanged

func (v *interfaceWindow) ConnectMovableChanged(cb func()) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "MovableChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".MovableChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		cb()
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal OnAllDesktopsChanged

func (v *interfaceWindow) ConnectOnAllDesktopsChanged(cb func()) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "OnAllDesktopsChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".OnAllDesktopsChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		cb()
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal ParentWindowChanged

func (v *interfaceWindow) ConnectParentWindowChanged(cb func()) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "ParentWindowChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".ParentWindowChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		cb()
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal ResizableChanged

func (v *interfaceWindow) ConnectResizableChanged(cb func()) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "ResizableChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".ResizableChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		cb()
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal ShadeableChanged

func (v *interfaceWindow) ConnectShadeableChanged(cb func()) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "ShadeableChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".ShadeableChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		cb()
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal ShadedChanged

func (v *interfaceWindow) ConnectShadedChanged(cb func()) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "ShadedChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".ShadedChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		cb()
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal SkipSwitcherChanged

func (v *interfaceWindow) ConnectSkipSwitcherChanged(cb func()) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "SkipSwitcherChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".SkipSwitcherChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		cb()
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal SkipTaskbarChanged

func (v *interfaceWindow) ConnectSkipTaskbarChanged(cb func()) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "SkipTaskbarChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".SkipTaskbarChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		cb()
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal TitleChanged

func (v *interfaceWindow) ConnectTitleChanged(cb func()) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "TitleChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".TitleChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		cb()
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal Unmapped

func (v *interfaceWindow) ConnectUnmapped(cb func()) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "Unmapped", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".Unmapped",
	}
	handlerFunc := func(sig *dbus.Signal) {
		cb()
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal VirtualDesktopChangeableChanged

func (v *interfaceWindow) ConnectVirtualDesktopChangeableChanged(cb func()) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "VirtualDesktopChangeableChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".VirtualDesktopChangeableChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		cb()
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal VirtualDesktopChanged

func (v *interfaceWindow) ConnectVirtualDesktopChanged(cb func()) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "VirtualDesktopChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".VirtualDesktopChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		cb()
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal WindowIdChanged

func (v *interfaceWindow) ConnectWindowIdChanged(cb func(wid uint32)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "WindowIdChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".WindowIdChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var wid uint32
		err := dbus.Store(sig.Body, &wid)
		if err == nil {
			cb(wid)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}
