# -*- encoding:utf-8; warn-indent:false; frozen_string_literal: true  -*-

# line 1 "lib/parser/lexer.rl"

# line 3 "lib/parser/lexer.rl"
#
# === BEFORE YOU START ===
#
# Read the Ruby Hacking Guide chapter 11, available in English at
# http://whitequark.org/blog/2013/04/01/ruby-hacking-guide-ch-11-finite-state-lexer/
#
# Remember two things about Ragel scanners:
#
#   1) Longest match wins.
#
#   2) If two matches have the same length, the first
#      in source code wins.
#
# General rules of making Ragel and Bison happy:
#
#  * `p` (position) and `@te` contain the index of the character
#    they're pointing to ("current"), plus one. `@ts` contains the index
#    of the corresponding character. The code for extracting matched token is:
#
#       @source_buffer.slice(@ts...@te)
#
#  * If your input is `foooooooobar` and the rule is:
#
#       'f' 'o'+
#
#    the result will be:
#
#       foooooooobar
#       ^ ts=0   ^ p=te=9
#
#  * A Ragel lexer action should not emit more than one token, unless
#    you know what you are doing.
#
#  * All Ragel commands (fnext, fgoto, ...) end with a semicolon.
#
#  * If an action emits the token and transitions to another state, use
#    these Ragel commands:
#
#       emit($whatever)
#       fnext $next_state; fbreak;
#
#    If you perform `fgoto` in an action which does not emit a token nor
#    rewinds the stream pointer, the parser's side-effectful,
#    context-sensitive lookahead actions will break in a hard to detect
#    and debug way.
#
#  * If an action does not emit a token:
#
#       fgoto $next_state;
#
#  * If an action features lookbehind, i.e. matches characters with the
#    intent of passing them to another action:
#
#       p = @ts - 1
#       fgoto $next_state;
#
#    or, if the lookbehind consists of a single character:
#
#       fhold; fgoto $next_state;
#
#  * Ragel merges actions. So, if you have `e_lparen = '(' %act` and
#    `c_lparen = '('` and a lexer action `e_lparen | c_lparen`, the result
#    _will_ invoke the action `act`.
#
#    e_something stands for "something with **e**mbedded action".
#
#  * EOF is explicit and is matched by `c_eof`. If you want to introspect
#    the state of the lexer, add this rule to the state:
#
#       c_eof => do_eof;
#
#  * If you proceed past EOF, the lexer will complain:
#
#       NoMethodError: undefined method `ord' for nil:NilClass
#

class Parser::Lexer

  
# line 85 "lib/parser/lexer.rb"
class << self
	attr_accessor :_lex_trans_keys
	private :_lex_trans_keys, :_lex_trans_keys=
end
self._lex_trans_keys = [
	0, 0, 101, 101, 103, 103, 
	105, 105, 110, 110, 69, 
	69, 78, 78, 68, 68, 
	95, 95, 95, 95, 0, 26, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 45, 
	0, 120, 0, 120, 0, 92, 
	0, 120, 0, 120, 0, 
	45, 0, 120, 0, 120, 
	67, 99, 45, 45, 0, 92, 
	0, 120, 0, 102, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 45, 0, 120, 
	0, 120, 0, 92, 0, 
	120, 0, 120, 0, 45, 
	0, 120, 0, 120, 67, 99, 
	45, 45, 0, 92, 0, 
	120, 0, 102, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 58, 58, 58, 58, 
	46, 46, 10, 10, 0, 127, 
	58, 58, 60, 60, 62, 
	62, 10, 10, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 115, 115, 99, 99, 
	117, 117, 101, 101, 108, 
	116, 101, 101, 115, 115, 
	115, 115, 105, 105, 108, 108, 
	105, 105, 108, 108, 58, 
	58, 0, 127, 10, 10, 
	0, 127, 9, 92, 10, 10, 
	9, 92, 58, 58, 98, 
	98, 101, 101, 103, 103, 
	105, 105, 110, 110, 0, 127, 
	61, 61, 9, 92, 9, 
	92, 9, 92, 9, 92, 
	9, 92, 10, 10, 0, 127, 
	0, 127, 61, 126, 93, 
	93, 0, 127, 0, 127, 
	10, 10, 34, 34, 10, 10, 
	39, 39, 0, 127, 10, 
	96, 96, 96, 0, 45, 
	0, 120, 0, 120, 0, 92, 
	0, 120, 0, 120, 0, 
	45, 0, 120, 0, 120, 
	67, 99, 45, 45, 0, 92, 
	0, 120, 0, 102, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	58, 58, 58, 58, 0, 
	127, 43, 57, 48, 57, 
	48, 57, 48, 57, 48, 57, 
	115, 115, 99, 99, 117, 
	117, 101, 101, 99, 99, 
	117, 117, 101, 101, 0, 127, 
	58, 58, 9, 92, 9, 
	92, 9, 92, 9, 92, 
	9, 92, 9, 92, 60, 60, 
	10, 10, 9, 92, 9, 
	92, 10, 10, 10, 10, 
	10, 10, 10, 10, 46, 46, 
	0, 95, 9, 32, 0, 
	0, 10, 10, 10, 10, 
	98, 98, 9, 32, 10, 10, 
	95, 95, 0, 92, 9, 
	32, 36, 123, 0, 127, 
	48, 57, 0, 127, 0, 120, 
	0, 0, 0, 0, 48, 
	55, 48, 55, 0, 0, 
	0, 0, 0, 92, 0, 0, 
	0, 0, 0, 0, 0, 
	92, 45, 45, 0, 0, 
	0, 0, 0, 0, 0, 92, 
	48, 102, 48, 102, 0, 
	0, 48, 102, 48, 102, 
	0, 0, 0, 45, 0, 92, 
	0, 92, 0, 0, 0, 
	0, 0, 92, 48, 102, 
	48, 102, 0, 0, 0, 45, 
	10, 10, 0, 92, 48, 
	123, 48, 102, 48, 102, 
	48, 102, 0, 0, 0, 125, 
	0, 125, 0, 0, 0, 
	125, 0, 0, 0, 125, 
	0, 125, 0, 125, 0, 125, 
	0, 0, 0, 125, 0, 
	125, 0, 125, 0, 125, 
	0, 125, 0, 125, 0, 0, 
	0, 0, 48, 102, 0, 
	0, 0, 92, 36, 123, 
	0, 127, 48, 57, 0, 127, 
	0, 120, 0, 0, 0, 
	0, 48, 55, 48, 55, 
	0, 0, 0, 0, 0, 92, 
	0, 0, 0, 0, 0, 
	0, 0, 92, 45, 45, 
	0, 0, 0, 0, 0, 0, 
	0, 92, 48, 102, 48, 
	102, 0, 0, 48, 102, 
	48, 102, 0, 0, 0, 45, 
	0, 92, 0, 92, 0, 
	0, 0, 0, 0, 92, 
	48, 102, 48, 102, 0, 0, 
	0, 45, 10, 10, 0, 
	92, 48, 123, 48, 102, 
	48, 102, 48, 102, 0, 0, 
	0, 125, 0, 125, 0, 
	0, 0, 125, 0, 0, 
	0, 125, 0, 125, 0, 125, 
	0, 125, 0, 0, 0, 
	125, 0, 125, 0, 125, 
	0, 125, 0, 125, 0, 125, 
	0, 0, 0, 0, 48, 
	102, 0, 0, 0, 92, 
	9, 32, 0, 26, 0, 92, 
	0, 26, 0, 35, 36, 
	123, 0, 127, 48, 57, 
	0, 127, 0, 26, 0, 35, 
	9, 32, 36, 123, 0, 
	127, 48, 57, 0, 127, 
	0, 32, 9, 32, 65, 122, 
	65, 122, 36, 64, 0, 
	127, 48, 57, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	9, 32, 0, 0, 61, 
	126, 10, 10, 10, 10, 
	0, 127, 0, 127, 48, 57, 
	115, 115, 38, 38, 42, 
	42, 64, 64, 58, 58, 
	60, 61, 62, 62, 61, 126, 
	61, 61, 61, 62, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 93, 93, 10, 
	10, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 124, 124, 0, 127, 
	0, 127, 9, 32, 10, 
	10, 10, 10, 46, 46, 
	10, 10, 0, 0, 0, 127, 
	0, 127, 61, 61, 0, 
	0, 9, 32, 0, 0, 
	61, 126, 10, 10, 10, 10, 
	38, 38, 42, 42, 64, 
	64, 60, 61, 62, 62, 
	61, 126, 61, 61, 61, 62, 
	0, 127, 93, 93, 10, 
	10, 124, 124, 0, 126, 
	0, 127, 0, 61, 9, 61, 
	9, 61, 0, 0, 9, 
	61, 9, 62, 46, 46, 
	46, 46, 58, 58, 9, 32, 
	0, 0, 0, 127, 0, 
	0, 9, 124, 0, 0, 
	10, 10, 10, 10, 0, 0, 
	9, 61, 58, 58, 60, 
	60, 62, 62, 9, 32, 
	10, 10, 0, 127, 102, 102, 
	101, 101, 110, 110, 104, 
	104, 0, 127, 0, 127, 
	0, 127, 0, 0, 0, 127, 
	10, 10, 0, 123, 9, 
	32, 10, 10, 10, 10, 
	10, 10, 0, 0, 111, 111, 
	0, 0, 0, 127, 0, 
	127, 9, 32, 0, 0, 
	10, 10, 10, 10, 10, 10, 
	0, 0, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 58, 61, 0, 0, 
	61, 126, 61, 61, 0, 0, 
	0, 0, 0, 0, 9, 
	32, 61, 61, 9, 32, 
	61, 126, 10, 10, 10, 10, 
	0, 127, 38, 61, 0, 
	0, 42, 61, 61, 61, 
	9, 92, 9, 92, 9, 92, 
	46, 46, 46, 46, 10, 
	10, 0, 26, 0, 127, 
	0, 127, 61, 61, 0, 0, 
	61, 126, 61, 62, 0, 
	0, 0, 0, 0, 0, 
	0, 0, 61, 126, 0, 127, 
	48, 57, 38, 38, 42, 
	42, 64, 64, 60, 61, 
	62, 62, 61, 61, 61, 62, 
	0, 127, 48, 57, 0, 
	127, 124, 124, 64, 64, 
	60, 61, 0, 0, 10, 34, 
	10, 39, 96, 96, 62, 
	62, 61, 126, 61, 62, 
	0, 122, 0, 0, 0, 127, 
	0, 127, 0, 120, 0, 
	0, 0, 0, 48, 55, 
	48, 55, 0, 0, 0, 0, 
	0, 92, 0, 0, 0, 
	0, 0, 0, 0, 92, 
	45, 45, 0, 0, 0, 0, 
	0, 0, 0, 92, 48, 
	102, 48, 102, 0, 0, 
	48, 102, 48, 102, 0, 0, 
	0, 45, 0, 92, 0, 
	92, 0, 0, 0, 0, 
	0, 92, 48, 102, 48, 102, 
	0, 0, 0, 45, 10, 
	10, 0, 92, 48, 123, 
	48, 102, 48, 102, 48, 102, 
	0, 0, 0, 125, 0, 
	125, 0, 0, 0, 125, 
	0, 0, 0, 125, 0, 125, 
	0, 125, 0, 125, 0, 
	0, 0, 125, 0, 125, 
	0, 125, 0, 125, 0, 125, 
	0, 125, 0, 125, 0, 
	125, 0, 125, 0, 125, 
	0, 125, 0, 125, 0, 125, 
	0, 125, 0, 125, 0, 
	125, 0, 125, 0, 125, 
	0, 125, 0, 0, 0, 0, 
	48, 102, 0, 0, 0, 
	127, 0, 127, 0, 127, 
	0, 0, 10, 10, 0, 0, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	61, 126, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 0, 
	61, 124, 0, 92, 9, 
	32, 0, 0, 10, 10, 
	10, 10, 10, 10, 0, 0, 
	0, 127, 0, 127, 9, 
	32, 0, 0, 10, 10, 
	10, 10, 10, 10, 0, 0, 
	0, 127, 0, 127, 61, 
	61, 0, 0, 9, 32, 
	0, 0, 61, 126, 10, 10, 
	10, 10, 0, 127, 0, 
	127, 48, 57, 61, 61, 
	38, 61, 0, 0, 0, 0, 
	42, 61, 61, 62, 46, 
	57, 46, 46, 10, 10, 
	48, 101, 48, 95, 46, 120, 
	48, 114, 43, 57, 48, 
	105, 102, 102, 0, 0, 
	101, 105, 0, 0, 0, 0, 
	48, 114, 48, 114, 48, 
	114, 48, 114, 105, 114, 
	102, 102, 0, 0, 101, 105, 
	115, 115, 0, 0, 0, 
	0, 48, 114, 48, 114, 
	48, 114, 48, 114, 48, 114, 
	48, 114, 48, 114, 48, 
	114, 46, 114, 48, 114, 
	46, 114, 48, 114, 58, 58, 
	60, 61, 62, 62, 61, 
	126, 61, 61, 61, 62, 
	0, 127, 0, 127, 0, 0, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 0, 10, 10, 
	0, 0, 0, 0, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 9, 92, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 0, 61, 
	124, 0, 0, 9, 92, 
	9, 92, 9, 92, 46, 46, 
	46, 46, 10, 10, 46, 
	46, 10, 10, 10, 61, 
	10, 10, 10, 101, 10, 110, 
	10, 100, 10, 10, 0
]

class << self
	attr_accessor :_lex_key_spans
	private :_lex_key_spans, :_lex_key_spans=
end
self._lex_key_spans = [
	0, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 27, 128, 128, 128, 128, 46, 
	121, 121, 93, 121, 121, 46, 121, 121, 
	33, 1, 93, 121, 103, 128, 128, 128, 
	128, 46, 121, 121, 93, 121, 121, 46, 
	121, 121, 33, 1, 93, 121, 103, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 1, 1, 
	1, 1, 128, 1, 1, 1, 1, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 1, 1, 1, 1, 9, 1, 1, 
	1, 1, 1, 1, 1, 1, 128, 1, 
	128, 84, 1, 84, 1, 1, 1, 1, 
	1, 1, 128, 1, 84, 84, 84, 84, 
	84, 1, 128, 128, 66, 1, 128, 128, 
	1, 1, 1, 1, 128, 87, 1, 46, 
	121, 121, 93, 121, 121, 46, 121, 121, 
	33, 1, 93, 121, 103, 128, 128, 128, 
	128, 128, 128, 1, 1, 128, 15, 10, 
	10, 10, 10, 1, 1, 1, 1, 1, 
	1, 1, 128, 1, 84, 84, 84, 84, 
	84, 84, 1, 1, 84, 84, 1, 1, 
	1, 1, 1, 96, 24, 0, 1, 1, 
	1, 24, 1, 1, 93, 24, 88, 128, 
	10, 128, 121, 0, 0, 8, 8, 0, 
	0, 93, 0, 0, 0, 93, 1, 0, 
	0, 0, 93, 55, 55, 0, 55, 55, 
	0, 46, 93, 93, 0, 0, 93, 55, 
	55, 0, 46, 1, 93, 76, 55, 55, 
	55, 0, 126, 126, 0, 126, 0, 126, 
	126, 126, 126, 0, 126, 126, 126, 126, 
	126, 126, 0, 0, 55, 0, 93, 88, 
	128, 10, 128, 121, 0, 0, 8, 8, 
	0, 0, 93, 0, 0, 0, 93, 1, 
	0, 0, 0, 93, 55, 55, 0, 55, 
	55, 0, 46, 93, 93, 0, 0, 93, 
	55, 55, 0, 46, 1, 93, 76, 55, 
	55, 55, 0, 126, 126, 0, 126, 0, 
	126, 126, 126, 126, 0, 126, 126, 126, 
	126, 126, 126, 0, 0, 55, 0, 93, 
	24, 27, 93, 27, 36, 88, 128, 10, 
	128, 27, 36, 24, 88, 128, 10, 128, 
	33, 24, 58, 58, 29, 128, 10, 128, 
	128, 128, 128, 24, 0, 66, 1, 1, 
	128, 128, 10, 1, 1, 1, 1, 1, 
	2, 1, 66, 1, 2, 128, 128, 128, 
	128, 128, 128, 128, 1, 1, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 1, 128, 128, 24, 1, 1, 1, 
	1, 0, 128, 128, 1, 0, 24, 0, 
	66, 1, 1, 1, 1, 1, 2, 1, 
	66, 1, 2, 128, 1, 1, 1, 127, 
	128, 62, 53, 53, 0, 53, 54, 1, 
	1, 1, 24, 0, 128, 0, 116, 0, 
	1, 1, 0, 53, 1, 1, 1, 24, 
	1, 128, 1, 1, 1, 1, 128, 128, 
	128, 0, 128, 1, 124, 24, 1, 1, 
	1, 0, 1, 0, 128, 128, 24, 0, 
	1, 1, 1, 0, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 4, 0, 
	66, 1, 0, 0, 0, 24, 1, 24, 
	66, 1, 1, 128, 24, 0, 20, 1, 
	84, 84, 84, 1, 1, 1, 27, 128, 
	128, 1, 0, 66, 2, 0, 0, 0, 
	0, 66, 128, 10, 1, 1, 1, 2, 
	1, 1, 2, 128, 10, 128, 1, 1, 
	2, 0, 25, 30, 1, 1, 66, 2, 
	123, 0, 128, 128, 121, 0, 0, 8, 
	8, 0, 0, 93, 0, 0, 0, 93, 
	1, 0, 0, 0, 93, 55, 55, 0, 
	55, 55, 0, 46, 93, 93, 0, 0, 
	93, 55, 55, 0, 46, 1, 93, 76, 
	55, 55, 55, 0, 126, 126, 0, 126, 
	0, 126, 126, 126, 126, 0, 126, 126, 
	126, 126, 126, 126, 126, 126, 126, 126, 
	126, 126, 126, 126, 126, 126, 126, 126, 
	126, 0, 0, 55, 0, 128, 128, 128, 
	0, 1, 0, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	66, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 0, 64, 93, 24, 0, 1, 
	1, 1, 0, 128, 128, 24, 0, 1, 
	1, 1, 0, 128, 128, 1, 0, 24, 
	0, 66, 1, 1, 128, 128, 10, 1, 
	24, 0, 0, 20, 2, 12, 1, 1, 
	54, 48, 75, 67, 15, 58, 1, 0, 
	5, 0, 0, 67, 67, 67, 67, 10, 
	1, 0, 5, 1, 0, 0, 67, 67, 
	67, 67, 67, 67, 67, 67, 69, 67, 
	69, 67, 1, 2, 1, 66, 1, 2, 
	128, 128, 0, 128, 128, 128, 128, 128, 
	128, 0, 1, 0, 0, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 84, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 0, 64, 0, 84, 
	84, 84, 1, 1, 1, 1, 1, 52, 
	1, 92, 101, 91, 1
]

class << self
	attr_accessor :_lex_index_offsets
	private :_lex_index_offsets, :_lex_index_offsets=
end
self._lex_index_offsets = [
	0, 0, 2, 4, 6, 8, 10, 12, 
	14, 16, 18, 46, 175, 304, 433, 562, 
	609, 731, 853, 947, 1069, 1191, 1238, 1360, 
	1482, 1516, 1518, 1612, 1734, 1838, 1967, 2096, 
	2225, 2354, 2401, 2523, 2645, 2739, 2861, 2983, 
	3030, 3152, 3274, 3308, 3310, 3404, 3526, 3630, 
	3759, 3888, 4017, 4146, 4275, 4404, 4533, 4662, 
	4791, 4920, 5049, 5178, 5307, 5436, 5565, 5567, 
	5569, 5571, 5573, 5702, 5704, 5706, 5708, 5710, 
	5839, 5968, 6097, 6226, 6355, 6484, 6613, 6742, 
	6871, 7000, 7129, 7258, 7387, 7516, 7645, 7774, 
	7903, 8032, 8034, 8036, 8038, 8040, 8050, 8052, 
	8054, 8056, 8058, 8060, 8062, 8064, 8066, 8195, 
	8197, 8326, 8411, 8413, 8498, 8500, 8502, 8504, 
	8506, 8508, 8510, 8639, 8641, 8726, 8811, 8896, 
	8981, 9066, 9068, 9197, 9326, 9393, 9395, 9524, 
	9653, 9655, 9657, 9659, 9661, 9790, 9878, 9880, 
	9927, 10049, 10171, 10265, 10387, 10509, 10556, 10678, 
	10800, 10834, 10836, 10930, 11052, 11156, 11285, 11414, 
	11543, 11672, 11801, 11930, 11932, 11934, 12063, 12079, 
	12090, 12101, 12112, 12123, 12125, 12127, 12129, 12131, 
	12133, 12135, 12137, 12266, 12268, 12353, 12438, 12523, 
	12608, 12693, 12778, 12780, 12782, 12867, 12952, 12954, 
	12956, 12958, 12960, 12962, 13059, 13084, 13085, 13087, 
	13089, 13091, 13116, 13118, 13120, 13214, 13239, 13328, 
	13457, 13468, 13597, 13719, 13720, 13721, 13730, 13739, 
	13740, 13741, 13835, 13836, 13837, 13838, 13932, 13934, 
	13935, 13936, 13937, 14031, 14087, 14143, 14144, 14200, 
	14256, 14257, 14304, 14398, 14492, 14493, 14494, 14588, 
	14644, 14700, 14701, 14748, 14750, 14844, 14921, 14977, 
	15033, 15089, 15090, 15217, 15344, 15345, 15472, 15473, 
	15600, 15727, 15854, 15981, 15982, 16109, 16236, 16363, 
	16490, 16617, 16744, 16745, 16746, 16802, 16803, 16897, 
	16986, 17115, 17126, 17255, 17377, 17378, 17379, 17388, 
	17397, 17398, 17399, 17493, 17494, 17495, 17496, 17590, 
	17592, 17593, 17594, 17595, 17689, 17745, 17801, 17802, 
	17858, 17914, 17915, 17962, 18056, 18150, 18151, 18152, 
	18246, 18302, 18358, 18359, 18406, 18408, 18502, 18579, 
	18635, 18691, 18747, 18748, 18875, 19002, 19003, 19130, 
	19131, 19258, 19385, 19512, 19639, 19640, 19767, 19894, 
	20021, 20148, 20275, 20402, 20403, 20404, 20460, 20461, 
	20555, 20580, 20608, 20702, 20730, 20767, 20856, 20985, 
	20996, 21125, 21153, 21190, 21215, 21304, 21433, 21444, 
	21573, 21607, 21632, 21691, 21750, 21780, 21909, 21920, 
	22049, 22178, 22307, 22436, 22461, 22462, 22529, 22531, 
	22533, 22662, 22791, 22802, 22804, 22806, 22808, 22810, 
	22812, 22815, 22817, 22884, 22886, 22889, 23018, 23147, 
	23276, 23405, 23534, 23663, 23792, 23794, 23796, 23925, 
	24054, 24183, 24312, 24441, 24570, 24699, 24828, 24957, 
	25086, 25215, 25344, 25473, 25602, 25731, 25860, 25989, 
	26118, 26247, 26376, 26505, 26634, 26763, 26892, 27021, 
	27150, 27279, 27408, 27537, 27666, 27795, 27924, 28053, 
	28182, 28311, 28440, 28569, 28698, 28827, 28956, 29085, 
	29214, 29343, 29472, 29601, 29730, 29859, 29988, 30117, 
	30246, 30375, 30504, 30633, 30762, 30891, 31020, 31149, 
	31278, 31407, 31536, 31665, 31794, 31923, 32052, 32181, 
	32310, 32439, 32568, 32697, 32826, 32955, 33084, 33213, 
	33342, 33471, 33600, 33729, 33858, 33987, 34116, 34245, 
	34374, 34503, 34505, 34634, 34763, 34788, 34790, 34792, 
	34794, 34796, 34797, 34926, 35055, 35057, 35058, 35083, 
	35084, 35151, 35153, 35155, 35157, 35159, 35161, 35164, 
	35166, 35233, 35235, 35238, 35367, 35369, 35371, 35373, 
	35501, 35630, 35693, 35747, 35801, 35802, 35856, 35911, 
	35913, 35915, 35917, 35942, 35943, 36072, 36073, 36190, 
	36191, 36193, 36195, 36196, 36250, 36252, 36254, 36256, 
	36281, 36283, 36412, 36414, 36416, 36418, 36420, 36549, 
	36678, 36807, 36808, 36937, 36939, 37064, 37089, 37091, 
	37093, 37095, 37096, 37098, 37099, 37228, 37357, 37382, 
	37383, 37385, 37387, 37389, 37390, 37519, 37648, 37777, 
	37906, 38035, 38164, 38293, 38422, 38551, 38680, 38809, 
	38938, 39067, 39196, 39325, 39454, 39583, 39712, 39717, 
	39718, 39785, 39787, 39788, 39789, 39790, 39815, 39817, 
	39842, 39909, 39911, 39913, 40042, 40067, 40068, 40089, 
	40091, 40176, 40261, 40346, 40348, 40350, 40352, 40380, 
	40509, 40638, 40640, 40641, 40708, 40711, 40712, 40713, 
	40714, 40715, 40782, 40911, 40922, 40924, 40926, 40928, 
	40931, 40933, 40935, 40938, 41067, 41078, 41207, 41209, 
	41211, 41214, 41215, 41241, 41272, 41274, 41276, 41343, 
	41346, 41470, 41471, 41600, 41729, 41851, 41852, 41853, 
	41862, 41871, 41872, 41873, 41967, 41968, 41969, 41970, 
	42064, 42066, 42067, 42068, 42069, 42163, 42219, 42275, 
	42276, 42332, 42388, 42389, 42436, 42530, 42624, 42625, 
	42626, 42720, 42776, 42832, 42833, 42880, 42882, 42976, 
	43053, 43109, 43165, 43221, 43222, 43349, 43476, 43477, 
	43604, 43605, 43732, 43859, 43986, 44113, 44114, 44241, 
	44368, 44495, 44622, 44749, 44876, 45003, 45130, 45257, 
	45384, 45511, 45638, 45765, 45892, 46019, 46146, 46273, 
	46400, 46527, 46528, 46529, 46585, 46586, 46715, 46844, 
	46973, 46974, 46976, 46977, 47106, 47235, 47364, 47493, 
	47622, 47751, 47880, 48009, 48138, 48267, 48396, 48525, 
	48654, 48783, 48912, 49041, 49170, 49299, 49428, 49557, 
	49686, 49815, 49944, 50073, 50202, 50331, 50460, 50589, 
	50718, 50847, 50976, 51105, 51234, 51363, 51492, 51621, 
	51750, 51879, 52008, 52137, 52266, 52395, 52524, 52653, 
	52782, 52911, 53040, 53169, 53298, 53427, 53556, 53685, 
	53814, 53943, 54072, 54201, 54330, 54459, 54588, 54717, 
	54846, 54913, 55042, 55171, 55300, 55429, 55558, 55687, 
	55816, 55945, 56074, 56203, 56332, 56461, 56590, 56719, 
	56848, 56977, 57106, 57235, 57364, 57493, 57622, 57751, 
	57880, 58009, 58138, 58139, 58204, 58298, 58323, 58324, 
	58326, 58328, 58330, 58331, 58460, 58589, 58614, 58615, 
	58617, 58619, 58621, 58622, 58751, 58880, 58882, 58883, 
	58908, 58909, 58976, 58978, 58980, 59109, 59238, 59249, 
	59251, 59276, 59277, 59278, 59299, 59302, 59315, 59317, 
	59319, 59374, 59423, 59499, 59567, 59583, 59642, 59644, 
	59645, 59651, 59652, 59653, 59721, 59789, 59857, 59925, 
	59936, 59938, 59939, 59945, 59947, 59948, 59949, 60017, 
	60085, 60153, 60221, 60289, 60357, 60425, 60493, 60563, 
	60631, 60701, 60769, 60771, 60774, 60776, 60843, 60845, 
	60848, 60977, 61106, 61107, 61236, 61365, 61494, 61623, 
	61752, 61881, 61882, 61884, 61885, 61886, 62015, 62144, 
	62273, 62402, 62531, 62660, 62789, 62918, 63047, 63176, 
	63305, 63434, 63563, 63692, 63821, 63950, 64079, 64208, 
	64337, 64466, 64595, 64724, 64853, 64982, 65111, 65240, 
	65369, 65498, 65627, 65756, 65885, 66014, 66143, 66272, 
	66401, 66530, 66659, 66744, 66873, 67002, 67131, 67260, 
	67389, 67518, 67647, 67776, 67905, 68034, 68163, 68292, 
	68421, 68550, 68679, 68808, 68937, 69066, 69195, 69324, 
	69453, 69582, 69711, 69840, 69969, 70098, 70227, 70356, 
	70485, 70614, 70743, 70872, 71001, 71130, 71259, 71388, 
	71517, 71646, 71775, 71904, 72033, 72162, 72291, 72420, 
	72549, 72678, 72807, 72936, 73065, 73194, 73323, 73452, 
	73581, 73710, 73839, 73968, 74097, 74226, 74355, 74484, 
	74613, 74742, 74871, 75000, 75129, 75130, 75195, 75196, 
	75281, 75366, 75451, 75453, 75455, 75457, 75459, 75461, 
	75514, 75516, 75609, 75711, 75803
]

class << self
	attr_accessor :_lex_indicies
	private :_lex_indicies, :_lex_indicies=
end
self._lex_indicies = [
	1, 0, 2, 0, 3, 0, 4, 0, 
	5, 0, 6, 0, 7, 0, 8, 0, 
	9, 0, 10, 0, 0, 0, 10, 0, 
	0, 0, 0, 0, 11, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 10, 0, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 14, 
	14, 12, 14, 12, 14, 14, 12, 12, 
	14, 14, 14, 15, 14, 14, 16, 16, 
	16, 16, 16, 16, 16, 16, 16, 16, 
	14, 14, 14, 14, 14, 14, 14, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 12, 14, 12, 12, 13, 14, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 12, 12, 12, 14, 12, 13, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 14, 
	14, 14, 14, 14, 14, 14, 14, 14, 
	14, 12, 12, 12, 12, 12, 12, 12, 
	14, 14, 14, 14, 14, 14, 14, 14, 
	14, 14, 14, 14, 14, 14, 14, 14, 
	14, 14, 14, 14, 14, 14, 14, 14, 
	14, 14, 12, 12, 12, 12, 14, 12, 
	14, 14, 14, 14, 14, 14, 14, 14, 
	14, 14, 14, 14, 14, 14, 14, 14, 
	14, 14, 14, 14, 14, 14, 14, 14, 
	14, 14, 12, 12, 12, 12, 12, 14, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	17, 17, 17, 17, 17, 17, 17, 17, 
	17, 17, 12, 12, 12, 12, 12, 12, 
	18, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 12, 12, 12, 12, 13, 
	12, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 12, 12, 12, 12, 12, 
	13, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 17, 17, 17, 17, 17, 17, 17, 
	17, 17, 17, 12, 12, 12, 12, 12, 
	12, 12, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 12, 12, 12, 12, 
	13, 12, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 12, 12, 12, 12, 
	12, 13, 19, 20, 20, 20, 19, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 19, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 21, 
	20, 19, 22, 22, 22, 19, 22, 22, 
	22, 22, 22, 23, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 19, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 24, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 25, 22, 19, 22, 22, 22, 19, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 19, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	26, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 25, 22, 19, 27, 27, 
	27, 19, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 19, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 28, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 29, 27, 19, 30, 30, 30, 19, 
	30, 30, 30, 30, 30, 31, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 19, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 32, 30, 19, 30, 30, 
	30, 19, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 19, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 32, 30, 19, 
	20, 20, 20, 19, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 19, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 33, 20, 19, 34, 
	34, 34, 19, 34, 34, 34, 34, 34, 
	35, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	19, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 36, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 37, 34, 34, 34, 34, 34, 
	34, 38, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 39, 34, 
	19, 34, 34, 34, 19, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 19, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	39, 34, 40, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 41, 19, 41, 19, 19, 42, 
	42, 42, 19, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	19, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 43, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 44, 42, 19, 22, 22, 22, 
	19, 22, 22, 22, 22, 22, 23, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 19, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 26, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 25, 22, 19, 45, 
	45, 45, 19, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	19, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	45, 45, 45, 45, 45, 45, 45, 46, 
	46, 46, 46, 46, 46, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 46, 
	46, 46, 46, 46, 46, 45, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 49, 
	49, 47, 49, 47, 49, 49, 47, 47, 
	49, 49, 49, 50, 49, 49, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	49, 49, 49, 49, 49, 49, 49, 48, 
	48, 48, 48, 48, 48, 48, 48, 48, 
	48, 48, 48, 48, 48, 48, 48, 48, 
	48, 48, 48, 48, 48, 48, 48, 48, 
	48, 47, 49, 47, 47, 48, 49, 48, 
	48, 48, 48, 48, 48, 48, 48, 48, 
	48, 48, 48, 48, 48, 48, 48, 48, 
	48, 48, 48, 48, 48, 48, 48, 48, 
	48, 47, 47, 47, 49, 47, 48, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 49, 
	49, 49, 49, 49, 49, 49, 49, 49, 
	49, 47, 47, 47, 47, 47, 47, 47, 
	49, 49, 49, 49, 49, 49, 49, 49, 
	49, 49, 49, 49, 49, 49, 49, 49, 
	49, 49, 49, 49, 49, 49, 49, 49, 
	49, 49, 47, 47, 47, 47, 49, 47, 
	49, 49, 49, 49, 49, 49, 49, 49, 
	49, 49, 49, 49, 49, 49, 49, 49, 
	49, 49, 49, 49, 49, 49, 49, 49, 
	49, 49, 47, 47, 47, 47, 47, 49, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 47, 47, 47, 47, 47, 47, 
	53, 48, 48, 48, 48, 48, 48, 48, 
	48, 48, 48, 48, 48, 48, 48, 48, 
	48, 48, 48, 48, 48, 48, 48, 48, 
	48, 48, 48, 47, 47, 47, 47, 48, 
	47, 48, 48, 48, 48, 48, 48, 48, 
	48, 48, 48, 48, 48, 48, 48, 48, 
	48, 48, 48, 48, 48, 48, 48, 48, 
	48, 48, 48, 47, 47, 47, 47, 47, 
	48, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 47, 47, 47, 47, 47, 
	47, 47, 48, 48, 48, 48, 48, 48, 
	48, 48, 48, 48, 48, 48, 48, 48, 
	48, 48, 48, 48, 48, 48, 48, 48, 
	48, 48, 48, 48, 47, 47, 47, 47, 
	48, 47, 48, 48, 48, 48, 48, 48, 
	48, 48, 48, 48, 48, 48, 48, 48, 
	48, 48, 48, 48, 48, 48, 48, 48, 
	48, 48, 48, 48, 47, 47, 47, 47, 
	47, 48, 54, 55, 55, 55, 54, 55, 
	55, 55, 55, 55, 55, 55, 55, 55, 
	55, 55, 55, 55, 55, 55, 55, 55, 
	55, 55, 55, 55, 54, 55, 55, 55, 
	55, 55, 55, 55, 55, 55, 55, 55, 
	55, 55, 55, 55, 55, 55, 55, 56, 
	55, 54, 57, 57, 57, 54, 57, 57, 
	57, 57, 57, 58, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 54, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 59, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 60, 57, 54, 57, 57, 57, 54, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 54, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	61, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 60, 57, 54, 62, 62, 
	62, 54, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 54, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 63, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 64, 62, 54, 65, 65, 65, 54, 
	65, 65, 65, 65, 65, 66, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 54, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 67, 65, 54, 65, 65, 
	65, 54, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 54, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 67, 65, 54, 
	55, 55, 55, 54, 55, 55, 55, 55, 
	55, 55, 55, 55, 55, 55, 55, 55, 
	55, 55, 55, 55, 55, 55, 55, 55, 
	55, 54, 55, 55, 55, 55, 55, 55, 
	55, 55, 55, 55, 55, 55, 55, 55, 
	55, 55, 55, 55, 68, 55, 54, 69, 
	69, 69, 54, 69, 69, 69, 69, 69, 
	70, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	54, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 71, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 72, 69, 69, 69, 69, 69, 
	69, 73, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 74, 69, 
	54, 69, 69, 69, 54, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 54, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	74, 69, 75, 54, 54, 54, 54, 54, 
	54, 54, 54, 54, 54, 54, 54, 54, 
	54, 54, 54, 54, 54, 54, 54, 54, 
	54, 54, 54, 54, 54, 54, 54, 54, 
	54, 54, 76, 54, 76, 54, 54, 77, 
	77, 77, 54, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	54, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 78, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 79, 77, 54, 57, 57, 57, 
	54, 57, 57, 57, 57, 57, 58, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 54, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 61, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 60, 57, 54, 80, 
	80, 80, 54, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	54, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	80, 80, 80, 80, 80, 80, 80, 81, 
	81, 81, 81, 81, 81, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 81, 
	81, 81, 81, 81, 81, 80, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 84, 
	84, 82, 84, 82, 84, 84, 82, 82, 
	84, 84, 84, 85, 84, 84, 86, 86, 
	86, 86, 86, 86, 86, 86, 86, 86, 
	84, 84, 84, 84, 84, 84, 84, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 82, 84, 82, 82, 83, 84, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 82, 82, 82, 84, 82, 83, 82, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 84, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	84, 82, 82, 82, 82, 82, 82, 82, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	84, 84, 82, 82, 82, 82, 84, 82, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	84, 84, 82, 82, 82, 82, 82, 84, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	87, 87, 87, 87, 87, 87, 87, 87, 
	87, 87, 82, 82, 82, 82, 82, 82, 
	88, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 82, 82, 82, 82, 83, 
	82, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 82, 82, 82, 82, 82, 
	83, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	82, 87, 87, 87, 87, 87, 87, 87, 
	87, 87, 87, 82, 82, 82, 82, 82, 
	82, 82, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 82, 82, 82, 82, 
	83, 82, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 82, 82, 82, 82, 
	82, 83, 89, 89, 89, 89, 89, 89, 
	89, 89, 89, 89, 89, 89, 89, 89, 
	89, 89, 89, 89, 89, 89, 89, 89, 
	89, 89, 89, 89, 89, 89, 89, 89, 
	89, 89, 89, 91, 91, 89, 91, 89, 
	91, 91, 89, 89, 91, 91, 91, 92, 
	91, 91, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 91, 91, 91, 91, 
	91, 91, 91, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 89, 91, 89, 
	89, 90, 91, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 89, 89, 89, 
	91, 89, 90, 89, 89, 89, 89, 89, 
	89, 89, 89, 89, 89, 89, 89, 89, 
	89, 89, 89, 89, 89, 89, 89, 89, 
	89, 89, 89, 89, 89, 89, 89, 89, 
	89, 89, 89, 89, 89, 89, 89, 89, 
	89, 89, 89, 89, 89, 89, 89, 89, 
	89, 89, 89, 91, 91, 91, 91, 91, 
	91, 91, 91, 91, 91, 89, 89, 89, 
	89, 89, 89, 89, 91, 91, 91, 91, 
	91, 91, 91, 91, 91, 91, 91, 91, 
	91, 91, 91, 91, 91, 91, 91, 91, 
	91, 91, 91, 91, 91, 91, 89, 89, 
	89, 89, 91, 89, 91, 91, 91, 91, 
	91, 91, 91, 91, 91, 91, 91, 91, 
	91, 91, 91, 91, 91, 91, 91, 91, 
	91, 91, 91, 91, 91, 91, 89, 89, 
	89, 89, 89, 91, 89, 89, 89, 89, 
	89, 89, 89, 89, 89, 89, 89, 89, 
	89, 89, 89, 89, 89, 89, 89, 89, 
	89, 89, 89, 89, 89, 89, 89, 89, 
	89, 89, 89, 89, 89, 89, 89, 89, 
	89, 89, 89, 89, 89, 89, 89, 89, 
	89, 89, 89, 89, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 89, 89, 
	89, 89, 89, 89, 95, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 89, 
	89, 89, 89, 90, 89, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 89, 
	89, 89, 89, 89, 90, 89, 89, 89, 
	89, 89, 89, 89, 89, 89, 89, 89, 
	89, 89, 89, 89, 89, 89, 89, 89, 
	89, 89, 89, 89, 89, 89, 89, 89, 
	89, 89, 89, 89, 89, 89, 89, 89, 
	89, 89, 89, 89, 89, 89, 89, 89, 
	89, 89, 89, 89, 89, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 89, 
	89, 89, 89, 89, 89, 89, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	89, 89, 89, 89, 90, 89, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	89, 89, 89, 89, 89, 90, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 97, 
	97, 98, 97, 98, 97, 97, 98, 98, 
	97, 97, 97, 99, 97, 97, 100, 100, 
	100, 100, 100, 100, 100, 100, 100, 100, 
	97, 97, 97, 97, 97, 97, 97, 96, 
	96, 96, 96, 96, 96, 96, 96, 96, 
	96, 96, 96, 96, 96, 96, 96, 96, 
	96, 96, 96, 96, 96, 96, 96, 96, 
	96, 98, 97, 98, 98, 96, 97, 96, 
	96, 96, 96, 96, 96, 96, 96, 96, 
	96, 96, 96, 96, 96, 96, 96, 96, 
	96, 96, 96, 96, 96, 96, 96, 96, 
	96, 98, 98, 98, 97, 98, 96, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 98, 98, 98, 98, 98, 98, 98, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 98, 98, 98, 98, 97, 98, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 98, 98, 98, 98, 98, 97, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	101, 101, 101, 101, 101, 101, 101, 101, 
	101, 101, 98, 98, 98, 98, 98, 98, 
	102, 101, 101, 101, 101, 101, 101, 101, 
	101, 101, 101, 101, 101, 101, 101, 101, 
	101, 101, 101, 101, 101, 101, 101, 101, 
	101, 101, 101, 98, 98, 98, 98, 101, 
	98, 101, 101, 101, 101, 101, 101, 101, 
	101, 101, 101, 101, 101, 101, 101, 101, 
	101, 101, 101, 101, 101, 101, 101, 101, 
	101, 101, 101, 98, 98, 98, 98, 98, 
	101, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	98, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 98, 98, 98, 98, 98, 
	98, 98, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 98, 98, 98, 98, 
	103, 98, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 98, 98, 98, 98, 
	98, 103, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 105, 105, 105, 105, 105, 105, 
	105, 105, 105, 105, 104, 104, 104, 104, 
	104, 104, 104, 105, 105, 105, 105, 105, 
	105, 105, 105, 105, 105, 105, 105, 105, 
	105, 105, 105, 105, 105, 105, 105, 105, 
	105, 105, 105, 105, 105, 104, 104, 104, 
	104, 105, 104, 105, 105, 105, 105, 105, 
	105, 105, 105, 105, 105, 105, 105, 105, 
	105, 105, 105, 105, 105, 105, 105, 105, 
	105, 105, 105, 105, 105, 104, 104, 104, 
	104, 104, 105, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 106, 106, 106, 106, 106, 
	106, 106, 106, 106, 106, 107, 107, 107, 
	107, 107, 107, 107, 106, 106, 106, 106, 
	106, 106, 106, 106, 106, 106, 106, 106, 
	106, 106, 106, 106, 106, 106, 106, 106, 
	106, 106, 106, 106, 106, 106, 107, 107, 
	107, 107, 107, 107, 106, 106, 106, 106, 
	106, 106, 106, 106, 106, 106, 106, 106, 
	106, 106, 106, 106, 106, 106, 106, 106, 
	106, 106, 106, 106, 106, 106, 107, 107, 
	107, 107, 107, 106, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 110, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 109, 109, 109, 109, 
	109, 109, 109, 109, 109, 109, 111, 108, 
	108, 108, 108, 110, 108, 109, 109, 109, 
	109, 109, 109, 109, 109, 109, 109, 109, 
	109, 109, 109, 109, 109, 109, 109, 109, 
	109, 109, 109, 109, 109, 109, 109, 108, 
	108, 108, 108, 109, 108, 109, 109, 109, 
	109, 109, 109, 109, 109, 109, 109, 109, 
	109, 109, 109, 109, 109, 109, 109, 109, 
	109, 109, 109, 109, 109, 109, 109, 108, 
	108, 108, 108, 108, 109, 111, 108, 108, 
	112, 113, 108, 114, 108, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 117, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 118, 
	115, 115, 115, 115, 117, 115, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	115, 115, 115, 115, 116, 115, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	115, 115, 115, 115, 115, 116, 118, 115, 
	120, 119, 121, 119, 122, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 124, 
	119, 124, 124, 124, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 124, 119, 
	119, 119, 119, 125, 126, 119, 127, 119, 
	128, 129, 130, 131, 132, 125, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	133, 119, 134, 130, 135, 136, 119, 123, 
	123, 123, 123, 123, 123, 123, 123, 123, 
	123, 123, 123, 123, 123, 123, 123, 123, 
	123, 123, 123, 123, 123, 123, 123, 123, 
	123, 137, 138, 130, 139, 123, 119, 123, 
	123, 123, 123, 123, 123, 123, 123, 140, 
	123, 123, 123, 123, 123, 123, 123, 123, 
	141, 123, 123, 142, 123, 143, 123, 123, 
	123, 144, 145, 119, 139, 119, 123, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	146, 119, 146, 146, 146, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 146, 
	119, 119, 119, 119, 147, 148, 119, 149, 
	119, 150, 151, 152, 153, 154, 147, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 155, 119, 156, 152, 157, 158, 119, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 159, 160, 152, 121, 116, 119, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	161, 116, 116, 116, 116, 116, 116, 116, 
	116, 162, 116, 116, 163, 116, 164, 116, 
	116, 116, 165, 166, 119, 121, 119, 116, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 117, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 118, 119, 119, 119, 119, 117, 
	119, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 119, 119, 119, 119, 116, 
	119, 116, 116, 116, 116, 116, 167, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 119, 119, 119, 119, 119, 
	116, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 117, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 118, 119, 119, 119, 119, 
	117, 119, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 119, 119, 119, 119, 
	116, 119, 116, 116, 116, 116, 168, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 119, 119, 119, 119, 
	119, 116, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 117, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 118, 119, 119, 119, 
	119, 117, 119, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 119, 119, 119, 
	119, 116, 119, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 169, 116, 116, 
	116, 116, 116, 116, 116, 119, 119, 119, 
	119, 119, 116, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 117, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 118, 119, 119, 
	119, 119, 117, 119, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 119, 119, 
	119, 119, 116, 119, 116, 116, 170, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 119, 119, 
	119, 119, 119, 116, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 117, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 118, 119, 
	119, 119, 119, 117, 119, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 119, 
	119, 119, 119, 116, 119, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 171, 116, 116, 116, 116, 116, 119, 
	119, 119, 119, 119, 116, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 117, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 118, 
	119, 119, 119, 119, 117, 119, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	119, 119, 119, 119, 116, 119, 116, 116, 
	116, 116, 167, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	119, 119, 119, 119, 119, 116, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 117, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	118, 119, 119, 119, 119, 117, 119, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 119, 119, 119, 119, 116, 119, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 172, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 119, 119, 119, 119, 119, 116, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	117, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 118, 119, 119, 119, 119, 117, 119, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 119, 119, 119, 119, 116, 119, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 173, 116, 116, 116, 116, 
	116, 116, 116, 174, 116, 116, 116, 116, 
	116, 116, 119, 119, 119, 119, 119, 116, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 117, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 118, 119, 119, 119, 119, 117, 
	119, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 119, 119, 119, 119, 116, 
	119, 116, 116, 116, 116, 175, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 119, 119, 119, 119, 119, 
	116, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 117, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 118, 119, 119, 119, 119, 
	117, 119, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 119, 119, 119, 119, 
	116, 119, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 176, 116, 116, 116, 
	116, 116, 116, 116, 119, 119, 119, 119, 
	119, 116, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 117, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 118, 119, 119, 119, 
	119, 117, 119, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 119, 119, 119, 
	119, 116, 119, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 167, 116, 116, 
	116, 116, 116, 116, 116, 119, 119, 119, 
	119, 119, 116, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 117, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 118, 119, 119, 
	119, 119, 117, 119, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 119, 119, 
	119, 119, 116, 119, 116, 116, 116, 116, 
	116, 116, 116, 116, 177, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 119, 119, 
	119, 119, 119, 116, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 117, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 118, 119, 
	119, 119, 119, 117, 119, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 119, 
	119, 119, 119, 116, 119, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	167, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 119, 
	119, 119, 119, 119, 116, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 117, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 118, 
	119, 119, 119, 119, 117, 119, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	119, 119, 119, 119, 116, 119, 116, 116, 
	116, 116, 116, 116, 116, 178, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	119, 119, 119, 119, 119, 116, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 117, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	118, 119, 119, 119, 119, 117, 119, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 119, 119, 119, 119, 116, 119, 116, 
	116, 116, 116, 116, 116, 116, 116, 179, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 119, 119, 119, 119, 119, 116, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	117, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 118, 119, 119, 119, 119, 117, 119, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 119, 119, 119, 119, 116, 119, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 171, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 119, 119, 119, 119, 119, 116, 
	181, 180, 182, 180, 183, 180, 152, 180, 
	184, 180, 180, 180, 180, 180, 180, 180, 
	185, 180, 186, 180, 187, 180, 152, 180, 
	188, 180, 152, 180, 189, 180, 183, 180, 
	191, 190, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 194, 192, 194, 194, 194, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 194, 192, 192, 192, 192, 192, 
	192, 192, 195, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 193, 193, 193, 193, 193, 
	193, 193, 193, 193, 193, 193, 193, 193, 
	193, 193, 193, 193, 193, 193, 193, 193, 
	193, 193, 193, 193, 193, 192, 196, 192, 
	192, 193, 192, 193, 193, 193, 197, 193, 
	193, 193, 193, 193, 193, 193, 193, 193, 
	193, 193, 193, 193, 193, 193, 193, 193, 
	193, 193, 193, 193, 193, 192, 192, 192, 
	192, 192, 193, 198, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 200, 192, 
	200, 200, 200, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 200, 192, 192, 
	192, 192, 192, 192, 192, 201, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 199, 199, 
	199, 199, 199, 199, 199, 199, 199, 199, 
	199, 199, 199, 199, 199, 199, 199, 199, 
	199, 199, 199, 199, 199, 199, 199, 199, 
	192, 202, 192, 192, 199, 192, 199, 199, 
	199, 203, 199, 199, 199, 199, 199, 199, 
	199, 199, 199, 199, 199, 199, 199, 199, 
	199, 199, 199, 199, 199, 199, 199, 199, 
	192, 192, 192, 192, 192, 199, 205, 204, 
	205, 205, 205, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 205, 204, 204, 
	204, 204, 204, 204, 204, 206, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 207, 204, 208, 204, 209, 204, 209, 
	209, 209, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 209, 204, 204, 204, 
	204, 204, 204, 204, 210, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	211, 204, 212, 213, 215, 214, 216, 214, 
	217, 214, 218, 214, 219, 214, 221, 221, 
	221, 221, 221, 221, 221, 221, 221, 221, 
	221, 221, 221, 221, 221, 221, 221, 221, 
	221, 221, 221, 221, 221, 221, 221, 221, 
	221, 221, 221, 221, 221, 221, 221, 221, 
	221, 221, 221, 221, 221, 221, 221, 221, 
	221, 221, 221, 221, 221, 221, 220, 220, 
	220, 220, 220, 220, 220, 220, 220, 220, 
	221, 221, 221, 221, 221, 221, 221, 220, 
	220, 220, 220, 220, 220, 220, 220, 220, 
	220, 220, 220, 220, 220, 220, 220, 220, 
	220, 220, 220, 220, 220, 220, 220, 220, 
	220, 221, 221, 221, 221, 221, 221, 220, 
	220, 220, 220, 220, 220, 220, 220, 220, 
	220, 220, 220, 220, 220, 220, 220, 220, 
	220, 220, 220, 220, 220, 220, 220, 220, 
	220, 221, 221, 221, 221, 221, 220, 222, 
	212, 223, 224, 223, 223, 223, 212, 212, 
	212, 212, 212, 212, 212, 212, 212, 212, 
	212, 212, 212, 212, 212, 212, 212, 212, 
	223, 212, 212, 225, 212, 212, 212, 212, 
	212, 212, 212, 212, 212, 212, 212, 212, 
	226, 226, 226, 226, 226, 226, 226, 226, 
	226, 226, 212, 212, 212, 212, 212, 212, 
	212, 212, 212, 212, 212, 212, 212, 212, 
	212, 212, 212, 212, 212, 212, 212, 212, 
	212, 212, 212, 212, 212, 212, 212, 212, 
	212, 212, 212, 212, 227, 212, 228, 229, 
	228, 228, 228, 212, 212, 212, 212, 212, 
	212, 212, 212, 212, 212, 212, 212, 212, 
	212, 212, 212, 212, 212, 228, 212, 212, 
	230, 212, 212, 212, 212, 212, 212, 212, 
	212, 212, 212, 212, 212, 231, 231, 231, 
	231, 231, 231, 231, 231, 231, 231, 212, 
	212, 212, 212, 212, 212, 212, 212, 212, 
	212, 212, 212, 212, 212, 212, 212, 212, 
	212, 212, 212, 212, 212, 212, 212, 212, 
	212, 212, 212, 212, 212, 212, 212, 212, 
	212, 232, 212, 234, 235, 234, 234, 234, 
	233, 233, 233, 233, 233, 233, 233, 233, 
	233, 233, 233, 233, 233, 233, 233, 233, 
	233, 233, 234, 233, 233, 236, 233, 233, 
	233, 233, 233, 233, 233, 233, 233, 233, 
	233, 233, 237, 237, 237, 237, 237, 237, 
	237, 237, 237, 237, 233, 233, 233, 233, 
	233, 233, 233, 233, 233, 233, 233, 233, 
	233, 233, 233, 233, 233, 233, 233, 233, 
	233, 233, 233, 233, 233, 233, 233, 233, 
	233, 233, 233, 233, 233, 233, 238, 233, 
	240, 241, 240, 240, 240, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 240, 
	239, 239, 242, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 243, 
	243, 243, 243, 243, 243, 243, 243, 243, 
	243, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 244, 239, 240, 245, 240, 
	240, 240, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 240, 239, 239, 242, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 243, 243, 243, 243, 
	243, 243, 243, 243, 243, 243, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	244, 239, 224, 212, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 248, 248, 246, 
	248, 246, 248, 248, 246, 246, 248, 248, 
	248, 249, 248, 248, 250, 250, 250, 250, 
	250, 250, 250, 250, 250, 250, 248, 248, 
	248, 248, 248, 248, 248, 247, 247, 247, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	247, 247, 247, 247, 247, 247, 247, 246, 
	248, 246, 246, 247, 248, 247, 247, 247, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	247, 247, 247, 247, 247, 247, 247, 246, 
	246, 246, 248, 246, 247, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 248, 248, 248, 
	248, 248, 248, 248, 248, 248, 248, 246, 
	246, 246, 246, 246, 246, 246, 248, 248, 
	248, 248, 248, 248, 248, 248, 248, 248, 
	248, 248, 248, 248, 248, 248, 248, 248, 
	248, 248, 248, 248, 248, 248, 248, 248, 
	246, 246, 246, 246, 248, 246, 248, 248, 
	248, 248, 248, 248, 248, 248, 248, 248, 
	248, 248, 248, 248, 248, 248, 248, 248, 
	248, 248, 248, 248, 248, 248, 248, 248, 
	246, 246, 246, 246, 246, 248, 251, 248, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 248, 
	246, 251, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 253, 246, 246, 
	246, 246, 254, 246, 246, 246, 246, 246, 
	255, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	222, 246, 246, 246, 252, 252, 252, 252, 
	252, 252, 252, 252, 252, 252, 252, 252, 
	252, 252, 252, 252, 252, 252, 252, 252, 
	252, 252, 252, 252, 252, 252, 246, 246, 
	246, 246, 252, 256, 252, 252, 252, 252, 
	252, 252, 252, 252, 252, 252, 252, 252, 
	252, 252, 252, 252, 252, 252, 252, 252, 
	252, 252, 252, 252, 252, 252, 246, 246, 
	246, 255, 246, 252, 258, 258, 258, 258, 
	258, 258, 258, 258, 258, 258, 259, 258, 
	258, 258, 258, 258, 258, 258, 258, 258, 
	258, 258, 258, 258, 258, 258, 258, 258, 
	258, 258, 258, 258, 258, 258, 258, 258, 
	258, 258, 258, 258, 258, 258, 258, 258, 
	258, 258, 258, 258, 257, 257, 257, 257, 
	257, 257, 257, 257, 257, 257, 258, 258, 
	258, 258, 258, 258, 258, 257, 257, 257, 
	257, 257, 257, 257, 257, 257, 257, 257, 
	257, 257, 257, 257, 257, 257, 257, 257, 
	257, 257, 257, 257, 257, 257, 257, 258, 
	258, 258, 258, 257, 258, 257, 257, 257, 
	257, 257, 257, 257, 257, 257, 257, 257, 
	257, 257, 257, 257, 257, 257, 257, 257, 
	257, 257, 257, 257, 257, 257, 257, 258, 
	258, 258, 258, 258, 257, 261, 260, 264, 
	263, 259, 258, 264, 265, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 253, 
	246, 246, 246, 246, 254, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 252, 252, 
	252, 252, 252, 252, 252, 252, 252, 252, 
	252, 252, 252, 252, 252, 252, 252, 252, 
	252, 252, 252, 252, 252, 252, 252, 252, 
	246, 246, 246, 246, 252, 256, 252, 252, 
	252, 252, 252, 252, 252, 252, 252, 252, 
	252, 252, 252, 252, 252, 252, 252, 252, 
	252, 252, 252, 252, 252, 252, 252, 252, 
	246, 246, 246, 246, 246, 252, 267, 266, 
	266, 266, 266, 266, 266, 266, 266, 266, 
	266, 266, 266, 266, 266, 266, 266, 266, 
	266, 266, 266, 266, 266, 266, 266, 266, 
	266, 266, 266, 266, 266, 266, 266, 266, 
	266, 266, 266, 266, 266, 266, 266, 266, 
	266, 266, 266, 266, 266, 266, 266, 266, 
	266, 266, 266, 266, 266, 266, 266, 266, 
	266, 266, 266, 266, 266, 266, 266, 266, 
	266, 266, 266, 266, 266, 266, 266, 266, 
	266, 266, 266, 266, 266, 266, 266, 266, 
	266, 266, 266, 266, 264, 266, 264, 267, 
	268, 269, 269, 269, 268, 269, 269, 269, 
	269, 269, 269, 269, 269, 269, 269, 269, 
	269, 269, 269, 269, 269, 269, 269, 269, 
	269, 269, 268, 269, 269, 269, 269, 269, 
	269, 269, 269, 269, 269, 269, 269, 269, 
	269, 269, 269, 269, 269, 270, 269, 268, 
	271, 271, 271, 268, 271, 271, 271, 271, 
	271, 272, 271, 271, 271, 271, 271, 271, 
	271, 271, 271, 271, 271, 271, 271, 271, 
	271, 268, 271, 271, 271, 271, 271, 271, 
	271, 271, 271, 271, 271, 271, 271, 271, 
	271, 271, 271, 271, 271, 271, 271, 271, 
	271, 271, 271, 271, 271, 271, 271, 271, 
	271, 271, 271, 271, 271, 271, 271, 271, 
	271, 271, 271, 271, 271, 271, 271, 271, 
	271, 271, 271, 271, 273, 271, 271, 271, 
	271, 271, 271, 271, 271, 271, 271, 271, 
	271, 271, 271, 271, 271, 271, 271, 271, 
	271, 271, 271, 271, 271, 271, 271, 271, 
	271, 271, 271, 271, 271, 271, 271, 271, 
	271, 271, 271, 271, 271, 271, 271, 274, 
	271, 268, 271, 271, 271, 268, 271, 271, 
	271, 271, 271, 271, 271, 271, 271, 271, 
	271, 271, 271, 271, 271, 271, 271, 271, 
	271, 271, 271, 268, 271, 271, 271, 271, 
	271, 271, 271, 271, 271, 271, 271, 271, 
	271, 271, 271, 271, 271, 271, 271, 271, 
	271, 271, 271, 271, 271, 271, 271, 271, 
	271, 271, 271, 271, 271, 271, 271, 271, 
	271, 271, 271, 271, 271, 271, 271, 271, 
	271, 271, 271, 271, 271, 271, 275, 271, 
	271, 271, 271, 271, 271, 271, 271, 271, 
	271, 271, 271, 271, 271, 271, 271, 271, 
	271, 271, 271, 271, 271, 271, 271, 271, 
	271, 271, 271, 271, 271, 271, 271, 271, 
	271, 271, 271, 271, 271, 271, 271, 271, 
	271, 274, 271, 268, 276, 276, 276, 268, 
	276, 276, 276, 276, 276, 276, 276, 276, 
	276, 276, 276, 276, 276, 276, 276, 276, 
	276, 276, 276, 276, 276, 268, 276, 276, 
	276, 276, 276, 276, 276, 276, 276, 276, 
	276, 276, 276, 276, 276, 276, 276, 276, 
	276, 276, 276, 276, 276, 276, 276, 276, 
	276, 276, 276, 276, 276, 276, 276, 276, 
	276, 276, 277, 276, 276, 276, 276, 276, 
	276, 276, 276, 276, 276, 276, 276, 276, 
	276, 276, 276, 276, 276, 276, 276, 276, 
	276, 276, 276, 276, 276, 276, 276, 278, 
	276, 268, 279, 279, 279, 268, 279, 279, 
	279, 279, 279, 280, 279, 279, 279, 279, 
	279, 279, 279, 279, 279, 279, 279, 279, 
	279, 279, 279, 268, 279, 279, 279, 279, 
	279, 279, 279, 279, 279, 279, 279, 279, 
	279, 279, 279, 279, 279, 279, 279, 279, 
	279, 279, 279, 279, 279, 279, 279, 279, 
	279, 279, 279, 279, 279, 279, 279, 279, 
	279, 279, 279, 279, 279, 279, 279, 279, 
	279, 279, 279, 279, 279, 279, 279, 279, 
	279, 279, 279, 279, 279, 279, 279, 279, 
	279, 279, 279, 279, 279, 279, 279, 279, 
	279, 279, 279, 279, 279, 279, 279, 279, 
	279, 279, 279, 279, 279, 279, 279, 279, 
	279, 279, 279, 279, 279, 279, 279, 279, 
	279, 281, 279, 268, 279, 279, 279, 268, 
	279, 279, 279, 279, 279, 279, 279, 279, 
	279, 279, 279, 279, 279, 279, 279, 279, 
	279, 279, 279, 279, 279, 268, 279, 279, 
	279, 279, 279, 279, 279, 279, 279, 279, 
	279, 279, 279, 279, 279, 279, 279, 279, 
	279, 279, 279, 279, 279, 279, 279, 279, 
	279, 279, 279, 279, 279, 279, 279, 279, 
	279, 279, 279, 279, 279, 279, 279, 279, 
	279, 279, 279, 279, 279, 279, 279, 279, 
	279, 279, 279, 279, 279, 279, 279, 279, 
	279, 279, 279, 279, 279, 279, 279, 279, 
	279, 279, 279, 279, 279, 279, 279, 279, 
	279, 279, 279, 279, 279, 279, 279, 279, 
	279, 279, 279, 279, 279, 279, 279, 279, 
	279, 279, 279, 281, 279, 268, 269, 269, 
	269, 268, 269, 269, 269, 269, 269, 269, 
	269, 269, 269, 269, 269, 269, 269, 269, 
	269, 269, 269, 269, 269, 269, 269, 268, 
	269, 269, 269, 269, 269, 269, 269, 269, 
	269, 269, 269, 269, 269, 269, 269, 269, 
	269, 269, 282, 269, 268, 283, 283, 283, 
	268, 283, 283, 283, 283, 283, 284, 283, 
	283, 283, 283, 283, 283, 283, 283, 283, 
	283, 283, 283, 283, 283, 283, 268, 283, 
	283, 283, 283, 283, 283, 283, 283, 283, 
	283, 283, 283, 283, 283, 283, 283, 283, 
	283, 283, 283, 283, 283, 283, 283, 283, 
	283, 283, 283, 283, 283, 283, 283, 283, 
	283, 283, 283, 283, 283, 283, 283, 285, 
	283, 283, 283, 283, 283, 283, 283, 283, 
	283, 283, 283, 283, 283, 283, 283, 283, 
	283, 283, 283, 283, 283, 283, 283, 283, 
	286, 283, 283, 283, 283, 283, 283, 287, 
	283, 283, 283, 283, 283, 283, 283, 283, 
	283, 283, 283, 283, 283, 283, 283, 283, 
	283, 283, 283, 283, 288, 283, 268, 283, 
	283, 283, 268, 283, 283, 283, 283, 283, 
	283, 283, 283, 283, 283, 283, 283, 283, 
	283, 283, 283, 283, 283, 283, 283, 283, 
	268, 283, 283, 283, 283, 283, 283, 283, 
	283, 283, 283, 283, 283, 283, 283, 283, 
	283, 283, 283, 283, 283, 283, 283, 283, 
	283, 283, 283, 283, 283, 283, 283, 283, 
	283, 283, 283, 283, 283, 283, 283, 283, 
	283, 283, 283, 283, 283, 283, 283, 283, 
	283, 283, 283, 283, 283, 283, 283, 283, 
	283, 283, 283, 283, 283, 283, 283, 283, 
	283, 283, 283, 283, 283, 283, 283, 283, 
	283, 283, 283, 283, 283, 283, 283, 283, 
	283, 283, 283, 283, 283, 283, 283, 283, 
	283, 283, 283, 283, 283, 283, 288, 283, 
	289, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	290, 268, 290, 268, 268, 291, 291, 291, 
	268, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 268, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 292, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	293, 291, 268, 271, 271, 271, 268, 271, 
	271, 271, 271, 271, 272, 271, 271, 271, 
	271, 271, 271, 271, 271, 271, 271, 271, 
	271, 271, 271, 271, 268, 271, 271, 271, 
	271, 271, 271, 271, 271, 271, 271, 271, 
	271, 271, 271, 271, 271, 271, 271, 271, 
	271, 271, 271, 271, 271, 271, 271, 271, 
	271, 271, 271, 271, 271, 271, 271, 271, 
	271, 271, 271, 271, 271, 271, 271, 271, 
	271, 271, 271, 271, 271, 271, 271, 275, 
	271, 271, 271, 271, 271, 271, 271, 271, 
	271, 271, 271, 271, 271, 271, 271, 271, 
	271, 271, 271, 271, 271, 271, 271, 271, 
	271, 271, 271, 271, 271, 271, 271, 271, 
	271, 271, 271, 271, 271, 271, 271, 271, 
	271, 271, 274, 271, 268, 294, 294, 294, 
	268, 294, 294, 294, 294, 294, 294, 294, 
	294, 294, 294, 294, 294, 294, 294, 294, 
	294, 294, 294, 294, 294, 294, 268, 294, 
	294, 294, 294, 294, 294, 294, 294, 294, 
	294, 294, 294, 294, 294, 294, 294, 294, 
	294, 294, 294, 294, 295, 295, 295, 295, 
	295, 295, 295, 295, 295, 295, 294, 294, 
	294, 294, 294, 294, 294, 295, 295, 295, 
	295, 295, 295, 294, 294, 294, 294, 294, 
	294, 294, 294, 294, 294, 294, 294, 294, 
	294, 294, 294, 294, 294, 294, 294, 294, 
	294, 294, 294, 294, 294, 295, 295, 295, 
	295, 295, 295, 294, 212, 212, 212, 212, 
	212, 212, 212, 212, 212, 212, 212, 212, 
	212, 212, 212, 212, 212, 212, 212, 212, 
	212, 212, 212, 212, 212, 212, 212, 212, 
	212, 212, 212, 212, 212, 297, 212, 212, 
	212, 212, 212, 212, 212, 212, 212, 212, 
	212, 212, 212, 212, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 298, 212, 
	212, 299, 212, 297, 212, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 212, 
	212, 212, 212, 296, 212, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 212, 
	212, 212, 212, 212, 296, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 297, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 298, 
	246, 246, 299, 246, 297, 246, 296, 296, 
	296, 296, 296, 296, 300, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	246, 246, 246, 246, 296, 246, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	246, 246, 246, 246, 246, 296, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 297, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	298, 246, 246, 299, 246, 297, 246, 296, 
	296, 296, 296, 296, 296, 296, 296, 301, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 246, 246, 246, 246, 296, 246, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 246, 246, 246, 246, 246, 296, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	297, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 298, 246, 246, 299, 246, 297, 246, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 302, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 246, 246, 246, 246, 296, 246, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 246, 246, 246, 246, 246, 296, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 297, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 298, 246, 246, 299, 246, 297, 
	246, 296, 296, 296, 302, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 246, 246, 246, 246, 296, 
	246, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 246, 246, 246, 246, 246, 
	296, 303, 303, 303, 303, 303, 303, 303, 
	303, 303, 303, 303, 303, 303, 303, 303, 
	303, 303, 303, 303, 303, 303, 303, 303, 
	303, 303, 303, 303, 303, 303, 303, 303, 
	303, 303, 305, 303, 303, 303, 303, 303, 
	303, 303, 303, 303, 303, 303, 303, 303, 
	303, 304, 304, 304, 304, 304, 304, 304, 
	304, 304, 304, 306, 303, 303, 303, 303, 
	305, 303, 304, 304, 304, 304, 304, 304, 
	304, 304, 304, 304, 304, 304, 304, 304, 
	304, 304, 304, 304, 304, 304, 304, 304, 
	304, 304, 304, 304, 303, 303, 303, 303, 
	304, 303, 304, 304, 304, 304, 304, 304, 
	304, 304, 304, 304, 304, 304, 304, 304, 
	304, 304, 304, 304, 304, 304, 304, 304, 
	304, 304, 304, 304, 303, 303, 303, 303, 
	303, 304, 306, 303, 303, 307, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 309, 309, 
	309, 309, 309, 309, 309, 309, 309, 309, 
	308, 308, 308, 308, 308, 308, 308, 309, 
	309, 309, 309, 309, 309, 309, 309, 309, 
	309, 309, 309, 309, 309, 309, 309, 309, 
	309, 309, 309, 309, 309, 309, 309, 309, 
	309, 308, 308, 308, 308, 309, 308, 309, 
	309, 309, 309, 309, 309, 309, 309, 309, 
	309, 309, 309, 309, 309, 309, 309, 309, 
	309, 309, 309, 309, 309, 309, 309, 309, 
	309, 308, 308, 308, 308, 308, 309, 311, 
	310, 311, 310, 310, 312, 312, 312, 312, 
	312, 312, 312, 312, 312, 312, 310, 312, 
	312, 312, 312, 312, 312, 312, 312, 312, 
	312, 310, 313, 313, 313, 313, 313, 313, 
	313, 313, 313, 313, 310, 315, 315, 315, 
	315, 315, 315, 315, 315, 315, 315, 314, 
	316, 316, 316, 316, 316, 316, 316, 316, 
	316, 316, 314, 318, 317, 319, 317, 320, 
	317, 321, 317, 323, 322, 324, 322, 325, 
	322, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 326, 326, 326, 326, 326, 326, 326, 
	326, 326, 326, 308, 308, 308, 308, 308, 
	308, 308, 326, 326, 326, 326, 326, 326, 
	326, 326, 326, 326, 326, 326, 326, 326, 
	326, 326, 326, 326, 326, 326, 326, 326, 
	326, 326, 326, 326, 308, 308, 308, 308, 
	326, 308, 326, 326, 326, 326, 326, 326, 
	326, 326, 326, 326, 326, 326, 326, 326, 
	326, 326, 326, 326, 326, 326, 326, 326, 
	326, 326, 326, 326, 308, 308, 308, 308, 
	308, 326, 327, 314, 328, 329, 328, 328, 
	328, 314, 314, 314, 314, 314, 314, 314, 
	314, 314, 314, 314, 314, 314, 314, 314, 
	314, 314, 314, 328, 314, 314, 330, 314, 
	314, 314, 314, 314, 314, 314, 314, 314, 
	314, 314, 314, 314, 314, 314, 314, 314, 
	314, 314, 314, 314, 314, 314, 314, 331, 
	314, 314, 314, 314, 314, 314, 314, 314, 
	314, 314, 314, 314, 314, 314, 314, 314, 
	314, 314, 314, 314, 314, 314, 314, 314, 
	314, 314, 314, 314, 314, 314, 314, 332, 
	314, 333, 334, 333, 333, 333, 314, 314, 
	314, 314, 314, 314, 314, 314, 314, 314, 
	314, 314, 314, 314, 314, 314, 314, 314, 
	333, 314, 314, 335, 314, 314, 314, 314, 
	314, 314, 314, 314, 314, 314, 314, 314, 
	314, 314, 314, 314, 314, 314, 314, 314, 
	314, 314, 314, 314, 336, 314, 314, 314, 
	314, 314, 314, 314, 314, 314, 314, 314, 
	314, 314, 314, 314, 314, 314, 314, 314, 
	314, 314, 314, 314, 314, 314, 314, 314, 
	314, 314, 314, 314, 337, 314, 339, 340, 
	339, 339, 339, 338, 338, 338, 338, 338, 
	338, 338, 338, 338, 338, 338, 338, 338, 
	338, 338, 338, 338, 338, 339, 338, 338, 
	341, 338, 338, 338, 338, 338, 338, 338, 
	338, 338, 338, 338, 338, 338, 338, 338, 
	338, 338, 338, 338, 338, 338, 338, 338, 
	338, 342, 338, 338, 338, 338, 338, 338, 
	338, 338, 338, 338, 338, 338, 338, 338, 
	338, 338, 338, 338, 338, 338, 338, 338, 
	338, 338, 338, 338, 338, 338, 338, 338, 
	338, 343, 338, 345, 346, 345, 345, 345, 
	344, 344, 344, 344, 344, 344, 344, 344, 
	344, 344, 344, 344, 344, 344, 344, 344, 
	344, 344, 345, 344, 344, 347, 344, 344, 
	344, 344, 344, 344, 344, 344, 344, 344, 
	344, 344, 344, 344, 344, 344, 344, 344, 
	344, 344, 344, 344, 344, 344, 348, 344, 
	344, 344, 344, 344, 344, 344, 344, 344, 
	344, 344, 344, 344, 344, 344, 344, 344, 
	344, 344, 344, 344, 344, 344, 344, 344, 
	344, 344, 344, 344, 344, 344, 349, 344, 
	345, 346, 345, 345, 345, 344, 344, 344, 
	344, 344, 344, 344, 344, 344, 344, 344, 
	344, 344, 344, 344, 344, 344, 344, 345, 
	344, 344, 347, 344, 344, 344, 344, 344, 
	344, 344, 344, 344, 344, 344, 344, 344, 
	344, 344, 344, 344, 344, 344, 344, 344, 
	344, 344, 344, 350, 344, 344, 344, 344, 
	344, 344, 344, 344, 344, 344, 344, 344, 
	344, 344, 344, 344, 344, 344, 344, 344, 
	344, 344, 344, 344, 344, 344, 344, 344, 
	344, 344, 344, 349, 344, 345, 351, 345, 
	345, 345, 344, 344, 344, 344, 344, 344, 
	344, 344, 344, 344, 344, 344, 344, 344, 
	344, 344, 344, 344, 345, 344, 344, 347, 
	344, 344, 344, 344, 344, 344, 344, 344, 
	344, 344, 344, 344, 344, 344, 344, 344, 
	344, 344, 344, 344, 344, 344, 344, 344, 
	348, 344, 344, 344, 344, 344, 344, 344, 
	344, 344, 344, 344, 344, 344, 344, 344, 
	344, 344, 344, 344, 344, 344, 344, 344, 
	344, 344, 344, 344, 344, 344, 344, 344, 
	349, 344, 352, 314, 329, 314, 354, 355, 
	354, 354, 354, 353, 353, 353, 353, 353, 
	353, 353, 353, 353, 353, 353, 353, 353, 
	353, 353, 353, 353, 353, 354, 353, 353, 
	356, 353, 353, 357, 353, 353, 353, 353, 
	353, 353, 353, 358, 353, 353, 353, 353, 
	353, 353, 353, 353, 353, 353, 353, 353, 
	353, 353, 353, 353, 353, 353, 353, 353, 
	353, 353, 353, 353, 353, 353, 353, 353, 
	353, 353, 353, 353, 353, 353, 353, 353, 
	353, 353, 353, 353, 353, 353, 353, 353, 
	353, 359, 353, 361, 355, 361, 361, 361, 
	360, 360, 360, 360, 360, 360, 360, 360, 
	360, 360, 360, 360, 360, 360, 360, 360, 
	360, 360, 361, 360, 360, 356, 360, 360, 
	360, 360, 360, 360, 360, 360, 360, 360, 
	360, 360, 360, 360, 360, 360, 360, 360, 
	360, 360, 360, 360, 360, 360, 360, 360, 
	360, 360, 360, 360, 360, 360, 360, 360, 
	360, 360, 360, 360, 360, 360, 360, 360, 
	360, 360, 360, 360, 360, 360, 360, 360, 
	360, 360, 360, 360, 360, 360, 359, 360, 
	364, 363, 366, 365, 367, 362, 368, 362, 
	369, 353, 371, 370, 370, 370, 371, 370, 
	370, 370, 370, 372, 373, 372, 372, 372, 
	370, 370, 370, 370, 370, 370, 370, 370, 
	370, 370, 370, 370, 371, 370, 370, 370, 
	370, 370, 372, 370, 370, 374, 370, 370, 
	370, 370, 370, 370, 370, 370, 370, 370, 
	370, 370, 370, 370, 370, 370, 370, 370, 
	370, 370, 370, 370, 370, 370, 370, 375, 
	370, 370, 370, 370, 370, 370, 370, 370, 
	370, 370, 370, 370, 370, 370, 370, 370, 
	370, 370, 370, 370, 370, 370, 370, 370, 
	370, 370, 370, 370, 370, 370, 376, 370, 
	370, 377, 370, 372, 378, 372, 372, 372, 
	378, 378, 378, 378, 378, 378, 378, 378, 
	378, 378, 378, 378, 378, 378, 378, 378, 
	378, 378, 372, 378, 379, 380, 381, 382, 
	383, 385, 384, 387, 388, 387, 387, 387, 
	386, 386, 386, 386, 386, 386, 386, 386, 
	386, 386, 386, 386, 386, 386, 386, 386, 
	386, 386, 387, 386, 373, 384, 389, 384, 
	391, 390, 390, 390, 391, 390, 390, 390, 
	390, 392, 393, 392, 392, 392, 390, 390, 
	390, 390, 390, 390, 390, 390, 390, 390, 
	390, 390, 391, 390, 390, 390, 390, 390, 
	392, 390, 390, 394, 390, 390, 390, 390, 
	390, 390, 390, 390, 390, 390, 390, 390, 
	390, 390, 390, 390, 390, 390, 390, 390, 
	390, 390, 390, 390, 390, 390, 390, 390, 
	390, 390, 390, 390, 390, 390, 390, 390, 
	390, 390, 390, 390, 390, 390, 390, 390, 
	390, 390, 390, 390, 390, 390, 390, 390, 
	390, 390, 390, 390, 395, 390, 392, 396, 
	392, 392, 392, 396, 396, 396, 396, 396, 
	396, 396, 396, 396, 396, 396, 396, 396, 
	396, 396, 396, 396, 396, 392, 396, 398, 
	397, 397, 397, 397, 397, 397, 397, 397, 
	397, 397, 397, 397, 397, 397, 397, 397, 
	397, 397, 397, 397, 397, 397, 397, 397, 
	397, 397, 397, 399, 397, 397, 397, 397, 
	397, 397, 397, 397, 397, 397, 397, 397, 
	397, 397, 397, 397, 397, 397, 397, 397, 
	397, 397, 397, 397, 397, 397, 397, 397, 
	397, 397, 397, 397, 397, 397, 397, 397, 
	397, 397, 397, 397, 397, 397, 397, 397, 
	397, 397, 397, 397, 397, 397, 397, 397, 
	397, 397, 397, 397, 397, 397, 400, 397, 
	401, 401, 401, 401, 401, 401, 401, 401, 
	401, 401, 401, 401, 401, 401, 401, 401, 
	401, 401, 401, 401, 401, 401, 401, 401, 
	401, 401, 401, 401, 401, 401, 401, 401, 
	401, 401, 401, 401, 401, 401, 401, 401, 
	401, 401, 401, 401, 401, 401, 401, 401, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 401, 401, 401, 401, 401, 401, 
	401, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 401, 401, 401, 401, 13, 
	401, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 401, 401, 401, 401, 401, 
	13, 16, 16, 16, 16, 16, 16, 16, 
	16, 16, 16, 401, 402, 402, 402, 402, 
	402, 402, 402, 402, 402, 402, 402, 402, 
	402, 402, 402, 402, 402, 402, 402, 402, 
	402, 402, 402, 402, 402, 402, 402, 402, 
	402, 402, 402, 402, 402, 402, 402, 402, 
	402, 402, 402, 402, 402, 402, 402, 402, 
	402, 402, 402, 402, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 402, 402, 
	402, 402, 402, 402, 402, 17, 17, 17, 
	17, 17, 17, 17, 17, 17, 17, 17, 
	17, 17, 17, 17, 17, 17, 17, 17, 
	17, 17, 17, 17, 17, 17, 17, 402, 
	402, 402, 402, 17, 402, 17, 17, 17, 
	17, 17, 17, 17, 17, 17, 17, 17, 
	17, 17, 17, 17, 17, 17, 17, 17, 
	17, 17, 17, 17, 17, 17, 17, 402, 
	402, 402, 402, 402, 17, 405, 404, 404, 
	404, 405, 404, 404, 404, 404, 404, 404, 
	404, 404, 404, 404, 404, 404, 404, 404, 
	404, 404, 404, 404, 404, 404, 404, 405, 
	404, 404, 404, 404, 404, 404, 404, 404, 
	404, 404, 404, 404, 404, 404, 404, 404, 
	404, 404, 404, 404, 404, 406, 406, 406, 
	406, 406, 406, 406, 406, 404, 404, 404, 
	404, 404, 404, 404, 404, 404, 404, 404, 
	407, 404, 404, 404, 404, 404, 404, 404, 
	404, 404, 408, 404, 404, 404, 404, 404, 
	404, 404, 404, 404, 404, 404, 404, 404, 
	404, 404, 404, 404, 404, 404, 404, 404, 
	409, 404, 404, 404, 404, 404, 404, 404, 
	404, 404, 404, 404, 404, 404, 404, 404, 
	404, 404, 410, 404, 404, 411, 404, 412, 
	413, 415, 415, 415, 415, 415, 415, 415, 
	415, 414, 416, 416, 416, 416, 416, 416, 
	416, 416, 414, 414, 417, 417, 42, 42, 
	42, 417, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 417, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 43, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 418, 42, 419, 420, 421, 421, 42, 
	42, 42, 421, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	421, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 43, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 422, 42, 41, 421, 423, 424, 
	425, 425, 27, 27, 27, 425, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 425, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	28, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 426, 27, 427, 
	427, 427, 427, 427, 427, 427, 427, 427, 
	427, 425, 425, 425, 425, 425, 425, 425, 
	427, 427, 427, 427, 427, 427, 425, 425, 
	425, 425, 425, 425, 425, 425, 425, 425, 
	425, 425, 425, 425, 425, 425, 425, 425, 
	425, 425, 425, 425, 425, 425, 425, 425, 
	427, 427, 427, 427, 427, 427, 425, 429, 
	429, 429, 429, 429, 429, 429, 429, 429, 
	429, 428, 428, 428, 428, 428, 428, 428, 
	429, 429, 429, 429, 429, 429, 428, 428, 
	428, 428, 428, 428, 428, 428, 428, 428, 
	428, 428, 428, 428, 428, 428, 428, 428, 
	428, 428, 428, 428, 428, 428, 428, 428, 
	429, 429, 429, 429, 429, 429, 428, 428, 
	430, 430, 430, 430, 430, 430, 430, 430, 
	430, 430, 421, 421, 421, 421, 421, 421, 
	421, 430, 430, 430, 430, 430, 430, 421, 
	421, 421, 421, 421, 421, 421, 421, 421, 
	421, 421, 421, 421, 421, 421, 421, 421, 
	421, 421, 421, 421, 421, 421, 421, 421, 
	421, 430, 430, 430, 430, 430, 430, 421, 
	432, 432, 432, 432, 432, 432, 432, 432, 
	432, 432, 431, 431, 431, 431, 431, 431, 
	431, 432, 432, 432, 432, 432, 432, 431, 
	431, 431, 431, 431, 431, 431, 431, 431, 
	431, 431, 431, 431, 431, 431, 431, 431, 
	431, 431, 431, 431, 431, 431, 431, 431, 
	431, 432, 432, 432, 432, 432, 432, 431, 
	431, 421, 20, 20, 20, 421, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 421, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 433, 20, 
	417, 27, 27, 27, 417, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 417, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 28, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 29, 27, 417, 434, 
	434, 434, 417, 434, 434, 434, 434, 434, 
	434, 434, 434, 434, 434, 434, 434, 434, 
	434, 434, 434, 434, 434, 434, 434, 434, 
	417, 434, 434, 434, 434, 434, 434, 434, 
	434, 434, 434, 434, 434, 434, 434, 434, 
	434, 434, 434, 434, 434, 434, 434, 434, 
	434, 434, 434, 434, 434, 434, 434, 434, 
	434, 434, 434, 434, 434, 434, 434, 434, 
	434, 434, 434, 434, 434, 434, 434, 434, 
	434, 434, 434, 434, 434, 434, 434, 434, 
	434, 434, 434, 434, 434, 434, 434, 434, 
	434, 434, 435, 434, 436, 437, 437, 434, 
	434, 434, 437, 434, 434, 434, 434, 434, 
	434, 434, 434, 434, 434, 434, 434, 434, 
	434, 434, 434, 434, 434, 434, 434, 434, 
	437, 434, 434, 434, 434, 434, 434, 434, 
	434, 434, 434, 434, 434, 434, 434, 434, 
	434, 434, 434, 434, 434, 434, 434, 434, 
	434, 434, 434, 434, 434, 434, 434, 434, 
	434, 434, 434, 434, 434, 434, 434, 434, 
	434, 434, 434, 434, 434, 434, 434, 434, 
	434, 434, 434, 434, 434, 434, 434, 434, 
	434, 434, 434, 434, 434, 434, 434, 434, 
	434, 434, 438, 434, 439, 439, 439, 439, 
	439, 439, 439, 439, 439, 439, 437, 437, 
	437, 437, 437, 437, 437, 439, 439, 439, 
	439, 439, 439, 437, 437, 437, 437, 437, 
	437, 437, 437, 437, 437, 437, 437, 437, 
	437, 437, 437, 437, 437, 437, 437, 437, 
	437, 437, 437, 437, 437, 439, 439, 439, 
	439, 439, 439, 437, 441, 441, 441, 441, 
	441, 441, 441, 441, 441, 441, 440, 440, 
	440, 440, 440, 440, 440, 441, 441, 441, 
	441, 441, 441, 440, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 441, 441, 441, 
	441, 441, 441, 440, 440, 437, 20, 20, 
	20, 437, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 437, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 433, 20, 442, 437, 437, 27, 
	27, 27, 437, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	437, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 28, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 29, 27, 444, 444, 444, 444, 
	444, 444, 444, 444, 444, 444, 443, 443, 
	443, 443, 443, 443, 443, 444, 444, 444, 
	444, 444, 444, 443, 443, 443, 443, 443, 
	443, 443, 443, 443, 443, 443, 443, 443, 
	443, 443, 443, 443, 443, 443, 443, 443, 
	443, 443, 443, 443, 443, 444, 444, 444, 
	444, 444, 444, 443, 443, 443, 443, 443, 
	443, 443, 443, 443, 443, 443, 443, 443, 
	443, 443, 443, 443, 443, 443, 443, 445, 
	443, 446, 446, 446, 446, 446, 446, 446, 
	446, 446, 446, 443, 443, 443, 443, 443, 
	443, 443, 446, 446, 446, 446, 446, 446, 
	443, 443, 443, 443, 443, 443, 443, 443, 
	443, 443, 443, 443, 443, 443, 443, 443, 
	443, 443, 443, 443, 443, 443, 443, 443, 
	443, 443, 446, 446, 446, 446, 446, 446, 
	443, 447, 447, 447, 447, 447, 447, 447, 
	447, 447, 447, 443, 443, 443, 443, 443, 
	443, 443, 447, 447, 447, 447, 447, 447, 
	443, 443, 443, 443, 443, 443, 443, 443, 
	443, 443, 443, 443, 443, 443, 443, 443, 
	443, 443, 443, 443, 443, 443, 443, 443, 
	443, 443, 447, 447, 447, 447, 447, 447, 
	443, 448, 448, 448, 448, 448, 448, 448, 
	448, 448, 448, 443, 443, 443, 443, 443, 
	443, 443, 448, 448, 448, 448, 448, 448, 
	443, 443, 443, 443, 443, 443, 443, 443, 
	443, 443, 443, 443, 443, 443, 443, 443, 
	443, 443, 443, 443, 443, 443, 443, 443, 
	443, 443, 448, 448, 448, 448, 448, 448, 
	443, 449, 452, 451, 451, 451, 452, 451, 
	451, 451, 451, 453, 451, 451, 451, 451, 
	451, 451, 451, 451, 451, 451, 451, 451, 
	451, 451, 451, 451, 452, 451, 451, 451, 
	451, 451, 453, 451, 451, 451, 451, 451, 
	451, 451, 451, 451, 451, 451, 451, 451, 
	451, 451, 454, 454, 454, 454, 454, 454, 
	454, 454, 454, 454, 451, 451, 451, 451, 
	451, 451, 451, 454, 454, 454, 454, 454, 
	454, 451, 451, 451, 451, 451, 451, 451, 
	451, 451, 451, 451, 451, 451, 451, 451, 
	451, 451, 451, 451, 451, 451, 451, 451, 
	451, 451, 451, 454, 454, 454, 454, 454, 
	454, 451, 451, 451, 451, 451, 451, 451, 
	451, 451, 451, 451, 451, 451, 451, 451, 
	451, 451, 451, 451, 451, 451, 451, 455, 
	451, 452, 451, 451, 451, 452, 451, 451, 
	451, 451, 450, 451, 451, 451, 451, 451, 
	451, 451, 451, 451, 451, 451, 451, 451, 
	451, 451, 451, 452, 451, 451, 451, 451, 
	451, 450, 451, 451, 451, 451, 451, 451, 
	451, 451, 451, 451, 451, 451, 451, 451, 
	451, 456, 456, 456, 456, 456, 456, 456, 
	456, 456, 456, 451, 451, 451, 451, 451, 
	451, 451, 456, 456, 456, 456, 456, 456, 
	451, 451, 451, 451, 451, 451, 451, 451, 
	451, 451, 451, 451, 451, 451, 451, 451, 
	451, 451, 451, 451, 451, 451, 451, 451, 
	451, 451, 456, 456, 456, 456, 456, 456, 
	451, 451, 451, 451, 451, 451, 451, 451, 
	451, 451, 451, 451, 451, 451, 451, 451, 
	451, 451, 451, 451, 451, 451, 457, 451, 
	450, 452, 456, 456, 456, 452, 456, 456, 
	456, 456, 450, 456, 456, 456, 456, 456, 
	456, 456, 456, 456, 456, 456, 456, 456, 
	456, 456, 456, 452, 456, 456, 456, 456, 
	456, 450, 456, 456, 456, 456, 456, 456, 
	456, 456, 456, 456, 456, 456, 456, 456, 
	456, 456, 456, 456, 456, 456, 456, 456, 
	456, 456, 456, 456, 456, 456, 456, 456, 
	456, 456, 456, 456, 456, 456, 456, 456, 
	456, 456, 456, 456, 456, 456, 456, 456, 
	456, 456, 456, 456, 456, 456, 456, 456, 
	456, 456, 456, 456, 456, 456, 456, 456, 
	456, 456, 456, 456, 456, 456, 456, 456, 
	456, 456, 456, 456, 456, 456, 456, 456, 
	456, 456, 456, 456, 456, 456, 456, 456, 
	456, 456, 456, 456, 456, 456, 450, 456, 
	458, 452, 459, 459, 459, 452, 459, 459, 
	459, 459, 453, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 452, 459, 459, 459, 459, 
	459, 453, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 454, 454, 454, 454, 454, 454, 454, 
	454, 454, 454, 459, 459, 459, 459, 459, 
	459, 459, 454, 454, 454, 454, 454, 454, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 454, 454, 454, 454, 454, 454, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 450, 459, 
	452, 459, 459, 459, 452, 459, 459, 459, 
	459, 450, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 452, 459, 459, 459, 459, 459, 
	450, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	456, 456, 456, 456, 456, 456, 456, 456, 
	456, 456, 459, 459, 459, 459, 459, 459, 
	459, 456, 456, 456, 456, 456, 456, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 456, 456, 456, 456, 456, 456, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 452, 459, 452, 
	459, 459, 459, 452, 459, 459, 459, 459, 
	460, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 452, 459, 459, 459, 459, 459, 460, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 461, 
	461, 461, 461, 461, 461, 461, 461, 461, 
	461, 459, 459, 459, 459, 459, 459, 459, 
	461, 461, 461, 461, 461, 461, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	461, 461, 461, 461, 461, 461, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 462, 459, 452, 459, 
	459, 459, 452, 459, 459, 459, 459, 460, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	452, 459, 459, 459, 459, 459, 460, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 454, 454, 
	454, 454, 454, 454, 454, 454, 454, 454, 
	459, 459, 459, 459, 459, 459, 459, 454, 
	454, 454, 454, 454, 454, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 454, 
	454, 454, 454, 454, 454, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 462, 459, 463, 452, 459, 
	459, 459, 452, 459, 459, 459, 459, 460, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	452, 459, 459, 459, 459, 459, 460, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 464, 464, 
	464, 464, 464, 464, 464, 464, 464, 464, 
	459, 459, 459, 459, 459, 459, 459, 464, 
	464, 464, 464, 464, 464, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 464, 
	464, 464, 464, 464, 464, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 462, 459, 452, 459, 459, 
	459, 452, 459, 459, 459, 459, 460, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 452, 
	459, 459, 459, 459, 459, 460, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 465, 465, 465, 
	465, 465, 465, 465, 465, 465, 465, 459, 
	459, 459, 459, 459, 459, 459, 465, 465, 
	465, 465, 465, 465, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 465, 465, 
	465, 465, 465, 465, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 462, 459, 452, 459, 459, 459, 
	452, 459, 459, 459, 459, 460, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 452, 459, 
	459, 459, 459, 459, 460, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 466, 466, 466, 466, 
	466, 466, 466, 466, 466, 466, 459, 459, 
	459, 459, 459, 459, 459, 466, 466, 466, 
	466, 466, 466, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 466, 466, 466, 
	466, 466, 466, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 462, 459, 452, 459, 459, 459, 452, 
	459, 459, 459, 459, 460, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 452, 459, 459, 
	459, 459, 459, 460, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 467, 467, 467, 467, 467, 
	467, 467, 467, 467, 467, 459, 459, 459, 
	459, 459, 459, 459, 467, 467, 467, 467, 
	467, 467, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 467, 467, 467, 467, 
	467, 467, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	462, 459, 452, 459, 459, 459, 452, 459, 
	459, 459, 459, 460, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 452, 459, 459, 459, 
	459, 459, 460, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 468, 468, 468, 468, 468, 468, 
	468, 468, 468, 468, 459, 459, 459, 459, 
	459, 459, 459, 468, 468, 468, 468, 468, 
	468, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 468, 468, 468, 468, 468, 
	468, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 462, 
	459, 452, 459, 459, 459, 452, 459, 459, 
	459, 459, 450, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 452, 459, 459, 459, 459, 
	459, 450, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 468, 468, 468, 468, 468, 468, 468, 
	468, 468, 468, 459, 459, 459, 459, 459, 
	459, 459, 468, 468, 468, 468, 468, 468, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 468, 468, 468, 468, 468, 468, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 450, 459, 
	469, 470, 472, 472, 472, 472, 472, 472, 
	472, 472, 472, 472, 471, 471, 471, 471, 
	471, 471, 471, 472, 472, 472, 472, 472, 
	472, 471, 471, 471, 471, 471, 471, 471, 
	471, 471, 471, 471, 471, 471, 471, 471, 
	471, 471, 471, 471, 471, 471, 471, 471, 
	471, 471, 471, 472, 472, 472, 472, 472, 
	472, 471, 471, 474, 473, 473, 473, 474, 
	473, 473, 473, 473, 473, 475, 473, 473, 
	473, 473, 473, 473, 473, 473, 473, 473, 
	473, 473, 473, 473, 473, 474, 473, 473, 
	473, 473, 473, 473, 473, 473, 476, 473, 
	473, 473, 473, 473, 473, 473, 473, 473, 
	473, 473, 473, 473, 473, 473, 473, 473, 
	473, 473, 473, 473, 473, 473, 473, 473, 
	473, 473, 473, 473, 473, 473, 473, 473, 
	473, 473, 473, 473, 473, 473, 473, 473, 
	473, 473, 473, 473, 473, 473, 473, 473, 
	473, 473, 473, 473, 473, 473, 473, 477, 
	473, 479, 478, 478, 478, 478, 478, 478, 
	478, 478, 478, 478, 478, 478, 478, 478, 
	478, 478, 478, 478, 478, 478, 478, 478, 
	478, 478, 478, 478, 478, 480, 478, 478, 
	478, 478, 478, 478, 478, 478, 478, 478, 
	478, 478, 478, 478, 478, 478, 478, 478, 
	478, 478, 478, 478, 478, 478, 478, 478, 
	478, 478, 478, 478, 478, 478, 478, 478, 
	478, 478, 478, 478, 478, 478, 478, 478, 
	478, 478, 478, 478, 478, 478, 478, 478, 
	478, 478, 478, 478, 478, 478, 478, 478, 
	481, 478, 482, 482, 482, 482, 482, 482, 
	482, 482, 482, 482, 482, 482, 482, 482, 
	482, 482, 482, 482, 482, 482, 482, 482, 
	482, 482, 482, 482, 482, 482, 482, 482, 
	482, 482, 482, 482, 482, 482, 482, 482, 
	482, 482, 482, 482, 482, 482, 482, 482, 
	482, 482, 48, 48, 48, 48, 48, 48, 
	48, 48, 48, 48, 482, 482, 482, 482, 
	482, 482, 482, 48, 48, 48, 48, 48, 
	48, 48, 48, 48, 48, 48, 48, 48, 
	48, 48, 48, 48, 48, 48, 48, 48, 
	48, 48, 48, 48, 48, 482, 482, 482, 
	482, 48, 482, 48, 48, 48, 48, 48, 
	48, 48, 48, 48, 48, 48, 48, 48, 
	48, 48, 48, 48, 48, 48, 48, 48, 
	48, 48, 48, 48, 48, 482, 482, 482, 
	482, 482, 48, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 482, 483, 483, 
	483, 483, 483, 483, 483, 483, 483, 483, 
	483, 483, 483, 483, 483, 483, 483, 483, 
	483, 483, 483, 483, 483, 483, 483, 483, 
	483, 483, 483, 483, 483, 483, 483, 483, 
	483, 483, 483, 483, 483, 483, 483, 483, 
	483, 483, 483, 483, 483, 483, 48, 48, 
	48, 48, 48, 48, 48, 48, 48, 48, 
	483, 483, 483, 483, 483, 483, 483, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 483, 483, 483, 483, 52, 483, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 483, 483, 483, 483, 483, 52, 486, 
	485, 485, 485, 486, 485, 485, 485, 485, 
	485, 485, 485, 485, 485, 485, 485, 485, 
	485, 485, 485, 485, 485, 485, 485, 485, 
	485, 486, 485, 485, 485, 485, 485, 485, 
	485, 485, 485, 485, 485, 485, 485, 485, 
	485, 485, 485, 485, 485, 485, 485, 487, 
	487, 487, 487, 487, 487, 487, 487, 485, 
	485, 485, 485, 485, 485, 485, 485, 485, 
	485, 485, 488, 485, 485, 485, 485, 485, 
	485, 485, 485, 485, 489, 485, 485, 485, 
	485, 485, 485, 485, 485, 485, 485, 485, 
	485, 485, 485, 485, 485, 485, 485, 485, 
	485, 485, 490, 485, 485, 485, 485, 485, 
	485, 485, 485, 485, 485, 485, 485, 485, 
	485, 485, 485, 485, 491, 485, 485, 492, 
	485, 493, 494, 496, 496, 496, 496, 496, 
	496, 496, 496, 495, 497, 497, 497, 497, 
	497, 497, 497, 497, 495, 495, 498, 498, 
	77, 77, 77, 498, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 498, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 78, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 499, 77, 500, 501, 502, 
	502, 77, 77, 77, 502, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 502, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 78, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 503, 77, 76, 502, 
	504, 505, 506, 506, 62, 62, 62, 506, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 506, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 63, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 507, 
	62, 508, 508, 508, 508, 508, 508, 508, 
	508, 508, 508, 506, 506, 506, 506, 506, 
	506, 506, 508, 508, 508, 508, 508, 508, 
	506, 506, 506, 506, 506, 506, 506, 506, 
	506, 506, 506, 506, 506, 506, 506, 506, 
	506, 506, 506, 506, 506, 506, 506, 506, 
	506, 506, 508, 508, 508, 508, 508, 508, 
	506, 510, 510, 510, 510, 510, 510, 510, 
	510, 510, 510, 509, 509, 509, 509, 509, 
	509, 509, 510, 510, 510, 510, 510, 510, 
	509, 509, 509, 509, 509, 509, 509, 509, 
	509, 509, 509, 509, 509, 509, 509, 509, 
	509, 509, 509, 509, 509, 509, 509, 509, 
	509, 509, 510, 510, 510, 510, 510, 510, 
	509, 509, 511, 511, 511, 511, 511, 511, 
	511, 511, 511, 511, 502, 502, 502, 502, 
	502, 502, 502, 511, 511, 511, 511, 511, 
	511, 502, 502, 502, 502, 502, 502, 502, 
	502, 502, 502, 502, 502, 502, 502, 502, 
	502, 502, 502, 502, 502, 502, 502, 502, 
	502, 502, 502, 511, 511, 511, 511, 511, 
	511, 502, 513, 513, 513, 513, 513, 513, 
	513, 513, 513, 513, 512, 512, 512, 512, 
	512, 512, 512, 513, 513, 513, 513, 513, 
	513, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 513, 513, 513, 513, 513, 
	513, 512, 512, 502, 55, 55, 55, 502, 
	55, 55, 55, 55, 55, 55, 55, 55, 
	55, 55, 55, 55, 55, 55, 55, 55, 
	55, 55, 55, 55, 55, 502, 55, 55, 
	55, 55, 55, 55, 55, 55, 55, 55, 
	55, 55, 55, 55, 55, 55, 55, 55, 
	514, 55, 498, 62, 62, 62, 498, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 498, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 63, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 64, 62, 
	498, 515, 515, 515, 498, 515, 515, 515, 
	515, 515, 515, 515, 515, 515, 515, 515, 
	515, 515, 515, 515, 515, 515, 515, 515, 
	515, 515, 498, 515, 515, 515, 515, 515, 
	515, 515, 515, 515, 515, 515, 515, 515, 
	515, 515, 515, 515, 515, 515, 515, 515, 
	515, 515, 515, 515, 515, 515, 515, 515, 
	515, 515, 515, 515, 515, 515, 515, 515, 
	515, 515, 515, 515, 515, 515, 515, 515, 
	515, 515, 515, 515, 515, 515, 515, 515, 
	515, 515, 515, 515, 515, 515, 515, 515, 
	515, 515, 515, 515, 516, 515, 517, 518, 
	518, 515, 515, 515, 518, 515, 515, 515, 
	515, 515, 515, 515, 515, 515, 515, 515, 
	515, 515, 515, 515, 515, 515, 515, 515, 
	515, 515, 518, 515, 515, 515, 515, 515, 
	515, 515, 515, 515, 515, 515, 515, 515, 
	515, 515, 515, 515, 515, 515, 515, 515, 
	515, 515, 515, 515, 515, 515, 515, 515, 
	515, 515, 515, 515, 515, 515, 515, 515, 
	515, 515, 515, 515, 515, 515, 515, 515, 
	515, 515, 515, 515, 515, 515, 515, 515, 
	515, 515, 515, 515, 515, 515, 515, 515, 
	515, 515, 515, 515, 519, 515, 520, 520, 
	520, 520, 520, 520, 520, 520, 520, 520, 
	518, 518, 518, 518, 518, 518, 518, 520, 
	520, 520, 520, 520, 520, 518, 518, 518, 
	518, 518, 518, 518, 518, 518, 518, 518, 
	518, 518, 518, 518, 518, 518, 518, 518, 
	518, 518, 518, 518, 518, 518, 518, 520, 
	520, 520, 520, 520, 520, 518, 522, 522, 
	522, 522, 522, 522, 522, 522, 522, 522, 
	521, 521, 521, 521, 521, 521, 521, 522, 
	522, 522, 522, 522, 522, 521, 521, 521, 
	521, 521, 521, 521, 521, 521, 521, 521, 
	521, 521, 521, 521, 521, 521, 521, 521, 
	521, 521, 521, 521, 521, 521, 521, 522, 
	522, 522, 522, 522, 522, 521, 521, 518, 
	55, 55, 55, 518, 55, 55, 55, 55, 
	55, 55, 55, 55, 55, 55, 55, 55, 
	55, 55, 55, 55, 55, 55, 55, 55, 
	55, 518, 55, 55, 55, 55, 55, 55, 
	55, 55, 55, 55, 55, 55, 55, 55, 
	55, 55, 55, 55, 514, 55, 523, 518, 
	518, 62, 62, 62, 518, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 518, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 63, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 64, 62, 525, 525, 
	525, 525, 525, 525, 525, 525, 525, 525, 
	524, 524, 524, 524, 524, 524, 524, 525, 
	525, 525, 525, 525, 525, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 525, 
	525, 525, 525, 525, 525, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 526, 524, 527, 527, 527, 527, 527, 
	527, 527, 527, 527, 527, 524, 524, 524, 
	524, 524, 524, 524, 527, 527, 527, 527, 
	527, 527, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 527, 527, 527, 527, 
	527, 527, 524, 528, 528, 528, 528, 528, 
	528, 528, 528, 528, 528, 524, 524, 524, 
	524, 524, 524, 524, 528, 528, 528, 528, 
	528, 528, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 528, 528, 528, 528, 
	528, 528, 524, 529, 529, 529, 529, 529, 
	529, 529, 529, 529, 529, 524, 524, 524, 
	524, 524, 524, 524, 529, 529, 529, 529, 
	529, 529, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 529, 529, 529, 529, 
	529, 529, 524, 530, 533, 532, 532, 532, 
	533, 532, 532, 532, 532, 534, 532, 532, 
	532, 532, 532, 532, 532, 532, 532, 532, 
	532, 532, 532, 532, 532, 532, 533, 532, 
	532, 532, 532, 532, 534, 532, 532, 532, 
	532, 532, 532, 532, 532, 532, 532, 532, 
	532, 532, 532, 532, 535, 535, 535, 535, 
	535, 535, 535, 535, 535, 535, 532, 532, 
	532, 532, 532, 532, 532, 535, 535, 535, 
	535, 535, 535, 532, 532, 532, 532, 532, 
	532, 532, 532, 532, 532, 532, 532, 532, 
	532, 532, 532, 532, 532, 532, 532, 532, 
	532, 532, 532, 532, 532, 535, 535, 535, 
	535, 535, 535, 532, 532, 532, 532, 532, 
	532, 532, 532, 532, 532, 532, 532, 532, 
	532, 532, 532, 532, 532, 532, 532, 532, 
	532, 536, 532, 533, 532, 532, 532, 533, 
	532, 532, 532, 532, 531, 532, 532, 532, 
	532, 532, 532, 532, 532, 532, 532, 532, 
	532, 532, 532, 532, 532, 533, 532, 532, 
	532, 532, 532, 531, 532, 532, 532, 532, 
	532, 532, 532, 532, 532, 532, 532, 532, 
	532, 532, 532, 537, 537, 537, 537, 537, 
	537, 537, 537, 537, 537, 532, 532, 532, 
	532, 532, 532, 532, 537, 537, 537, 537, 
	537, 537, 532, 532, 532, 532, 532, 532, 
	532, 532, 532, 532, 532, 532, 532, 532, 
	532, 532, 532, 532, 532, 532, 532, 532, 
	532, 532, 532, 532, 537, 537, 537, 537, 
	537, 537, 532, 532, 532, 532, 532, 532, 
	532, 532, 532, 532, 532, 532, 532, 532, 
	532, 532, 532, 532, 532, 532, 532, 532, 
	538, 532, 531, 533, 537, 537, 537, 533, 
	537, 537, 537, 537, 531, 537, 537, 537, 
	537, 537, 537, 537, 537, 537, 537, 537, 
	537, 537, 537, 537, 537, 533, 537, 537, 
	537, 537, 537, 531, 537, 537, 537, 537, 
	537, 537, 537, 537, 537, 537, 537, 537, 
	537, 537, 537, 537, 537, 537, 537, 537, 
	537, 537, 537, 537, 537, 537, 537, 537, 
	537, 537, 537, 537, 537, 537, 537, 537, 
	537, 537, 537, 537, 537, 537, 537, 537, 
	537, 537, 537, 537, 537, 537, 537, 537, 
	537, 537, 537, 537, 537, 537, 537, 537, 
	537, 537, 537, 537, 537, 537, 537, 537, 
	537, 537, 537, 537, 537, 537, 537, 537, 
	537, 537, 537, 537, 537, 537, 537, 537, 
	537, 537, 537, 537, 537, 537, 537, 537, 
	531, 537, 539, 533, 540, 540, 540, 533, 
	540, 540, 540, 540, 534, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 533, 540, 540, 
	540, 540, 540, 534, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 535, 535, 535, 535, 535, 
	535, 535, 535, 535, 535, 540, 540, 540, 
	540, 540, 540, 540, 535, 535, 535, 535, 
	535, 535, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 535, 535, 535, 535, 
	535, 535, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	531, 540, 533, 540, 540, 540, 533, 540, 
	540, 540, 540, 531, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 533, 540, 540, 540, 
	540, 540, 531, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 537, 537, 537, 537, 537, 537, 
	537, 537, 537, 537, 540, 540, 540, 540, 
	540, 540, 540, 537, 537, 537, 537, 537, 
	537, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 537, 537, 537, 537, 537, 
	537, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 533, 
	540, 533, 540, 540, 540, 533, 540, 540, 
	540, 540, 541, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 533, 540, 540, 540, 540, 
	540, 541, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 542, 542, 542, 542, 542, 542, 542, 
	542, 542, 542, 540, 540, 540, 540, 540, 
	540, 540, 542, 542, 542, 542, 542, 542, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 542, 542, 542, 542, 542, 542, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 543, 540, 
	533, 540, 540, 540, 533, 540, 540, 540, 
	540, 541, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 533, 540, 540, 540, 540, 540, 
	541, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	535, 535, 535, 535, 535, 535, 535, 535, 
	535, 535, 540, 540, 540, 540, 540, 540, 
	540, 535, 535, 535, 535, 535, 535, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 535, 535, 535, 535, 535, 535, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 543, 540, 544, 
	533, 540, 540, 540, 533, 540, 540, 540, 
	540, 541, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 533, 540, 540, 540, 540, 540, 
	541, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	545, 545, 545, 545, 545, 545, 545, 545, 
	545, 545, 540, 540, 540, 540, 540, 540, 
	540, 545, 545, 545, 545, 545, 545, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 545, 545, 545, 545, 545, 545, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 543, 540, 533, 
	540, 540, 540, 533, 540, 540, 540, 540, 
	541, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 533, 540, 540, 540, 540, 540, 541, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 546, 
	546, 546, 546, 546, 546, 546, 546, 546, 
	546, 540, 540, 540, 540, 540, 540, 540, 
	546, 546, 546, 546, 546, 546, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	546, 546, 546, 546, 546, 546, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 543, 540, 533, 540, 
	540, 540, 533, 540, 540, 540, 540, 541, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	533, 540, 540, 540, 540, 540, 541, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 547, 547, 
	547, 547, 547, 547, 547, 547, 547, 547, 
	540, 540, 540, 540, 540, 540, 540, 547, 
	547, 547, 547, 547, 547, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 547, 
	547, 547, 547, 547, 547, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 543, 540, 533, 540, 540, 
	540, 533, 540, 540, 540, 540, 541, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 533, 
	540, 540, 540, 540, 540, 541, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 540, 
	540, 540, 540, 540, 540, 540, 548, 548, 
	548, 548, 548, 548, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 548, 548, 
	548, 548, 548, 548, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 543, 540, 533, 540, 540, 540, 
	533, 540, 540, 540, 540, 541, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 533, 540, 
	540, 540, 540, 540, 541, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 549, 549, 549, 549, 
	549, 549, 549, 549, 549, 549, 540, 540, 
	540, 540, 540, 540, 540, 549, 549, 549, 
	549, 549, 549, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 549, 549, 549, 
	549, 549, 549, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 543, 540, 533, 540, 540, 540, 533, 
	540, 540, 540, 540, 531, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 533, 540, 540, 
	540, 540, 540, 531, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 549, 549, 549, 549, 549, 
	549, 549, 549, 549, 549, 540, 540, 540, 
	540, 540, 540, 540, 549, 549, 549, 549, 
	549, 549, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 549, 549, 549, 549, 
	549, 549, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	531, 540, 550, 551, 553, 553, 553, 553, 
	553, 553, 553, 553, 553, 553, 552, 552, 
	552, 552, 552, 552, 552, 553, 553, 553, 
	553, 553, 553, 552, 552, 552, 552, 552, 
	552, 552, 552, 552, 552, 552, 552, 552, 
	552, 552, 552, 552, 552, 552, 552, 552, 
	552, 552, 552, 552, 552, 553, 553, 553, 
	553, 553, 553, 552, 552, 555, 554, 554, 
	554, 555, 554, 554, 554, 554, 556, 557, 
	556, 556, 556, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 555, 
	554, 554, 554, 554, 554, 556, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 558, 554, 556, 559, 556, 556, 556, 
	559, 559, 559, 559, 559, 559, 559, 559, 
	559, 559, 559, 559, 559, 559, 559, 559, 
	559, 559, 556, 559, 560, 561, 561, 561, 
	560, 561, 561, 561, 561, 561, 561, 561, 
	561, 561, 561, 561, 561, 561, 561, 561, 
	561, 561, 561, 561, 561, 561, 560, 561, 
	563, 562, 562, 562, 563, 562, 562, 562, 
	562, 562, 564, 562, 562, 562, 562, 562, 
	562, 562, 562, 562, 562, 562, 562, 562, 
	562, 562, 563, 562, 562, 562, 562, 562, 
	562, 562, 562, 562, 562, 562, 562, 562, 
	562, 562, 562, 562, 562, 562, 562, 562, 
	562, 562, 562, 562, 562, 562, 562, 562, 
	562, 562, 562, 562, 562, 562, 562, 562, 
	562, 562, 562, 562, 562, 562, 562, 562, 
	562, 562, 562, 562, 562, 562, 562, 562, 
	562, 562, 562, 562, 562, 562, 562, 562, 
	562, 562, 562, 562, 565, 562, 566, 567, 
	567, 567, 566, 567, 567, 567, 567, 567, 
	568, 567, 567, 567, 567, 567, 567, 567, 
	567, 567, 567, 567, 567, 567, 567, 567, 
	566, 567, 570, 569, 569, 569, 570, 569, 
	569, 569, 569, 569, 571, 569, 569, 569, 
	569, 569, 569, 569, 569, 569, 569, 569, 
	569, 569, 569, 569, 570, 569, 569, 569, 
	569, 569, 569, 569, 569, 572, 569, 574, 
	573, 573, 573, 573, 573, 573, 573, 573, 
	573, 573, 573, 573, 573, 573, 573, 573, 
	573, 573, 573, 573, 573, 573, 573, 573, 
	573, 573, 573, 575, 573, 573, 573, 573, 
	573, 573, 573, 573, 573, 573, 573, 573, 
	573, 573, 573, 573, 573, 573, 573, 573, 
	573, 573, 573, 573, 573, 573, 573, 573, 
	573, 573, 573, 573, 573, 573, 573, 573, 
	573, 573, 573, 573, 573, 573, 573, 573, 
	573, 573, 573, 573, 573, 573, 573, 573, 
	573, 573, 573, 573, 573, 573, 576, 573, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 577, 577, 577, 577, 577, 577, 
	577, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 577, 577, 577, 577, 83, 
	577, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 577, 577, 577, 577, 577, 
	83, 86, 86, 86, 86, 86, 86, 86, 
	86, 86, 86, 577, 578, 578, 578, 578, 
	578, 578, 578, 578, 578, 578, 578, 578, 
	578, 578, 578, 578, 578, 578, 578, 578, 
	578, 578, 578, 578, 578, 578, 578, 578, 
	578, 578, 578, 578, 578, 578, 578, 578, 
	578, 578, 578, 578, 578, 578, 578, 578, 
	578, 578, 578, 578, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 578, 578, 
	578, 578, 578, 578, 578, 87, 87, 87, 
	87, 87, 87, 87, 87, 87, 87, 87, 
	87, 87, 87, 87, 87, 87, 87, 87, 
	87, 87, 87, 87, 87, 87, 87, 578, 
	578, 578, 578, 87, 578, 87, 87, 87, 
	87, 87, 87, 87, 87, 87, 87, 87, 
	87, 87, 87, 87, 87, 87, 87, 87, 
	87, 87, 87, 87, 87, 87, 87, 578, 
	578, 578, 578, 578, 87, 580, 579, 579, 
	579, 580, 579, 579, 579, 579, 579, 581, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 580, 
	579, 583, 582, 582, 582, 583, 582, 582, 
	582, 582, 584, 585, 584, 584, 584, 582, 
	582, 582, 582, 582, 582, 582, 582, 582, 
	582, 582, 582, 583, 582, 582, 582, 582, 
	582, 584, 582, 582, 586, 582, 584, 587, 
	584, 584, 584, 587, 587, 587, 587, 587, 
	587, 587, 587, 587, 587, 587, 587, 587, 
	587, 587, 587, 587, 587, 584, 587, 589, 
	588, 588, 588, 588, 588, 588, 588, 588, 
	588, 588, 588, 588, 588, 588, 588, 588, 
	588, 588, 588, 588, 588, 588, 588, 588, 
	588, 588, 588, 590, 588, 588, 588, 588, 
	588, 588, 588, 588, 588, 588, 588, 588, 
	588, 588, 588, 588, 588, 588, 588, 588, 
	588, 588, 588, 588, 588, 588, 588, 588, 
	588, 588, 588, 588, 588, 588, 588, 588, 
	588, 588, 588, 588, 588, 588, 588, 588, 
	588, 588, 588, 588, 588, 588, 588, 588, 
	588, 588, 588, 588, 588, 588, 591, 588, 
	592, 592, 592, 592, 592, 592, 592, 592, 
	592, 592, 592, 592, 592, 592, 592, 592, 
	592, 592, 592, 592, 592, 592, 592, 592, 
	592, 592, 592, 592, 592, 592, 592, 592, 
	592, 592, 592, 592, 592, 592, 592, 592, 
	592, 592, 592, 592, 592, 592, 592, 592, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 592, 592, 592, 592, 592, 592, 
	592, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 592, 592, 592, 592, 90, 
	592, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 592, 592, 592, 592, 592, 
	90, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 592, 593, 593, 593, 593, 
	593, 593, 593, 593, 593, 593, 593, 593, 
	593, 593, 593, 593, 593, 593, 593, 593, 
	593, 593, 593, 593, 593, 593, 593, 593, 
	593, 593, 593, 593, 593, 593, 593, 593, 
	593, 593, 593, 593, 593, 593, 593, 593, 
	593, 593, 593, 593, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 593, 593, 
	593, 593, 593, 593, 593, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 593, 
	593, 593, 593, 94, 593, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 593, 
	593, 593, 593, 593, 94, 595, 594, 594, 
	594, 595, 594, 594, 594, 594, 596, 597, 
	596, 596, 596, 594, 594, 594, 594, 594, 
	594, 594, 594, 594, 594, 594, 594, 595, 
	594, 594, 594, 594, 594, 596, 594, 596, 
	598, 596, 596, 596, 598, 598, 598, 598, 
	598, 598, 598, 598, 598, 598, 598, 598, 
	598, 598, 598, 598, 598, 598, 596, 598, 
	600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 599, 599, 599, 599, 599, 599, 
	600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 599, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 601, 601, 601, 
	601, 601, 601, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 601, 602, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 603, 98, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 604, 604, 604, 
	604, 604, 604, 604, 96, 96, 96, 96, 
	96, 96, 96, 96, 96, 96, 604, 604, 
	604, 604, 604, 604, 604, 96, 96, 96, 
	96, 96, 96, 96, 96, 96, 96, 96, 
	96, 96, 96, 96, 96, 96, 96, 96, 
	96, 96, 96, 96, 96, 96, 96, 604, 
	604, 604, 604, 96, 604, 96, 96, 96, 
	96, 96, 96, 96, 96, 96, 96, 96, 
	96, 96, 96, 96, 96, 96, 96, 96, 
	96, 96, 96, 96, 96, 96, 96, 604, 
	604, 604, 604, 604, 96, 100, 100, 100, 
	100, 100, 100, 100, 100, 100, 100, 604, 
	605, 605, 605, 605, 605, 605, 605, 605, 
	605, 605, 605, 605, 605, 605, 605, 605, 
	605, 605, 605, 605, 605, 605, 605, 605, 
	605, 605, 605, 605, 605, 605, 605, 605, 
	605, 605, 605, 605, 605, 605, 605, 605, 
	605, 605, 605, 605, 605, 605, 605, 605, 
	101, 101, 101, 101, 101, 101, 101, 101, 
	101, 101, 605, 605, 605, 605, 605, 605, 
	605, 101, 101, 101, 101, 101, 101, 101, 
	101, 101, 101, 101, 101, 101, 101, 101, 
	101, 101, 101, 101, 101, 101, 101, 101, 
	101, 101, 101, 605, 605, 605, 605, 101, 
	605, 101, 101, 101, 101, 101, 101, 101, 
	101, 101, 101, 101, 101, 101, 101, 101, 
	101, 101, 101, 101, 101, 101, 101, 101, 
	101, 101, 101, 605, 605, 605, 605, 605, 
	101, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 606, 606, 606, 606, 606, 
	606, 606, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 606, 606, 606, 606, 
	103, 606, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 606, 606, 606, 606, 
	606, 103, 608, 609, 609, 609, 608, 609, 
	609, 609, 609, 610, 611, 610, 610, 610, 
	609, 609, 609, 609, 609, 609, 609, 609, 
	609, 609, 609, 609, 608, 609, 609, 609, 
	609, 609, 610, 612, 609, 613, 614, 615, 
	616, 609, 609, 609, 617, 618, 609, 618, 
	609, 619, 609, 609, 609, 609, 609, 609, 
	609, 609, 609, 609, 620, 609, 621, 622, 
	623, 609, 609, 624, 625, 624, 624, 626, 
	624, 624, 624, 624, 624, 624, 624, 624, 
	624, 624, 624, 624, 624, 624, 624, 624, 
	624, 624, 624, 624, 624, 627, 628, 609, 
	619, 629, 619, 630, 631, 632, 633, 634, 
	635, 607, 607, 636, 607, 607, 607, 637, 
	638, 639, 607, 607, 640, 641, 642, 643, 
	607, 644, 607, 645, 607, 609, 646, 609, 
	618, 609, 607, 647, 647, 647, 647, 647, 
	647, 647, 647, 647, 647, 647, 647, 647, 
	647, 647, 647, 647, 647, 647, 647, 647, 
	647, 647, 647, 647, 647, 647, 647, 647, 
	647, 647, 647, 647, 648, 647, 647, 647, 
	647, 647, 647, 647, 647, 647, 647, 647, 
	647, 647, 647, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 647, 647, 647, 
	648, 647, 648, 647, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 647, 647, 
	647, 647, 607, 647, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 647, 647, 
	647, 647, 647, 607, 610, 649, 610, 610, 
	610, 649, 649, 649, 649, 649, 649, 649, 
	649, 649, 649, 649, 649, 649, 649, 649, 
	649, 649, 649, 610, 649, 650, 619, 651, 
	651, 619, 651, 651, 651, 651, 651, 651, 
	651, 651, 651, 651, 651, 651, 651, 651, 
	651, 651, 651, 651, 651, 651, 651, 651, 
	651, 651, 651, 651, 651, 651, 651, 651, 
	651, 651, 651, 651, 651, 651, 651, 651, 
	651, 651, 651, 651, 651, 651, 651, 651, 
	651, 651, 651, 651, 651, 651, 651, 651, 
	651, 651, 651, 651, 651, 651, 651, 619, 
	651, 652, 653, 654, 655, 656, 656, 656, 
	656, 656, 656, 656, 656, 656, 656, 656, 
	656, 656, 656, 656, 656, 656, 656, 656, 
	656, 656, 656, 656, 656, 656, 656, 656, 
	656, 656, 656, 656, 656, 656, 105, 105, 
	656, 105, 656, 105, 105, 656, 656, 105, 
	105, 105, 658, 105, 105, 659, 659, 659, 
	659, 659, 659, 659, 659, 659, 659, 105, 
	105, 105, 105, 105, 105, 105, 657, 657, 
	657, 657, 657, 657, 657, 657, 657, 657, 
	657, 657, 657, 657, 657, 657, 657, 657, 
	657, 657, 657, 657, 657, 657, 657, 657, 
	656, 105, 656, 656, 657, 105, 657, 657, 
	657, 657, 657, 657, 657, 657, 657, 657, 
	657, 657, 657, 657, 657, 657, 657, 657, 
	657, 657, 657, 657, 657, 657, 657, 657, 
	656, 656, 656, 105, 656, 657, 660, 660, 
	660, 660, 660, 660, 660, 660, 660, 660, 
	660, 660, 660, 660, 660, 660, 660, 660, 
	660, 660, 660, 660, 660, 660, 660, 660, 
	660, 660, 660, 660, 660, 660, 660, 660, 
	660, 660, 660, 660, 660, 660, 660, 660, 
	660, 660, 660, 660, 660, 660, 657, 657, 
	657, 657, 657, 657, 657, 657, 657, 657, 
	660, 660, 660, 660, 660, 660, 660, 657, 
	657, 657, 657, 657, 657, 657, 657, 657, 
	657, 657, 657, 657, 657, 657, 657, 657, 
	657, 657, 657, 657, 657, 657, 657, 657, 
	657, 660, 660, 660, 660, 657, 660, 657, 
	657, 657, 657, 657, 657, 657, 657, 657, 
	657, 657, 657, 657, 657, 657, 657, 657, 
	657, 657, 657, 657, 657, 657, 657, 657, 
	657, 660, 660, 660, 660, 660, 657, 659, 
	659, 659, 659, 659, 659, 659, 659, 659, 
	659, 660, 661, 651, 619, 651, 619, 651, 
	619, 651, 663, 662, 619, 664, 651, 619, 
	651, 665, 619, 656, 656, 656, 656, 656, 
	656, 656, 656, 656, 656, 656, 656, 656, 
	656, 656, 656, 656, 656, 656, 656, 656, 
	656, 656, 656, 656, 656, 656, 656, 656, 
	656, 656, 656, 656, 656, 656, 656, 656, 
	656, 656, 656, 656, 656, 656, 656, 656, 
	656, 656, 656, 656, 656, 656, 656, 656, 
	656, 656, 656, 656, 656, 656, 656, 656, 
	656, 656, 619, 656, 619, 651, 619, 619, 
	651, 647, 647, 647, 647, 647, 647, 647, 
	647, 647, 647, 647, 647, 647, 647, 647, 
	647, 647, 647, 647, 647, 647, 647, 647, 
	647, 647, 647, 647, 647, 647, 647, 647, 
	647, 647, 648, 647, 647, 647, 647, 647, 
	647, 647, 647, 647, 647, 647, 647, 647, 
	647, 624, 624, 624, 624, 624, 624, 624, 
	624, 624, 624, 647, 647, 647, 648, 647, 
	648, 647, 624, 624, 624, 624, 624, 624, 
	624, 624, 624, 624, 624, 624, 624, 624, 
	624, 624, 624, 624, 624, 624, 624, 624, 
	624, 624, 624, 624, 647, 647, 647, 647, 
	624, 647, 624, 624, 624, 624, 624, 624, 
	624, 624, 624, 624, 624, 624, 624, 624, 
	624, 624, 624, 624, 624, 624, 624, 624, 
	624, 624, 624, 624, 647, 647, 647, 647, 
	647, 624, 666, 666, 666, 666, 666, 666, 
	666, 666, 666, 666, 666, 666, 666, 666, 
	666, 666, 666, 666, 666, 666, 666, 666, 
	666, 666, 666, 666, 666, 666, 666, 666, 
	666, 666, 666, 648, 666, 666, 666, 666, 
	666, 666, 666, 666, 666, 666, 666, 666, 
	666, 666, 624, 624, 624, 624, 624, 624, 
	624, 624, 624, 624, 666, 666, 666, 648, 
	666, 648, 666, 624, 624, 624, 624, 667, 
	624, 624, 624, 624, 624, 624, 624, 624, 
	624, 624, 624, 624, 624, 624, 624, 624, 
	624, 624, 624, 624, 624, 666, 666, 666, 
	666, 624, 666, 624, 624, 624, 624, 624, 
	624, 624, 624, 624, 624, 624, 624, 624, 
	624, 624, 624, 624, 624, 624, 624, 624, 
	624, 624, 624, 624, 624, 666, 666, 666, 
	666, 666, 624, 666, 666, 666, 666, 666, 
	666, 666, 666, 666, 666, 666, 666, 666, 
	666, 666, 666, 666, 666, 666, 666, 666, 
	666, 666, 666, 666, 666, 666, 666, 666, 
	666, 666, 666, 666, 648, 666, 666, 666, 
	666, 666, 666, 666, 666, 666, 666, 666, 
	666, 666, 666, 624, 624, 624, 624, 624, 
	624, 624, 624, 624, 624, 666, 666, 666, 
	648, 666, 648, 666, 624, 624, 624, 624, 
	624, 624, 668, 624, 624, 624, 624, 624, 
	624, 624, 624, 624, 624, 624, 624, 624, 
	624, 624, 624, 624, 624, 624, 666, 666, 
	666, 666, 624, 666, 624, 624, 624, 624, 
	624, 624, 624, 624, 624, 624, 624, 624, 
	624, 624, 624, 624, 624, 624, 624, 624, 
	624, 624, 624, 624, 624, 624, 666, 666, 
	666, 666, 666, 624, 666, 666, 666, 666, 
	666, 666, 666, 666, 666, 666, 666, 666, 
	666, 666, 666, 666, 666, 666, 666, 666, 
	666, 666, 666, 666, 666, 666, 666, 666, 
	666, 666, 666, 666, 666, 648, 666, 666, 
	666, 666, 666, 666, 666, 666, 666, 666, 
	666, 666, 666, 666, 624, 624, 624, 624, 
	624, 624, 624, 624, 624, 624, 666, 666, 
	666, 648, 666, 648, 666, 624, 624, 624, 
	624, 624, 624, 624, 624, 669, 624, 624, 
	624, 624, 624, 624, 624, 624, 624, 624, 
	624, 624, 624, 624, 624, 624, 624, 666, 
	666, 666, 666, 624, 666, 624, 624, 624, 
	624, 624, 624, 624, 624, 624, 624, 624, 
	624, 624, 624, 624, 624, 624, 624, 624, 
	624, 624, 624, 624, 624, 624, 624, 666, 
	666, 666, 666, 666, 624, 666, 666, 666, 
	666, 666, 666, 666, 666, 666, 666, 666, 
	666, 666, 666, 666, 666, 666, 666, 666, 
	666, 666, 666, 666, 666, 666, 666, 666, 
	666, 666, 666, 666, 666, 666, 648, 666, 
	666, 666, 666, 666, 666, 666, 666, 666, 
	666, 666, 666, 666, 666, 624, 624, 624, 
	624, 624, 624, 624, 624, 624, 624, 666, 
	666, 666, 648, 666, 648, 666, 624, 624, 
	624, 624, 624, 624, 624, 624, 624, 624, 
	624, 624, 624, 670, 624, 624, 624, 624, 
	624, 624, 624, 624, 624, 624, 624, 624, 
	666, 666, 666, 666, 624, 666, 624, 624, 
	624, 624, 624, 624, 624, 624, 624, 624, 
	624, 624, 624, 624, 624, 624, 624, 624, 
	624, 624, 624, 624, 624, 624, 624, 624, 
	666, 666, 666, 666, 666, 624, 666, 666, 
	666, 666, 666, 666, 666, 666, 666, 666, 
	666, 666, 666, 666, 666, 666, 666, 666, 
	666, 666, 666, 666, 666, 666, 666, 666, 
	666, 666, 666, 666, 666, 666, 666, 648, 
	666, 666, 666, 666, 666, 666, 666, 666, 
	666, 666, 666, 666, 666, 666, 624, 624, 
	624, 624, 624, 624, 624, 624, 624, 624, 
	666, 666, 666, 648, 666, 648, 666, 624, 
	624, 624, 624, 624, 624, 624, 624, 624, 
	624, 624, 624, 624, 671, 624, 624, 624, 
	624, 624, 624, 624, 624, 624, 624, 624, 
	624, 666, 666, 666, 666, 624, 666, 624, 
	624, 624, 624, 624, 624, 624, 624, 624, 
	624, 624, 624, 624, 624, 624, 624, 624, 
	624, 624, 624, 624, 624, 624, 624, 624, 
	624, 666, 666, 666, 666, 666, 624, 666, 
	666, 666, 666, 666, 666, 666, 666, 666, 
	666, 666, 666, 666, 666, 666, 666, 666, 
	666, 666, 666, 666, 666, 666, 666, 666, 
	666, 666, 666, 666, 666, 666, 666, 666, 
	648, 666, 666, 666, 666, 666, 666, 666, 
	666, 666, 666, 666, 666, 666, 666, 624, 
	624, 624, 624, 624, 624, 624, 624, 624, 
	624, 666, 666, 666, 648, 666, 648, 666, 
	624, 624, 624, 670, 624, 624, 624, 624, 
	624, 624, 624, 624, 624, 624, 624, 624, 
	624, 624, 624, 624, 624, 624, 624, 624, 
	624, 624, 666, 666, 666, 666, 624, 666, 
	624, 624, 624, 624, 624, 624, 624, 624, 
	624, 624, 624, 624, 624, 624, 624, 624, 
	624, 624, 624, 624, 624, 624, 624, 624, 
	624, 624, 666, 666, 666, 666, 666, 624, 
	665, 656, 611, 656, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 648, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 672, 672, 
	672, 648, 672, 648, 672, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 672, 
	672, 672, 672, 673, 672, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 672, 
	672, 672, 672, 672, 607, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 648, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 672, 
	672, 672, 648, 672, 648, 672, 607, 607, 
	607, 607, 674, 675, 607, 607, 607, 607, 
	607, 676, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	672, 672, 672, 672, 607, 672, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	672, 672, 672, 672, 672, 607, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 648, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	672, 672, 672, 648, 672, 648, 672, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 677, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 672, 672, 672, 672, 607, 672, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 672, 672, 672, 672, 672, 607, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	648, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 672, 672, 672, 648, 672, 648, 672, 
	607, 607, 678, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 672, 672, 672, 672, 607, 672, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 672, 672, 672, 672, 672, 607, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 648, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 672, 672, 672, 648, 672, 648, 
	672, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 679, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 672, 672, 672, 672, 607, 
	672, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 672, 672, 672, 672, 672, 
	607, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 648, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 672, 672, 672, 648, 672, 
	648, 672, 607, 607, 607, 680, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 672, 672, 672, 672, 
	607, 672, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 672, 672, 672, 672, 
	672, 607, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 648, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 672, 672, 672, 648, 
	672, 648, 672, 607, 607, 607, 607, 607, 
	607, 607, 607, 681, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 672, 672, 672, 
	672, 607, 672, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 672, 672, 672, 
	672, 672, 607, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 648, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 672, 672, 672, 
	648, 672, 648, 672, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 682, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 672, 672, 
	672, 672, 607, 672, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 672, 672, 
	672, 672, 672, 607, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 648, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 672, 672, 
	672, 648, 672, 648, 672, 607, 607, 607, 
	607, 607, 607, 683, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 672, 
	672, 672, 672, 607, 672, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 672, 
	672, 672, 672, 672, 607, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 648, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 672, 
	672, 672, 648, 672, 648, 672, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	672, 672, 672, 672, 684, 672, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	672, 672, 672, 672, 672, 607, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 648, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	672, 672, 672, 648, 672, 648, 672, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 672, 672, 672, 672, 685, 672, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 672, 672, 672, 672, 672, 607, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	648, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 672, 672, 672, 648, 672, 648, 672, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	686, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 672, 672, 672, 672, 607, 672, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 672, 672, 672, 672, 672, 607, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 648, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 672, 672, 672, 648, 672, 648, 
	672, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 687, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 672, 672, 672, 672, 607, 
	672, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 672, 672, 672, 672, 672, 
	607, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 648, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 672, 672, 672, 648, 672, 
	648, 672, 607, 607, 607, 607, 683, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 672, 672, 672, 672, 
	607, 672, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 672, 672, 672, 672, 
	672, 607, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 648, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 672, 672, 672, 648, 
	672, 648, 672, 607, 607, 607, 607, 607, 
	607, 607, 607, 688, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 672, 672, 672, 
	672, 607, 672, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 672, 672, 672, 
	672, 672, 607, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 648, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 672, 672, 672, 
	648, 672, 648, 672, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 687, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 672, 672, 
	672, 672, 607, 672, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 672, 672, 
	672, 672, 672, 607, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 648, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 672, 672, 
	672, 648, 672, 648, 672, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 672, 
	672, 672, 672, 607, 672, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	689, 607, 690, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 672, 
	672, 672, 672, 672, 607, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 648, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 672, 
	672, 672, 648, 672, 648, 672, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	672, 672, 672, 672, 607, 672, 607, 607, 
	607, 607, 607, 607, 607, 607, 691, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	672, 672, 672, 672, 672, 607, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 648, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	672, 672, 672, 648, 672, 648, 672, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 672, 672, 672, 672, 607, 672, 692, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 672, 672, 672, 672, 672, 607, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	648, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 672, 672, 672, 648, 672, 648, 672, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 672, 672, 672, 672, 607, 672, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 685, 607, 607, 607, 607, 607, 
	607, 607, 672, 672, 672, 672, 672, 607, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 648, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 672, 672, 672, 648, 672, 648, 
	672, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 672, 672, 672, 672, 607, 
	672, 607, 607, 607, 685, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 672, 672, 672, 672, 672, 
	607, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 648, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 672, 672, 672, 648, 672, 
	648, 672, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 672, 672, 672, 672, 
	607, 672, 607, 607, 607, 607, 693, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 694, 607, 607, 607, 607, 
	607, 607, 607, 607, 672, 672, 672, 672, 
	672, 607, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 648, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 672, 672, 672, 648, 
	672, 648, 672, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 672, 672, 672, 
	672, 607, 672, 607, 607, 607, 607, 607, 
	607, 695, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 672, 672, 672, 
	672, 672, 607, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 648, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 672, 672, 672, 
	648, 672, 648, 672, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 672, 672, 
	672, 672, 607, 672, 607, 607, 607, 607, 
	607, 607, 607, 607, 696, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 672, 672, 
	672, 672, 672, 607, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 648, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 672, 672, 
	672, 648, 672, 648, 672, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 672, 
	672, 672, 672, 607, 672, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 685, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 672, 
	672, 672, 672, 672, 607, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 648, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 672, 
	672, 672, 648, 672, 648, 672, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	672, 672, 672, 672, 607, 672, 607, 607, 
	607, 607, 697, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	672, 672, 672, 672, 672, 607, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 648, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	672, 672, 672, 648, 672, 648, 672, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 672, 672, 672, 672, 607, 672, 698, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 672, 672, 672, 672, 672, 607, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	648, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 672, 672, 672, 648, 672, 648, 672, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 672, 672, 672, 672, 607, 672, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 685, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 672, 672, 672, 672, 672, 607, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 648, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 672, 672, 672, 648, 672, 648, 
	672, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 672, 672, 672, 672, 607, 
	672, 699, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 700, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 672, 672, 672, 672, 672, 
	607, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 648, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 672, 672, 672, 648, 672, 
	648, 672, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 672, 672, 672, 672, 
	607, 672, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 701, 607, 607, 607, 
	607, 607, 607, 607, 672, 672, 672, 672, 
	672, 607, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 648, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 672, 672, 672, 648, 
	672, 648, 672, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 672, 672, 672, 
	672, 607, 672, 607, 607, 607, 607, 685, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 672, 672, 672, 
	672, 672, 607, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 648, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 672, 672, 672, 
	648, 672, 648, 672, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 672, 672, 
	672, 672, 607, 672, 702, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 672, 672, 
	672, 672, 672, 607, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 648, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 672, 672, 
	672, 648, 672, 648, 672, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 672, 
	672, 672, 672, 607, 672, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 692, 
	607, 607, 607, 607, 607, 607, 607, 672, 
	672, 672, 672, 672, 607, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 648, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 672, 
	672, 672, 648, 672, 648, 672, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	672, 672, 672, 672, 607, 672, 607, 607, 
	607, 607, 703, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 685, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	672, 672, 672, 672, 672, 607, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 648, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	672, 672, 672, 648, 672, 648, 672, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 672, 672, 672, 672, 607, 672, 607, 
	607, 607, 607, 607, 704, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 672, 672, 672, 672, 672, 607, 705, 
	705, 705, 705, 705, 705, 705, 705, 705, 
	705, 705, 705, 705, 705, 705, 705, 705, 
	705, 705, 705, 705, 705, 705, 705, 705, 
	705, 705, 705, 705, 705, 705, 705, 705, 
	648, 705, 705, 705, 705, 705, 705, 705, 
	705, 705, 705, 705, 705, 705, 705, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 705, 705, 705, 648, 705, 648, 705, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 705, 705, 705, 705, 607, 705, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	706, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 705, 705, 705, 705, 705, 607, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 648, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 672, 672, 672, 648, 672, 648, 
	672, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 672, 672, 672, 672, 607, 
	672, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 707, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 672, 672, 672, 672, 672, 
	607, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 648, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 672, 672, 672, 648, 672, 
	648, 672, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 672, 672, 672, 672, 
	607, 672, 607, 607, 607, 607, 708, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 672, 672, 672, 672, 
	672, 607, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 648, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 672, 672, 672, 648, 
	672, 648, 672, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 672, 672, 672, 
	672, 607, 672, 607, 607, 607, 709, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 672, 672, 672, 
	672, 672, 607, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 648, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 672, 672, 672, 
	648, 672, 710, 672, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 672, 672, 
	672, 672, 607, 672, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 672, 672, 
	672, 672, 672, 607, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 648, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 672, 672, 
	672, 648, 672, 648, 672, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 672, 
	672, 672, 672, 607, 672, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	711, 607, 712, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 672, 
	672, 672, 672, 672, 607, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 648, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 672, 
	672, 672, 648, 672, 648, 672, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	672, 672, 672, 672, 607, 672, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	713, 607, 607, 607, 607, 607, 607, 607, 
	672, 672, 672, 672, 672, 607, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 648, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	672, 672, 672, 648, 672, 648, 672, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 672, 672, 672, 672, 607, 672, 607, 
	607, 607, 607, 685, 607, 607, 607, 714, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 672, 672, 672, 672, 672, 607, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	648, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 672, 672, 672, 648, 672, 648, 672, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 672, 672, 672, 672, 607, 672, 
	607, 607, 607, 607, 607, 685, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 672, 672, 672, 672, 672, 607, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 648, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 672, 672, 672, 648, 672, 648, 
	672, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 672, 672, 672, 672, 607, 
	672, 607, 607, 607, 685, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 715, 607, 607, 607, 607, 
	607, 607, 607, 672, 672, 672, 672, 672, 
	607, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 648, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 672, 672, 672, 648, 672, 
	648, 672, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 672, 672, 672, 672, 
	607, 672, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 716, 607, 
	607, 607, 607, 607, 672, 672, 672, 672, 
	672, 607, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 648, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 672, 672, 672, 648, 
	672, 648, 672, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 672, 672, 672, 
	672, 607, 672, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 701, 607, 607, 607, 
	607, 607, 607, 607, 607, 672, 672, 672, 
	672, 672, 607, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 648, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 672, 672, 672, 
	648, 672, 648, 672, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 672, 672, 
	672, 672, 607, 672, 717, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 639, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 672, 672, 
	672, 672, 672, 607, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 648, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 672, 672, 
	672, 648, 672, 648, 672, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 672, 
	672, 672, 672, 607, 672, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	699, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 672, 
	672, 672, 672, 672, 607, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 648, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 672, 
	672, 672, 648, 672, 648, 672, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	672, 672, 672, 672, 607, 672, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 685, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	672, 672, 672, 672, 672, 607, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 648, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	672, 672, 672, 648, 672, 648, 672, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 672, 672, 672, 672, 607, 672, 607, 
	607, 607, 607, 607, 685, 607, 607, 607, 
	607, 607, 607, 607, 685, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 672, 672, 672, 672, 672, 607, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	648, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 672, 672, 672, 648, 672, 648, 672, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 672, 672, 672, 672, 607, 672, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 718, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 672, 672, 672, 672, 672, 607, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 648, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 672, 672, 672, 648, 672, 648, 
	672, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 672, 672, 672, 672, 607, 
	672, 607, 607, 607, 719, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 672, 672, 672, 672, 672, 
	607, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 648, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 672, 672, 672, 648, 672, 
	648, 672, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 672, 672, 672, 672, 
	607, 672, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 720, 607, 
	607, 607, 607, 607, 672, 672, 672, 672, 
	672, 607, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 648, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 672, 672, 672, 648, 
	672, 648, 672, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 672, 672, 672, 
	672, 607, 672, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 701, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 672, 672, 672, 
	672, 672, 607, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 648, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 672, 672, 672, 
	648, 672, 648, 672, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 672, 672, 
	672, 672, 607, 672, 607, 607, 607, 607, 
	721, 607, 607, 607, 722, 607, 607, 607, 
	607, 607, 723, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 672, 672, 
	672, 672, 672, 607, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 648, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 672, 672, 
	672, 648, 672, 648, 672, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 672, 
	672, 672, 672, 607, 672, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 723, 607, 607, 672, 
	672, 672, 672, 672, 607, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 648, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 672, 
	672, 672, 648, 672, 648, 672, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	672, 672, 672, 672, 607, 672, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 685, 607, 607, 607, 607, 607, 607, 
	672, 672, 672, 672, 672, 607, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 648, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	672, 672, 672, 648, 672, 648, 672, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 672, 672, 672, 672, 607, 672, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 685, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 672, 672, 672, 672, 672, 607, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	648, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 672, 672, 672, 648, 672, 648, 672, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 672, 672, 672, 672, 607, 672, 
	607, 607, 607, 607, 724, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 672, 672, 672, 672, 672, 607, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 648, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 672, 672, 672, 648, 672, 648, 
	672, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 672, 672, 672, 672, 607, 
	672, 607, 607, 607, 725, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 726, 727, 607, 607, 607, 
	607, 607, 607, 672, 672, 672, 672, 672, 
	607, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 648, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 672, 672, 672, 648, 672, 
	648, 672, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 672, 672, 672, 672, 
	607, 672, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	685, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 672, 672, 672, 672, 
	672, 607, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 648, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 672, 672, 672, 648, 
	672, 648, 672, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 672, 672, 672, 
	672, 607, 672, 607, 607, 728, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 672, 672, 672, 
	672, 672, 607, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 648, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 672, 672, 672, 
	648, 672, 648, 672, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 672, 672, 
	672, 672, 607, 672, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	701, 607, 607, 607, 607, 607, 672, 672, 
	672, 672, 672, 607, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 648, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 672, 672, 
	672, 648, 672, 648, 672, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 672, 
	672, 672, 672, 607, 672, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 729, 607, 
	607, 730, 607, 607, 607, 607, 607, 672, 
	672, 672, 672, 672, 607, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 648, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 672, 
	672, 672, 648, 672, 648, 672, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	672, 672, 672, 672, 607, 672, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 685, 607, 
	672, 672, 672, 672, 672, 607, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 648, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	672, 672, 672, 648, 672, 648, 672, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 672, 672, 672, 672, 607, 672, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	696, 607, 607, 607, 607, 607, 607, 607, 
	607, 672, 672, 672, 672, 672, 607, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	648, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 672, 672, 672, 648, 672, 648, 672, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 672, 672, 672, 672, 607, 672, 
	607, 607, 607, 607, 731, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 732, 607, 607, 607, 
	607, 607, 672, 672, 672, 672, 672, 607, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 648, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 672, 672, 672, 648, 672, 648, 
	672, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 672, 672, 672, 672, 607, 
	672, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 714, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 672, 672, 672, 672, 672, 
	607, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 648, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 672, 672, 672, 648, 672, 
	648, 672, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 672, 672, 672, 672, 
	607, 672, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 733, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 672, 672, 672, 672, 
	672, 607, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 648, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 672, 672, 672, 648, 
	672, 648, 672, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 672, 672, 672, 
	672, 607, 672, 607, 607, 607, 607, 639, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 672, 672, 672, 
	672, 672, 607, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 648, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 672, 672, 672, 
	648, 672, 648, 672, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 672, 672, 
	672, 672, 607, 672, 607, 607, 607, 607, 
	607, 607, 607, 734, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 728, 607, 607, 
	607, 607, 607, 607, 607, 607, 672, 672, 
	672, 672, 672, 607, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 648, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 672, 672, 
	672, 648, 672, 648, 672, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 672, 
	672, 672, 672, 607, 672, 607, 607, 607, 
	607, 696, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 672, 
	672, 672, 672, 672, 607, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 648, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 672, 
	672, 672, 648, 672, 648, 672, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	672, 672, 672, 672, 607, 672, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 735, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	672, 672, 672, 672, 672, 607, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 648, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	672, 672, 672, 648, 672, 648, 672, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 672, 672, 672, 672, 607, 672, 607, 
	607, 607, 736, 607, 607, 607, 607, 607, 
	607, 607, 737, 607, 607, 607, 607, 607, 
	607, 607, 738, 607, 607, 607, 607, 607, 
	607, 672, 672, 672, 672, 672, 607, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	648, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 672, 672, 672, 648, 672, 648, 672, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 672, 672, 672, 672, 607, 672, 
	607, 607, 607, 607, 714, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 672, 672, 672, 672, 672, 607, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 648, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 672, 672, 672, 648, 672, 648, 
	672, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 672, 672, 672, 672, 607, 
	672, 607, 607, 607, 607, 702, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 672, 672, 672, 672, 672, 
	607, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 648, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 672, 672, 672, 648, 672, 
	648, 672, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 672, 672, 672, 672, 
	607, 672, 607, 607, 607, 607, 607, 607, 
	607, 607, 722, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 672, 672, 672, 672, 
	672, 607, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 648, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 672, 672, 672, 648, 
	672, 648, 672, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 672, 672, 672, 
	672, 607, 672, 607, 607, 607, 607, 607, 
	607, 607, 739, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 672, 672, 672, 
	672, 672, 607, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 648, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 672, 672, 672, 
	648, 672, 648, 672, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 672, 672, 
	672, 672, 607, 672, 607, 607, 607, 607, 
	696, 607, 607, 607, 720, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 672, 672, 
	672, 672, 672, 607, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 648, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 672, 672, 
	672, 648, 672, 648, 672, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 672, 
	672, 672, 672, 607, 672, 607, 607, 607, 
	607, 607, 607, 607, 607, 740, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 672, 
	672, 672, 672, 672, 607, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 648, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 672, 
	672, 672, 648, 672, 648, 672, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	672, 672, 672, 672, 607, 672, 607, 607, 
	607, 607, 741, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	672, 672, 672, 672, 672, 607, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 648, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	672, 672, 672, 648, 672, 648, 672, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 672, 672, 672, 672, 607, 672, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 690, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 672, 672, 672, 672, 672, 607, 619, 
	651, 743, 744, 744, 744, 743, 744, 744, 
	744, 744, 745, 744, 745, 745, 745, 744, 
	744, 744, 744, 744, 744, 744, 744, 744, 
	744, 744, 744, 743, 744, 744, 744, 744, 
	744, 745, 744, 744, 746, 744, 744, 744, 
	744, 744, 744, 744, 744, 744, 744, 747, 
	744, 744, 744, 744, 744, 744, 744, 744, 
	744, 744, 744, 744, 744, 744, 744, 744, 
	744, 744, 742, 742, 742, 742, 742, 742, 
	742, 742, 742, 742, 742, 742, 742, 742, 
	742, 742, 742, 742, 742, 742, 742, 742, 
	742, 742, 742, 742, 744, 748, 744, 744, 
	742, 744, 742, 742, 742, 742, 742, 742, 
	742, 742, 742, 742, 742, 742, 742, 742, 
	742, 742, 742, 742, 742, 742, 742, 742, 
	742, 742, 742, 742, 744, 744, 744, 744, 
	744, 742, 749, 749, 749, 749, 749, 749, 
	749, 749, 749, 749, 749, 749, 749, 749, 
	749, 749, 749, 749, 749, 749, 749, 749, 
	749, 749, 749, 749, 749, 749, 749, 749, 
	749, 749, 749, 110, 749, 749, 749, 749, 
	749, 749, 749, 749, 749, 749, 749, 749, 
	749, 749, 109, 109, 109, 109, 109, 109, 
	109, 109, 109, 109, 111, 749, 749, 749, 
	749, 110, 749, 109, 109, 109, 109, 109, 
	109, 109, 109, 109, 109, 109, 109, 109, 
	109, 109, 109, 109, 109, 109, 109, 109, 
	109, 109, 109, 109, 109, 749, 749, 749, 
	749, 109, 749, 109, 109, 109, 109, 109, 
	109, 109, 109, 109, 109, 109, 109, 109, 
	109, 109, 109, 109, 109, 109, 109, 109, 
	109, 109, 109, 109, 109, 749, 749, 749, 
	749, 749, 109, 745, 750, 745, 745, 745, 
	750, 750, 750, 750, 750, 750, 750, 750, 
	750, 750, 750, 750, 750, 750, 750, 750, 
	750, 750, 745, 750, 751, 752, 753, 754, 
	755, 749, 756, 749, 757, 759, 760, 760, 
	760, 759, 760, 760, 760, 760, 761, 762, 
	761, 761, 761, 760, 760, 760, 760, 760, 
	760, 760, 760, 760, 760, 760, 760, 759, 
	760, 760, 760, 760, 760, 761, 763, 760, 
	764, 760, 765, 766, 760, 760, 760, 767, 
	768, 760, 768, 760, 765, 760, 760, 760, 
	760, 760, 760, 760, 760, 760, 760, 760, 
	760, 769, 770, 771, 760, 760, 772, 772, 
	772, 772, 772, 772, 772, 772, 772, 772, 
	772, 772, 772, 772, 772, 772, 772, 772, 
	772, 772, 772, 772, 772, 772, 772, 772, 
	773, 774, 760, 765, 758, 765, 758, 758, 
	758, 758, 758, 758, 758, 758, 758, 758, 
	758, 758, 758, 758, 758, 758, 758, 758, 
	758, 758, 758, 758, 758, 758, 758, 758, 
	760, 775, 760, 768, 760, 758, 776, 776, 
	776, 776, 776, 776, 776, 776, 776, 776, 
	776, 776, 776, 776, 776, 776, 776, 776, 
	776, 776, 776, 776, 776, 776, 776, 776, 
	776, 776, 776, 776, 776, 776, 776, 777, 
	776, 776, 776, 776, 776, 776, 776, 776, 
	776, 776, 776, 776, 776, 776, 758, 758, 
	758, 758, 758, 758, 758, 758, 758, 758, 
	776, 776, 776, 776, 776, 777, 776, 758, 
	758, 758, 758, 758, 758, 758, 758, 758, 
	758, 758, 758, 758, 758, 758, 758, 758, 
	758, 758, 758, 758, 758, 758, 758, 758, 
	758, 776, 776, 776, 776, 758, 776, 758, 
	758, 758, 758, 758, 758, 758, 758, 758, 
	758, 758, 758, 758, 758, 758, 758, 758, 
	758, 758, 758, 758, 758, 758, 758, 758, 
	758, 776, 776, 776, 776, 776, 758, 779, 
	778, 780, 761, 781, 761, 761, 761, 781, 
	781, 781, 781, 781, 781, 781, 781, 781, 
	781, 781, 781, 781, 781, 781, 781, 781, 
	781, 761, 781, 782, 765, 783, 783, 765, 
	783, 783, 783, 783, 783, 783, 783, 783, 
	783, 783, 783, 783, 783, 783, 783, 783, 
	783, 783, 783, 783, 783, 783, 783, 783, 
	783, 783, 783, 783, 783, 783, 783, 783, 
	783, 783, 783, 783, 783, 783, 783, 783, 
	783, 783, 783, 783, 783, 783, 783, 783, 
	783, 783, 783, 783, 783, 783, 783, 783, 
	783, 783, 783, 783, 783, 765, 783, 784, 
	785, 786, 787, 765, 783, 765, 783, 765, 
	783, 765, 788, 783, 765, 783, 790, 765, 
	789, 789, 789, 789, 789, 789, 789, 789, 
	789, 789, 789, 789, 789, 789, 789, 789, 
	789, 789, 789, 789, 789, 789, 789, 789, 
	789, 789, 789, 789, 789, 789, 789, 789, 
	789, 789, 789, 789, 789, 789, 789, 789, 
	789, 789, 789, 789, 789, 789, 789, 789, 
	789, 789, 789, 789, 789, 789, 789, 789, 
	789, 789, 789, 789, 789, 789, 789, 765, 
	789, 765, 783, 765, 765, 783, 791, 791, 
	791, 791, 791, 791, 791, 791, 791, 791, 
	791, 791, 791, 791, 791, 791, 791, 791, 
	791, 791, 791, 791, 791, 791, 791, 791, 
	791, 791, 791, 791, 791, 791, 791, 777, 
	791, 791, 791, 791, 791, 791, 791, 791, 
	791, 791, 791, 791, 791, 791, 772, 772, 
	772, 772, 772, 772, 772, 772, 772, 772, 
	791, 791, 791, 791, 791, 777, 791, 772, 
	772, 772, 772, 772, 772, 772, 772, 772, 
	772, 772, 772, 772, 772, 772, 772, 772, 
	772, 772, 772, 772, 772, 772, 772, 772, 
	772, 791, 791, 791, 791, 772, 791, 772, 
	772, 772, 772, 772, 772, 772, 772, 772, 
	772, 772, 772, 772, 772, 772, 772, 772, 
	772, 772, 772, 772, 772, 772, 772, 772, 
	772, 791, 791, 791, 791, 791, 772, 790, 
	789, 762, 789, 765, 783, 793, 792, 792, 
	792, 793, 792, 792, 792, 792, 794, 795, 
	794, 794, 794, 792, 792, 792, 792, 792, 
	792, 792, 792, 792, 792, 792, 792, 793, 
	792, 792, 792, 792, 792, 794, 792, 792, 
	796, 792, 121, 797, 792, 798, 792, 799, 
	121, 152, 800, 154, 121, 792, 792, 792, 
	792, 792, 792, 792, 792, 792, 792, 801, 
	792, 802, 152, 803, 804, 792, 792, 792, 
	792, 792, 792, 792, 792, 792, 792, 792, 
	792, 792, 792, 792, 792, 792, 792, 792, 
	792, 792, 792, 792, 792, 792, 792, 792, 
	152, 805, 152, 121, 792, 792, 792, 792, 
	792, 792, 792, 792, 792, 792, 806, 792, 
	792, 792, 792, 792, 792, 792, 792, 807, 
	792, 792, 808, 792, 809, 792, 792, 792, 
	165, 166, 792, 121, 792, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 794, 810, 
	794, 794, 794, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 794, 810, 810, 
	810, 810, 147, 148, 810, 149, 810, 150, 
	151, 152, 153, 154, 147, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 155, 
	810, 156, 152, 157, 158, 810, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	159, 160, 152, 121, 116, 810, 116, 116, 
	116, 116, 116, 116, 116, 116, 161, 116, 
	116, 116, 116, 116, 116, 116, 116, 162, 
	116, 116, 163, 116, 164, 116, 116, 116, 
	165, 166, 810, 121, 810, 116, 811, 812, 
	812, 812, 811, 812, 812, 812, 812, 152, 
	813, 152, 152, 152, 812, 812, 812, 812, 
	812, 812, 812, 812, 812, 812, 812, 812, 
	811, 812, 812, 812, 812, 812, 152, 812, 
	812, 812, 812, 812, 812, 812, 812, 812, 
	812, 812, 812, 812, 812, 812, 812, 812, 
	812, 812, 812, 812, 812, 812, 812, 812, 
	812, 812, 812, 152, 812, 152, 813, 152, 
	152, 152, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 152, 115, 115, 115, 
	115, 115, 121, 115, 115, 115, 115, 115, 
	115, 115, 152, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 152, 115, 152, 813, 152, 152, 152, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 152, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 152, 
	115, 814, 152, 813, 152, 152, 152, 815, 
	815, 815, 815, 815, 815, 815, 815, 815, 
	815, 815, 815, 815, 815, 815, 815, 815, 
	815, 152, 815, 815, 815, 815, 815, 815, 
	815, 815, 815, 816, 815, 815, 815, 815, 
	815, 815, 815, 815, 815, 815, 815, 815, 
	815, 815, 815, 815, 815, 815, 152, 815, 
	152, 813, 152, 152, 152, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 152, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 152, 152, 115, 817, 
	811, 152, 811, 819, 818, 821, 822, 821, 
	821, 821, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 821, 820, 823, 811, 
	811, 811, 811, 811, 811, 811, 811, 811, 
	811, 811, 811, 811, 811, 811, 811, 811, 
	811, 811, 811, 811, 811, 811, 811, 811, 
	811, 811, 811, 811, 811, 811, 811, 811, 
	117, 811, 811, 811, 811, 811, 811, 811, 
	811, 811, 811, 811, 811, 811, 811, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 118, 811, 811, 811, 811, 117, 811, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 811, 811, 811, 811, 116, 811, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 811, 811, 811, 811, 811, 116, 
	824, 152, 813, 152, 152, 152, 811, 811, 
	811, 811, 811, 811, 811, 811, 811, 811, 
	811, 811, 811, 811, 811, 811, 811, 811, 
	152, 811, 811, 811, 811, 811, 811, 811, 
	811, 811, 811, 811, 811, 811, 811, 811, 
	811, 811, 811, 811, 811, 811, 811, 811, 
	811, 811, 811, 811, 811, 152, 811, 811, 
	811, 811, 811, 811, 811, 811, 811, 811, 
	811, 811, 811, 811, 811, 811, 811, 811, 
	811, 811, 811, 811, 811, 811, 811, 811, 
	811, 811, 811, 811, 811, 811, 811, 811, 
	811, 811, 811, 811, 811, 811, 811, 811, 
	811, 811, 811, 811, 811, 811, 811, 811, 
	811, 811, 811, 811, 811, 811, 811, 811, 
	811, 811, 811, 811, 121, 811, 825, 826, 
	827, 828, 829, 830, 152, 813, 152, 152, 
	152, 811, 811, 811, 811, 811, 811, 811, 
	811, 811, 811, 811, 811, 811, 811, 811, 
	811, 811, 811, 152, 811, 811, 811, 811, 
	811, 811, 811, 811, 811, 121, 811, 811, 
	811, 811, 811, 811, 811, 811, 811, 811, 
	811, 811, 811, 811, 811, 811, 811, 811, 
	152, 811, 152, 818, 121, 831, 121, 831, 
	832, 833, 832, 832, 832, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 832, 
	820, 834, 831, 835, 835, 835, 835, 835, 
	835, 835, 835, 835, 124, 835, 124, 124, 
	124, 835, 835, 835, 835, 835, 835, 835, 
	835, 835, 835, 835, 835, 835, 835, 835, 
	835, 835, 835, 124, 835, 835, 835, 835, 
	125, 126, 835, 127, 835, 128, 129, 130, 
	131, 132, 125, 835, 835, 835, 835, 835, 
	835, 835, 835, 835, 835, 133, 835, 134, 
	130, 135, 136, 835, 123, 123, 123, 123, 
	123, 123, 123, 123, 123, 123, 123, 123, 
	123, 123, 123, 123, 123, 123, 123, 123, 
	123, 123, 123, 123, 123, 123, 137, 138, 
	130, 139, 123, 835, 123, 123, 123, 123, 
	123, 123, 123, 123, 140, 123, 123, 123, 
	123, 123, 123, 123, 123, 141, 123, 123, 
	142, 123, 143, 123, 123, 123, 144, 145, 
	835, 139, 835, 123, 152, 831, 836, 831, 
	837, 831, 838, 831, 839, 191, 191, 191, 
	839, 191, 191, 191, 191, 840, 191, 840, 
	840, 840, 191, 191, 191, 191, 191, 191, 
	191, 191, 191, 191, 191, 191, 839, 191, 
	191, 191, 191, 191, 840, 191, 191, 191, 
	191, 191, 191, 191, 191, 191, 191, 191, 
	191, 191, 191, 191, 191, 191, 191, 191, 
	191, 191, 191, 191, 191, 191, 191, 191, 
	191, 191, 191, 191, 191, 193, 193, 193, 
	193, 193, 193, 193, 193, 193, 193, 193, 
	193, 193, 193, 193, 193, 193, 193, 193, 
	193, 193, 193, 193, 193, 193, 193, 191, 
	841, 191, 191, 193, 191, 193, 193, 193, 
	197, 193, 193, 193, 193, 193, 193, 193, 
	193, 193, 193, 193, 193, 193, 193, 193, 
	193, 193, 193, 193, 193, 193, 193, 191, 
	191, 191, 191, 191, 193, 190, 190, 190, 
	190, 190, 190, 190, 190, 190, 190, 190, 
	190, 190, 190, 190, 190, 190, 190, 190, 
	190, 190, 190, 190, 190, 190, 190, 190, 
	190, 190, 190, 190, 190, 190, 842, 190, 
	190, 190, 190, 190, 190, 190, 190, 190, 
	190, 190, 190, 190, 190, 193, 193, 193, 
	193, 193, 193, 193, 193, 193, 193, 191, 
	190, 190, 190, 190, 842, 190, 193, 193, 
	193, 193, 193, 193, 193, 193, 193, 193, 
	193, 193, 193, 193, 193, 193, 193, 193, 
	193, 193, 193, 193, 193, 193, 193, 193, 
	190, 190, 190, 190, 193, 190, 193, 193, 
	193, 193, 193, 193, 193, 193, 193, 193, 
	193, 193, 193, 193, 193, 193, 193, 193, 
	193, 193, 193, 193, 193, 193, 193, 193, 
	190, 190, 190, 190, 190, 193, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 194, 
	843, 194, 194, 194, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 194, 843, 
	843, 843, 843, 843, 843, 843, 195, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 193, 
	193, 193, 193, 193, 193, 193, 193, 193, 
	193, 193, 193, 193, 193, 193, 193, 193, 
	193, 193, 193, 193, 193, 193, 193, 193, 
	193, 843, 196, 843, 843, 193, 843, 193, 
	193, 193, 197, 193, 193, 193, 193, 193, 
	193, 193, 193, 193, 193, 193, 193, 193, 
	193, 193, 193, 193, 193, 193, 193, 193, 
	193, 843, 843, 843, 843, 843, 193, 844, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 842, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	193, 193, 193, 193, 193, 193, 193, 193, 
	193, 193, 191, 843, 843, 843, 843, 842, 
	843, 193, 193, 193, 193, 193, 193, 193, 
	193, 193, 193, 193, 193, 193, 193, 193, 
	193, 193, 193, 193, 193, 193, 193, 193, 
	193, 193, 193, 843, 843, 843, 843, 193, 
	843, 193, 193, 193, 193, 193, 193, 193, 
	193, 193, 193, 193, 193, 193, 193, 845, 
	193, 193, 193, 193, 193, 193, 193, 193, 
	193, 193, 193, 843, 843, 843, 843, 843, 
	193, 198, 843, 847, 846, 846, 846, 847, 
	846, 846, 846, 846, 848, 846, 848, 848, 
	848, 846, 846, 846, 846, 846, 846, 846, 
	846, 846, 846, 846, 846, 847, 846, 846, 
	846, 846, 846, 848, 846, 846, 849, 846, 
	846, 846, 846, 846, 846, 846, 846, 846, 
	846, 846, 846, 846, 846, 846, 846, 846, 
	846, 846, 846, 846, 846, 846, 846, 846, 
	846, 846, 846, 846, 846, 846, 846, 846, 
	846, 846, 846, 846, 846, 846, 846, 846, 
	846, 846, 846, 846, 846, 846, 846, 846, 
	846, 846, 846, 846, 846, 846, 846, 850, 
	846, 846, 846, 846, 846, 846, 846, 851, 
	846, 846, 846, 846, 846, 846, 846, 846, 
	846, 846, 846, 846, 846, 846, 846, 846, 
	846, 846, 846, 846, 846, 846, 852, 846, 
	848, 853, 848, 848, 848, 853, 853, 853, 
	853, 853, 853, 853, 853, 853, 853, 853, 
	853, 853, 853, 853, 853, 853, 853, 848, 
	853, 854, 855, 856, 857, 859, 858, 860, 
	861, 858, 862, 864, 865, 865, 865, 864, 
	865, 865, 865, 865, 866, 867, 866, 866, 
	866, 865, 865, 865, 865, 865, 865, 865, 
	865, 865, 865, 865, 865, 864, 865, 865, 
	865, 865, 865, 866, 865, 865, 868, 865, 
	865, 865, 865, 865, 865, 865, 865, 865, 
	865, 865, 865, 865, 865, 865, 865, 865, 
	865, 865, 865, 865, 865, 865, 865, 865, 
	865, 865, 865, 865, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 865, 869, 
	865, 865, 863, 865, 863, 863, 863, 863, 
	863, 863, 863, 863, 870, 863, 863, 863, 
	863, 863, 863, 863, 863, 871, 863, 863, 
	872, 863, 873, 863, 863, 863, 865, 865, 
	865, 865, 865, 863, 874, 874, 874, 874, 
	874, 874, 874, 874, 874, 874, 874, 874, 
	874, 874, 874, 874, 874, 874, 874, 874, 
	874, 874, 874, 874, 874, 874, 874, 874, 
	874, 874, 874, 874, 874, 874, 874, 874, 
	874, 874, 874, 874, 874, 874, 874, 874, 
	874, 874, 874, 874, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 874, 874, 
	874, 874, 874, 874, 874, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 874, 
	874, 874, 874, 863, 874, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 874, 
	874, 874, 874, 874, 863, 866, 875, 866, 
	866, 866, 875, 875, 875, 875, 875, 875, 
	875, 875, 875, 875, 875, 875, 875, 875, 
	875, 875, 875, 875, 866, 875, 876, 877, 
	878, 879, 880, 882, 881, 883, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	884, 884, 884, 884, 884, 884, 884, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 884, 884, 884, 884, 863, 884, 863, 
	863, 863, 863, 863, 885, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 884, 884, 884, 884, 884, 863, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 884, 884, 884, 884, 884, 884, 884, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 884, 884, 884, 884, 863, 884, 
	863, 863, 863, 863, 886, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 884, 884, 884, 884, 884, 863, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 884, 884, 884, 884, 884, 884, 
	884, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 863, 884, 884, 884, 884, 863, 
	884, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 863, 887, 863, 863, 863, 863, 
	863, 863, 863, 884, 884, 884, 884, 884, 
	863, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 863, 884, 884, 884, 884, 884, 
	884, 884, 863, 863, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 863, 863, 884, 884, 884, 884, 
	863, 884, 863, 863, 888, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 863, 863, 884, 884, 884, 884, 
	884, 863, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 863, 863, 863, 863, 863, 863, 
	863, 863, 863, 863, 884, 884, 884, 884, 
	884, 884, 884, 863, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 884, 884, 884, 
	884, 863, 884, 863, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 889, 
	863, 863, 863, 863, 863, 884, 884, 884, 
	884, 884, 863, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 863, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 884, 884, 884, 
	884, 884, 884, 884, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 884, 884, 
	884, 884, 863, 884, 863, 863, 863, 863, 
	885, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 884, 884, 
	884, 884, 884, 863, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 884, 884, 
	884, 884, 884, 884, 884, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 884, 
	884, 884, 884, 863, 884, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 890, 863, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 884, 
	884, 884, 884, 884, 863, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 884, 
	884, 884, 884, 884, 884, 884, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	884, 884, 884, 884, 863, 884, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 891, 863, 863, 863, 863, 863, 863, 
	863, 892, 863, 863, 863, 863, 863, 863, 
	884, 884, 884, 884, 884, 863, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	884, 884, 884, 884, 884, 884, 884, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 884, 884, 884, 884, 863, 884, 863, 
	863, 863, 863, 893, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 884, 884, 884, 884, 884, 863, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 884, 884, 884, 884, 884, 884, 884, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 884, 884, 884, 884, 863, 884, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 894, 863, 863, 863, 863, 863, 
	863, 863, 884, 884, 884, 884, 884, 863, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 884, 884, 884, 884, 884, 884, 
	884, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 863, 884, 884, 884, 884, 863, 
	884, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 863, 885, 863, 863, 863, 863, 
	863, 863, 863, 884, 884, 884, 884, 884, 
	863, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 863, 884, 884, 884, 884, 884, 
	884, 884, 863, 863, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 863, 863, 884, 884, 884, 884, 
	863, 884, 863, 863, 863, 863, 863, 863, 
	863, 863, 895, 863, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 863, 863, 884, 884, 884, 884, 
	884, 863, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 863, 863, 863, 863, 863, 863, 
	863, 863, 863, 863, 884, 884, 884, 884, 
	884, 884, 884, 863, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 884, 884, 884, 
	884, 863, 884, 863, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 885, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 884, 884, 884, 
	884, 884, 863, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 863, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 884, 884, 884, 
	884, 884, 884, 884, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 884, 884, 
	884, 884, 863, 884, 863, 863, 863, 863, 
	863, 863, 863, 896, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 884, 884, 
	884, 884, 884, 863, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 884, 884, 
	884, 884, 884, 884, 884, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 884, 
	884, 884, 884, 863, 884, 863, 863, 863, 
	863, 863, 863, 863, 863, 897, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 884, 
	884, 884, 884, 884, 863, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 884, 
	884, 884, 884, 884, 884, 884, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	884, 884, 884, 884, 863, 884, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 889, 863, 863, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	884, 884, 884, 884, 884, 863, 899, 222, 
	222, 222, 899, 222, 222, 222, 222, 900, 
	901, 900, 900, 900, 222, 222, 222, 222, 
	222, 222, 222, 222, 222, 222, 222, 222, 
	899, 222, 222, 222, 222, 222, 900, 902, 
	222, 903, 222, 904, 905, 222, 906, 222, 
	907, 908, 222, 909, 910, 911, 222, 222, 
	222, 222, 222, 222, 222, 222, 222, 222, 
	912, 222, 913, 914, 915, 916, 222, 917, 
	918, 917, 917, 919, 917, 917, 917, 917, 
	917, 917, 917, 917, 917, 917, 917, 917, 
	917, 917, 917, 917, 917, 917, 917, 917, 
	917, 920, 921, 222, 922, 923, 222, 924, 
	925, 926, 927, 928, 929, 898, 898, 930, 
	898, 898, 898, 931, 932, 933, 898, 898, 
	934, 935, 936, 937, 898, 938, 898, 939, 
	898, 940, 941, 222, 922, 222, 898, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	943, 942, 943, 943, 943, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 943, 
	297, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 298, 942, 942, 299, 942, 297, 942, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 942, 944, 942, 942, 898, 942, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 942, 942, 942, 942, 942, 898, 
	946, 945, 945, 947, 945, 948, 950, 951, 
	949, 949, 949, 949, 949, 949, 949, 949, 
	949, 949, 949, 949, 949, 949, 949, 949, 
	949, 949, 949, 949, 949, 949, 949, 949, 
	949, 949, 949, 949, 949, 949, 949, 949, 
	949, 949, 949, 949, 949, 949, 949, 949, 
	949, 949, 949, 949, 949, 949, 949, 949, 
	949, 949, 949, 949, 949, 949, 949, 949, 
	949, 949, 949, 949, 949, 949, 949, 952, 
	949, 954, 953, 955, 956, 957, 900, 958, 
	900, 900, 900, 958, 958, 958, 958, 958, 
	958, 958, 958, 958, 958, 958, 958, 958, 
	958, 958, 958, 958, 958, 900, 958, 960, 
	959, 962, 963, 962, 962, 962, 961, 961, 
	961, 961, 961, 961, 961, 961, 961, 961, 
	961, 961, 961, 961, 961, 961, 961, 961, 
	962, 961, 222, 964, 964, 964, 964, 964, 
	964, 964, 964, 964, 964, 964, 964, 964, 
	964, 964, 964, 964, 964, 964, 964, 964, 
	964, 964, 964, 964, 964, 964, 964, 964, 
	964, 964, 964, 964, 964, 964, 964, 964, 
	964, 964, 964, 964, 964, 964, 964, 964, 
	964, 964, 964, 964, 964, 964, 964, 964, 
	964, 964, 964, 964, 964, 964, 964, 964, 
	964, 964, 964, 222, 964, 965, 966, 967, 
	968, 970, 970, 970, 970, 970, 970, 970, 
	970, 970, 970, 970, 970, 970, 970, 970, 
	970, 970, 970, 970, 970, 970, 970, 970, 
	970, 970, 970, 970, 970, 970, 970, 970, 
	970, 970, 970, 970, 970, 970, 970, 970, 
	970, 970, 970, 970, 970, 970, 970, 970, 
	970, 969, 969, 969, 969, 969, 969, 969, 
	969, 969, 969, 970, 970, 970, 970, 970, 
	970, 970, 971, 971, 971, 971, 971, 971, 
	971, 971, 971, 971, 971, 971, 971, 971, 
	971, 971, 971, 971, 971, 971, 971, 971, 
	971, 971, 971, 971, 970, 970, 970, 970, 
	970, 970, 971, 971, 971, 971, 971, 971, 
	971, 971, 971, 971, 971, 971, 971, 971, 
	971, 971, 971, 971, 971, 971, 971, 971, 
	971, 971, 971, 971, 970, 970, 970, 970, 
	970, 969, 973, 972, 972, 972, 972, 972, 
	972, 972, 972, 972, 972, 972, 972, 972, 
	972, 972, 972, 972, 972, 972, 972, 972, 
	972, 222, 972, 974, 976, 975, 975, 975, 
	975, 975, 975, 975, 975, 975, 975, 975, 
	975, 975, 975, 975, 975, 975, 975, 222, 
	975, 222, 212, 223, 224, 223, 223, 223, 
	972, 972, 972, 972, 972, 972, 972, 972, 
	972, 972, 972, 972, 972, 972, 972, 972, 
	972, 972, 223, 972, 972, 225, 972, 972, 
	972, 972, 972, 972, 972, 972, 972, 972, 
	972, 972, 226, 226, 226, 226, 226, 226, 
	226, 226, 226, 226, 972, 972, 972, 222, 
	972, 972, 972, 972, 972, 972, 972, 972, 
	972, 972, 972, 972, 972, 972, 972, 972, 
	972, 972, 972, 972, 972, 972, 972, 972, 
	972, 972, 972, 972, 972, 972, 227, 972, 
	240, 241, 240, 240, 240, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 240, 
	239, 239, 242, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 243, 
	243, 243, 243, 243, 243, 243, 243, 243, 
	243, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 244, 239, 223, 224, 223, 
	223, 223, 972, 972, 972, 972, 972, 972, 
	972, 972, 972, 972, 972, 972, 972, 972, 
	972, 972, 972, 972, 223, 972, 972, 225, 
	972, 972, 972, 972, 972, 972, 972, 972, 
	972, 972, 972, 972, 226, 226, 226, 226, 
	226, 226, 226, 226, 226, 226, 972, 972, 
	972, 222, 222, 972, 972, 972, 972, 972, 
	972, 972, 972, 972, 972, 972, 972, 972, 
	972, 972, 972, 972, 972, 972, 972, 972, 
	972, 972, 972, 972, 972, 972, 972, 972, 
	227, 972, 978, 964, 980, 979, 982, 981, 
	964, 983, 983, 983, 964, 983, 983, 983, 
	983, 983, 983, 983, 983, 983, 983, 983, 
	983, 983, 983, 983, 983, 983, 983, 983, 
	983, 983, 964, 983, 964, 964, 964, 964, 
	964, 964, 964, 964, 964, 964, 964, 964, 
	964, 964, 964, 964, 964, 964, 964, 964, 
	964, 964, 964, 964, 964, 964, 964, 964, 
	964, 964, 964, 964, 964, 985, 986, 964, 
	987, 248, 988, 986, 964, 964, 989, 990, 
	964, 990, 964, 248, 964, 964, 964, 964, 
	964, 964, 964, 964, 964, 964, 991, 964, 
	992, 993, 994, 964, 995, 984, 984, 984, 
	984, 984, 984, 984, 984, 984, 984, 984, 
	984, 984, 984, 984, 984, 984, 984, 984, 
	984, 984, 984, 984, 984, 984, 984, 996, 
	964, 964, 248, 984, 248, 984, 984, 984, 
	984, 984, 984, 984, 984, 984, 984, 984, 
	984, 984, 984, 984, 984, 984, 984, 984, 
	984, 984, 984, 984, 984, 984, 984, 964, 
	997, 964, 998, 964, 984, 999, 999, 999, 
	999, 999, 999, 999, 999, 999, 999, 999, 
	999, 999, 999, 999, 999, 999, 999, 999, 
	999, 999, 999, 999, 999, 999, 999, 999, 
	999, 999, 999, 999, 999, 999, 1000, 999, 
	999, 999, 999, 999, 999, 999, 999, 999, 
	999, 999, 999, 999, 999, 984, 984, 984, 
	984, 984, 984, 984, 984, 984, 984, 999, 
	999, 999, 1001, 999, 1000, 999, 984, 984, 
	984, 984, 984, 984, 984, 984, 984, 984, 
	984, 984, 984, 984, 984, 984, 984, 984, 
	984, 984, 984, 984, 984, 984, 984, 984, 
	999, 999, 999, 999, 984, 999, 984, 984, 
	984, 984, 984, 984, 984, 984, 984, 984, 
	984, 984, 984, 984, 984, 984, 984, 984, 
	984, 984, 984, 984, 984, 984, 984, 984, 
	999, 999, 999, 999, 999, 984, 1003, 1002, 
	1004, 1006, 1007, 1005, 1005, 1005, 1005, 1005, 
	1005, 1005, 1005, 1005, 1005, 1005, 1005, 1005, 
	1005, 1005, 1005, 1005, 1005, 1005, 1005, 1005, 
	1005, 1005, 1005, 1005, 1005, 1005, 1005, 1005, 
	1005, 1005, 1005, 1005, 1005, 1005, 1005, 1005, 
	1005, 1005, 1005, 1005, 1005, 1005, 1005, 1005, 
	1005, 1005, 1005, 1005, 1005, 1005, 1005, 1005, 
	1005, 1005, 1005, 1005, 1005, 1005, 1005, 1005, 
	1005, 1005, 1008, 1005, 1010, 1011, 1009, 1012, 
	1013, 1014, 1015, 248, 999, 999, 1016, 999, 
	999, 999, 999, 999, 999, 999, 999, 999, 
	999, 999, 999, 999, 999, 999, 999, 999, 
	999, 999, 999, 999, 999, 999, 999, 999, 
	999, 999, 999, 999, 999, 999, 999, 999, 
	999, 999, 999, 999, 999, 999, 999, 999, 
	999, 999, 999, 999, 999, 999, 999, 999, 
	999, 999, 999, 999, 999, 999, 999, 999, 
	999, 999, 999, 999, 248, 999, 999, 999, 
	999, 999, 999, 999, 999, 999, 999, 999, 
	999, 999, 999, 999, 999, 999, 999, 999, 
	999, 999, 999, 999, 999, 999, 999, 999, 
	999, 999, 999, 999, 999, 999, 999, 999, 
	999, 999, 999, 999, 999, 999, 999, 999, 
	999, 999, 999, 999, 999, 999, 247, 247, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	999, 999, 999, 999, 999, 999, 999, 247, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	247, 999, 999, 999, 999, 247, 999, 247, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	247, 999, 999, 999, 999, 999, 247, 250, 
	250, 250, 250, 250, 250, 250, 250, 250, 
	250, 999, 1017, 999, 248, 999, 248, 999, 
	248, 1018, 999, 248, 999, 248, 999, 248, 
	248, 999, 1019, 1019, 1019, 1019, 1019, 1019, 
	1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 
	1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 
	1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 
	1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 
	1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 
	1019, 1019, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1019, 1019, 1019, 1019, 
	1019, 1019, 1022, 1020, 1020, 1020, 1020, 1020, 
	1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020, 
	1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020, 
	1020, 1020, 1020, 1020, 1020, 1019, 1019, 1019, 
	1019, 1020, 1019, 1020, 1020, 1020, 1020, 1020, 
	1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020, 
	1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020, 
	1020, 1020, 1020, 1020, 1020, 1019, 1019, 1019, 
	1019, 1019, 1020, 1024, 1024, 1024, 1024, 1024, 
	1024, 1024, 1024, 1024, 1024, 1023, 1025, 1025, 
	1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025, 
	1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025, 
	1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025, 
	1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025, 
	1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025, 
	1025, 1025, 1025, 1025, 1025, 1025, 1027, 1027, 
	1027, 1027, 1027, 1027, 1027, 1027, 1027, 1027, 
	1025, 1025, 1025, 1025, 1025, 1025, 1025, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1025, 1025, 1025, 1025, 1026, 1025, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1025, 1025, 1025, 1025, 1025, 1026, 1017, 
	999, 1016, 999, 1028, 1029, 964, 1030, 263, 
	253, 253, 253, 253, 253, 253, 253, 253, 
	253, 253, 253, 253, 253, 253, 253, 253, 
	253, 253, 253, 253, 253, 253, 253, 264, 
	253, 265, 254, 254, 254, 254, 254, 254, 
	254, 254, 254, 254, 254, 254, 254, 254, 
	254, 254, 254, 254, 254, 254, 254, 254, 
	254, 254, 254, 254, 254, 254, 264, 254, 
	264, 267, 222, 964, 922, 222, 964, 964, 
	964, 964, 964, 964, 964, 964, 964, 964, 
	964, 964, 964, 964, 964, 964, 964, 964, 
	964, 964, 964, 964, 964, 964, 964, 964, 
	964, 964, 964, 964, 964, 964, 964, 964, 
	964, 964, 964, 964, 964, 964, 964, 964, 
	964, 964, 964, 964, 964, 964, 964, 964, 
	964, 964, 964, 964, 964, 964, 964, 964, 
	964, 964, 964, 964, 964, 222, 964, 222, 
	973, 964, 1034, 1033, 1033, 1033, 1034, 1033, 
	1033, 1033, 1033, 1035, 1036, 1035, 1035, 1035, 
	1033, 1033, 1033, 1033, 1033, 1033, 1033, 1033, 
	1033, 1033, 1033, 1033, 1034, 1033, 1033, 1033, 
	1033, 1033, 1035, 1033, 1033, 1033, 1033, 1033, 
	1033, 1033, 1033, 1033, 1033, 1033, 1033, 1033, 
	1033, 1033, 1033, 1033, 1033, 1033, 1033, 1033, 
	1033, 1033, 1033, 1033, 1033, 1033, 1033, 1033, 
	1033, 1033, 1033, 1037, 1037, 1037, 1037, 1037, 
	1037, 1037, 1037, 1037, 1037, 1037, 1037, 1037, 
	1037, 1037, 1037, 1037, 1037, 1037, 1037, 1037, 
	1037, 1037, 1037, 1037, 1037, 1033, 1038, 1033, 
	1033, 1037, 1033, 1037, 1037, 1037, 1037, 1037, 
	1037, 1037, 1037, 1037, 1037, 1037, 1037, 1037, 
	1037, 1037, 1037, 1037, 1037, 1037, 1037, 1037, 
	1037, 1037, 1037, 1037, 1037, 1033, 1039, 1039, 
	1039, 1039, 1039, 1039, 1039, 1039, 1039, 1039, 
	1039, 1039, 1039, 1039, 1039, 1039, 1039, 1039, 
	1039, 1039, 1039, 1039, 1039, 1039, 1039, 1039, 
	1039, 1039, 1039, 1039, 1039, 1039, 1039, 1039, 
	1039, 1039, 1039, 1039, 1039, 1039, 1039, 1039, 
	1039, 1039, 1039, 1039, 1039, 1039, 1039, 1039, 
	1039, 1039, 1039, 1039, 1039, 1039, 1039, 1039, 
	1039, 1039, 1039, 1039, 1039, 1039, 1039, 1039, 
	1040, 1040, 1040, 1040, 1040, 1040, 1040, 1040, 
	1040, 1040, 1040, 1040, 1040, 1040, 1040, 1040, 
	1040, 1040, 1040, 1040, 1040, 1040, 1040, 1040, 
	1040, 1040, 1039, 1039, 1039, 1039, 1040, 1039, 
	1040, 1040, 1040, 1040, 1040, 1040, 1040, 1040, 
	1040, 1040, 1040, 1040, 1040, 1040, 1040, 1040, 
	1040, 1040, 1040, 1040, 1040, 1040, 1040, 1040, 
	1040, 1040, 1039, 1039, 1039, 1039, 1039, 1040, 
	1041, 1041, 1041, 1041, 1041, 1041, 1041, 1041, 
	1041, 1041, 1041, 1041, 1041, 1041, 1041, 1041, 
	1041, 1041, 1041, 1041, 1041, 1041, 1041, 1041, 
	1041, 1041, 1041, 1041, 1041, 1041, 1041, 1041, 
	1041, 1041, 1041, 1041, 1041, 1041, 1041, 1041, 
	1041, 1041, 1041, 1041, 1041, 1041, 1041, 1041, 
	1042, 1042, 1042, 1042, 1042, 1042, 1042, 1042, 
	1042, 1042, 1041, 1041, 1041, 1041, 1041, 1041, 
	1041, 1042, 1042, 1042, 1042, 1042, 1042, 1042, 
	1042, 1042, 1042, 1042, 1042, 1042, 1042, 1042, 
	1042, 1042, 1042, 1042, 1042, 1042, 1042, 1042, 
	1042, 1042, 1042, 1041, 1041, 1041, 1041, 1042, 
	1041, 1042, 1042, 1042, 1042, 1042, 1042, 1042, 
	1042, 1042, 1042, 1042, 1042, 1042, 1042, 1042, 
	1042, 1042, 1042, 1042, 1042, 1042, 1042, 1042, 
	1042, 1042, 1042, 1041, 1041, 1041, 1041, 1041, 
	1042, 1045, 1044, 1044, 1044, 1045, 1044, 1044, 
	1044, 1044, 1044, 1044, 1044, 1044, 1044, 1044, 
	1044, 1044, 1044, 1044, 1044, 1044, 1044, 1044, 
	1044, 1044, 1044, 1045, 1044, 1044, 1044, 1044, 
	1044, 1044, 1044, 1044, 1044, 1044, 1044, 1044, 
	1044, 1044, 1044, 1044, 1044, 1044, 1044, 1044, 
	1044, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1044, 1044, 1044, 1044, 1044, 1044, 1044, 
	1044, 1044, 1044, 1044, 1047, 1044, 1044, 1044, 
	1044, 1044, 1044, 1044, 1044, 1044, 1048, 1044, 
	1044, 1044, 1044, 1044, 1044, 1044, 1044, 1044, 
	1044, 1044, 1044, 1044, 1044, 1044, 1044, 1044, 
	1044, 1044, 1044, 1044, 1049, 1044, 1044, 1044, 
	1044, 1044, 1044, 1044, 1044, 1044, 1044, 1044, 
	1044, 1044, 1044, 1044, 1044, 1044, 1050, 1044, 
	1044, 1051, 1044, 1052, 1053, 1055, 1055, 1055, 
	1055, 1055, 1055, 1055, 1055, 1054, 1056, 1056, 
	1056, 1056, 1056, 1056, 1056, 1056, 1054, 1054, 
	1057, 1057, 291, 291, 291, 1057, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 1057, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	292, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 1058, 291, 1059, 
	1060, 1061, 1061, 291, 291, 291, 1061, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 1061, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 292, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 1062, 291, 
	290, 1061, 1063, 1064, 1065, 1065, 276, 276, 
	276, 1065, 276, 276, 276, 276, 276, 276, 
	276, 276, 276, 276, 276, 276, 276, 276, 
	276, 276, 276, 276, 276, 276, 276, 1065, 
	276, 276, 276, 276, 276, 276, 276, 276, 
	276, 276, 276, 276, 276, 276, 276, 276, 
	276, 276, 276, 276, 276, 276, 276, 276, 
	276, 276, 276, 276, 276, 276, 276, 276, 
	276, 276, 276, 276, 277, 276, 276, 276, 
	276, 276, 276, 276, 276, 276, 276, 276, 
	276, 276, 276, 276, 276, 276, 276, 276, 
	276, 276, 276, 276, 276, 276, 276, 276, 
	276, 1066, 276, 1067, 1067, 1067, 1067, 1067, 
	1067, 1067, 1067, 1067, 1067, 1065, 1065, 1065, 
	1065, 1065, 1065, 1065, 1067, 1067, 1067, 1067, 
	1067, 1067, 1065, 1065, 1065, 1065, 1065, 1065, 
	1065, 1065, 1065, 1065, 1065, 1065, 1065, 1065, 
	1065, 1065, 1065, 1065, 1065, 1065, 1065, 1065, 
	1065, 1065, 1065, 1065, 1067, 1067, 1067, 1067, 
	1067, 1067, 1065, 1069, 1069, 1069, 1069, 1069, 
	1069, 1069, 1069, 1069, 1069, 1068, 1068, 1068, 
	1068, 1068, 1068, 1068, 1069, 1069, 1069, 1069, 
	1069, 1069, 1068, 1068, 1068, 1068, 1068, 1068, 
	1068, 1068, 1068, 1068, 1068, 1068, 1068, 1068, 
	1068, 1068, 1068, 1068, 1068, 1068, 1068, 1068, 
	1068, 1068, 1068, 1068, 1069, 1069, 1069, 1069, 
	1069, 1069, 1068, 1068, 1070, 1070, 1070, 1070, 
	1070, 1070, 1070, 1070, 1070, 1070, 1061, 1061, 
	1061, 1061, 1061, 1061, 1061, 1070, 1070, 1070, 
	1070, 1070, 1070, 1061, 1061, 1061, 1061, 1061, 
	1061, 1061, 1061, 1061, 1061, 1061, 1061, 1061, 
	1061, 1061, 1061, 1061, 1061, 1061, 1061, 1061, 
	1061, 1061, 1061, 1061, 1061, 1070, 1070, 1070, 
	1070, 1070, 1070, 1061, 1072, 1072, 1072, 1072, 
	1072, 1072, 1072, 1072, 1072, 1072, 1071, 1071, 
	1071, 1071, 1071, 1071, 1071, 1072, 1072, 1072, 
	1072, 1072, 1072, 1071, 1071, 1071, 1071, 1071, 
	1071, 1071, 1071, 1071, 1071, 1071, 1071, 1071, 
	1071, 1071, 1071, 1071, 1071, 1071, 1071, 1071, 
	1071, 1071, 1071, 1071, 1071, 1072, 1072, 1072, 
	1072, 1072, 1072, 1071, 1071, 1061, 269, 269, 
	269, 1061, 269, 269, 269, 269, 269, 269, 
	269, 269, 269, 269, 269, 269, 269, 269, 
	269, 269, 269, 269, 269, 269, 269, 1061, 
	269, 269, 269, 269, 269, 269, 269, 269, 
	269, 269, 269, 269, 269, 269, 269, 269, 
	269, 269, 1073, 269, 1057, 276, 276, 276, 
	1057, 276, 276, 276, 276, 276, 276, 276, 
	276, 276, 276, 276, 276, 276, 276, 276, 
	276, 276, 276, 276, 276, 276, 1057, 276, 
	276, 276, 276, 276, 276, 276, 276, 276, 
	276, 276, 276, 276, 276, 276, 276, 276, 
	276, 276, 276, 276, 276, 276, 276, 276, 
	276, 276, 276, 276, 276, 276, 276, 276, 
	276, 276, 276, 277, 276, 276, 276, 276, 
	276, 276, 276, 276, 276, 276, 276, 276, 
	276, 276, 276, 276, 276, 276, 276, 276, 
	276, 276, 276, 276, 276, 276, 276, 276, 
	278, 276, 1057, 1074, 1074, 1074, 1057, 1074, 
	1074, 1074, 1074, 1074, 1074, 1074, 1074, 1074, 
	1074, 1074, 1074, 1074, 1074, 1074, 1074, 1074, 
	1074, 1074, 1074, 1074, 1057, 1074, 1074, 1074, 
	1074, 1074, 1074, 1074, 1074, 1074, 1074, 1074, 
	1074, 1074, 1074, 1074, 1074, 1074, 1074, 1074, 
	1074, 1074, 1074, 1074, 1074, 1074, 1074, 1074, 
	1074, 1074, 1074, 1074, 1074, 1074, 1074, 1074, 
	1074, 1074, 1074, 1074, 1074, 1074, 1074, 1074, 
	1074, 1074, 1074, 1074, 1074, 1074, 1074, 1074, 
	1074, 1074, 1074, 1074, 1074, 1074, 1074, 1074, 
	1074, 1074, 1074, 1074, 1074, 1074, 1075, 1074, 
	1076, 1077, 1077, 1074, 1074, 1074, 1077, 1074, 
	1074, 1074, 1074, 1074, 1074, 1074, 1074, 1074, 
	1074, 1074, 1074, 1074, 1074, 1074, 1074, 1074, 
	1074, 1074, 1074, 1074, 1077, 1074, 1074, 1074, 
	1074, 1074, 1074, 1074, 1074, 1074, 1074, 1074, 
	1074, 1074, 1074, 1074, 1074, 1074, 1074, 1074, 
	1074, 1074, 1074, 1074, 1074, 1074, 1074, 1074, 
	1074, 1074, 1074, 1074, 1074, 1074, 1074, 1074, 
	1074, 1074, 1074, 1074, 1074, 1074, 1074, 1074, 
	1074, 1074, 1074, 1074, 1074, 1074, 1074, 1074, 
	1074, 1074, 1074, 1074, 1074, 1074, 1074, 1074, 
	1074, 1074, 1074, 1074, 1074, 1074, 1078, 1074, 
	1079, 1079, 1079, 1079, 1079, 1079, 1079, 1079, 
	1079, 1079, 1077, 1077, 1077, 1077, 1077, 1077, 
	1077, 1079, 1079, 1079, 1079, 1079, 1079, 1077, 
	1077, 1077, 1077, 1077, 1077, 1077, 1077, 1077, 
	1077, 1077, 1077, 1077, 1077, 1077, 1077, 1077, 
	1077, 1077, 1077, 1077, 1077, 1077, 1077, 1077, 
	1077, 1079, 1079, 1079, 1079, 1079, 1079, 1077, 
	1081, 1081, 1081, 1081, 1081, 1081, 1081, 1081, 
	1081, 1081, 1080, 1080, 1080, 1080, 1080, 1080, 
	1080, 1081, 1081, 1081, 1081, 1081, 1081, 1080, 
	1080, 1080, 1080, 1080, 1080, 1080, 1080, 1080, 
	1080, 1080, 1080, 1080, 1080, 1080, 1080, 1080, 
	1080, 1080, 1080, 1080, 1080, 1080, 1080, 1080, 
	1080, 1081, 1081, 1081, 1081, 1081, 1081, 1080, 
	1080, 1077, 269, 269, 269, 1077, 269, 269, 
	269, 269, 269, 269, 269, 269, 269, 269, 
	269, 269, 269, 269, 269, 269, 269, 269, 
	269, 269, 269, 1077, 269, 269, 269, 269, 
	269, 269, 269, 269, 269, 269, 269, 269, 
	269, 269, 269, 269, 269, 269, 1073, 269, 
	1082, 1077, 1077, 276, 276, 276, 1077, 276, 
	276, 276, 276, 276, 276, 276, 276, 276, 
	276, 276, 276, 276, 276, 276, 276, 276, 
	276, 276, 276, 276, 1077, 276, 276, 276, 
	276, 276, 276, 276, 276, 276, 276, 276, 
	276, 276, 276, 276, 276, 276, 276, 276, 
	276, 276, 276, 276, 276, 276, 276, 276, 
	276, 276, 276, 276, 276, 276, 276, 276, 
	276, 277, 276, 276, 276, 276, 276, 276, 
	276, 276, 276, 276, 276, 276, 276, 276, 
	276, 276, 276, 276, 276, 276, 276, 276, 
	276, 276, 276, 276, 276, 276, 278, 276, 
	1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
	1084, 1084, 1083, 1083, 1083, 1083, 1083, 1083, 
	1083, 1084, 1084, 1084, 1084, 1084, 1084, 1083, 
	1083, 1083, 1083, 1083, 1083, 1083, 1083, 1083, 
	1083, 1083, 1083, 1083, 1083, 1083, 1083, 1083, 
	1083, 1083, 1083, 1083, 1083, 1083, 1083, 1083, 
	1083, 1084, 1084, 1084, 1084, 1084, 1084, 1083, 
	1083, 1083, 1083, 1083, 1083, 1083, 1083, 1083, 
	1083, 1083, 1083, 1083, 1083, 1083, 1083, 1083, 
	1083, 1083, 1083, 1085, 1083, 1086, 1086, 1086, 
	1086, 1086, 1086, 1086, 1086, 1086, 1086, 1083, 
	1083, 1083, 1083, 1083, 1083, 1083, 1086, 1086, 
	1086, 1086, 1086, 1086, 1083, 1083, 1083, 1083, 
	1083, 1083, 1083, 1083, 1083, 1083, 1083, 1083, 
	1083, 1083, 1083, 1083, 1083, 1083, 1083, 1083, 
	1083, 1083, 1083, 1083, 1083, 1083, 1086, 1086, 
	1086, 1086, 1086, 1086, 1083, 1087, 1087, 1087, 
	1087, 1087, 1087, 1087, 1087, 1087, 1087, 1083, 
	1083, 1083, 1083, 1083, 1083, 1083, 1087, 1087, 
	1087, 1087, 1087, 1087, 1083, 1083, 1083, 1083, 
	1083, 1083, 1083, 1083, 1083, 1083, 1083, 1083, 
	1083, 1083, 1083, 1083, 1083, 1083, 1083, 1083, 
	1083, 1083, 1083, 1083, 1083, 1083, 1087, 1087, 
	1087, 1087, 1087, 1087, 1083, 1088, 1088, 1088, 
	1088, 1088, 1088, 1088, 1088, 1088, 1088, 1083, 
	1083, 1083, 1083, 1083, 1083, 1083, 1088, 1088, 
	1088, 1088, 1088, 1088, 1083, 1083, 1083, 1083, 
	1083, 1083, 1083, 1083, 1083, 1083, 1083, 1083, 
	1083, 1083, 1083, 1083, 1083, 1083, 1083, 1083, 
	1083, 1083, 1083, 1083, 1083, 1083, 1088, 1088, 
	1088, 1088, 1088, 1088, 1083, 1089, 1092, 1091, 
	1091, 1091, 1092, 1091, 1091, 1091, 1091, 1093, 
	1091, 1091, 1091, 1091, 1091, 1091, 1091, 1091, 
	1091, 1091, 1091, 1091, 1091, 1091, 1091, 1091, 
	1092, 1091, 1091, 1091, 1091, 1091, 1093, 1091, 
	1091, 1091, 1091, 1091, 1091, 1091, 1091, 1091, 
	1091, 1091, 1091, 1091, 1091, 1091, 1094, 1094, 
	1094, 1094, 1094, 1094, 1094, 1094, 1094, 1094, 
	1091, 1091, 1091, 1091, 1091, 1091, 1091, 1094, 
	1094, 1094, 1094, 1094, 1094, 1091, 1091, 1091, 
	1091, 1091, 1091, 1091, 1091, 1091, 1091, 1091, 
	1091, 1091, 1091, 1091, 1091, 1091, 1091, 1091, 
	1091, 1091, 1091, 1091, 1091, 1091, 1091, 1094, 
	1094, 1094, 1094, 1094, 1094, 1091, 1091, 1091, 
	1091, 1091, 1091, 1091, 1091, 1091, 1091, 1091, 
	1091, 1091, 1091, 1091, 1091, 1091, 1091, 1091, 
	1091, 1091, 1091, 1095, 1091, 1092, 1091, 1091, 
	1091, 1092, 1091, 1091, 1091, 1091, 1090, 1091, 
	1091, 1091, 1091, 1091, 1091, 1091, 1091, 1091, 
	1091, 1091, 1091, 1091, 1091, 1091, 1091, 1092, 
	1091, 1091, 1091, 1091, 1091, 1090, 1091, 1091, 
	1091, 1091, 1091, 1091, 1091, 1091, 1091, 1091, 
	1091, 1091, 1091, 1091, 1091, 1096, 1096, 1096, 
	1096, 1096, 1096, 1096, 1096, 1096, 1096, 1091, 
	1091, 1091, 1091, 1091, 1091, 1091, 1096, 1096, 
	1096, 1096, 1096, 1096, 1091, 1091, 1091, 1091, 
	1091, 1091, 1091, 1091, 1091, 1091, 1091, 1091, 
	1091, 1091, 1091, 1091, 1091, 1091, 1091, 1091, 
	1091, 1091, 1091, 1091, 1091, 1091, 1096, 1096, 
	1096, 1096, 1096, 1096, 1091, 1091, 1091, 1091, 
	1091, 1091, 1091, 1091, 1091, 1091, 1091, 1091, 
	1091, 1091, 1091, 1091, 1091, 1091, 1091, 1091, 
	1091, 1091, 1097, 1091, 1090, 1092, 1096, 1096, 
	1096, 1092, 1096, 1096, 1096, 1096, 1090, 1096, 
	1096, 1096, 1096, 1096, 1096, 1096, 1096, 1096, 
	1096, 1096, 1096, 1096, 1096, 1096, 1096, 1092, 
	1096, 1096, 1096, 1096, 1096, 1090, 1096, 1096, 
	1096, 1096, 1096, 1096, 1096, 1096, 1096, 1096, 
	1096, 1096, 1096, 1096, 1096, 1096, 1096, 1096, 
	1096, 1096, 1096, 1096, 1096, 1096, 1096, 1096, 
	1096, 1096, 1096, 1096, 1096, 1096, 1096, 1096, 
	1096, 1096, 1096, 1096, 1096, 1096, 1096, 1096, 
	1096, 1096, 1096, 1096, 1096, 1096, 1096, 1096, 
	1096, 1096, 1096, 1096, 1096, 1096, 1096, 1096, 
	1096, 1096, 1096, 1096, 1096, 1096, 1096, 1096, 
	1096, 1096, 1096, 1096, 1096, 1096, 1096, 1096, 
	1096, 1096, 1096, 1096, 1096, 1096, 1096, 1096, 
	1096, 1096, 1096, 1096, 1096, 1096, 1096, 1096, 
	1096, 1096, 1090, 1096, 1098, 1092, 1099, 1099, 
	1099, 1092, 1099, 1099, 1099, 1099, 1093, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1092, 
	1099, 1099, 1099, 1099, 1099, 1093, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1100, 1100, 1100, 
	1100, 1100, 1100, 1100, 1100, 1100, 1100, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1100, 1100, 
	1100, 1100, 1100, 1100, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1100, 1100, 
	1100, 1100, 1100, 1100, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1090, 1099, 1092, 1099, 1099, 1099, 
	1092, 1099, 1099, 1099, 1099, 1090, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1092, 1099, 
	1099, 1099, 1099, 1099, 1090, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1096, 1096, 1096, 1096, 
	1096, 1096, 1096, 1096, 1096, 1096, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1096, 1096, 1096, 
	1096, 1096, 1096, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1096, 1096, 1096, 
	1096, 1096, 1096, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1092, 1099, 1092, 1099, 1099, 1099, 1092, 
	1099, 1099, 1099, 1099, 1101, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1092, 1099, 1099, 
	1099, 1099, 1099, 1101, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1102, 1102, 1102, 1102, 1102, 
	1102, 1102, 1102, 1102, 1102, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1102, 1102, 1102, 1102, 
	1102, 1102, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1102, 1102, 1102, 1102, 
	1102, 1102, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1103, 1099, 1092, 1099, 1099, 1099, 1092, 1099, 
	1099, 1099, 1099, 1101, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1092, 1099, 1099, 1099, 
	1099, 1099, 1101, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1100, 1100, 1100, 1100, 1100, 1100, 
	1100, 1100, 1100, 1100, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1100, 1100, 1100, 1100, 1100, 
	1100, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1100, 1100, 1100, 1100, 1100, 
	1100, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1103, 
	1099, 1104, 1092, 1099, 1099, 1099, 1092, 1099, 
	1099, 1099, 1099, 1101, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1092, 1099, 1099, 1099, 
	1099, 1099, 1101, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1105, 1105, 1105, 1105, 1105, 1105, 
	1105, 1105, 1105, 1105, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1105, 1105, 1105, 1105, 1105, 
	1105, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1105, 1105, 1105, 1105, 1105, 
	1105, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1103, 
	1099, 1092, 1099, 1099, 1099, 1092, 1099, 1099, 
	1099, 1099, 1101, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1092, 1099, 1099, 1099, 1099, 
	1099, 1101, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1106, 1106, 1106, 1106, 1106, 1106, 1106, 
	1106, 1106, 1106, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1106, 1106, 1106, 1106, 1106, 1106, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1106, 1106, 1106, 1106, 1106, 1106, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1103, 1099, 
	1092, 1099, 1099, 1099, 1092, 1099, 1099, 1099, 
	1099, 1101, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1092, 1099, 1099, 1099, 1099, 1099, 
	1101, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1107, 1107, 1107, 1107, 1107, 1107, 1107, 1107, 
	1107, 1107, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1107, 1107, 1107, 1107, 1107, 1107, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1107, 1107, 1107, 1107, 1107, 1107, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1103, 1099, 1092, 
	1099, 1099, 1099, 1092, 1099, 1099, 1099, 1099, 
	1101, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1092, 1099, 1099, 1099, 1099, 1099, 1101, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1108, 
	1108, 1108, 1108, 1108, 1108, 1108, 1108, 1108, 
	1108, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1108, 1108, 1108, 1108, 1108, 1108, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1108, 1108, 1108, 1108, 1108, 1108, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1103, 1099, 1092, 1099, 
	1099, 1099, 1092, 1099, 1099, 1099, 1099, 1101, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1092, 1099, 1099, 1099, 1099, 1099, 1101, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1109, 1109, 
	1109, 1109, 1109, 1109, 1109, 1109, 1109, 1109, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1109, 
	1109, 1109, 1109, 1109, 1109, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1109, 
	1109, 1109, 1109, 1109, 1109, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1103, 1099, 1092, 1099, 1099, 
	1099, 1092, 1099, 1099, 1099, 1099, 1090, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1092, 
	1099, 1099, 1099, 1099, 1099, 1090, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1109, 1109, 1109, 
	1109, 1109, 1109, 1109, 1109, 1109, 1109, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1109, 1109, 
	1109, 1109, 1109, 1109, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1109, 1109, 
	1109, 1109, 1109, 1109, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1090, 1099, 1092, 1099, 1099, 1099, 
	1092, 1099, 1099, 1099, 1099, 1110, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1092, 1099, 
	1099, 1099, 1099, 1099, 1110, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1111, 1111, 1111, 1111, 
	1111, 1111, 1111, 1111, 1111, 1111, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1111, 1111, 1111, 
	1111, 1111, 1111, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1111, 1111, 1111, 
	1111, 1111, 1111, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1103, 1099, 1092, 1099, 1099, 1099, 1092, 
	1099, 1099, 1099, 1099, 1110, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1092, 1099, 1099, 
	1099, 1099, 1099, 1110, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1112, 1112, 1112, 1112, 1112, 
	1112, 1112, 1112, 1112, 1112, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1112, 1112, 1112, 1112, 
	1112, 1112, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1112, 1112, 1112, 1112, 
	1112, 1112, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1103, 1099, 1092, 1099, 1099, 1099, 1092, 1099, 
	1099, 1099, 1099, 1110, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1092, 1099, 1099, 1099, 
	1099, 1099, 1110, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1113, 1113, 1113, 1113, 1113, 1113, 
	1113, 1113, 1113, 1113, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1113, 1113, 1113, 1113, 1113, 
	1113, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1113, 1113, 1113, 1113, 1113, 
	1113, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1090, 
	1099, 1092, 1099, 1099, 1099, 1092, 1099, 1099, 
	1099, 1099, 1110, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1092, 1099, 1099, 1099, 1099, 
	1099, 1110, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1114, 1114, 1114, 1114, 1114, 1114, 1114, 
	1114, 1114, 1114, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1114, 1114, 1114, 1114, 1114, 1114, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1114, 1114, 1114, 1114, 1114, 1114, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1090, 1099, 
	1092, 1099, 1099, 1099, 1092, 1099, 1099, 1099, 
	1099, 1110, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1092, 1099, 1099, 1099, 1099, 1099, 
	1110, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1115, 1115, 1115, 1115, 1115, 1115, 1115, 1115, 
	1115, 1115, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1115, 1115, 1115, 1115, 1115, 1115, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1115, 1115, 1115, 1115, 1115, 1115, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1090, 1099, 1092, 
	1099, 1099, 1099, 1092, 1099, 1099, 1099, 1099, 
	1110, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1092, 1099, 1099, 1099, 1099, 1099, 1110, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1116, 
	1116, 1116, 1116, 1116, 1116, 1116, 1116, 1116, 
	1116, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1116, 1116, 1116, 1116, 1116, 1116, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1116, 1116, 1116, 1116, 1116, 1116, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1090, 1099, 1092, 1099, 
	1099, 1099, 1092, 1099, 1099, 1099, 1099, 1110, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1092, 1099, 1099, 1099, 1099, 1099, 1110, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1117, 1117, 
	1117, 1117, 1117, 1117, 1117, 1117, 1117, 1117, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1117, 
	1117, 1117, 1117, 1117, 1117, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1117, 
	1117, 1117, 1117, 1117, 1117, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1090, 1099, 1092, 1099, 1099, 
	1099, 1092, 1099, 1099, 1099, 1099, 1110, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1092, 
	1099, 1099, 1099, 1099, 1099, 1110, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1109, 1109, 1109, 
	1109, 1109, 1109, 1109, 1109, 1109, 1109, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1109, 1109, 
	1109, 1109, 1109, 1109, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1109, 1109, 
	1109, 1109, 1109, 1109, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1090, 1099, 1092, 1099, 1099, 1099, 
	1092, 1099, 1099, 1099, 1099, 1110, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1092, 1099, 
	1099, 1099, 1099, 1099, 1110, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1118, 1118, 1118, 1118, 
	1118, 1118, 1118, 1118, 1118, 1118, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1118, 1118, 1118, 
	1118, 1118, 1118, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1118, 1118, 1118, 
	1118, 1118, 1118, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1103, 1099, 1092, 1099, 1099, 1099, 1092, 
	1099, 1099, 1099, 1099, 1110, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1092, 1099, 1099, 
	1099, 1099, 1099, 1110, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1119, 1119, 1119, 1119, 1119, 
	1119, 1119, 1119, 1119, 1119, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1119, 1119, 1119, 1119, 
	1119, 1119, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1119, 1119, 1119, 1119, 
	1119, 1119, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1103, 1099, 1092, 1099, 1099, 1099, 1092, 1099, 
	1099, 1099, 1099, 1110, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1092, 1099, 1099, 1099, 
	1099, 1099, 1110, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1120, 1120, 1120, 1120, 1120, 1120, 
	1120, 1120, 1120, 1120, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1120, 1120, 1120, 1120, 1120, 
	1120, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1120, 1120, 1120, 1120, 1120, 
	1120, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1103, 
	1099, 1092, 1099, 1099, 1099, 1092, 1099, 1099, 
	1099, 1099, 1110, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1092, 1099, 1099, 1099, 1099, 
	1099, 1110, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1121, 1121, 1121, 1121, 1121, 1121, 1121, 
	1121, 1121, 1121, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1121, 1121, 1121, 1121, 1121, 1121, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1121, 1121, 1121, 1121, 1121, 1121, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1103, 1099, 
	1092, 1099, 1099, 1099, 1092, 1099, 1099, 1099, 
	1099, 1110, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1092, 1099, 1099, 1099, 1099, 1099, 
	1110, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1109, 1109, 1109, 1109, 1109, 1109, 1109, 1109, 
	1109, 1109, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1109, 1109, 1109, 1109, 1109, 1109, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1109, 1109, 1109, 1109, 1109, 1109, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1103, 1099, 1122, 
	1123, 1125, 1125, 1125, 1125, 1125, 1125, 1125, 
	1125, 1125, 1125, 1124, 1124, 1124, 1124, 1124, 
	1124, 1124, 1125, 1125, 1125, 1125, 1125, 1125, 
	1124, 1124, 1124, 1124, 1124, 1124, 1124, 1124, 
	1124, 1124, 1124, 1124, 1124, 1124, 1124, 1124, 
	1124, 1124, 1124, 1124, 1124, 1124, 1124, 1124, 
	1124, 1124, 1125, 1125, 1125, 1125, 1125, 1125, 
	1124, 1124, 212, 212, 212, 212, 212, 212, 
	212, 212, 212, 212, 212, 212, 212, 212, 
	212, 212, 212, 212, 212, 212, 212, 212, 
	212, 212, 212, 212, 212, 212, 212, 212, 
	212, 212, 212, 297, 212, 212, 212, 212, 
	212, 212, 212, 212, 212, 212, 212, 212, 
	212, 212, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 298, 212, 212, 299, 
	212, 297, 212, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 212, 212, 212, 
	212, 296, 212, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 212, 212, 212, 
	212, 212, 296, 964, 964, 964, 964, 964, 
	964, 964, 964, 964, 964, 964, 964, 964, 
	964, 964, 964, 964, 964, 964, 964, 964, 
	964, 964, 964, 964, 964, 964, 964, 964, 
	964, 964, 964, 964, 297, 964, 964, 964, 
	964, 964, 964, 964, 964, 964, 964, 964, 
	964, 964, 964, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 298, 964, 964, 
	299, 964, 297, 964, 296, 296, 296, 296, 
	1126, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 964, 964, 
	964, 964, 296, 964, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 964, 964, 
	964, 964, 964, 296, 964, 964, 964, 964, 
	964, 964, 964, 964, 964, 964, 964, 964, 
	964, 964, 964, 964, 964, 964, 964, 964, 
	964, 964, 964, 964, 964, 964, 964, 964, 
	964, 964, 964, 964, 964, 297, 964, 964, 
	964, 964, 964, 964, 964, 964, 964, 964, 
	964, 964, 964, 964, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 298, 964, 
	964, 299, 964, 297, 964, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 1127, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 964, 
	964, 964, 964, 296, 964, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 964, 
	964, 964, 964, 964, 296, 1128, 1129, 964, 
	959, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 943, 942, 943, 943, 943, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 943, 297, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 298, 942, 942, 299, 942, 
	297, 942, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 942, 944, 942, 942, 
	1130, 942, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 942, 942, 942, 942, 
	942, 898, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 943, 942, 943, 943, 943, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 943, 297, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 298, 942, 942, 299, 
	942, 297, 942, 898, 898, 898, 898, 1131, 
	1132, 898, 898, 898, 898, 898, 1133, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 942, 944, 942, 
	942, 898, 942, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 942, 942, 942, 
	942, 942, 898, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 943, 942, 943, 943, 
	943, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 943, 297, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 298, 942, 942, 
	299, 942, 297, 942, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 1134, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 942, 944, 
	942, 942, 898, 942, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 942, 942, 
	942, 942, 942, 898, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 943, 942, 943, 
	943, 943, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 943, 297, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 298, 942, 
	942, 299, 942, 297, 942, 898, 898, 1135, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 942, 
	944, 942, 942, 898, 942, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 942, 
	942, 942, 942, 942, 898, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 943, 942, 
	943, 943, 943, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 943, 297, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 298, 
	942, 942, 299, 942, 297, 942, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 1136, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	942, 944, 942, 942, 898, 942, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	942, 942, 942, 942, 942, 898, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 943, 
	942, 943, 943, 943, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 943, 297, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	298, 942, 942, 299, 942, 297, 942, 898, 
	898, 898, 1137, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 942, 944, 942, 942, 898, 942, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 942, 942, 942, 942, 942, 898, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	943, 942, 943, 943, 943, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 943, 
	297, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 298, 942, 942, 299, 942, 297, 942, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	1138, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 942, 944, 942, 942, 898, 942, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 942, 942, 942, 942, 942, 898, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 943, 942, 943, 943, 943, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	943, 297, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 298, 942, 942, 299, 942, 297, 
	942, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 1139, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 942, 944, 942, 942, 898, 
	942, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 942, 942, 942, 942, 942, 
	898, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 943, 942, 943, 943, 943, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 943, 297, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 298, 942, 942, 299, 942, 
	297, 942, 898, 898, 898, 898, 898, 898, 
	1140, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 942, 944, 942, 942, 
	898, 942, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 942, 942, 942, 942, 
	942, 898, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 943, 942, 943, 943, 943, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 943, 297, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 298, 942, 942, 299, 
	942, 297, 942, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 942, 944, 942, 
	942, 1141, 942, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 942, 942, 942, 
	942, 942, 898, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 943, 942, 943, 943, 
	943, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 943, 297, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 298, 942, 942, 
	299, 942, 297, 942, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 942, 944, 
	942, 942, 1142, 942, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 942, 942, 
	942, 942, 942, 898, 212, 212, 212, 212, 
	212, 212, 212, 212, 212, 212, 212, 212, 
	212, 212, 212, 212, 212, 212, 212, 212, 
	212, 212, 212, 212, 212, 212, 212, 212, 
	212, 212, 212, 212, 212, 297, 212, 212, 
	212, 212, 212, 212, 212, 212, 212, 212, 
	212, 212, 212, 212, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 298, 212, 
	212, 299, 212, 297, 212, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 212, 
	212, 212, 212, 898, 212, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 212, 
	212, 212, 212, 212, 898, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 943, 942, 
	943, 943, 943, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 943, 297, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 298, 
	942, 942, 299, 942, 297, 942, 898, 898, 
	898, 898, 898, 898, 898, 898, 1143, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	942, 944, 942, 942, 898, 942, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	942, 942, 942, 942, 942, 898, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 943, 
	942, 943, 943, 943, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 943, 297, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	298, 942, 942, 299, 942, 297, 942, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 1144, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 942, 944, 942, 942, 898, 942, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 942, 942, 942, 942, 942, 898, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	943, 942, 943, 943, 943, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 943, 
	297, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 298, 942, 942, 299, 942, 297, 942, 
	898, 898, 898, 898, 1140, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 942, 944, 942, 942, 898, 942, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 942, 942, 942, 942, 942, 898, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 943, 942, 943, 943, 943, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	943, 297, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 298, 942, 942, 299, 942, 297, 
	942, 898, 898, 898, 898, 898, 898, 898, 
	898, 1145, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 942, 944, 942, 942, 898, 
	942, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 942, 942, 942, 942, 942, 
	898, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 943, 942, 943, 943, 943, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 943, 297, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 298, 942, 942, 299, 942, 
	297, 942, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 1144, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 942, 944, 942, 942, 
	898, 942, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 942, 942, 942, 942, 
	942, 898, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 943, 942, 943, 943, 943, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 943, 297, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 298, 942, 942, 299, 
	942, 297, 942, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 942, 944, 942, 
	942, 898, 942, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 1146, 898, 
	1147, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 942, 942, 942, 
	942, 942, 898, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 943, 942, 943, 943, 
	943, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 943, 297, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 298, 942, 942, 
	299, 942, 297, 942, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 942, 944, 
	942, 942, 898, 942, 898, 898, 898, 898, 
	898, 898, 898, 898, 1148, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 942, 942, 
	942, 942, 942, 898, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 943, 942, 943, 
	943, 943, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 943, 297, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 298, 942, 
	942, 299, 942, 297, 942, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 942, 
	944, 942, 942, 898, 942, 1149, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 942, 
	942, 942, 942, 942, 898, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 943, 942, 
	943, 943, 943, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 943, 297, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 298, 
	942, 942, 299, 942, 297, 942, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	942, 944, 942, 942, 898, 942, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	1142, 898, 898, 898, 898, 898, 898, 898, 
	942, 942, 942, 942, 942, 898, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 943, 
	942, 943, 943, 943, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 943, 297, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	298, 942, 942, 299, 942, 297, 942, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 942, 944, 942, 942, 898, 942, 898, 
	898, 898, 1142, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 942, 942, 942, 942, 942, 898, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	943, 942, 943, 943, 943, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 943, 
	297, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 298, 942, 942, 299, 942, 297, 942, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 942, 944, 942, 942, 898, 942, 
	898, 898, 898, 898, 1150, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 1151, 898, 898, 898, 898, 898, 898, 
	898, 898, 942, 942, 942, 942, 942, 898, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 943, 942, 943, 943, 943, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	943, 297, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 298, 942, 942, 299, 942, 297, 
	942, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 942, 944, 942, 942, 898, 
	942, 898, 898, 898, 898, 898, 898, 1152, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 942, 942, 942, 942, 942, 
	898, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 943, 942, 943, 943, 943, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 943, 297, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 298, 942, 942, 299, 942, 
	297, 942, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 942, 944, 942, 942, 
	898, 942, 898, 898, 898, 898, 898, 898, 
	898, 898, 1153, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 942, 942, 942, 942, 
	942, 898, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 943, 942, 943, 943, 943, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 943, 297, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 298, 942, 942, 299, 
	942, 297, 942, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 942, 944, 942, 
	942, 898, 942, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	1142, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 942, 942, 942, 
	942, 942, 898, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 943, 942, 943, 943, 
	943, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 943, 297, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 298, 942, 942, 
	299, 942, 297, 942, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 942, 944, 
	942, 942, 898, 942, 898, 898, 898, 898, 
	1154, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 942, 942, 
	942, 942, 942, 898, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 943, 942, 943, 
	943, 943, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 943, 297, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 298, 942, 
	942, 299, 942, 297, 942, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 942, 
	944, 942, 942, 898, 942, 1155, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 942, 
	942, 942, 942, 942, 898, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 943, 942, 
	943, 943, 943, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 943, 297, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 298, 
	942, 942, 299, 942, 297, 942, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	942, 944, 942, 942, 898, 942, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	1142, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	942, 942, 942, 942, 942, 898, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 943, 
	942, 943, 943, 943, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 943, 297, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	298, 942, 942, 299, 942, 297, 942, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 942, 944, 942, 942, 898, 942, 1156, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 1157, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 942, 942, 942, 942, 942, 898, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	943, 942, 943, 943, 943, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 943, 
	297, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 298, 942, 942, 299, 942, 297, 942, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 942, 944, 942, 942, 898, 942, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 1158, 898, 898, 898, 898, 898, 
	898, 898, 942, 942, 942, 942, 942, 898, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 943, 942, 943, 943, 943, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	943, 297, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 298, 942, 942, 299, 942, 297, 
	942, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 942, 944, 942, 942, 898, 
	942, 898, 898, 898, 898, 1142, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 942, 942, 942, 942, 942, 
	898, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 943, 942, 943, 943, 943, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 943, 297, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 298, 942, 942, 299, 942, 
	297, 942, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 942, 944, 942, 942, 
	898, 942, 1159, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 942, 942, 942, 942, 
	942, 898, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 943, 942, 943, 943, 943, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 943, 297, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 298, 942, 942, 299, 
	942, 297, 942, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 942, 944, 942, 
	942, 898, 942, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 1149, 898, 898, 
	898, 898, 898, 898, 898, 942, 942, 942, 
	942, 942, 898, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 943, 942, 943, 943, 
	943, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 943, 297, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 298, 942, 942, 
	299, 942, 297, 942, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 942, 944, 
	942, 942, 898, 942, 898, 898, 898, 898, 
	1160, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 1142, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 942, 942, 
	942, 942, 942, 898, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 943, 942, 943, 
	943, 943, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 943, 297, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 298, 942, 
	942, 299, 942, 297, 942, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 942, 
	944, 942, 942, 898, 942, 898, 898, 898, 
	898, 898, 1142, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 942, 
	942, 942, 942, 942, 898, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 943, 942, 
	943, 943, 943, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 943, 297, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 298, 
	942, 942, 299, 942, 297, 942, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	942, 944, 942, 942, 898, 942, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 1161, 898, 1162, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	942, 942, 942, 942, 942, 898, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 943, 
	942, 943, 943, 943, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 943, 297, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	298, 942, 942, 299, 942, 297, 942, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 942, 944, 942, 942, 898, 942, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 1163, 898, 898, 898, 898, 898, 898, 
	898, 942, 942, 942, 942, 942, 898, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	943, 942, 943, 943, 943, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 943, 
	297, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 298, 942, 942, 299, 942, 297, 942, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 942, 944, 942, 942, 898, 942, 
	898, 898, 898, 898, 1142, 898, 898, 898, 
	1160, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 942, 942, 942, 942, 942, 898, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 943, 942, 943, 943, 943, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	943, 297, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 298, 942, 942, 299, 942, 297, 
	942, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 942, 944, 942, 942, 898, 
	942, 898, 898, 898, 1142, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 1164, 898, 898, 898, 898, 
	898, 898, 898, 942, 942, 942, 942, 942, 
	898, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 943, 942, 943, 943, 943, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 943, 297, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 298, 942, 942, 299, 942, 
	297, 942, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 942, 944, 942, 942, 
	898, 942, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 1165, 898, 
	898, 898, 898, 898, 942, 942, 942, 942, 
	942, 898, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 943, 942, 943, 943, 943, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 943, 297, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 298, 942, 942, 299, 
	942, 297, 942, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 942, 944, 942, 
	942, 898, 942, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 1158, 898, 898, 898, 
	898, 898, 898, 898, 898, 942, 942, 942, 
	942, 942, 898, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 943, 942, 943, 943, 
	943, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 943, 297, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 298, 942, 942, 
	299, 942, 297, 942, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 942, 944, 
	942, 942, 898, 942, 1166, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 933, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 942, 942, 
	942, 942, 942, 898, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 943, 942, 943, 
	943, 943, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 943, 297, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 298, 942, 
	942, 299, 942, 297, 942, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 942, 
	944, 942, 942, 898, 942, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	1156, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 942, 
	942, 942, 942, 942, 898, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 943, 942, 
	943, 943, 943, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 943, 297, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 298, 
	942, 942, 299, 942, 297, 942, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	942, 944, 942, 942, 898, 942, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 1142, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	942, 942, 942, 942, 942, 898, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 943, 
	942, 943, 943, 943, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 943, 297, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	298, 942, 942, 299, 942, 297, 942, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 942, 944, 942, 942, 898, 942, 898, 
	898, 898, 898, 898, 1167, 898, 898, 898, 
	898, 898, 898, 898, 1142, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 942, 942, 942, 942, 942, 898, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	943, 942, 943, 943, 943, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 943, 
	297, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 298, 942, 942, 299, 942, 297, 942, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 942, 944, 942, 942, 898, 942, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 1168, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 942, 942, 942, 942, 942, 898, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 943, 942, 943, 943, 943, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	943, 297, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 298, 942, 942, 299, 942, 297, 
	942, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 942, 944, 942, 942, 898, 
	942, 898, 898, 898, 1169, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 942, 942, 942, 942, 942, 
	898, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 943, 942, 943, 943, 943, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 943, 297, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 298, 942, 942, 299, 942, 
	297, 942, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 942, 944, 942, 942, 
	898, 942, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 1170, 898, 
	898, 898, 898, 898, 942, 942, 942, 942, 
	942, 898, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 943, 942, 943, 943, 943, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 943, 297, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 298, 942, 942, 299, 
	942, 297, 942, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 942, 944, 942, 
	942, 898, 942, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 1158, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 942, 942, 942, 
	942, 942, 898, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 943, 942, 943, 943, 
	943, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 943, 297, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 298, 942, 942, 
	299, 942, 297, 942, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 942, 944, 
	942, 942, 898, 942, 898, 898, 898, 898, 
	1171, 898, 898, 898, 1172, 898, 898, 898, 
	898, 898, 1173, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 942, 942, 
	942, 942, 942, 898, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 943, 942, 943, 
	943, 943, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 943, 297, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 298, 942, 
	942, 299, 942, 297, 942, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 942, 
	944, 942, 942, 898, 942, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 1173, 898, 898, 942, 
	942, 942, 942, 942, 898, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 943, 942, 
	943, 943, 943, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 943, 297, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 298, 
	942, 942, 299, 942, 297, 942, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	942, 944, 942, 942, 898, 942, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 1142, 898, 898, 898, 898, 898, 898, 
	942, 942, 942, 942, 942, 898, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 943, 
	942, 943, 943, 943, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 943, 297, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	298, 942, 942, 299, 942, 297, 942, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 942, 944, 942, 942, 898, 942, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 1142, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 942, 942, 942, 942, 942, 898, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	943, 942, 943, 943, 943, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 943, 
	297, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 298, 942, 942, 299, 942, 297, 942, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 942, 944, 942, 942, 898, 942, 
	898, 898, 898, 898, 1174, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 942, 942, 942, 942, 942, 898, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 943, 942, 943, 943, 943, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	943, 297, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 298, 942, 942, 299, 942, 297, 
	942, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 942, 944, 942, 942, 898, 
	942, 898, 898, 898, 1175, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 1176, 1177, 898, 898, 898, 
	898, 898, 898, 942, 942, 942, 942, 942, 
	898, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 943, 942, 943, 943, 943, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 943, 297, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 298, 942, 942, 299, 942, 
	297, 942, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 942, 944, 942, 942, 
	898, 942, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	1142, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 942, 942, 942, 942, 
	942, 898, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 943, 942, 943, 943, 943, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 943, 297, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 298, 942, 942, 299, 
	942, 297, 942, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 942, 944, 942, 
	942, 898, 942, 898, 898, 1178, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 942, 942, 942, 
	942, 942, 898, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 943, 942, 943, 943, 
	943, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 943, 297, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 298, 942, 942, 
	299, 942, 297, 942, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 942, 944, 
	942, 942, 898, 942, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	1179, 898, 898, 898, 898, 898, 942, 942, 
	942, 942, 942, 898, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 943, 942, 943, 
	943, 943, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 943, 297, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 298, 942, 
	942, 299, 942, 297, 942, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 942, 
	944, 942, 942, 898, 942, 898, 898, 898, 
	898, 1180, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 942, 
	942, 942, 942, 942, 898, 1181, 1181, 1181, 
	1181, 1181, 1181, 1181, 1181, 1181, 1181, 1181, 
	1181, 1181, 1181, 1181, 1181, 1181, 1181, 1181, 
	1181, 1181, 1181, 1181, 1181, 1181, 1181, 1181, 
	1181, 1181, 1181, 1181, 1181, 1181, 1183, 1181, 
	1181, 1181, 1181, 1181, 1181, 1181, 1181, 1181, 
	1181, 1181, 1181, 1181, 1181, 1182, 1182, 1182, 
	1182, 1182, 1182, 1182, 1182, 1182, 1182, 1184, 
	1181, 1181, 1185, 1181, 1183, 1181, 1182, 1182, 
	1182, 1182, 1182, 1182, 1182, 1182, 1182, 1182, 
	1182, 1182, 1182, 1182, 1182, 1182, 1182, 1182, 
	1182, 1182, 1182, 1182, 1182, 1182, 1182, 1182, 
	1181, 1181, 1181, 1181, 1182, 1181, 1182, 1182, 
	1182, 1182, 1182, 1182, 1182, 1182, 1182, 1182, 
	1182, 1182, 1182, 1182, 1182, 1182, 1182, 1182, 
	1182, 1182, 1182, 1182, 1182, 1182, 1182, 1182, 
	1181, 1181, 1181, 1181, 1181, 1182, 950, 1186, 
	949, 949, 949, 949, 949, 949, 949, 949, 
	949, 949, 949, 949, 949, 949, 949, 949, 
	949, 949, 949, 949, 949, 949, 949, 949, 
	949, 949, 949, 949, 949, 949, 949, 949, 
	949, 949, 949, 949, 949, 949, 949, 949, 
	949, 949, 949, 949, 949, 949, 949, 949, 
	949, 949, 949, 949, 949, 949, 949, 949, 
	949, 949, 949, 949, 949, 949, 949, 952, 
	949, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 943, 942, 943, 943, 943, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 943, 297, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 298, 942, 942, 299, 942, 
	297, 942, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 942, 944, 942, 942, 
	898, 942, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 1187, 898, 898, 1188, 898, 
	898, 898, 898, 898, 942, 942, 942, 942, 
	942, 898, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 943, 942, 943, 943, 943, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 943, 297, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 298, 942, 942, 299, 
	942, 297, 942, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 942, 944, 942, 
	942, 898, 942, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 1142, 898, 942, 942, 942, 
	942, 942, 898, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 943, 942, 943, 943, 
	943, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 943, 297, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 298, 942, 942, 
	299, 942, 297, 942, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 942, 944, 
	942, 942, 898, 942, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 1153, 898, 898, 
	898, 898, 898, 898, 898, 898, 942, 942, 
	942, 942, 942, 898, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 943, 942, 943, 
	943, 943, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 943, 297, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 298, 942, 
	942, 299, 942, 297, 942, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 942, 
	944, 942, 942, 898, 942, 898, 898, 898, 
	898, 1189, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 1190, 898, 898, 898, 898, 898, 942, 
	942, 942, 942, 942, 898, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 943, 942, 
	943, 943, 943, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 943, 297, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 298, 
	942, 942, 299, 942, 297, 942, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	942, 944, 942, 942, 898, 942, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 1160, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	942, 942, 942, 942, 942, 898, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 943, 
	942, 943, 943, 943, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 943, 297, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	298, 942, 942, 299, 942, 297, 942, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 942, 944, 942, 942, 898, 942, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 1191, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 942, 942, 942, 942, 942, 898, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	943, 942, 943, 943, 943, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 943, 
	297, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 298, 942, 942, 299, 942, 297, 942, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 942, 944, 942, 942, 898, 942, 
	898, 898, 898, 898, 933, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 942, 942, 942, 942, 942, 898, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 943, 942, 943, 943, 943, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	943, 297, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 298, 942, 942, 299, 942, 297, 
	942, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 942, 944, 942, 942, 898, 
	942, 898, 898, 898, 898, 898, 898, 898, 
	1192, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 1193, 898, 898, 898, 898, 898, 
	898, 898, 898, 942, 942, 942, 942, 942, 
	898, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 943, 942, 943, 943, 943, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 943, 297, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 298, 942, 942, 299, 942, 
	297, 942, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 942, 944, 942, 942, 
	898, 942, 898, 898, 898, 898, 1153, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 942, 942, 942, 942, 
	942, 898, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 943, 942, 943, 943, 943, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 943, 297, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 298, 942, 942, 299, 
	942, 297, 942, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 942, 944, 942, 
	942, 898, 942, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 1158, 
	898, 898, 898, 898, 898, 942, 942, 942, 
	942, 942, 898, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 943, 942, 943, 943, 
	943, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 943, 297, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 298, 942, 942, 
	299, 942, 297, 942, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 942, 944, 
	942, 942, 898, 942, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 1194, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 942, 942, 
	942, 942, 942, 898, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 943, 942, 943, 
	943, 943, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 943, 297, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 298, 942, 
	942, 299, 942, 297, 942, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 942, 
	944, 942, 942, 898, 942, 898, 898, 898, 
	1195, 898, 898, 898, 898, 898, 898, 898, 
	1196, 898, 898, 898, 898, 898, 898, 898, 
	1197, 898, 898, 898, 898, 898, 898, 942, 
	942, 942, 942, 942, 898, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 943, 942, 
	943, 943, 943, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 943, 297, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 298, 
	942, 942, 299, 942, 297, 942, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	942, 944, 942, 942, 898, 942, 898, 898, 
	898, 898, 1160, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	942, 942, 942, 942, 942, 898, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 943, 
	942, 943, 943, 943, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 943, 297, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	298, 942, 942, 299, 942, 297, 942, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 942, 944, 942, 942, 898, 942, 898, 
	898, 898, 898, 1198, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 942, 942, 942, 942, 942, 898, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	943, 942, 943, 943, 943, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 943, 
	297, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 298, 942, 942, 299, 942, 297, 942, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 942, 944, 942, 942, 898, 942, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 1199, 898, 898, 898, 898, 898, 
	898, 898, 942, 942, 942, 942, 942, 898, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 943, 942, 943, 943, 943, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	943, 297, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 298, 942, 942, 299, 942, 297, 
	942, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 942, 944, 942, 942, 898, 
	942, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 1167, 898, 898, 898, 898, 
	898, 898, 898, 942, 942, 942, 942, 942, 
	898, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 943, 942, 943, 943, 943, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 943, 297, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 298, 942, 942, 299, 942, 
	297, 942, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 942, 944, 942, 942, 
	898, 942, 898, 898, 898, 898, 898, 898, 
	898, 898, 1200, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 942, 942, 942, 942, 
	942, 898, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 943, 942, 943, 943, 943, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 943, 297, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 298, 942, 942, 299, 
	942, 297, 942, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 942, 944, 942, 
	942, 898, 942, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 1167, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 942, 942, 942, 
	942, 942, 898, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 943, 942, 943, 943, 
	943, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 943, 297, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 298, 942, 942, 
	299, 942, 297, 942, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 942, 944, 
	942, 942, 898, 942, 898, 898, 898, 898, 
	898, 898, 898, 1201, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 942, 942, 
	942, 942, 942, 898, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 943, 942, 943, 
	943, 943, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 943, 297, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 298, 942, 
	942, 299, 942, 297, 942, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 942, 
	944, 942, 942, 898, 942, 898, 898, 898, 
	898, 1153, 898, 898, 898, 1202, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 942, 
	942, 942, 942, 942, 898, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 943, 942, 
	943, 943, 943, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 943, 297, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 298, 
	942, 942, 299, 942, 297, 942, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	942, 944, 942, 942, 898, 942, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 1203, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	942, 942, 942, 942, 942, 898, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 943, 
	942, 943, 943, 943, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 943, 297, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	298, 942, 942, 299, 942, 297, 942, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 942, 944, 942, 942, 898, 942, 898, 
	898, 898, 898, 1167, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 942, 942, 942, 942, 942, 898, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	943, 942, 943, 943, 943, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 943, 
	297, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 298, 942, 942, 299, 942, 297, 942, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 942, 944, 942, 942, 898, 942, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	1204, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 942, 942, 942, 942, 942, 898, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 943, 942, 943, 943, 943, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	943, 297, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 298, 942, 942, 299, 942, 297, 
	942, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 942, 944, 942, 942, 898, 
	942, 898, 898, 898, 898, 1205, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 942, 942, 942, 942, 942, 
	898, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 943, 942, 943, 943, 943, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 943, 297, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 298, 942, 942, 299, 942, 
	297, 942, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 942, 944, 942, 942, 
	898, 942, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 898, 1147, 898, 898, 
	898, 898, 898, 898, 898, 898, 898, 898, 
	898, 898, 898, 898, 942, 942, 942, 942, 
	942, 898, 1206, 222, 964, 964, 964, 964, 
	964, 964, 964, 964, 964, 964, 964, 964, 
	964, 964, 964, 964, 964, 964, 964, 964, 
	964, 964, 964, 964, 964, 964, 964, 964, 
	964, 964, 964, 964, 964, 964, 964, 964, 
	964, 964, 964, 964, 964, 964, 964, 964, 
	964, 964, 964, 964, 964, 964, 964, 964, 
	964, 964, 964, 964, 964, 964, 964, 964, 
	964, 964, 1207, 964, 1209, 1208, 1208, 1208, 
	1209, 1208, 1208, 1208, 1208, 1210, 1211, 1210, 
	1210, 1210, 1208, 1208, 1208, 1208, 1208, 1208, 
	1208, 1208, 1208, 1208, 1208, 1208, 1209, 1208, 
	1208, 1208, 1208, 1208, 1210, 1208, 1208, 1212, 
	1208, 1208, 1208, 1208, 1208, 1208, 1208, 1208, 
	1208, 1208, 1208, 1208, 1208, 1208, 1208, 1208, 
	1208, 1208, 1208, 1208, 1208, 1208, 1208, 1208, 
	1208, 1208, 1208, 1208, 1208, 1208, 1208, 1208, 
	1208, 1208, 1208, 1208, 1208, 1208, 1208, 1208, 
	1208, 1208, 1208, 1208, 1208, 1208, 1208, 1208, 
	1208, 1208, 1208, 1208, 1208, 1208, 1208, 1208, 
	1213, 1208, 1210, 1214, 1210, 1210, 1210, 1214, 
	1214, 1214, 1214, 1214, 1214, 1214, 1214, 1214, 
	1214, 1214, 1214, 1214, 1214, 1214, 1214, 1214, 
	1214, 1210, 1214, 1215, 1216, 1217, 1218, 1219, 
	1221, 1220, 1222, 1224, 1225, 1225, 1225, 1224, 
	1225, 1225, 1225, 1225, 1226, 1227, 1226, 1226, 
	1226, 1225, 1225, 1225, 1225, 1225, 1225, 1225, 
	1225, 1225, 1225, 1225, 1225, 1224, 1225, 1225, 
	1225, 1225, 1225, 1226, 1225, 1228, 1229, 1225, 
	1225, 1225, 1228, 1225, 1225, 1225, 1225, 1225, 
	1225, 1225, 1225, 1225, 1225, 1225, 1225, 1225, 
	1225, 1225, 1225, 1225, 1225, 1225, 1225, 1225, 
	1225, 1225, 1225, 1225, 1223, 1223, 1223, 1223, 
	1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223, 
	1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223, 
	1223, 1223, 1223, 1223, 1223, 1223, 1225, 1230, 
	1225, 1225, 1223, 1225, 1223, 1223, 1223, 1223, 
	1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223, 
	1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223, 
	1223, 1223, 1223, 1223, 1223, 1223, 1225, 1225, 
	1225, 1225, 1225, 1223, 1231, 1231, 1231, 1231, 
	1231, 1231, 1231, 1231, 1231, 1231, 1231, 1231, 
	1231, 1231, 1231, 1231, 1231, 1231, 1231, 1231, 
	1231, 1231, 1231, 1231, 1231, 1231, 1231, 1231, 
	1231, 1231, 1231, 1231, 1231, 305, 1231, 1231, 
	1231, 1231, 1231, 1231, 1231, 1231, 1231, 1231, 
	1231, 1231, 1231, 1231, 304, 304, 304, 304, 
	304, 304, 304, 304, 304, 304, 306, 1231, 
	1231, 1231, 1231, 305, 1231, 304, 304, 304, 
	304, 304, 304, 304, 304, 304, 304, 304, 
	304, 304, 304, 304, 304, 304, 304, 304, 
	304, 304, 304, 304, 304, 304, 304, 1231, 
	1231, 1231, 1231, 304, 1231, 304, 304, 304, 
	304, 304, 304, 304, 304, 304, 304, 304, 
	304, 304, 304, 304, 304, 304, 304, 304, 
	304, 304, 304, 304, 304, 304, 304, 1231, 
	1231, 1231, 1231, 1231, 304, 1226, 1232, 1226, 
	1226, 1226, 1232, 1232, 1232, 1232, 1232, 1232, 
	1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 
	1232, 1232, 1232, 1232, 1226, 1232, 1233, 1234, 
	1235, 1236, 1237, 1238, 1231, 1239, 1241, 1242, 
	1242, 1242, 1241, 1242, 1242, 1242, 1242, 1243, 
	1244, 1243, 1243, 1243, 1242, 1242, 1242, 1242, 
	1242, 1242, 1242, 1242, 1242, 1242, 1242, 1242, 
	1241, 1242, 1242, 1242, 1242, 1242, 1243, 1245, 
	1246, 1247, 1248, 1249, 1250, 1246, 1251, 1252, 
	1253, 1249, 1254, 1255, 1256, 1249, 1257, 1258, 
	1258, 1258, 1258, 1258, 1258, 1258, 1258, 1258, 
	1259, 1260, 1261, 1262, 1263, 1264, 1265, 1266, 
	1267, 1266, 1266, 1268, 1266, 1266, 1266, 1266, 
	1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 
	1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 
	1266, 1269, 1270, 1271, 1249, 1272, 1246, 1273, 
	1274, 1275, 1276, 1277, 1278, 1240, 1240, 1279, 
	1240, 1240, 1240, 1280, 1281, 1282, 1240, 1240, 
	1283, 1284, 1285, 1286, 1240, 1287, 1240, 1288, 
	1240, 1289, 1290, 1291, 1292, 1242, 1240, 314, 
	314, 314, 314, 314, 314, 314, 314, 314, 
	314, 314, 314, 314, 314, 314, 314, 314, 
	314, 314, 314, 314, 314, 314, 314, 314, 
	314, 314, 314, 314, 314, 314, 314, 314, 
	1293, 314, 314, 314, 314, 314, 314, 314, 
	314, 314, 314, 314, 314, 314, 314, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 314, 314, 314, 314, 314, 1293, 314, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 314, 314, 314, 314, 1240, 314, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 314, 314, 314, 314, 314, 1240, 
	1295, 1294, 1296, 1243, 1297, 1243, 1243, 1243, 
	1297, 1297, 1297, 1297, 1297, 1297, 1297, 1297, 
	1297, 1297, 1297, 1297, 1297, 1297, 1297, 1297, 
	1297, 1297, 1243, 1297, 1298, 1300, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1300, 1299, 
	1301, 1302, 1303, 1304, 1305, 1305, 1305, 1305, 
	1305, 1305, 1305, 1305, 1305, 1305, 1305, 1305, 
	1305, 1305, 1305, 1305, 1305, 1305, 1305, 1305, 
	1305, 1305, 1305, 1305, 1305, 1305, 1305, 1305, 
	1305, 1305, 1305, 1305, 1305, 309, 309, 1305, 
	309, 1305, 309, 309, 1305, 1305, 309, 309, 
	309, 1306, 309, 309, 1307, 1307, 1307, 1307, 
	1307, 1307, 1307, 1307, 1307, 1307, 309, 309, 
	309, 309, 309, 309, 309, 326, 326, 326, 
	326, 326, 326, 326, 326, 326, 326, 326, 
	326, 326, 326, 326, 326, 326, 326, 326, 
	326, 326, 326, 326, 326, 326, 326, 1305, 
	309, 1305, 1305, 326, 309, 326, 326, 326, 
	326, 326, 326, 326, 326, 326, 326, 326, 
	326, 326, 326, 326, 326, 326, 326, 326, 
	326, 326, 326, 326, 326, 326, 326, 1305, 
	1305, 1305, 309, 1305, 326, 1308, 1308, 1308, 
	1308, 1308, 1308, 1308, 1308, 1308, 1308, 1308, 
	1308, 1308, 1308, 1308, 1308, 1308, 1308, 1308, 
	1308, 1308, 1308, 1308, 1308, 1308, 1308, 1308, 
	1308, 1308, 1308, 1308, 1308, 1308, 1308, 1308, 
	1308, 1308, 1308, 1308, 1308, 1308, 1308, 1308, 
	1308, 1308, 1308, 1308, 1308, 326, 326, 326, 
	326, 326, 326, 326, 326, 326, 326, 1308, 
	1308, 1308, 1308, 1308, 1308, 1308, 326, 326, 
	326, 326, 326, 326, 326, 326, 326, 326, 
	326, 326, 326, 326, 326, 326, 326, 326, 
	326, 326, 326, 326, 326, 326, 326, 326, 
	1308, 1308, 1308, 1308, 326, 1308, 326, 326, 
	326, 326, 326, 326, 326, 326, 326, 326, 
	326, 326, 326, 326, 326, 326, 326, 326, 
	326, 326, 326, 326, 326, 326, 326, 326, 
	1308, 1308, 1308, 1308, 1308, 326, 1307, 1307, 
	1307, 1307, 1307, 1307, 1307, 1307, 1307, 1307, 
	1308, 1309, 314, 1249, 1310, 1310, 1310, 1310, 
	1310, 1310, 1310, 1311, 1310, 1310, 1310, 1310, 
	1310, 1310, 1310, 1310, 1310, 1310, 1310, 1310, 
	1310, 1310, 1309, 1310, 1312, 1313, 1249, 1314, 
	1314, 1314, 1314, 1314, 1314, 1314, 1314, 1314, 
	1314, 1314, 1314, 1314, 1314, 1314, 1314, 1314, 
	1314, 1309, 1314, 1309, 1315, 1310, 1317, 1316, 
	313, 313, 313, 313, 313, 313, 313, 313, 
	313, 313, 1316, 1319, 1318, 1320, 1318, 313, 
	313, 313, 313, 313, 313, 313, 313, 313, 
	313, 1321, 1321, 1321, 1321, 1321, 1321, 1321, 
	1321, 1321, 1321, 1321, 1322, 1321, 1321, 1321, 
	1321, 1321, 1321, 1321, 1321, 1321, 1321, 1321, 
	1321, 1321, 1321, 1321, 1321, 1321, 1321, 1321, 
	1321, 1321, 1321, 1321, 1321, 1321, 1323, 1321, 
	1321, 1321, 1321, 1321, 1322, 1321, 312, 312, 
	312, 312, 312, 312, 312, 312, 312, 312, 
	1321, 1321, 1321, 1321, 1321, 1321, 1321, 1321, 
	1321, 1321, 1321, 1321, 1321, 1321, 1321, 1321, 
	1321, 1321, 1321, 1321, 1321, 1321, 1321, 1321, 
	1321, 1321, 1321, 1321, 1321, 1321, 1321, 1321, 
	1321, 1321, 1321, 1321, 1321, 311, 1321, 1325, 
	1324, 1326, 1326, 1326, 1326, 1326, 1326, 1326, 
	1326, 1326, 1326, 1324, 1324, 1324, 1324, 1324, 
	1324, 1324, 1324, 1327, 1324, 1328, 1329, 1324, 
	1324, 1324, 1324, 1324, 1324, 1324, 1324, 1324, 
	1330, 1324, 1324, 1324, 1324, 1324, 1324, 1324, 
	1324, 1331, 1324, 1324, 1324, 1324, 1324, 1324, 
	1332, 1324, 1324, 1327, 1324, 1328, 1329, 1324, 
	1324, 1324, 1333, 1324, 1324, 1324, 1324, 1324, 
	1330, 1324, 1324, 1334, 1324, 1324, 1324, 1324, 
	1324, 1331, 1324, 315, 315, 315, 315, 315, 
	315, 315, 315, 315, 315, 1335, 1335, 1335, 
	1335, 1335, 1335, 1335, 1335, 1335, 1335, 1335, 
	1336, 1335, 1335, 1335, 1335, 1335, 1335, 1335, 
	1335, 1335, 1335, 1335, 1335, 1335, 1335, 1335, 
	1335, 1335, 1335, 1335, 1335, 1335, 1335, 1335, 
	1335, 1335, 1337, 1335, 1335, 1335, 1335, 1335, 
	1336, 1335, 1335, 1335, 1338, 1335, 1335, 1335, 
	1335, 1335, 1335, 1335, 1335, 1339, 1335, 1340, 
	314, 1340, 314, 314, 316, 316, 316, 316, 
	316, 316, 316, 316, 316, 316, 314, 316, 
	316, 316, 316, 316, 316, 316, 316, 316, 
	316, 1341, 1341, 1341, 1341, 1341, 1341, 1341, 
	1341, 1341, 1341, 1341, 1341, 1341, 1341, 1341, 
	1341, 1341, 1341, 1341, 1341, 1341, 1341, 1341, 
	1341, 1341, 1341, 1341, 1341, 1341, 1341, 1341, 
	1341, 1341, 1341, 1341, 1341, 1341, 1340, 1341, 
	1341, 1341, 1341, 1341, 1341, 1341, 1341, 1341, 
	1342, 1341, 1344, 1343, 1345, 1347, 1346, 1346, 
	1346, 1348, 1346, 1349, 1350, 1326, 1326, 1326, 
	1326, 1326, 1326, 1326, 1326, 1326, 1326, 1324, 
	1324, 1324, 1324, 1324, 1324, 1324, 1324, 1324, 
	1324, 1324, 1324, 1324, 1324, 1324, 1324, 1324, 
	1324, 1324, 1324, 1324, 1324, 1324, 1324, 1324, 
	1324, 1324, 1324, 1324, 1324, 1324, 1324, 1324, 
	1324, 1324, 1324, 1324, 1332, 1324, 1324, 1324, 
	1324, 1324, 1324, 1324, 1324, 1324, 1333, 1324, 
	1324, 1324, 1324, 1324, 1324, 1324, 1324, 1334, 
	1324, 1351, 1351, 1351, 1351, 1351, 1351, 1351, 
	1351, 1351, 1351, 1324, 1324, 1324, 1324, 1324, 
	1324, 1324, 1324, 1324, 1324, 1324, 1324, 1324, 
	1324, 1324, 1324, 1324, 1324, 1324, 1324, 1324, 
	1324, 1324, 1324, 1324, 1324, 1324, 1324, 1324, 
	1324, 1324, 1324, 1324, 1324, 1324, 1324, 1324, 
	1352, 1324, 1324, 1324, 1324, 1324, 1324, 1324, 
	1324, 1324, 1333, 1324, 1324, 1324, 1324, 1324, 
	1324, 1324, 1324, 1334, 1324, 1354, 1354, 1354, 
	1354, 1354, 1354, 1354, 1354, 1354, 1354, 1353, 
	1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 
	1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 
	1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 
	1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 
	1353, 1353, 1353, 1353, 1355, 1353, 1353, 1353, 
	1353, 1353, 1353, 1353, 1353, 1353, 1356, 1353, 
	1353, 1353, 1353, 1353, 1353, 1353, 1353, 1357, 
	1353, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 
	1354, 1354, 1354, 1353, 1353, 1353, 1353, 1353, 
	1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 
	1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 
	1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 
	1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 
	1358, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 
	1353, 1353, 1356, 1353, 1353, 1353, 1353, 1353, 
	1353, 1353, 1353, 1357, 1353, 1356, 1353, 1353, 
	1353, 1353, 1353, 1353, 1353, 1353, 1357, 1353, 
	1360, 1359, 1361, 1363, 1362, 1362, 1362, 1364, 
	1362, 1366, 1365, 1367, 1368, 1370, 1370, 1369, 
	1369, 1369, 1369, 1369, 1369, 1369, 1369, 1369, 
	1369, 1369, 1369, 1369, 1369, 1369, 1369, 1369, 
	1369, 1369, 1369, 1369, 1369, 1369, 1369, 1369, 
	1369, 1369, 1369, 1369, 1369, 1369, 1369, 1369, 
	1369, 1369, 1369, 1369, 1369, 1369, 1369, 1369, 
	1369, 1369, 1369, 1369, 1371, 1369, 1369, 1369, 
	1369, 1369, 1369, 1369, 1369, 1369, 1372, 1369, 
	1369, 1369, 1369, 1369, 1369, 1369, 1369, 1373, 
	1369, 1374, 1374, 1353, 1353, 1353, 1353, 1353, 
	1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 
	1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 
	1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 
	1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 
	1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 
	1375, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 
	1353, 1353, 1356, 1353, 1353, 1353, 1353, 1353, 
	1353, 1353, 1353, 1357, 1353, 1374, 1374, 1353, 
	1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 
	1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 
	1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 
	1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 
	1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 
	1353, 1353, 1353, 1353, 1358, 1353, 1353, 1353, 
	1353, 1353, 1353, 1353, 1353, 1353, 1356, 1353, 
	1353, 1353, 1353, 1353, 1353, 1353, 1353, 1357, 
	1353, 1377, 1377, 1377, 1377, 1377, 1377, 1377, 
	1377, 1377, 1377, 1376, 1376, 1376, 1376, 1376, 
	1376, 1376, 1376, 1376, 1376, 1376, 1376, 1376, 
	1376, 1376, 1376, 1376, 1376, 1376, 1376, 1376, 
	1376, 1376, 1376, 1376, 1376, 1376, 1376, 1376, 
	1376, 1376, 1376, 1376, 1376, 1376, 1376, 1376, 
	1378, 1376, 1376, 1376, 1376, 1376, 1376, 1376, 
	1376, 1376, 1379, 1376, 1376, 1376, 1376, 1376, 
	1376, 1376, 1376, 1380, 1376, 1382, 1382, 1382, 
	1382, 1382, 1382, 1382, 1382, 1382, 1382, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1383, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1384, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1385, 
	1381, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 
	1387, 1387, 1387, 1386, 1386, 1386, 1386, 1386, 
	1386, 1386, 1387, 1387, 1387, 1387, 1387, 1387, 
	1386, 1386, 1386, 1386, 1386, 1386, 1386, 1386, 
	1386, 1386, 1386, 1386, 1386, 1386, 1386, 1386, 
	1386, 1386, 1386, 1386, 1386, 1386, 1386, 1386, 
	1388, 1386, 1387, 1387, 1387, 1387, 1387, 1387, 
	1386, 1386, 1389, 1386, 1386, 1386, 1386, 1386, 
	1386, 1386, 1386, 1390, 1386, 1391, 1391, 1391, 
	1391, 1391, 1391, 1391, 1391, 1391, 1391, 1353, 
	1353, 1353, 1353, 1353, 1353, 1353, 1391, 1391, 
	1391, 1391, 1391, 1391, 1353, 1353, 1353, 1353, 
	1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 
	1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 
	1353, 1353, 1353, 1353, 1392, 1353, 1391, 1391, 
	1391, 1391, 1391, 1391, 1353, 1353, 1356, 1353, 
	1353, 1353, 1353, 1353, 1353, 1353, 1353, 1357, 
	1353, 1391, 1391, 1391, 1391, 1391, 1391, 1391, 
	1391, 1391, 1391, 1353, 1353, 1353, 1353, 1353, 
	1353, 1353, 1391, 1391, 1391, 1391, 1391, 1391, 
	1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 
	1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 
	1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 
	1358, 1353, 1391, 1391, 1391, 1391, 1391, 1391, 
	1353, 1353, 1356, 1353, 1353, 1353, 1353, 1353, 
	1353, 1353, 1353, 1357, 1353, 1394, 1393, 1395, 
	1395, 1395, 1395, 1395, 1395, 1395, 1395, 1395, 
	1395, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 
	1393, 1393, 1393, 1393, 1396, 1393, 1393, 1393, 
	1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 
	1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 
	1393, 1393, 1393, 1393, 1393, 1393, 1397, 1393, 
	1393, 1393, 1393, 1393, 1396, 1393, 1393, 1393, 
	1398, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 
	1393, 1399, 1393, 1400, 1400, 1400, 1400, 1400, 
	1400, 1400, 1400, 1400, 1400, 1393, 1393, 1393, 
	1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 
	1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 
	1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 
	1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 
	1393, 1393, 1401, 1393, 1393, 1393, 1393, 1393, 
	1393, 1393, 1393, 1393, 1398, 1393, 1393, 1393, 
	1393, 1393, 1393, 1393, 1393, 1399, 1393, 1402, 
	1353, 1403, 1403, 1403, 1403, 1403, 1403, 1403, 
	1403, 1403, 1403, 1353, 1353, 1353, 1353, 1353, 
	1353, 1353, 1353, 1353, 1353, 1353, 1404, 1353, 
	1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 
	1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 
	1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 
	1405, 1353, 1353, 1353, 1353, 1353, 1404, 1353, 
	1353, 1353, 1356, 1353, 1353, 1353, 1353, 1353, 
	1353, 1353, 1353, 1357, 1353, 1403, 1403, 1403, 
	1403, 1403, 1403, 1403, 1403, 1403, 1403, 1353, 
	1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 
	1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 
	1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 
	1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 
	1353, 1353, 1353, 1353, 1358, 1353, 1353, 1353, 
	1353, 1353, 1353, 1353, 1353, 1353, 1356, 1353, 
	1353, 1353, 1353, 1353, 1353, 1353, 1353, 1357, 
	1353, 1311, 1318, 1249, 1406, 1310, 1300, 1310, 
	1407, 1408, 1318, 1318, 1318, 1318, 1318, 1318, 
	1318, 1318, 1318, 1318, 1318, 1318, 1318, 1318, 
	1318, 1318, 1318, 1318, 1318, 1318, 1318, 1318, 
	1318, 1318, 1318, 1318, 1318, 1318, 1318, 1318, 
	1318, 1318, 1318, 1318, 1318, 1318, 1318, 1318, 
	1318, 1318, 1318, 1318, 1318, 1318, 1318, 1318, 
	1318, 1318, 1318, 1318, 1318, 1318, 1318, 1318, 
	1318, 1318, 1318, 1318, 1318, 1318, 1318, 1318, 
	1318, 1300, 1318, 1300, 1310, 1300, 1249, 1310, 
	1305, 1305, 1305, 1305, 1305, 1305, 1305, 1305, 
	1305, 1305, 1305, 1305, 1305, 1305, 1305, 1305, 
	1305, 1305, 1305, 1305, 1305, 1305, 1305, 1305, 
	1305, 1305, 1305, 1305, 1305, 1305, 1305, 1305, 
	1305, 1305, 1305, 1305, 1305, 1305, 1305, 1305, 
	1305, 1305, 1305, 1305, 1305, 1305, 1305, 1305, 
	326, 326, 326, 326, 326, 326, 326, 326, 
	326, 326, 1305, 1305, 1305, 1305, 1305, 1305, 
	1409, 326, 326, 326, 326, 326, 326, 326, 
	326, 326, 326, 326, 326, 326, 326, 326, 
	326, 326, 326, 326, 326, 326, 326, 326, 
	326, 326, 326, 1305, 1305, 1305, 1305, 326, 
	1305, 326, 326, 326, 326, 326, 326, 326, 
	326, 326, 326, 326, 326, 326, 326, 326, 
	326, 326, 326, 326, 326, 326, 326, 326, 
	326, 326, 326, 1305, 1305, 1305, 1305, 1305, 
	326, 314, 314, 314, 314, 314, 314, 314, 
	314, 314, 314, 314, 314, 314, 314, 314, 
	314, 314, 314, 314, 314, 314, 314, 314, 
	314, 314, 314, 314, 314, 314, 314, 314, 
	314, 314, 1293, 314, 314, 314, 314, 314, 
	314, 314, 314, 314, 314, 314, 314, 314, 
	314, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 
	1266, 1266, 1266, 1410, 314, 314, 314, 314, 
	1293, 314, 1266, 1266, 1266, 1266, 1266, 1266, 
	1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 
	1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 
	1266, 1266, 1266, 1266, 314, 314, 314, 314, 
	1266, 314, 1266, 1266, 1266, 1266, 1266, 1266, 
	1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 
	1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 
	1266, 1266, 1266, 1266, 314, 314, 314, 314, 
	314, 1266, 1411, 1412, 1412, 1412, 1412, 1412, 
	1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412, 
	1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412, 
	1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412, 
	1412, 1412, 1412, 1412, 1293, 1412, 1412, 1412, 
	1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412, 
	1412, 1412, 1412, 1266, 1266, 1266, 1266, 1266, 
	1266, 1266, 1266, 1266, 1266, 1410, 1412, 1412, 
	1412, 1412, 1293, 1412, 1266, 1266, 1266, 1266, 
	1413, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 
	1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 
	1266, 1266, 1266, 1266, 1266, 1266, 1412, 1412, 
	1412, 1412, 1266, 1412, 1266, 1266, 1266, 1266, 
	1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 
	1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 
	1266, 1266, 1266, 1266, 1266, 1266, 1412, 1412, 
	1412, 1412, 1412, 1266, 1412, 1412, 1412, 1412, 
	1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412, 
	1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412, 
	1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412, 
	1412, 1412, 1412, 1412, 1412, 1293, 1412, 1412, 
	1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412, 
	1412, 1412, 1412, 1412, 1266, 1266, 1266, 1266, 
	1266, 1266, 1266, 1266, 1266, 1266, 1410, 1412, 
	1412, 1412, 1412, 1293, 1412, 1266, 1266, 1266, 
	1266, 1266, 1266, 1414, 1266, 1266, 1266, 1266, 
	1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 
	1266, 1266, 1266, 1266, 1266, 1266, 1266, 1412, 
	1412, 1412, 1412, 1266, 1412, 1266, 1266, 1266, 
	1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 
	1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 
	1266, 1266, 1266, 1266, 1266, 1266, 1266, 1412, 
	1412, 1412, 1412, 1412, 1266, 1412, 1412, 1412, 
	1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412, 
	1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412, 
	1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412, 
	1412, 1412, 1412, 1412, 1412, 1412, 1293, 1412, 
	1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412, 
	1412, 1412, 1412, 1412, 1412, 1266, 1266, 1266, 
	1266, 1266, 1266, 1266, 1266, 1266, 1266, 1410, 
	1412, 1412, 1412, 1412, 1293, 1412, 1266, 1266, 
	1266, 1266, 1266, 1266, 1266, 1266, 1415, 1266, 
	1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 
	1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 
	1412, 1412, 1412, 1412, 1266, 1412, 1266, 1266, 
	1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 
	1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 
	1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 
	1412, 1412, 1412, 1412, 1412, 1266, 1412, 1412, 
	1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412, 
	1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412, 
	1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412, 
	1412, 1412, 1412, 1412, 1412, 1412, 1412, 1293, 
	1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412, 
	1412, 1412, 1412, 1412, 1412, 1412, 1266, 1266, 
	1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 
	1410, 1412, 1412, 1412, 1412, 1293, 1412, 1266, 
	1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 
	1266, 1266, 1266, 1266, 1416, 1266, 1266, 1266, 
	1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 
	1266, 1412, 1412, 1412, 1412, 1266, 1412, 1266, 
	1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 
	1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 
	1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 
	1266, 1412, 1412, 1412, 1412, 1412, 1266, 1412, 
	1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412, 
	1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412, 
	1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412, 
	1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412, 
	1293, 1412, 1412, 1412, 1412, 1412, 1412, 1412, 
	1412, 1412, 1412, 1412, 1412, 1412, 1412, 1266, 
	1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 
	1266, 1410, 1412, 1412, 1412, 1412, 1293, 1412, 
	1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 
	1266, 1266, 1266, 1266, 1266, 1417, 1266, 1266, 
	1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 
	1266, 1266, 1412, 1412, 1412, 1412, 1266, 1412, 
	1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 
	1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 
	1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 
	1266, 1266, 1412, 1412, 1412, 1412, 1412, 1266, 
	1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412, 
	1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412, 
	1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412, 
	1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412, 
	1412, 1293, 1412, 1412, 1412, 1412, 1412, 1412, 
	1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412, 
	1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 
	1266, 1266, 1410, 1412, 1412, 1412, 1412, 1293, 
	1412, 1266, 1266, 1266, 1416, 1266, 1266, 1266, 
	1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 
	1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 
	1266, 1266, 1266, 1412, 1412, 1412, 1412, 1266, 
	1412, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 
	1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 
	1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 
	1266, 1266, 1266, 1412, 1412, 1412, 1412, 1412, 
	1266, 1418, 1420, 1419, 1421, 1422, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1293, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1423, 1423, 1423, 1423, 1423, 1293, 1423, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1423, 1423, 1423, 1423, 1424, 1423, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1423, 1423, 1423, 1423, 1423, 1240, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1293, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1423, 1423, 1423, 1423, 1423, 1293, 1423, 
	1240, 1240, 1240, 1240, 1425, 1426, 1240, 1240, 
	1240, 1240, 1240, 1427, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1423, 1423, 1423, 1423, 1240, 1423, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1423, 1423, 1423, 1423, 1423, 1240, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1293, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1423, 1423, 1423, 1423, 1423, 1293, 
	1423, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1428, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1423, 1423, 1423, 1423, 1240, 
	1423, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1423, 1423, 1423, 1423, 1423, 
	1240, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1293, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1423, 1423, 1423, 1423, 1423, 
	1293, 1423, 1240, 1240, 1429, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1423, 1423, 1423, 1423, 
	1240, 1423, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1423, 1423, 1423, 1423, 
	1423, 1240, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1293, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1423, 1423, 1423, 1423, 
	1423, 1293, 1423, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1430, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1423, 1423, 1423, 
	1423, 1240, 1423, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1423, 1423, 1423, 
	1423, 1423, 1240, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1293, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1423, 1423, 1423, 
	1423, 1423, 1293, 1423, 1240, 1240, 1240, 1431, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1423, 1423, 
	1423, 1423, 1240, 1423, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1423, 1423, 
	1423, 1423, 1423, 1240, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1293, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1423, 1423, 
	1423, 1423, 1423, 1293, 1423, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1432, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1423, 
	1423, 1423, 1423, 1240, 1423, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1423, 
	1423, 1423, 1423, 1423, 1240, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1293, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1423, 
	1423, 1423, 1423, 1423, 1293, 1423, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1433, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1423, 1423, 1423, 1423, 1240, 1423, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1423, 1423, 1423, 1423, 1423, 1240, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1293, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1423, 1423, 1423, 1423, 1423, 1293, 1423, 1240, 
	1240, 1240, 1240, 1240, 1240, 1434, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1423, 1423, 1423, 1423, 1240, 1423, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1423, 1423, 1423, 1423, 1423, 1240, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1293, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1423, 1423, 1423, 1423, 1423, 1293, 1423, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1423, 1423, 1423, 1423, 1435, 1423, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1423, 1423, 1423, 1423, 1423, 1240, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1293, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1423, 1423, 1423, 1423, 1423, 1293, 
	1423, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1423, 1423, 1423, 1423, 1436, 
	1423, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1423, 1423, 1423, 1423, 1423, 
	1240, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1293, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1423, 1423, 1423, 1423, 1423, 
	1293, 1423, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1437, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1423, 1423, 1423, 1423, 
	1240, 1423, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1423, 1423, 1423, 1423, 
	1423, 1240, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1293, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1423, 1423, 1423, 1423, 
	1423, 1293, 1423, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1438, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1423, 1423, 1423, 
	1423, 1240, 1423, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1423, 1423, 1423, 
	1423, 1423, 1240, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1293, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1423, 1423, 1423, 
	1423, 1423, 1293, 1423, 1240, 1240, 1240, 1240, 
	1439, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1423, 1423, 
	1423, 1423, 1240, 1423, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1423, 1423, 
	1423, 1423, 1423, 1240, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1293, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1423, 1423, 
	1423, 1423, 1423, 1293, 1423, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1423, 
	1423, 1423, 1423, 1440, 1423, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1423, 
	1423, 1423, 1423, 1423, 1240, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1293, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1423, 
	1423, 1423, 1423, 1423, 1293, 1423, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1423, 1423, 1423, 1423, 1441, 1423, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1423, 1423, 1423, 1423, 1423, 1240, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1293, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1423, 1423, 1423, 1423, 1423, 1293, 1423, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1442, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1423, 1423, 1423, 1423, 1240, 1423, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1423, 1423, 1423, 1423, 1423, 1240, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1293, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1423, 1423, 1423, 1423, 1423, 1293, 1423, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1438, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1423, 1423, 1423, 1423, 1240, 1423, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1423, 1423, 1423, 1423, 1423, 1240, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1293, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1423, 1423, 1423, 1423, 1423, 1293, 
	1423, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1423, 1423, 1423, 1423, 1240, 
	1423, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1443, 1240, 1444, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1423, 1423, 1423, 1423, 1423, 
	1240, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1293, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1423, 1423, 1423, 1423, 1423, 
	1293, 1423, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1423, 1423, 1423, 1423, 
	1240, 1423, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1445, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1423, 1423, 1423, 1423, 
	1423, 1240, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1293, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1423, 1423, 1423, 1423, 
	1423, 1293, 1423, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1423, 1423, 1423, 
	1423, 1240, 1423, 1446, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1423, 1423, 1423, 
	1423, 1423, 1240, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1293, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1423, 1423, 1423, 
	1423, 1423, 1293, 1423, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1423, 1423, 
	1423, 1423, 1240, 1423, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1447, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1423, 1423, 
	1423, 1423, 1423, 1240, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1293, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1423, 1423, 
	1423, 1423, 1423, 1293, 1423, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1423, 
	1423, 1423, 1423, 1240, 1423, 1240, 1240, 1240, 
	1448, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1423, 
	1423, 1423, 1423, 1423, 1240, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1293, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1423, 
	1423, 1423, 1423, 1423, 1293, 1423, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1423, 1423, 1423, 1423, 1240, 1423, 1240, 1240, 
	1240, 1240, 1449, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1450, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1423, 1423, 1423, 1423, 1423, 1240, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1293, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1423, 1423, 1423, 1423, 1423, 1293, 1423, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1423, 1423, 1423, 1423, 1240, 1423, 1240, 
	1240, 1240, 1240, 1240, 1240, 1451, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1423, 1423, 1423, 1423, 1423, 1240, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1293, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1423, 1423, 1423, 1423, 1423, 1293, 1423, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1423, 1423, 1423, 1423, 1240, 1423, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1452, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1423, 1423, 1423, 1423, 1423, 1240, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1293, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1423, 1423, 1423, 1423, 1423, 1293, 
	1423, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1423, 1423, 1423, 1423, 1240, 
	1423, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1448, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1423, 1423, 1423, 1423, 1423, 
	1240, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1293, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1423, 1423, 1423, 1423, 1423, 
	1293, 1423, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1423, 1423, 1423, 1423, 
	1240, 1423, 1240, 1240, 1240, 1240, 1453, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1423, 1423, 1423, 1423, 
	1423, 1240, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1293, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1423, 1423, 1423, 1423, 
	1423, 1293, 1423, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1423, 1423, 1423, 
	1423, 1240, 1423, 1454, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1423, 1423, 1423, 
	1423, 1423, 1240, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1293, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1423, 1423, 1423, 
	1423, 1423, 1293, 1423, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1423, 1423, 
	1423, 1423, 1240, 1423, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1455, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1423, 1423, 
	1423, 1423, 1423, 1240, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1293, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1423, 1423, 
	1423, 1423, 1423, 1293, 1423, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1423, 
	1423, 1423, 1423, 1240, 1423, 1456, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1457, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1423, 
	1423, 1423, 1423, 1423, 1240, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1293, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1423, 
	1423, 1423, 1423, 1423, 1293, 1423, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1423, 1423, 1423, 1423, 1240, 1423, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1458, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1423, 1423, 1423, 1423, 1423, 1240, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1293, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1423, 1423, 1423, 1423, 1423, 1293, 1423, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1423, 1423, 1423, 1423, 1240, 1423, 1240, 
	1240, 1240, 1240, 1448, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1423, 1423, 1423, 1423, 1423, 1240, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1293, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1423, 1423, 1423, 1423, 1423, 1293, 1423, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1423, 1423, 1423, 1423, 1240, 1423, 
	1459, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1423, 1423, 1423, 1423, 1423, 1240, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1293, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1423, 1423, 1423, 1423, 1423, 1293, 
	1423, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1423, 1423, 1423, 1423, 1240, 
	1423, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1460, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1423, 1423, 1423, 1423, 1423, 
	1240, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1293, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1423, 1423, 1423, 1423, 1423, 
	1293, 1423, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1423, 1423, 1423, 1423, 
	1240, 1423, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1461, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1423, 1423, 1423, 1423, 
	1423, 1240, 1462, 1462, 1462, 1462, 1462, 1462, 
	1462, 1462, 1462, 328, 329, 328, 328, 328, 
	1462, 1462, 1462, 1462, 1462, 1462, 1462, 1462, 
	1462, 1462, 1462, 1462, 1462, 1462, 1462, 1462, 
	1462, 1462, 328, 1293, 1462, 330, 1462, 1462, 
	1462, 1462, 1462, 1462, 1462, 1462, 1462, 1462, 
	1462, 1462, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1462, 1462, 331, 1462, 
	1462, 1293, 1462, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1462, 332, 1462, 
	1462, 1240, 1462, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1462, 1462, 1462, 
	1462, 1462, 1240, 345, 346, 345, 345, 345, 
	344, 344, 344, 344, 344, 344, 344, 344, 
	344, 344, 344, 344, 344, 344, 344, 344, 
	344, 344, 345, 344, 344, 347, 344, 344, 
	344, 344, 344, 344, 344, 344, 344, 344, 
	344, 344, 344, 344, 344, 344, 344, 344, 
	344, 344, 344, 344, 344, 344, 350, 344, 
	344, 344, 344, 344, 344, 344, 344, 344, 
	344, 344, 344, 344, 344, 344, 344, 344, 
	344, 344, 344, 344, 344, 344, 344, 344, 
	344, 344, 344, 344, 344, 344, 349, 344, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1293, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1423, 1423, 1423, 1423, 1423, 1293, 
	1423, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1423, 1423, 1423, 1423, 1240, 
	1423, 1240, 1240, 1240, 1240, 1464, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1465, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1423, 1423, 1423, 1423, 1423, 
	1240, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1293, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1423, 1423, 1423, 1423, 1423, 
	1293, 1423, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1423, 1423, 1423, 1423, 
	1240, 1423, 1240, 1240, 1240, 1240, 1240, 1466, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1423, 1423, 1423, 1423, 
	1423, 1240, 1467, 1467, 1467, 1467, 1467, 1467, 
	1467, 1467, 1467, 1467, 1467, 1467, 1467, 1467, 
	1467, 1467, 1467, 1467, 1467, 1467, 1467, 1467, 
	1467, 1467, 1467, 1467, 1467, 1467, 1467, 1467, 
	1467, 1467, 1467, 1293, 1467, 1467, 1467, 1467, 
	1467, 1467, 1467, 1467, 1467, 1467, 1467, 1467, 
	1467, 1467, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1467, 1467, 1467, 1467, 
	1467, 1293, 1467, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1467, 1467, 1467, 
	1467, 1240, 1467, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1468, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1467, 1467, 1467, 
	1467, 1467, 1240, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1293, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1423, 1423, 1423, 
	1423, 1423, 1293, 1423, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1423, 1423, 
	1423, 1423, 1240, 1423, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1469, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1423, 1423, 
	1423, 1423, 1423, 1240, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1293, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1423, 1423, 
	1423, 1423, 1423, 1293, 1423, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1423, 
	1423, 1423, 1423, 1240, 1423, 1240, 1240, 1240, 
	1240, 1470, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1423, 
	1423, 1423, 1423, 1423, 1240, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1293, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1423, 
	1423, 1423, 1423, 1423, 1293, 1423, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1423, 1423, 1423, 1423, 1240, 1423, 1240, 1240, 
	1240, 1471, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1423, 1423, 1423, 1423, 1423, 1240, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1293, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1423, 1423, 1423, 1423, 1423, 1472, 1423, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1423, 1423, 1423, 1423, 1240, 1423, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1423, 1423, 1423, 1423, 1423, 1240, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1293, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1423, 1423, 1423, 1423, 1423, 1293, 1423, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1423, 1423, 1423, 1423, 1240, 1423, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1473, 1240, 1474, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1423, 1423, 1423, 1423, 1423, 1240, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1293, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1423, 1423, 1423, 1423, 1423, 1293, 
	1423, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1423, 1423, 1423, 1423, 1240, 
	1423, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1475, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1423, 1423, 1423, 1423, 1423, 
	1240, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1293, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1423, 1423, 1423, 1423, 1423, 
	1293, 1423, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1423, 1423, 1423, 1423, 
	1240, 1423, 1240, 1240, 1240, 1240, 1448, 1240, 
	1240, 1240, 1476, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1423, 1423, 1423, 1423, 
	1423, 1240, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1293, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1423, 1423, 1423, 1423, 
	1423, 1293, 1423, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1423, 1423, 1423, 
	1423, 1240, 1423, 1240, 1240, 1240, 1240, 1240, 
	1448, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1423, 1423, 1423, 
	1423, 1423, 1240, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1293, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1423, 1423, 1423, 
	1423, 1423, 1293, 1423, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1423, 1423, 
	1423, 1423, 1240, 1423, 1240, 1240, 1240, 1441, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1477, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1423, 1423, 
	1423, 1423, 1423, 1240, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1293, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1423, 1423, 
	1423, 1423, 1423, 1293, 1423, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1423, 
	1423, 1423, 1423, 1240, 1423, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1478, 1240, 1240, 1240, 1240, 1240, 1423, 
	1423, 1423, 1423, 1423, 1240, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1293, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1423, 
	1423, 1423, 1423, 1423, 1293, 1423, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1423, 1423, 1423, 1423, 1240, 1423, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1458, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1423, 1423, 1423, 1423, 1423, 1240, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1293, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1423, 1423, 1423, 1423, 1423, 1293, 1423, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1423, 1423, 1423, 1423, 1240, 1423, 1479, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1282, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1423, 1423, 1423, 1423, 1423, 1240, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1293, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1423, 1423, 1423, 1423, 1423, 1293, 1423, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1423, 1423, 1423, 1423, 1240, 1423, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1480, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1423, 1423, 1423, 1423, 1423, 1240, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1293, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1423, 1423, 1423, 1423, 1423, 1293, 
	1423, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1423, 1423, 1423, 1423, 1240, 
	1423, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1481, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1423, 1423, 1423, 1423, 1423, 
	1240, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1293, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1423, 1423, 1423, 1423, 1423, 
	1293, 1423, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1423, 1423, 1423, 1423, 
	1240, 1423, 1240, 1240, 1240, 1240, 1441, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1423, 1423, 1423, 1423, 
	1423, 1240, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1293, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1423, 1423, 1423, 1423, 
	1423, 1293, 1423, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1423, 1423, 1423, 
	1423, 1240, 1423, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1448, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1423, 1423, 1423, 
	1423, 1423, 1240, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1293, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1423, 1423, 1423, 
	1423, 1423, 1293, 1423, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1423, 1423, 
	1423, 1423, 1240, 1423, 1240, 1240, 1240, 1240, 
	1240, 1482, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1448, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1423, 1423, 
	1423, 1423, 1423, 1240, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1293, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1423, 1423, 
	1423, 1423, 1423, 1293, 1423, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1423, 
	1423, 1423, 1423, 1240, 1423, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1483, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1423, 
	1423, 1423, 1423, 1423, 1240, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1293, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1423, 
	1423, 1423, 1423, 1423, 1293, 1423, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1423, 1423, 1423, 1423, 1240, 1423, 1240, 1240, 
	1240, 1484, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1423, 1423, 1423, 1423, 1423, 1240, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1293, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1423, 1423, 1423, 1423, 1423, 1293, 1423, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1423, 1423, 1423, 1423, 1240, 1423, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1485, 1240, 1240, 1240, 1240, 
	1240, 1423, 1423, 1423, 1423, 1423, 1240, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1293, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1423, 1423, 1423, 1423, 1423, 1293, 1423, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1423, 1423, 1423, 1423, 1240, 1423, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1458, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1423, 1423, 1423, 1423, 1423, 1240, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1293, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1423, 1423, 1423, 1423, 1423, 1293, 
	1423, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1423, 1423, 1423, 1423, 1240, 
	1423, 1240, 1240, 1240, 1240, 1486, 1240, 1240, 
	1240, 1487, 1240, 1240, 1240, 1240, 1240, 1488, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1423, 1423, 1423, 1423, 1423, 
	1240, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1293, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1423, 1423, 1423, 1423, 1423, 
	1293, 1423, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1423, 1423, 1423, 1423, 
	1240, 1423, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1489, 1240, 1240, 1423, 1423, 1423, 1423, 
	1423, 1240, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1293, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1423, 1423, 1423, 1423, 
	1423, 1293, 1423, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1423, 1423, 1423, 
	1423, 1240, 1423, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1455, 1240, 
	1240, 1240, 1240, 1240, 1240, 1423, 1423, 1423, 
	1423, 1423, 1240, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1293, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1423, 1423, 1423, 
	1423, 1423, 1293, 1423, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1423, 1423, 
	1423, 1423, 1240, 1423, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1441, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1423, 1423, 
	1423, 1423, 1423, 1240, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1293, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1423, 1423, 
	1423, 1423, 1423, 1293, 1423, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1423, 
	1423, 1423, 1423, 1240, 1423, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1490, 1240, 1240, 1240, 1240, 1240, 1240, 1423, 
	1423, 1423, 1423, 1423, 1240, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1293, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1423, 
	1423, 1423, 1423, 1423, 1293, 1423, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1423, 1423, 1423, 1423, 1240, 1423, 1240, 1240, 
	1240, 1240, 1491, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1423, 1423, 1423, 1423, 1423, 1240, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1293, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1423, 1423, 1423, 1423, 1423, 1293, 1423, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1423, 1423, 1423, 1423, 1240, 1423, 1240, 
	1240, 1240, 1492, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1493, 1494, 1240, 1240, 1240, 1240, 1240, 
	1240, 1423, 1423, 1423, 1423, 1423, 1240, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1293, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1423, 1423, 1423, 1423, 1423, 1293, 1423, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1423, 1423, 1423, 1423, 1240, 1423, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1441, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1423, 1423, 1423, 1423, 1423, 1240, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1293, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1423, 1423, 1423, 1423, 1423, 1293, 
	1423, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1423, 1423, 1423, 1423, 1240, 
	1423, 1240, 1240, 1495, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1423, 1423, 1423, 1423, 1423, 
	1240, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1293, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1423, 1423, 1423, 1423, 1423, 
	1293, 1423, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1423, 1423, 1423, 1423, 
	1240, 1423, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1496, 1240, 
	1240, 1240, 1240, 1240, 1423, 1423, 1423, 1423, 
	1423, 1240, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1293, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1423, 1423, 1423, 1423, 
	1423, 1293, 1423, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1423, 1423, 1423, 
	1423, 1240, 1423, 1240, 1240, 1240, 1240, 1482, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1423, 1423, 1423, 
	1423, 1423, 1240, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1293, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1423, 1423, 1423, 
	1423, 1423, 1293, 1423, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1423, 1423, 
	1423, 1423, 1240, 1423, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1497, 1240, 1240, 
	1498, 1240, 1240, 1240, 1240, 1240, 1423, 1423, 
	1423, 1423, 1423, 1240, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1293, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1423, 1423, 
	1423, 1423, 1423, 1293, 1423, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1423, 
	1423, 1423, 1423, 1240, 1423, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1441, 1240, 1423, 
	1423, 1423, 1423, 1423, 1240, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1293, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1423, 
	1423, 1423, 1423, 1423, 1293, 1423, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1423, 1423, 1423, 1423, 1240, 1423, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1499, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1423, 1423, 1423, 1423, 1423, 1240, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1293, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1423, 1423, 1423, 1423, 1423, 1293, 1423, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1423, 1423, 1423, 1423, 1240, 1423, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1455, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1423, 1423, 1423, 1423, 1423, 1240, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1293, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1423, 1423, 1423, 1423, 1423, 1293, 1423, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1423, 1423, 1423, 1423, 1240, 1423, 
	1240, 1240, 1240, 1240, 1500, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1501, 1240, 1240, 1240, 
	1240, 1240, 1423, 1423, 1423, 1423, 1423, 1240, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1293, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1423, 1423, 1423, 1423, 1423, 1293, 
	1423, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1423, 1423, 1423, 1423, 1240, 
	1423, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1502, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1423, 1423, 1423, 1423, 1423, 
	1240, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1293, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1423, 1423, 1423, 1423, 1423, 
	1293, 1423, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1423, 1423, 1423, 1423, 
	1240, 1423, 1240, 1240, 1240, 1240, 1240, 1441, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1423, 1423, 1423, 1423, 
	1423, 1240, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1293, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1423, 1423, 1423, 1423, 
	1423, 1293, 1423, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1423, 1423, 1423, 
	1423, 1240, 1423, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1503, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1423, 1423, 1423, 
	1423, 1423, 1240, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1293, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1423, 1423, 1423, 
	1423, 1423, 1293, 1423, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1423, 1423, 
	1423, 1423, 1240, 1423, 1240, 1240, 1240, 1240, 
	1504, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1423, 1423, 
	1423, 1423, 1423, 1240, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1293, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1423, 1423, 
	1423, 1423, 1423, 1293, 1423, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1423, 
	1423, 1423, 1423, 1240, 1423, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1490, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1423, 
	1423, 1423, 1423, 1423, 1240, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1293, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1423, 
	1423, 1423, 1423, 1423, 1293, 1423, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1423, 1423, 1423, 1423, 1240, 1423, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1505, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1506, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1423, 1423, 1423, 1423, 1423, 1240, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1293, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1423, 1423, 1423, 1423, 1423, 1293, 1423, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1423, 1423, 1423, 1423, 1240, 1423, 1240, 
	1240, 1240, 1240, 1452, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1423, 1423, 1423, 1423, 1423, 1240, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1293, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1423, 1423, 1423, 1423, 1423, 1293, 1423, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1423, 1423, 1423, 1423, 1240, 1423, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1481, 1240, 1240, 1240, 
	1240, 1240, 1423, 1423, 1423, 1423, 1423, 1240, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1293, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1423, 1423, 1423, 1423, 1423, 1293, 
	1423, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1423, 1423, 1423, 1423, 1240, 
	1423, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1507, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1423, 1423, 1423, 1423, 1423, 
	1240, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1293, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1423, 1423, 1423, 1423, 1423, 
	1293, 1423, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1423, 1423, 1423, 1423, 
	1240, 1423, 1240, 1240, 1240, 1508, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1509, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1510, 1240, 1240, 
	1240, 1240, 1240, 1240, 1423, 1423, 1423, 1423, 
	1423, 1240, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1293, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1423, 1423, 1423, 1423, 
	1423, 1293, 1423, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1423, 1423, 1423, 
	1423, 1240, 1423, 1240, 1240, 1240, 1240, 1511, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1423, 1423, 1423, 
	1423, 1423, 1240, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1293, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1423, 1423, 1423, 
	1423, 1423, 1293, 1423, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1423, 1423, 
	1423, 1423, 1240, 1423, 1240, 1240, 1240, 1240, 
	1240, 1447, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1423, 1423, 
	1423, 1423, 1423, 1240, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1293, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1423, 1423, 
	1423, 1423, 1423, 1293, 1423, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1423, 
	1423, 1423, 1423, 1240, 1423, 1240, 1240, 1240, 
	1240, 1512, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1423, 
	1423, 1423, 1423, 1423, 1240, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1293, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1423, 
	1423, 1423, 1423, 1423, 1293, 1423, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1423, 1423, 1423, 1423, 1240, 1423, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1513, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1423, 1423, 1423, 1423, 1423, 1240, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1293, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1423, 1423, 1423, 1423, 1423, 1293, 1423, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1423, 1423, 1423, 1423, 1240, 1423, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1482, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1423, 1423, 1423, 1423, 1423, 1240, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1293, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1423, 1423, 1423, 1423, 1423, 1293, 1423, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1423, 1423, 1423, 1423, 1240, 1423, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1514, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1423, 1423, 1423, 1423, 1423, 1240, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1293, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1423, 1423, 1423, 1423, 1423, 1293, 
	1423, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1423, 1423, 1423, 1423, 1240, 
	1423, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1482, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1423, 1423, 1423, 1423, 1423, 
	1240, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1293, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1423, 1423, 1423, 1423, 1423, 
	1293, 1423, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1423, 1423, 1423, 1423, 
	1240, 1423, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1515, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1423, 1423, 1423, 1423, 
	1423, 1240, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1293, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1423, 1423, 1423, 1423, 
	1423, 1293, 1423, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1423, 1423, 1423, 
	1423, 1240, 1423, 1240, 1240, 1240, 1240, 1452, 
	1240, 1240, 1240, 1516, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1423, 1423, 1423, 
	1423, 1423, 1240, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1293, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1423, 1423, 1423, 
	1423, 1423, 1293, 1423, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1423, 1423, 
	1423, 1423, 1240, 1423, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1517, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1423, 1423, 
	1423, 1423, 1423, 1240, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1293, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1423, 1423, 
	1423, 1423, 1423, 1293, 1423, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1423, 
	1423, 1423, 1423, 1240, 1423, 1240, 1240, 1240, 
	1240, 1482, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1423, 
	1423, 1423, 1423, 1423, 1240, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1293, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1423, 
	1423, 1423, 1423, 1423, 1293, 1423, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1423, 1423, 1423, 1423, 1240, 1423, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1518, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1423, 1423, 1423, 1423, 1423, 1240, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1293, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1423, 1423, 1423, 1423, 1423, 1293, 1423, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1423, 1423, 1423, 1423, 1240, 1423, 1240, 
	1240, 1240, 1240, 1519, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1423, 1423, 1423, 1423, 1423, 1240, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1293, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1423, 1423, 1423, 1423, 1423, 1293, 1423, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1423, 1423, 1423, 1423, 1240, 1423, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1520, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1423, 1423, 1423, 1423, 1423, 1240, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1293, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1423, 1423, 1423, 1423, 1423, 1293, 
	1423, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1423, 1423, 1423, 1423, 1240, 
	1423, 1240, 1240, 1240, 1490, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1423, 1423, 1423, 1423, 1423, 
	1240, 1521, 1309, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1249, 1299, 1522, 1524, 1523, 1524, 1524, 
	1524, 1523, 1523, 1523, 1523, 1523, 1523, 1523, 
	1523, 1523, 1523, 1523, 1523, 1523, 1523, 1523, 
	1523, 1523, 1523, 1524, 1523, 1523, 1525, 1523, 
	1523, 1526, 1523, 1523, 1523, 1523, 1523, 1523, 
	1523, 358, 1523, 1523, 1523, 1523, 1523, 1523, 
	1523, 1523, 1523, 1523, 1523, 1523, 1523, 1523, 
	1523, 1523, 1523, 1523, 1523, 1523, 1523, 1523, 
	1523, 1523, 1523, 1523, 1523, 1523, 1523, 1523, 
	1523, 1523, 1523, 1523, 1523, 1523, 1523, 1523, 
	1523, 1523, 1523, 1523, 1523, 1523, 1523, 1527, 
	1523, 354, 355, 354, 354, 354, 1528, 1528, 
	1528, 1528, 1528, 1528, 1528, 1528, 1528, 1528, 
	1528, 1528, 1528, 1528, 1528, 1528, 1528, 1528, 
	354, 1528, 1528, 356, 1528, 1528, 357, 1528, 
	1528, 1528, 1528, 1528, 1528, 1528, 358, 1528, 
	1528, 1528, 1528, 1528, 1528, 1528, 1528, 1528, 
	1528, 1528, 1528, 1528, 1528, 1528, 1528, 1528, 
	1528, 1528, 1528, 1528, 1528, 1528, 1528, 1528, 
	1528, 1528, 1528, 1528, 1528, 1528, 1528, 1528, 
	1528, 1528, 1528, 1528, 1528, 1528, 1528, 1528, 
	1528, 1528, 1528, 1528, 359, 1528, 361, 1529, 
	361, 361, 361, 1529, 1529, 1529, 1529, 1529, 
	1529, 1529, 1529, 1529, 1529, 1529, 1529, 1529, 
	1529, 1529, 1529, 1529, 1529, 361, 1529, 1529, 
	356, 1529, 1529, 1529, 1529, 1529, 1529, 1529, 
	1529, 1529, 1529, 1529, 1529, 1529, 1529, 1529, 
	1529, 1529, 1529, 1529, 1529, 1529, 1529, 1529, 
	1529, 1529, 1529, 1529, 1529, 1529, 1529, 1529, 
	1529, 1529, 1529, 1529, 1529, 1529, 1529, 1529, 
	1529, 1529, 1529, 1529, 1529, 1529, 1529, 1529, 
	1529, 1529, 1529, 1529, 1529, 1529, 1529, 1529, 
	1529, 359, 1529, 1531, 1530, 1533, 1532, 364, 
	363, 369, 1528, 367, 1528, 1535, 1534, 1534, 
	1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 
	1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 
	1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 
	1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 
	1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 
	1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 
	1536, 1534, 1535, 1534, 1535, 1534, 1534, 1534, 
	1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 
	1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 
	1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 
	1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 
	1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 
	1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 
	1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 
	1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 
	1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 
	1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 
	1534, 1534, 1534, 1534, 1534, 1534, 1534, 1538, 
	1534, 1535, 1534, 1534, 1534, 1534, 1534, 1534, 
	1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 
	1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 
	1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 
	1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 
	1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 
	1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 
	1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 
	1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 
	1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 
	1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 
	1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 
	1534, 1534, 1534, 1534, 1534, 1539, 1534, 1535, 
	1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 
	1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 
	1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 
	1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 
	1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 
	1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 
	1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 
	1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 
	1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 
	1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 
	1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 
	1534, 1540, 1534, 1542, 1540, 0
]

class << self
	attr_accessor :_lex_trans_targs
	private :_lex_trans_targs, :_lex_trans_targs=
end
self._lex_trans_targs = [
	187, 2, 3, 4, 193, 6, 7, 8, 
	9, 10, 187, 187, 196, 199, 196, 12, 
	200, 201, 14, 196, 208, 209, 212, 213, 
	225, 222, 214, 215, 216, 19, 217, 218, 
	219, 227, 229, 230, 234, 235, 236, 231, 
	25, 18, 210, 211, 27, 259, 260, 262, 
	264, 262, 30, 265, 266, 32, 262, 273, 
	274, 277, 278, 290, 287, 279, 280, 281, 
	37, 282, 283, 284, 292, 294, 295, 299, 
	300, 301, 296, 43, 36, 275, 276, 45, 
	324, 325, 332, 334, 332, 48, 335, 336, 
	50, 338, 341, 338, 52, 342, 343, 54, 
	349, 348, 0, 56, 350, 351, 58, 352, 
	353, 353, 353, 353, 466, 61, 62, 63, 
	466, 65, 466, 495, 66, 67, 495, 495, 
	499, 499, 71, 66, 72, 497, 498, 500, 
	501, 499, 495, 502, 503, 505, 68, 69, 
	506, 507, 70, 499, 73, 74, 79, 86, 
	509, 510, 72, 497, 498, 500, 501, 499, 
	495, 502, 503, 505, 68, 69, 506, 507, 
	70, 73, 74, 79, 86, 509, 510, 508, 
	75, 76, 77, 78, 80, 81, 84, 82, 
	83, 85, 87, 88, 495, 90, 91, 92, 
	94, 97, 95, 96, 98, 100, 526, 526, 
	526, 527, 102, 529, 103, 530, 104, 527, 
	102, 529, 103, 530, 564, 105, 564, 106, 
	107, 105, 564, 106, 564, 564, 564, 110, 
	111, 112, 113, 575, 564, 564, 564, 116, 
	117, 118, 564, 121, 116, 117, 118, 564, 
	121, 119, 119, 117, 118, 585, 120, 119, 
	119, 117, 118, 585, 120, 117, 564, 602, 
	564, 123, 603, 609, 127, 618, 619, 132, 
	133, 127, 128, 617, 128, 617, 564, 129, 
	130, 131, 620, 134, 564, 634, 635, 638, 
	639, 651, 648, 640, 641, 642, 139, 643, 
	644, 645, 653, 655, 656, 660, 661, 662, 
	657, 145, 138, 636, 637, 147, 698, 699, 
	149, 566, 108, 568, 151, 152, 701, 803, 
	154, 155, 156, 803, 811, 811, 811, 159, 
	833, 832, 811, 835, 837, 811, 164, 165, 
	166, 841, 811, 168, 169, 852, 821, 874, 
	172, 173, 174, 178, 179, 172, 173, 174, 
	178, 179, 175, 175, 173, 174, 176, 177, 
	175, 175, 173, 174, 176, 177, 922, 173, 
	811, 991, 180, 993, 182, 186, 994, 184, 
	991, 181, 991, 183, 993, 183, 993, 185, 
	993, 991, 187, 187, 188, 189, 190, 192, 
	194, 195, 187, 187, 187, 191, 187, 191, 
	187, 1, 187, 187, 187, 5, 196, 196, 
	197, 196, 198, 202, 196, 196, 11, 13, 
	196, 196, 196, 196, 203, 204, 205, 15, 
	21, 26, 237, 28, 196, 196, 196, 206, 
	207, 196, 16, 196, 196, 196, 17, 196, 
	196, 196, 20, 220, 196, 221, 223, 196, 
	224, 226, 228, 22, 196, 196, 23, 232, 
	196, 233, 24, 196, 238, 242, 239, 240, 
	241, 196, 196, 243, 244, 247, 249, 258, 
	245, 246, 196, 248, 250, 252, 251, 196, 
	253, 254, 255, 256, 257, 196, 196, 196, 
	261, 262, 262, 262, 263, 267, 262, 29, 
	31, 262, 262, 262, 262, 268, 269, 270, 
	33, 39, 44, 302, 46, 262, 262, 262, 
	271, 272, 262, 34, 262, 262, 262, 35, 
	262, 262, 262, 38, 285, 262, 286, 288, 
	262, 289, 291, 293, 40, 262, 262, 41, 
	297, 262, 298, 42, 262, 303, 307, 304, 
	305, 306, 262, 262, 308, 309, 312, 314, 
	323, 310, 311, 262, 313, 315, 317, 316, 
	262, 318, 319, 320, 321, 322, 262, 262, 
	262, 326, 327, 327, 328, 327, 329, 327, 
	327, 327, 330, 330, 330, 331, 330, 330, 
	330, 332, 332, 332, 333, 332, 47, 49, 
	332, 332, 332, 337, 337, 337, 338, 338, 
	339, 338, 340, 338, 338, 51, 53, 338, 
	338, 338, 344, 344, 345, 344, 344, 346, 
	347, 346, 55, 57, 348, 348, 348, 354, 
	353, 353, 355, 356, 357, 358, 360, 363, 
	364, 365, 366, 353, 367, 368, 370, 372, 
	373, 374, 378, 380, 381, 382, 398, 403, 
	410, 415, 422, 429, 432, 433, 437, 431, 
	441, 449, 453, 455, 460, 462, 465, 353, 
	353, 353, 353, 353, 353, 359, 353, 359, 
	353, 361, 59, 362, 353, 60, 353, 353, 
	369, 371, 353, 375, 376, 377, 373, 379, 
	353, 383, 384, 393, 396, 385, 386, 387, 
	388, 389, 390, 391, 392, 354, 394, 395, 
	397, 399, 402, 400, 401, 404, 407, 405, 
	406, 408, 409, 411, 413, 412, 414, 416, 
	417, 353, 418, 419, 420, 421, 353, 423, 
	426, 424, 425, 427, 428, 430, 434, 435, 
	436, 438, 440, 439, 442, 443, 444, 446, 
	445, 447, 448, 450, 451, 452, 454, 456, 
	457, 458, 459, 461, 463, 464, 467, 466, 
	466, 468, 469, 471, 472, 466, 466, 466, 
	470, 466, 470, 64, 473, 466, 475, 474, 
	474, 478, 479, 480, 481, 474, 483, 484, 
	485, 486, 488, 490, 491, 492, 493, 494, 
	474, 476, 474, 477, 474, 474, 474, 474, 
	474, 482, 474, 482, 487, 474, 489, 474, 
	495, 495, 496, 511, 512, 498, 514, 515, 
	502, 516, 517, 518, 519, 520, 522, 523, 
	524, 525, 495, 495, 495, 495, 495, 495, 
	499, 504, 495, 495, 495, 495, 495, 495, 
	495, 495, 495, 513, 495, 513, 495, 495, 
	495, 495, 521, 495, 89, 93, 99, 526, 
	528, 531, 101, 526, 526, 527, 532, 532, 
	533, 534, 536, 538, 539, 532, 532, 535, 
	532, 535, 532, 537, 532, 532, 532, 541, 
	540, 540, 542, 543, 544, 546, 548, 549, 
	554, 561, 540, 540, 540, 540, 545, 540, 
	545, 540, 547, 540, 540, 541, 550, 551, 
	552, 553, 555, 556, 559, 557, 558, 560, 
	562, 563, 565, 564, 573, 574, 576, 577, 
	579, 580, 581, 582, 584, 586, 587, 590, 
	591, 616, 622, 623, 624, 701, 702, 703, 
	704, 705, 583, 707, 724, 729, 736, 741, 
	743, 749, 752, 753, 757, 751, 761, 772, 
	776, 779, 787, 791, 794, 795, 564, 105, 
	106, 564, 108, 567, 564, 564, 569, 571, 
	572, 564, 570, 564, 564, 564, 564, 564, 
	109, 564, 564, 564, 564, 564, 578, 564, 
	578, 564, 564, 114, 564, 115, 564, 564, 
	583, 564, 588, 564, 589, 564, 564, 564, 
	592, 601, 564, 122, 604, 605, 606, 564, 
	607, 124, 610, 611, 125, 614, 615, 564, 
	593, 595, 564, 594, 564, 564, 596, 599, 
	600, 564, 597, 598, 564, 564, 564, 564, 
	564, 564, 608, 564, 602, 612, 613, 564, 
	612, 564, 602, 612, 126, 621, 564, 564, 
	564, 625, 564, 564, 564, 626, 628, 564, 
	627, 564, 627, 564, 629, 630, 631, 135, 
	141, 146, 663, 148, 564, 564, 564, 632, 
	633, 564, 136, 564, 564, 564, 137, 564, 
	564, 564, 140, 646, 564, 647, 649, 564, 
	650, 652, 654, 142, 564, 564, 143, 658, 
	564, 659, 144, 564, 664, 668, 665, 666, 
	667, 564, 564, 669, 670, 673, 684, 697, 
	671, 672, 564, 674, 675, 676, 678, 677, 
	564, 679, 680, 681, 682, 683, 685, 692, 
	686, 687, 688, 689, 690, 691, 693, 694, 
	695, 696, 564, 564, 564, 700, 150, 153, 
	564, 706, 708, 709, 719, 722, 710, 711, 
	712, 713, 714, 715, 716, 717, 718, 720, 
	721, 723, 725, 728, 726, 727, 730, 733, 
	731, 732, 734, 735, 737, 739, 738, 740, 
	742, 744, 746, 745, 747, 748, 750, 718, 
	754, 755, 756, 758, 760, 759, 762, 763, 
	764, 769, 765, 766, 767, 564, 565, 566, 
	108, 768, 571, 770, 771, 773, 774, 775, 
	777, 778, 780, 781, 782, 785, 783, 784, 
	786, 788, 789, 790, 792, 793, 564, 583, 
	796, 796, 797, 798, 799, 801, 796, 796, 
	796, 800, 796, 800, 796, 802, 796, 804, 
	803, 803, 805, 806, 803, 807, 809, 803, 
	803, 803, 803, 808, 803, 808, 810, 803, 
	812, 811, 811, 815, 816, 817, 811, 818, 
	820, 823, 824, 825, 826, 827, 811, 828, 
	829, 834, 862, 866, 811, 867, 869, 871, 
	811, 872, 873, 875, 879, 881, 882, 884, 
	885, 903, 908, 915, 923, 930, 937, 942, 
	943, 947, 941, 952, 962, 968, 971, 980, 
	984, 988, 989, 990, 823, 813, 811, 814, 
	811, 811, 811, 811, 811, 811, 819, 811, 
	819, 811, 157, 822, 811, 811, 811, 811, 
	811, 811, 811, 811, 811, 830, 811, 831, 
	811, 811, 158, 160, 811, 161, 843, 854, 
	857, 836, 858, 859, 844, 848, 850, 811, 
	836, 161, 838, 840, 162, 811, 838, 811, 
	839, 811, 811, 163, 842, 811, 811, 845, 
	847, 811, 845, 846, 848, 850, 847, 811, 
	849, 811, 811, 851, 853, 811, 167, 811, 
	811, 811, 855, 847, 848, 850, 855, 856, 
	811, 845, 847, 848, 850, 811, 845, 847, 
	848, 850, 811, 860, 847, 848, 850, 860, 
	861, 811, 161, 862, 836, 863, 848, 850, 
	864, 847, 161, 864, 836, 865, 868, 870, 
	811, 170, 171, 811, 811, 876, 877, 878, 
	873, 880, 811, 811, 883, 811, 811, 811, 
	886, 887, 896, 901, 888, 889, 890, 891, 
	892, 893, 894, 895, 812, 897, 898, 899, 
	900, 812, 902, 904, 907, 905, 906, 812, 
	812, 909, 912, 910, 911, 913, 914, 812, 
	916, 918, 917, 919, 920, 921, 811, 811, 
	924, 812, 925, 811, 926, 927, 928, 929, 
	813, 931, 934, 932, 933, 935, 936, 938, 
	939, 940, 812, 944, 945, 946, 948, 950, 
	951, 949, 812, 953, 954, 955, 958, 956, 
	957, 959, 960, 961, 963, 965, 964, 966, 
	967, 969, 970, 972, 973, 975, 978, 974, 
	976, 977, 979, 981, 982, 983, 985, 986, 
	987, 811, 811, 991, 992, 996, 997, 998, 
	991, 991, 991, 995, 991, 991, 1000, 999, 
	1001, 999, 1002, 1003, 1004, 999, 999
]

class << self
	attr_accessor :_lex_trans_actions
	private :_lex_trans_actions, :_lex_trans_actions=
end
self._lex_trans_actions = [
	1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 2, 3, 4, 0, 5, 0, 
	0, 0, 0, 6, 0, 7, 0, 8, 
	0, 0, 7, 0, 0, 0, 0, 8, 
	0, 7, 0, 8, 0, 7, 7, 0, 
	0, 0, 0, 0, 0, 0, 0, 9, 
	0, 10, 0, 0, 0, 0, 11, 0, 
	7, 0, 8, 0, 0, 7, 0, 0, 
	0, 0, 8, 0, 7, 0, 8, 0, 
	7, 7, 0, 0, 0, 0, 0, 0, 
	0, 0, 12, 0, 13, 0, 0, 0, 
	0, 14, 0, 15, 0, 0, 0, 0, 
	0, 16, 0, 0, 0, 0, 0, 0, 
	17, 18, 19, 20, 21, 0, 0, 0, 
	22, 0, 23, 24, 0, 0, 25, 26, 
	27, 28, 29, 30, 30, 31, 32, 30, 
	33, 32, 34, 32, 30, 30, 31, 30, 
	35, 30, 30, 36, 30, 30, 30, 30, 
	30, 30, 0, 37, 38, 0, 39, 38, 
	40, 38, 0, 0, 37, 0, 41, 0, 
	0, 0, 0, 0, 0, 0, 0, 28, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 42, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 43, 44, 
	45, 46, 0, 0, 0, 46, 29, 47, 
	30, 30, 30, 47, 48, 0, 49, 0, 
	29, 30, 50, 30, 51, 52, 53, 0, 
	0, 0, 0, 0, 54, 55, 56, 0, 
	29, 0, 57, 0, 30, 58, 30, 59, 
	30, 60, 61, 62, 61, 63, 61, 0, 
	64, 65, 64, 66, 64, 67, 68, 0, 
	69, 0, 0, 0, 0, 70, 70, 0, 
	0, 71, 71, 72, 0, 29, 73, 0, 
	0, 0, 70, 0, 74, 0, 7, 0, 
	8, 0, 0, 7, 0, 0, 0, 0, 
	8, 0, 7, 0, 8, 0, 7, 7, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 75, 0, 0, 0, 0, 75, 76, 
	0, 0, 0, 77, 78, 79, 80, 0, 
	7, 7, 81, 82, 82, 83, 0, 0, 
	0, 0, 84, 0, 0, 0, 0, 0, 
	0, 29, 0, 0, 0, 30, 58, 30, 
	30, 30, 60, 61, 62, 61, 61, 61, 
	0, 64, 65, 64, 64, 64, 85, 67, 
	86, 87, 0, 88, 0, 89, 89, 0, 
	90, 0, 91, 60, 92, 0, 93, 29, 
	94, 95, 98, 99, 0, 29, 0, 7, 
	0, 7, 100, 101, 102, 60, 103, 0, 
	104, 0, 105, 106, 107, 0, 108, 109, 
	0, 110, 7, 7, 111, 112, 0, 0, 
	113, 114, 115, 116, 117, 117, 117, 117, 
	117, 117, 117, 117, 118, 119, 120, 0, 
	0, 121, 0, 122, 123, 124, 0, 125, 
	126, 127, 0, 0, 128, 0, 0, 129, 
	0, 7, 0, 0, 130, 131, 0, 0, 
	132, 0, 29, 133, 0, 0, 0, 0, 
	0, 134, 135, 0, 0, 0, 0, 0, 
	0, 0, 136, 0, 0, 0, 0, 137, 
	0, 0, 0, 0, 0, 138, 139, 140, 
	0, 141, 142, 143, 7, 7, 144, 0, 
	0, 145, 146, 147, 148, 117, 117, 117, 
	117, 117, 117, 117, 117, 149, 150, 151, 
	0, 0, 152, 0, 153, 154, 155, 0, 
	156, 157, 158, 0, 0, 159, 0, 0, 
	160, 0, 7, 0, 0, 161, 162, 0, 
	0, 163, 0, 29, 164, 0, 0, 0, 
	0, 0, 165, 166, 0, 0, 0, 0, 
	0, 0, 0, 167, 0, 0, 0, 0, 
	168, 0, 0, 0, 0, 0, 169, 170, 
	171, 0, 172, 173, 0, 174, 0, 175, 
	176, 177, 178, 179, 180, 0, 181, 182, 
	183, 184, 185, 186, 7, 187, 0, 0, 
	188, 189, 190, 191, 192, 193, 194, 195, 
	0, 196, 7, 197, 198, 0, 0, 199, 
	200, 201, 202, 203, 0, 204, 205, 206, 
	0, 207, 0, 0, 208, 209, 210, 211, 
	212, 213, 0, 29, 0, 0, 7, 7, 
	0, 0, 0, 214, 0, 0, 0, 0, 
	215, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 216, 
	217, 218, 219, 220, 221, 60, 222, 0, 
	223, 0, 0, 0, 224, 0, 225, 226, 
	0, 0, 227, 0, 0, 0, 228, 0, 
	229, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 228, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 230, 0, 0, 0, 0, 231, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 7, 232, 
	233, 0, 0, 7, 0, 234, 235, 236, 
	60, 237, 0, 0, 29, 238, 0, 239, 
	240, 0, 29, 0, 0, 241, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	242, 0, 243, 0, 244, 245, 246, 247, 
	248, 60, 249, 0, 0, 250, 0, 251, 
	252, 253, 254, 29, 0, 28, 0, 0, 
	28, 0, 0, 0, 0, 0, 0, 7, 
	7, 7, 255, 256, 257, 258, 259, 260, 
	261, 0, 262, 263, 264, 265, 266, 267, 
	268, 269, 270, 60, 271, 0, 272, 273, 
	274, 275, 276, 277, 0, 0, 0, 278, 
	7, 7, 0, 279, 280, 281, 282, 283, 
	0, 0, 0, 0, 0, 284, 285, 60, 
	286, 0, 287, 29, 288, 289, 290, 291, 
	292, 293, 0, 29, 0, 0, 0, 0, 
	0, 0, 294, 295, 296, 297, 60, 298, 
	0, 299, 29, 300, 301, 302, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 303, 304, 0, 8, 0, 0, 
	7, 305, 0, 0, 305, 305, 0, 0, 
	7, 306, 0, 306, 0, 306, 306, 306, 
	0, 0, 306, 303, 303, 303, 303, 303, 
	303, 303, 303, 303, 303, 303, 303, 303, 
	303, 303, 303, 303, 0, 0, 307, 308, 
	308, 309, 310, 0, 311, 312, 0, 75, 
	0, 313, 0, 314, 315, 316, 317, 318, 
	30, 319, 320, 321, 322, 323, 60, 324, 
	0, 325, 326, 0, 327, 0, 328, 329, 
	305, 330, 0, 331, 0, 332, 333, 334, 
	0, 0, 335, 0, 0, 0, 0, 336, 
	0, 0, 0, 0, 0, 0, 0, 337, 
	0, 0, 338, 0, 339, 340, 0, 0, 
	0, 341, 0, 0, 342, 343, 344, 345, 
	346, 347, 0, 348, 349, 349, 0, 350, 
	0, 351, 352, 352, 0, 0, 353, 354, 
	355, 0, 356, 357, 358, 0, 7, 359, 
	360, 361, 0, 362, 117, 117, 117, 117, 
	117, 117, 117, 117, 363, 364, 365, 0, 
	0, 366, 0, 367, 368, 369, 0, 370, 
	371, 372, 0, 0, 373, 0, 0, 374, 
	0, 7, 0, 0, 375, 376, 0, 0, 
	377, 0, 29, 378, 0, 0, 0, 0, 
	0, 379, 380, 0, 0, 0, 0, 0, 
	0, 0, 381, 0, 0, 0, 0, 0, 
	382, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 383, 384, 385, 0, 0, 0, 
	386, 29, 303, 303, 303, 303, 303, 303, 
	303, 303, 303, 303, 303, 303, 75, 303, 
	303, 303, 303, 303, 303, 303, 303, 303, 
	303, 303, 303, 303, 303, 303, 303, 303, 
	303, 303, 303, 303, 303, 303, 303, 387, 
	303, 303, 303, 303, 303, 303, 303, 303, 
	303, 303, 303, 303, 388, 389, 390, 391, 
	392, 392, 388, 303, 303, 303, 303, 303, 
	303, 303, 303, 303, 303, 303, 303, 303, 
	303, 303, 303, 303, 303, 303, 393, 394, 
	395, 396, 0, 29, 0, 0, 397, 398, 
	399, 60, 400, 0, 401, 29, 402, 7, 
	403, 404, 0, 29, 405, 0, 0, 406, 
	407, 408, 409, 60, 410, 0, 29, 411, 
	412, 413, 414, 0, 29, 0, 415, 0, 
	7, 416, 0, 0, 0, 0, 417, 0, 
	0, 418, 418, 0, 419, 0, 0, 0, 
	420, 7, 421, 421, 421, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 422, 423, 424, 0, 
	425, 426, 427, 428, 429, 430, 60, 431, 
	0, 432, 0, 0, 433, 434, 435, 436, 
	437, 438, 439, 440, 441, 0, 442, 0, 
	443, 444, 0, 0, 445, 446, 447, 0, 
	0, 448, 0, 0, 447, 449, 449, 450, 
	451, 0, 452, 453, 0, 454, 455, 456, 
	0, 457, 458, 0, 0, 459, 460, 447, 
	447, 461, 0, 0, 462, 462, 0, 463, 
	0, 464, 465, 7, 0, 466, 0, 467, 
	468, 469, 470, 470, 471, 471, 0, 0, 
	472, 473, 473, 474, 474, 475, 476, 476, 
	477, 477, 478, 479, 479, 480, 480, 0, 
	0, 481, 482, 483, 484, 485, 486, 486, 
	483, 485, 487, 418, 488, 0, 0, 0, 
	489, 0, 0, 490, 491, 421, 421, 421, 
	492, 421, 493, 494, 29, 495, 496, 497, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 498, 0, 0, 0, 
	0, 492, 0, 0, 0, 0, 0, 499, 
	500, 0, 0, 0, 0, 0, 0, 501, 
	0, 0, 0, 0, 0, 500, 502, 503, 
	0, 504, 0, 505, 0, 0, 0, 0, 
	506, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 507, 0, 0, 0, 0, 0, 
	0, 0, 506, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 508, 509, 510, 511, 511, 89, 511, 
	512, 513, 514, 0, 515, 516, 0, 517, 
	0, 518, 0, 0, 0, 519, 520
]

class << self
	attr_accessor :_lex_to_state_actions
	private :_lex_to_state_actions, :_lex_to_state_actions=
end
self._lex_to_state_actions = [
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 96, 0, 0, 0, 0, 
	0, 0, 0, 0, 96, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 96, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 96, 
	0, 0, 96, 0, 96, 0, 0, 0, 
	0, 96, 96, 0, 0, 0, 0, 0, 
	96, 0, 96, 0, 96, 0, 0, 0, 
	0, 96, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 96, 0, 0, 0, 0, 0, 
	0, 0, 96, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 96, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 96, 0, 
	0, 0, 0, 0, 96, 0, 0, 0, 
	0, 0, 0, 0, 96, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 96, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 96, 0, 0, 0, 
	0, 0, 0, 96, 0, 0, 0, 0, 
	0, 0, 0, 96, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 96, 
	0, 0, 0, 0, 0, 0, 0, 96, 
	0, 0, 0, 0, 0
]

class << self
	attr_accessor :_lex_from_state_actions
	private :_lex_from_state_actions, :_lex_from_state_actions=
end
self._lex_from_state_actions = [
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 97, 0, 0, 0, 0, 
	0, 0, 0, 0, 97, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 97, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 97, 
	0, 0, 97, 0, 97, 0, 0, 0, 
	0, 97, 97, 0, 0, 0, 0, 0, 
	97, 0, 97, 0, 97, 0, 0, 0, 
	0, 97, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 97, 0, 0, 0, 0, 0, 
	0, 0, 97, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 97, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 97, 0, 
	0, 0, 0, 0, 97, 0, 0, 0, 
	0, 0, 0, 0, 97, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 97, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 97, 0, 0, 0, 
	0, 0, 0, 97, 0, 0, 0, 0, 
	0, 0, 0, 97, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 97, 
	0, 0, 0, 0, 0, 0, 0, 97, 
	0, 0, 0, 0, 0
]

class << self
	attr_accessor :_lex_eof_trans
	private :_lex_eof_trans, :_lex_eof_trans=
end
self._lex_eof_trans = [
	0, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 13, 13, 13, 13, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 48, 48, 48, 
	48, 55, 55, 55, 55, 55, 55, 55, 
	55, 55, 55, 55, 55, 55, 55, 83, 
	83, 83, 83, 90, 90, 90, 90, 0, 
	0, 0, 0, 105, 107, 109, 109, 109, 
	109, 109, 116, 116, 120, 120, 120, 120, 
	120, 120, 120, 120, 120, 120, 120, 120, 
	120, 120, 120, 120, 120, 120, 120, 120, 
	120, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 191, 193, 193, 
	193, 205, 205, 205, 213, 215, 215, 215, 
	215, 215, 221, 213, 213, 213, 213, 213, 
	213, 213, 247, 247, 247, 247, 247, 247, 
	213, 263, 213, 263, 247, 247, 213, 269, 
	269, 269, 269, 269, 269, 269, 269, 269, 
	269, 269, 269, 269, 269, 213, 247, 247, 
	247, 247, 304, 304, 304, 309, 311, 311, 
	311, 315, 315, 318, 318, 318, 318, 323, 
	323, 323, 309, 315, 315, 315, 315, 315, 
	315, 315, 315, 315, 354, 361, 363, 363, 
	363, 363, 354, 0, 379, 380, 381, 383, 
	385, 387, 385, 385, 0, 397, 398, 402, 
	402, 403, 404, 413, 414, 415, 415, 415, 
	418, 418, 420, 421, 422, 422, 422, 424, 
	425, 426, 426, 426, 429, 429, 422, 432, 
	432, 422, 418, 418, 437, 438, 438, 438, 
	441, 441, 438, 438, 438, 444, 444, 444, 
	444, 450, 451, 451, 451, 451, 459, 451, 
	451, 451, 451, 464, 451, 451, 451, 451, 
	451, 451, 470, 471, 472, 472, 0, 479, 
	483, 483, 484, 485, 494, 495, 496, 496, 
	496, 499, 499, 501, 502, 503, 503, 503, 
	505, 506, 507, 507, 507, 510, 510, 503, 
	513, 513, 503, 499, 499, 518, 519, 519, 
	519, 522, 522, 519, 519, 519, 525, 525, 
	525, 525, 531, 532, 532, 532, 532, 540, 
	532, 532, 532, 532, 545, 532, 532, 532, 
	532, 532, 532, 551, 552, 553, 553, 0, 
	560, 561, 0, 567, 0, 574, 578, 578, 
	579, 0, 0, 588, 589, 593, 593, 594, 
	0, 599, 0, 602, 0, 605, 605, 606, 
	607, 0, 648, 650, 651, 652, 653, 655, 
	657, 661, 661, 652, 652, 652, 652, 663, 
	652, 652, 657, 652, 652, 648, 667, 667, 
	667, 667, 667, 667, 657, 657, 673, 673, 
	673, 673, 673, 673, 673, 673, 673, 673, 
	673, 673, 673, 673, 673, 673, 673, 673, 
	673, 673, 673, 673, 673, 673, 673, 673, 
	673, 673, 673, 673, 673, 673, 673, 673, 
	673, 706, 673, 673, 673, 673, 673, 673, 
	673, 673, 673, 673, 673, 673, 673, 673, 
	673, 673, 673, 673, 673, 673, 673, 673, 
	673, 673, 673, 673, 673, 673, 673, 673, 
	673, 673, 673, 673, 673, 673, 673, 673, 
	673, 673, 673, 673, 673, 673, 673, 673, 
	673, 652, 0, 750, 751, 752, 754, 750, 
	750, 758, 0, 777, 779, 781, 782, 783, 
	784, 785, 787, 784, 784, 784, 784, 784, 
	790, 784, 784, 792, 790, 790, 784, 0, 
	811, 812, 116, 116, 815, 816, 116, 812, 
	812, 819, 821, 824, 812, 825, 812, 826, 
	827, 829, 831, 812, 819, 832, 832, 821, 
	832, 836, 832, 832, 832, 832, 0, 191, 
	844, 845, 844, 844, 0, 854, 855, 857, 
	859, 861, 859, 863, 0, 875, 876, 877, 
	878, 880, 882, 884, 885, 885, 885, 885, 
	885, 885, 885, 885, 885, 885, 885, 885, 
	885, 885, 885, 885, 0, 943, 946, 949, 
	950, 954, 956, 957, 958, 959, 960, 962, 
	965, 966, 968, 970, 973, 975, 976, 213, 
	973, 978, 973, 965, 980, 982, 965, 965, 
	1000, 1003, 1005, 1006, 1010, 1013, 1014, 1015, 
	1016, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 
	1000, 1000, 1000, 1020, 1024, 1026, 1000, 1000, 
	965, 1031, 1032, 1032, 1032, 965, 965, 965, 
	1033, 1040, 1040, 1042, 1044, 1053, 1054, 1055, 
	1055, 1055, 1058, 1058, 1060, 1061, 1062, 1062, 
	1062, 1064, 1065, 1066, 1066, 1066, 1069, 1069, 
	1062, 1072, 1072, 1062, 1058, 1058, 1077, 1078, 
	1078, 1078, 1081, 1081, 1078, 1078, 1078, 1084, 
	1084, 1084, 1084, 1090, 1091, 1091, 1091, 1091, 
	1099, 1091, 1091, 1091, 1091, 1105, 1091, 1091, 
	1091, 1091, 1091, 1091, 1091, 1091, 1091, 1091, 
	1091, 1091, 1091, 1091, 1091, 1091, 1091, 1091, 
	1091, 1123, 1124, 1125, 1125, 213, 965, 965, 
	1129, 965, 960, 943, 943, 943, 943, 943, 
	943, 943, 943, 943, 943, 943, 213, 943, 
	943, 943, 943, 943, 943, 943, 943, 943, 
	943, 943, 943, 943, 943, 943, 943, 943, 
	943, 943, 943, 943, 943, 943, 943, 943, 
	943, 943, 943, 943, 943, 943, 943, 943, 
	943, 943, 943, 943, 943, 943, 943, 943, 
	943, 943, 943, 943, 943, 943, 943, 1182, 
	950, 943, 943, 943, 943, 943, 943, 943, 
	943, 943, 943, 943, 943, 943, 943, 943, 
	943, 943, 943, 943, 943, 943, 943, 943, 
	943, 943, 1207, 965, 0, 1215, 1216, 1217, 
	1219, 1221, 1223, 0, 1232, 1233, 1234, 1235, 
	1237, 1232, 1240, 0, 315, 1295, 1297, 1298, 
	1299, 1300, 1302, 1304, 1306, 1309, 1309, 315, 
	1311, 1313, 1314, 1315, 1311, 1317, 1319, 1319, 
	1322, 1322, 1325, 1336, 315, 1342, 1344, 1346, 
	1347, 1350, 1351, 1325, 1325, 1354, 1354, 1354, 
	1360, 1362, 1363, 1366, 1368, 1369, 1370, 1354, 
	1354, 1377, 1382, 1387, 1354, 1354, 1394, 1394, 
	1354, 1354, 1319, 1311, 1311, 1319, 1311, 1311, 
	1306, 315, 1412, 1413, 1413, 1413, 1413, 1413, 
	1413, 1419, 1306, 1422, 1423, 1424, 1424, 1424, 
	1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 
	1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 
	1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 
	1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 
	1424, 1463, 1464, 1424, 1424, 1468, 1424, 1424, 
	1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 
	1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 
	1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 
	1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 
	1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 
	1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 
	1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 
	1424, 1424, 1424, 1424, 1522, 1300, 1523, 0, 
	1529, 1530, 1531, 1533, 1529, 1529, 1529, 0, 
	1538, 1538, 1538, 1538, 1542
]

class << self
	attr_accessor :lex_start
end
self.lex_start = 187;
class << self
	attr_accessor :lex_error
end
self.lex_error = 0;

class << self
	attr_accessor :lex_en_interp_words
end
self.lex_en_interp_words = 196;
class << self
	attr_accessor :lex_en_interp_string
end
self.lex_en_interp_string = 262;
class << self
	attr_accessor :lex_en_plain_words
end
self.lex_en_plain_words = 327;
class << self
	attr_accessor :lex_en_plain_string
end
self.lex_en_plain_string = 330;
class << self
	attr_accessor :lex_en_interp_backslash_delimited
end
self.lex_en_interp_backslash_delimited = 332;
class << self
	attr_accessor :lex_en_plain_backslash_delimited
end
self.lex_en_plain_backslash_delimited = 337;
class << self
	attr_accessor :lex_en_interp_backslash_delimited_words
end
self.lex_en_interp_backslash_delimited_words = 338;
class << self
	attr_accessor :lex_en_plain_backslash_delimited_words
end
self.lex_en_plain_backslash_delimited_words = 344;
class << self
	attr_accessor :lex_en_regexp_modifiers
end
self.lex_en_regexp_modifiers = 346;
class << self
	attr_accessor :lex_en_expr_variable
end
self.lex_en_expr_variable = 348;
class << self
	attr_accessor :lex_en_expr_fname
end
self.lex_en_expr_fname = 353;
class << self
	attr_accessor :lex_en_expr_endfn
end
self.lex_en_expr_endfn = 466;
class << self
	attr_accessor :lex_en_expr_dot
end
self.lex_en_expr_dot = 474;
class << self
	attr_accessor :lex_en_expr_arg
end
self.lex_en_expr_arg = 495;
class << self
	attr_accessor :lex_en_expr_cmdarg
end
self.lex_en_expr_cmdarg = 526;
class << self
	attr_accessor :lex_en_expr_endarg
end
self.lex_en_expr_endarg = 532;
class << self
	attr_accessor :lex_en_expr_mid
end
self.lex_en_expr_mid = 540;
class << self
	attr_accessor :lex_en_expr_beg
end
self.lex_en_expr_beg = 564;
class << self
	attr_accessor :lex_en_expr_labelarg
end
self.lex_en_expr_labelarg = 796;
class << self
	attr_accessor :lex_en_expr_value
end
self.lex_en_expr_value = 803;
class << self
	attr_accessor :lex_en_expr_end
end
self.lex_en_expr_end = 811;
class << self
	attr_accessor :lex_en_leading_dot
end
self.lex_en_leading_dot = 991;
class << self
	attr_accessor :lex_en_line_comment
end
self.lex_en_line_comment = 999;
class << self
	attr_accessor :lex_en_line_begin
end
self.lex_en_line_begin = 187;


# line 82 "lib/parser/lexer.rl"
  # %

  ESCAPES = {
    ?a.ord => "\a", ?b.ord  => "\b", ?e.ord => "\e", ?f.ord => "\f",
    ?n.ord => "\n", ?r.ord  => "\r", ?s.ord => "\s", ?t.ord => "\t",
    ?v.ord => "\v", ?\\.ord => "\\"
  }.freeze

  REGEXP_META_CHARACTERS = Regexp.union(*"\\$()*+.<>?[]^{|}".chars).freeze

  attr_reader   :source_buffer

  attr_accessor :diagnostics
  attr_accessor :static_env
  attr_accessor :force_utf32

  attr_accessor :cond, :cmdarg, :in_kwarg, :context, :command_start

  attr_accessor :tokens, :comments

  attr_reader :paren_nest, :cmdarg_stack, :cond_stack, :lambda_stack

  def initialize(version)
    @version    = version
    @static_env = nil
    @context    = nil

    @tokens     = nil
    @comments   = nil

    reset
  end

  def reset(reset_state=true)
    # Ragel state:
    if reset_state
      # Unit tests set state prior to resetting lexer.
      @cs     = self.class.lex_en_line_begin

      @cond   = StackState.new('cond')
      @cmdarg = StackState.new('cmdarg')
      @cond_stack   = []
      @cmdarg_stack = []
    end

    @force_utf32   = false # Set to true by some tests

    @source_pts    = nil # @source as a codepoint array

    @p             = 0   # stream position (saved manually in #advance)
    @ts            = nil # token start
    @te            = nil # token end
    @act           = 0   # next action

    @stack         = []  # state stack
    @top           = 0   # state stack top pointer

    # Lexer state:
    @token_queue   = []
    @literal_stack = []

    @eq_begin_s    = nil # location of last encountered =begin
    @sharp_s       = nil # location of last encountered #

    @newline_s     = nil # location of last encountered newline

    @num_base      = nil # last numeric base
    @num_digits_s  = nil # starting position of numeric digits
    @num_suffix_s  = nil # starting position of numeric suffix
    @num_xfrm      = nil # numeric suffix-induced transformation

    @escape_s      = nil # starting position of current sequence
    @escape        = nil # last escaped sequence, as string

    @herebody_s    = nil # starting position of current heredoc line

    # Ruby 1.9 ->() lambdas emit a distinct token if do/{ is
    # encountered after a matching closing parenthesis.
    @paren_nest    = 0
    @lambda_stack  = []

    # After encountering the closing line of <<~SQUIGGLY_HEREDOC,
    # we store the indentation level and give it out to the parser
    # on request. It is not possible to infer indentation level just
    # from the AST because escape sequences such as `\ ` or `\t` are
    # expanded inside the lexer, but count as non-whitespace for
    # indentation purposes.
    @dedent_level  = nil

    # If the lexer is in `command state' (aka expr_value)
    # at the entry to #advance, it will transition to expr_cmdarg
    # instead of expr_arg at certain points.
    @command_start = true

    # True at the end of "def foo a:"
    @in_kwarg      = false

    # State before =begin / =end block comment
    @cs_before_block_comment = self.class.lex_en_line_begin
  end

  def source_buffer=(source_buffer)
    @source_buffer = source_buffer

    if @source_buffer
      source = @source_buffer.source

      if source.encoding == Encoding::UTF_8
        @source_pts = source.unpack('U*')
      else
        @source_pts = source.unpack('C*')
      end

      if @source_pts[0] == 0xfeff
        # Skip byte order mark.
        @p = 1
      end
    else
      @source_pts = nil
    end
  end

  def encoding
    @source_buffer.source.encoding
  end

  LEX_STATES = {
    :line_begin    => lex_en_line_begin,
    :expr_dot      => lex_en_expr_dot,
    :expr_fname    => lex_en_expr_fname,
    :expr_value    => lex_en_expr_value,
    :expr_beg      => lex_en_expr_beg,
    :expr_mid      => lex_en_expr_mid,
    :expr_arg      => lex_en_expr_arg,
    :expr_cmdarg   => lex_en_expr_cmdarg,
    :expr_end      => lex_en_expr_end,
    :expr_endarg   => lex_en_expr_endarg,
    :expr_endfn    => lex_en_expr_endfn,
    :expr_labelarg => lex_en_expr_labelarg,

    :interp_string => lex_en_interp_string,
    :interp_words  => lex_en_interp_words,
    :plain_string  => lex_en_plain_string,
    :plain_words   => lex_en_plain_string,
  }

  def state
    LEX_STATES.invert.fetch(@cs, @cs)
  end

  def state=(state)
    @cs = LEX_STATES.fetch(state)
  end

  def push_cmdarg
    @cmdarg_stack.push(@cmdarg)
    @cmdarg = StackState.new("cmdarg.#{@cmdarg_stack.count}")
  end

  def pop_cmdarg
    @cmdarg = @cmdarg_stack.pop
  end

  def push_cond
    @cond_stack.push(@cond)
    @cond = StackState.new("cond.#{@cond_stack.count}")
  end

  def pop_cond
    @cond = @cond_stack.pop
  end

  def dedent_level
    # We erase @dedent_level as a precaution to avoid accidentally
    # using a stale value.
    dedent_level, @dedent_level = @dedent_level, nil
    dedent_level
  end

  # Return next token: [type, value].
  def advance
    if @token_queue.any?
      return @token_queue.shift
    end

    # Ugly, but dependent on Ragel output. Consider refactoring it somehow.
    klass = self.class
    _lex_trans_keys         = klass.send :_lex_trans_keys
    _lex_key_spans          = klass.send :_lex_key_spans
    _lex_index_offsets      = klass.send :_lex_index_offsets
    _lex_indicies           = klass.send :_lex_indicies
    _lex_trans_targs        = klass.send :_lex_trans_targs
    _lex_trans_actions      = klass.send :_lex_trans_actions
    _lex_to_state_actions   = klass.send :_lex_to_state_actions
    _lex_from_state_actions = klass.send :_lex_from_state_actions
    _lex_eof_trans          = klass.send :_lex_eof_trans

    pe = @source_pts.size + 2
    p, eof = @p, pe

    cmd_state = @command_start
    @command_start = false

    
# line 11330 "lib/parser/lexer.rb"
begin
	testEof = false
	_slen, _trans, _keys, _inds, _acts, _nacts = nil
	_goto_level = 0
	_resume = 10
	_eof_trans = 15
	_again = 20
	_test_eof = 30
	_out = 40
	while true
	if _goto_level <= 0
	if p == pe
		_goto_level = _test_eof
		next
	end
	if  @cs == 0
		_goto_level = _out
		next
	end
	end
	if _goto_level <= _resume
	case _lex_from_state_actions[ @cs] 
	when 97 then
# line 1 "NONE"
		begin
 @ts = p
		end
# line 11358 "lib/parser/lexer.rb"
	end
	_keys =  @cs << 1
	_inds = _lex_index_offsets[ @cs]
	_slen = _lex_key_spans[ @cs]
	_wide = ( (@source_pts[p] || 0))
	_trans = if (   _slen > 0 && 
			_lex_trans_keys[_keys] <= _wide && 
			_wide <= _lex_trans_keys[_keys + 1] 
		    ) then
			_lex_indicies[ _inds + _wide - _lex_trans_keys[_keys] ] 
		 else 
			_lex_indicies[ _inds + _slen ]
		 end
	end
	if _goto_level <= _eof_trans
	 @cs = _lex_trans_targs[_trans]
	if _lex_trans_actions[_trans] != 0
	case _lex_trans_actions[_trans]
	when 29 then
# line 501 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
	when 117 then
# line 825 "lib/parser/lexer.rl"
		begin

    @escape_s = p
    @escape   = nil
  		end
	when 30 then
# line 865 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
	when 60 then
# line 1229 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
	when 64 then
# line 1232 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
	when 310 then
# line 1273 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 37 then
# line 1566 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 39 then
# line 1586 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 41 then
# line 1614 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 71 then
# line 1806 "lib/parser/lexer.rl"
		begin
 heredoc_e      = p 		end
	when 349 then
# line 1898 "lib/parser/lexer.rl"
		begin
 tm = p - 1; diag_msg = :ivar_name 		end
	when 352 then
# line 1899 "lib/parser/lexer.rl"
		begin
 tm = p - 2; diag_msg = :cvar_name 		end
	when 360 then
# line 1919 "lib/parser/lexer.rl"
		begin
 @escape = nil 		end
	when 392 then
# line 2008 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 308 then
# line 2115 "lib/parser/lexer.rl"
		begin
 ident_tok = tok; ident_ts = @ts; ident_te = @te; 		end
	when 479 then
# line 2301 "lib/parser/lexer.rl"
		begin
 @num_base = 16; @num_digits_s = p 		end
	when 473 then
# line 2302 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = p 		end
	when 476 then
# line 2303 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = p 		end
	when 470 then
# line 2304 "lib/parser/lexer.rl"
		begin
 @num_base = 2;  @num_digits_s = p 		end
	when 485 then
# line 2305 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = @ts 		end
	when 447 then
# line 2306 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = @ts 		end
	when 462 then
# line 2307 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 455 then
# line 2364 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 452 then
# line 2365 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 89 then
# line 2575 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 7 then
# line 1 "NONE"
		begin
 @te = p+1
		end
	when 113 then
# line 1106 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DBEG, '#{'.freeze)

    if current_literal.heredoc?
      current_literal.saved_herebody_s = @herebody_s
      @herebody_s = nil
    end

    current_literal.start_interp_brace
    @command_start = true
     @cs = 803;
    	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 5 then
# line 1032 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 348
		_goto_level = _again
		next
	end

   end
		end
	when 109 then
# line 957 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 108 then
# line 874 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 796;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 115 then
# line 1048 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    if @version >= 27
      literal.extend_string(tok, @ts, @te)
    else
      message = tok.start_with?('#@@') ? :cvar_name : :ivar_name
      diagnostic :error, message, { :name => tok(@ts + 1, @te) }, range(@ts + 1, @te)
    end
   end
		end
	when 114 then
# line 1032 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 348
		_goto_level = _again
		next
	end

   end
		end
	when 111 then
# line 1019 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    literal.extend_space @ts, @te
   end
		end
	when 112 then
# line 874 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 796;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 6 then
# line 898 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 4 then
# line 874 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 796;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 145 then
# line 1106 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DBEG, '#{'.freeze)

    if current_literal.heredoc?
      current_literal.saved_herebody_s = @herebody_s
      @herebody_s = nil
    end

    current_literal.start_interp_brace
    @command_start = true
     @cs = 803;
    	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 10 then
# line 1032 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 348
		_goto_level = _again
		next
	end

   end
		end
	when 142 then
# line 957 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 141 then
# line 874 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 796;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 147 then
# line 1048 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    if @version >= 27
      literal.extend_string(tok, @ts, @te)
    else
      message = tok.start_with?('#@@') ? :cvar_name : :ivar_name
      diagnostic :error, message, { :name => tok(@ts + 1, @te) }, range(@ts + 1, @te)
    end
   end
		end
	when 146 then
# line 1032 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 348
		_goto_level = _again
		next
	end

   end
		end
	when 144 then
# line 874 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 796;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 11 then
# line 898 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 9 then
# line 874 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 796;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 173 then
# line 957 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 172 then
# line 874 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 796;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 175 then
# line 1019 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    literal.extend_space @ts, @te
   end
		end
	when 176 then
# line 874 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 796;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 179 then
# line 957 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 178 then
# line 874 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 796;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 181 then
# line 874 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 796;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 188 then
# line 1106 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DBEG, '#{'.freeze)

    if current_literal.heredoc?
      current_literal.saved_herebody_s = @herebody_s
      @herebody_s = nil
    end

    current_literal.start_interp_brace
    @command_start = true
     @cs = 803;
    	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 13 then
# line 1032 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 348
		_goto_level = _again
		next
	end

   end
		end
	when 185 then
# line 957 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 184 then
# line 874 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 796;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 190 then
# line 1048 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    if @version >= 27
      literal.extend_string(tok, @ts, @te)
    else
      message = tok.start_with?('#@@') ? :cvar_name : :ivar_name
      diagnostic :error, message, { :name => tok(@ts + 1, @te) }, range(@ts + 1, @te)
    end
   end
		end
	when 189 then
# line 1032 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 348
		_goto_level = _again
		next
	end

   end
		end
	when 187 then
# line 874 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 796;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 12 then
# line 874 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 796;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 192 then
# line 957 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 191 then
# line 874 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 796;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 199 then
# line 1106 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DBEG, '#{'.freeze)

    if current_literal.heredoc?
      current_literal.saved_herebody_s = @herebody_s
      @herebody_s = nil
    end

    current_literal.start_interp_brace
    @command_start = true
     @cs = 803;
    	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 15 then
# line 1032 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 348
		_goto_level = _again
		next
	end

   end
		end
	when 195 then
# line 957 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 194 then
# line 874 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 796;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 201 then
# line 1048 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    if @version >= 27
      literal.extend_string(tok, @ts, @te)
    else
      message = tok.start_with?('#@@') ? :cvar_name : :ivar_name
      diagnostic :error, message, { :name => tok(@ts + 1, @te) }, range(@ts + 1, @te)
    end
   end
		end
	when 200 then
# line 1032 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 348
		_goto_level = _again
		next
	end

   end
		end
	when 197 then
# line 1019 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    literal.extend_space @ts, @te
   end
		end
	when 198 then
# line 874 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 796;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 14 then
# line 874 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 796;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 203 then
# line 957 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 202 then
# line 874 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 796;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 205 then
# line 1019 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    literal.extend_space @ts, @te
   end
		end
	when 206 then
# line 1203 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tREGEXP_OPT, tok(@ts, @te - 1), @ts, @te - 1)
        p = p - 1;
        	begin
		 @cs = 811
		_goto_level = _again
		next
	end

       end
		end
	when 207 then
# line 1190 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        unknown_options = tok.scan(/[^imxouesn]/)
        if unknown_options.any?
          diagnostic :error, :regexp_options,
                     { :options => unknown_options.join }
        end

        emit(:tREGEXP_OPT)
         @cs = 811;
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 16 then
# line 1342 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        if    tok =~ /^\$([1-9][0-9]*)$/
          emit(:tNTH_REF, tok(@ts + 1).to_i)
        elsif tok =~ /^\$([&`'+])$/
          emit(:tBACK_REF)
        else
          emit(:tGVAR)
        end

         @cs = (stack_pop); 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 208 then
# line 1342 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if    tok =~ /^\$([1-9][0-9]*)$/
          emit(:tNTH_REF, tok(@ts + 1).to_i)
        elsif tok =~ /^\$([&`'+])$/
          emit(:tBACK_REF)
        else
          emit(:tGVAR)
        end

         @cs = (stack_pop); 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 210 then
# line 1355 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if tok =~ /^@@[0-9]/
          diagnostic :error, :cvar_name, { :name => tok }
        end

        emit(:tCVAR)
         @cs = (stack_pop); 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 209 then
# line 1365 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if tok =~ /^@[0-9]/
          diagnostic :error, :ivar_name, { :name => tok }
        end

        emit(:tIVAR)
         @cs = (stack_pop); 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 231 then
# line 1386 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_table(KEYWORDS_BEGIN);
            @cs = 466; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 217 then
# line 1394 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit(:tIDENTIFIER)
            @cs = 466; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 18 then
# line 1398 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = @ts - 1
            @cs = 811; 	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 348
		_goto_level = _again
		next
	end
  end
		end
	when 214 then
# line 1407 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_table(PUNCTUATION)
            @cs = 466; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 226 then
# line 1411 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; p = p - 1; 	begin
		 @cs = 811
		_goto_level = _again
		next
	end
  end
		end
	when 20 then
# line 1417 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        if version?(23)
          type, delimiter = tok[0..-2], tok[-1].chr
          	begin
		 @cs = (push_literal(type, delimiter, @ts))
		_goto_level = _again
		next
	end

        else
          p = @ts - 1
          	begin
		 @cs = 811
		_goto_level = _again
		next
	end

        end
       end
		end
	when 213 then
# line 1430 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 811
		_goto_level = _again
		next
	end
  end
		end
	when 212 then
# line 528 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 230 then
# line 1386 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(KEYWORDS_BEGIN);
            @cs = 466; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 227 then
# line 1390 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tCONSTANT)
            @cs = 466; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 229 then
# line 1394 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tIDENTIFIER)
            @cs = 466; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 224 then
# line 1398 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
            @cs = 811; 	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 348
		_goto_level = _again
		next
	end
  end
		end
	when 220 then
# line 1407 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(PUNCTUATION)
            @cs = 466; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 225 then
# line 1414 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 564
		_goto_level = _again
		next
	end
  end
		end
	when 218 then
# line 1427 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 223 then
# line 1430 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 811
		_goto_level = _again
		next
	end
  end
		end
	when 19 then
# line 1407 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  emit_table(PUNCTUATION)
            @cs = 466; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 17 then
# line 1430 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  p = p - 1; 	begin
		 @cs = 811
		_goto_level = _again
		next
	end
  end
		end
	when 216 then
# line 1 "NONE"
		begin
	case  @act
	when 43 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS_BEGIN);
            @cs = 466; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 44 then
	begin begin p = (( @te))-1; end
 emit(:tCONSTANT)
            @cs = 466; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 45 then
	begin begin p = (( @te))-1; end
 emit(:tIDENTIFIER)
            @cs = 466; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
end 
			end
	when 22 then
# line 1442 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit(:tLABEL, tok(@ts, @te - 2), @ts, @te - 1)
           p = p - 1;  @cs = 796; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 233 then
# line 1460 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 811
		_goto_level = _again
		next
	end
  end
		end
	when 232 then
# line 528 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 235 then
# line 1457 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 234 then
# line 1460 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 811
		_goto_level = _again
		next
	end
  end
		end
	when 21 then
# line 1460 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  p = p - 1; 	begin
		 @cs = 811
		_goto_level = _again
		next
	end
  end
		end
	when 241 then
# line 1486 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_table(PUNCTUATION)
            @cs = 495; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 240 then
# line 1492 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 811
		_goto_level = _again
		next
	end
  end
		end
	when 239 then
# line 528 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 251 then
# line 1471 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tCONSTANT)
            @cs = (arg_or_cmdarg(cmd_state)); 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 242 then
# line 1475 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tIDENTIFIER)
            @cs = (arg_or_cmdarg(cmd_state)); 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 247 then
# line 1486 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(PUNCTUATION)
            @cs = 495; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 245 then
# line 1489 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 250 then
# line 1492 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 811
		_goto_level = _again
		next
	end
  end
		end
	when 274 then
# line 1552 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        # Unlike expr_beg as invoked in the next rule, do not warn
        p = @ts - 1
        	begin
		 @cs = 811
		_goto_level = _again
		next
	end

       end
		end
	when 257 then
# line 1570 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        if tok(tm, tm + 1) == '/'.freeze
          # Ambiguous regexp literal.
          if @version < 30
            diagnostic :warning, :ambiguous_literal, nil, range(tm, tm + 1)
          else
            diagnostic :warning, :ambiguous_regexp, nil, range(tm, tm + 1)
          end
        end

        p = tm - 1
        	begin
		 @cs = 564
		_goto_level = _again
		next
	end

       end
		end
	when 263 then
# line 1598 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; p = p - 1; 	begin
		 @cs = 564
		_goto_level = _again
		next
	end
  end
		end
	when 25 then
# line 1606 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = @ts - 1; 	begin
		 @cs = 564
		_goto_level = _again
		next
	end
  end
		end
	when 265 then
# line 1615 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = tm - 1; 	begin
		 @cs = 811
		_goto_level = _again
		next
	end
  end
		end
	when 40 then
# line 1626 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        p = @ts - 1
        	begin
		 @cs = 811
		_goto_level = _again
		next
	end

       end
		end
	when 252 then
# line 1640 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 564
		_goto_level = _again
		next
	end
  end
		end
	when 253 then
# line 528 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 264 then
# line 1561 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 564
		_goto_level = _again
		next
	end
  end
		end
	when 260 then
# line 1587 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        diagnostic :warning, :ambiguous_prefix, { :prefix => tok(tm, @te) },
                   range(tm, @te)

        p = tm - 1
        	begin
		 @cs = 564
		_goto_level = _again
		next
	end

       end
		end
	when 262 then
# line 1603 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 564
		_goto_level = _again
		next
	end
  end
		end
	when 256 then
# line 1626 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        p = @ts - 1
        	begin
		 @cs = 811
		_goto_level = _again
		next
	end

       end
		end
	when 255 then
# line 1631 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 273 then
# line 1640 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 564
		_goto_level = _again
		next
	end
  end
		end
	when 26 then
# line 1631 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
		end
	when 42 then
# line 1640 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  p = p - 1; 	begin
		 @cs = 564
		_goto_level = _again
		next
	end
  end
		end
	when 24 then
# line 1 "NONE"
		begin
	case  @act
	when 72 then
	begin begin p = (( @te))-1; end

        if tok(tm, tm + 1) == '/'.freeze
          # Ambiguous regexp literal.
          if @version < 30
            diagnostic :warning, :ambiguous_literal, nil, range(tm, tm + 1)
          else
            diagnostic :warning, :ambiguous_regexp, nil, range(tm, tm + 1)
          end
        end

        p = tm - 1
        	begin
		 @cs = 564
		_goto_level = _again
		next
	end

      end
	when 73 then
	begin begin p = (( @te))-1; end

        diagnostic :warning, :ambiguous_prefix, { :prefix => tok(tm, @te) },
                   range(tm, @te)

        p = tm - 1
        	begin
		 @cs = 564
		_goto_level = _again
		next
	end

      end
	when 78 then
	begin begin p = (( @te))-1; end

        p = @ts - 1
        	begin
		 @cs = 811
		_goto_level = _again
		next
	end

      end
	else
	begin begin p = (( @te))-1; end
end
end 
			end
	when 44 then
# line 1676 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = @ts - 1
           	begin
		 @cs = 495
		_goto_level = _again
		next
	end
  end
		end
	when 278 then
# line 528 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 279 then
# line 1676 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
           	begin
		 @cs = 495
		_goto_level = _again
		next
	end
  end
		end
	when 45 then
# line 1676 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  p = @ts - 1
           	begin
		 @cs = 495
		_goto_level = _again
		next
	end
  end
		end
	when 43 then
# line 1 "NONE"
		begin
	case  @act
	when 85 then
	begin begin p = (( @te))-1; end

        if @cond.active?
          emit(:kDO_COND, 'do'.freeze, @te - 2, @te)
        else
          emit(:kDO, 'do'.freeze, @te - 2, @te)
        end
         @cs = 803; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 86 then
	begin begin p = (( @te))-1; end
 p = @ts - 1
           	begin
		 @cs = 495
		_goto_level = _again
		next
	end
 end
end 
			end
	when 289 then
# line 1712 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_do(true)
            @cs = 803; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 282 then
# line 1718 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 811
		_goto_level = _again
		next
	end
  end
		end
	when 283 then
# line 528 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 284 then
# line 1715 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 287 then
# line 1718 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 811
		_goto_level = _again
		next
	end
  end
		end
	when 293 then
# line 1742 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 564
		_goto_level = _again
		next
	end
  end
		end
	when 292 then
# line 528 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 301 then
# line 1734 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1; 	begin
		 @cs = 564
		_goto_level = _again
		next
	end
  end
		end
	when 295 then
# line 1736 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 299 then
# line 1742 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 564
		_goto_level = _again
		next
	end
  end
		end
	when 294 then
# line 1 "NONE"
		begin
	case  @act
	when 93 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 564; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 94 then
	begin begin p = (( @te))-1; end
 p = @ts - 1; 	begin
		 @cs = 564
		_goto_level = _again
		next
	end
 end
end 
			end
	when 57 then
# line 1757 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tUNARY_NUM, tok(@ts, @ts + 1), @ts, @ts + 1)
        p = p - 1;  @cs = 811; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 334 then
# line 1774 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        type = delimiter = tok[0].chr
        p = p - 1; 	begin
		 @cs = (push_literal(type, delimiter, @ts))
		_goto_level = _again
		next
	end

       end
		end
	when 326 then
# line 1781 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        type, delimiter = @source_buffer.slice(@ts).chr, tok[-1].chr
        	begin
		 @cs = (push_literal(type, delimiter, @ts))
		_goto_level = _again
		next
	end

       end
		end
	when 55 then
# line 1788 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        type, delimiter = tok[0..-2], tok[-1].chr
        	begin
		 @cs = (push_literal(type, delimiter, @ts))
		_goto_level = _again
		next
	end

       end
		end
	when 347 then
# line 1863 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        p = p - 1; p = p - 1;
        emit(:tSYMBEG, tok(@ts, @ts + 1), @ts, @ts + 1)
        	begin
		 @cs = 353
		_goto_level = _again
		next
	end

       end
		end
	when 335 then
# line 1871 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        type, delimiter = tok, tok[-1].chr
        	begin
		 @cs = (push_literal(type, delimiter, @ts))
		_goto_level = _again
		next
	end

       end
		end
	when 346 then
# line 1879 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tSYMBOL, tok(@ts + 1, @ts + 2))
         @cs = 811; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 69 then
# line 1893 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tSYMBOL, tok(@ts + 1), @ts)
         @cs = 811; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 357 then
# line 1934 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        escape = { " "  => '\s', "\r" => '\r', "\n" => '\n', "\t" => '\t',
                   "\v" => '\v', "\f" => '\f' }[@source_buffer.slice(@ts + 1)]
        diagnostic :warning, :invalid_escape_use, { :escape => escape }, range

        p = @ts - 1
        	begin
		 @cs = 811
		_goto_level = _again
		next
	end

       end
		end
	when 356 then
# line 1944 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        diagnostic :fatal, :incomplete_escape, nil, range(@ts, @ts + 1)
       end
		end
	when 336 then
# line 2003 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_table(PUNCTUATION_BEGIN)
           	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 52 then
# line 2024 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        p = p - 1;

        if version?(18)
          ident = tok(@ts, @te - 2)

          emit((@source_buffer.slice(@ts) =~ /[A-Z]/) ? :tCONSTANT : :tIDENTIFIER,
               ident, @ts, @te - 2)
          p = p - 1; # continue as a symbol

          if !@static_env.nil? && @static_env.declared?(ident)
             @cs = 811;
          else
             @cs = (arg_or_cmdarg(cmd_state));
          end
        else
          emit(:tLABEL, tok(@ts, @te - 2), @ts, @te - 1)
           @cs = 796;
        end

        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 49 then
# line 2117 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tIDENTIFIER, ident_tok, ident_ts, ident_te)
        p = ident_te - 1

        if !@static_env.nil? && @static_env.declared?(ident_tok) && @version < 25
           @cs = 466;
        else
           @cs = 526;
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 320 then
# line 2136 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        p = @ts - 1
        @cs_before_block_comment = @cs
        	begin
		 @cs = 187
		_goto_level = _again
		next
	end

       end
		end
	when 56 then
# line 2152 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = @ts - 1; 	begin
		 @cs = 811
		_goto_level = _again
		next
	end
  end
		end
	when 304 then
# line 528 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 330 then
# line 1757 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tUNARY_NUM, tok(@ts, @ts + 1), @ts, @ts + 1)
        p = p - 1;  @cs = 811; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 329 then
# line 1764 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tSTAR, '*'.freeze)
           	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 325 then
# line 1794 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        diagnostic :fatal, :string_eof, nil, range(@ts, @ts + 1)
       end
		end
	when 354 then
# line 1854 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        diagnostic :error, :unterminated_heredoc_id, nil, range(@ts, @ts + 1)
       end
		end
	when 337 then
# line 1893 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1), @ts)
         @cs = 811; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 350 then
# line 1901 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if @version >= 27
          diagnostic :error, diag_msg, { name: tok(tm, @te) }, range(tm, @te)
        else
          emit(:tCOLON, tok(@ts, @ts + 1), @ts, @ts + 1)
          p = @ts
        end

         @cs = 811; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 355 then
# line 1944 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        diagnostic :fatal, :incomplete_escape, nil, range(@ts, @ts + 1)
       end
		end
	when 361 then
# line 1950 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        p = @ts - 1
        	begin
		 @cs = 811
		_goto_level = _again
		next
	end

       end
		end
	when 327 then
# line 2003 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(PUNCTUATION_BEGIN)
           	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 331 then
# line 2051 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if @version >= 27
          emit(:tBDOT2)
        else
          emit(:tDOT2)
        end

         @cs = 564; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 332 then
# line 2062 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        # Here we scan and conditionally emit "\n":
        # + if it's there
        #   + and emitted we do nothing
        #   + and not emitted we return `p` to "\n" to process it on the next scan
        # + if it's not there we do nothing
        followed_by_nl = @te - 1 == @newline_s
        nl_emitted = false
        dots_te = followed_by_nl ? @te - 1 : @te

        if @version >= 30
          if @lambda_stack.any? && @lambda_stack.last + 1 == @paren_nest
            # To reject `->(...)` like `->...`
            emit(:tDOT3, '...'.freeze, @ts, dots_te)
          else
            emit(:tBDOT3, '...'.freeze, @ts, dots_te)

            if @version >= 31 && followed_by_nl && @context.in_def_open_args?
              emit(:tNL, @te - 1, @te)
              nl_emitted = true
            end
          end
        elsif @version >= 27
          emit(:tBDOT3, '...'.freeze, @ts, dots_te)
        else
          emit(:tDOT3, '...'.freeze, @ts, dots_te)
        end

        if followed_by_nl && !nl_emitted
          # return "\n" to process it on the next scan
          p = p - 1;
        end

         @cs = 564; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 307 then
# line 1327 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    emit(:tIDENTIFIER)

    if !@static_env.nil? && @static_env.declared?(tok)
       @cs = 466; 	begin
		p += 1
		_goto_level = _out
		next
	end

    else
       @cs = (arg_or_cmdarg(cmd_state)); 	begin
		p += 1
		_goto_level = _out
		next
	end

    end
   end
		end
	when 317 then
# line 2133 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 319 then
# line 2136 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        p = @ts - 1
        @cs_before_block_comment = @cs
        	begin
		 @cs = 187
		_goto_level = _again
		next
	end

       end
		end
	when 322 then
# line 2152 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1; 	begin
		 @cs = 811
		_goto_level = _again
		next
	end
  end
		end
	when 54 then
# line 1794 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
        diagnostic :fatal, :string_eof, nil, range(@ts, @ts + 1)
       end
		end
	when 73 then
# line 1854 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
        diagnostic :error, :unterminated_heredoc_id, nil, range(@ts, @ts + 1)
       end
		end
	when 74 then
# line 1921 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 811; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 48 then
# line 1327 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
    emit(:tIDENTIFIER)

    if !@static_env.nil? && @static_env.declared?(tok)
       @cs = 466; 	begin
		p += 1
		_goto_level = _out
		next
	end

    else
       @cs = (arg_or_cmdarg(cmd_state)); 	begin
		p += 1
		_goto_level = _out
		next
	end

    end
   end
		end
	when 53 then
# line 2133 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
		end
	when 68 then
# line 2152 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  p = @ts - 1; 	begin
		 @cs = 811
		_goto_level = _again
		next
	end
  end
		end
	when 51 then
# line 1 "NONE"
		begin
	case  @act
	when 99 then
	begin begin p = (( @te))-1; end

        emit(:tUNARY_NUM, tok(@ts, @ts + 1), @ts, @ts + 1)
        p = p - 1;  @cs = 811; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 106 then
	begin begin p = (( @te))-1; end

        diagnostic :error, :unterminated_heredoc_id, nil, range(@ts, @ts + 1)
      end
	when 117 then
	begin begin p = (( @te))-1; end

        if @version >= 27
          emit(:tPIPE, tok(@ts, @ts + 1), @ts, @ts + 1)
          p = p - 1;
           @cs = 564; 	begin
		p += 1
		_goto_level = _out
		next
	end

        else
          p -= 2
          	begin
		 @cs = 811
		_goto_level = _again
		next
	end

        end
      end
	when 121 then
	begin begin p = (( @te))-1; end
 emit_table(PUNCTUATION_BEGIN)
           	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 122 then
	begin begin p = (( @te))-1; end
 emit(:kRESCUE, 'rescue'.freeze, @ts, tm)
           p = tm - 1
            @cs = 540; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 123 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS_BEGIN)
           @command_start = true
            @cs = 803; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 127 then
	begin begin p = (( @te))-1; end
 p = @ts - 1
           	begin
		 @cs = 811
		_goto_level = _again
		next
	end
 end
	when 128 then
	begin begin p = (( @te))-1; end

    emit(:tIDENTIFIER)

    if !@static_env.nil? && @static_env.declared?(tok)
       @cs = 466; 	begin
		p += 1
		_goto_level = _out
		next
	end

    else
       @cs = (arg_or_cmdarg(cmd_state)); 	begin
		p += 1
		_goto_level = _out
		next
	end

    end
  end
	when 132 then
	begin begin p = (( @te))-1; end
 p = @ts - 1; 	begin
		 @cs = 811
		_goto_level = _again
		next
	end
 end
end 
			end
	when 395 then
# line 2172 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 564
		_goto_level = _again
		next
	end
  end
		end
	when 396 then
# line 528 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 397 then
# line 2160 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 401 then
# line 2172 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 564
		_goto_level = _again
		next
	end
  end
		end
	when 77 then
# line 2182 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = @ts - 1
           	begin
		 @cs = 811
		_goto_level = _again
		next
	end
  end
		end
	when 405 then
# line 2187 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        	begin
		 @cs = (push_literal(tok, tok, @ts))
		_goto_level = _again
		next
	end

       end
		end
	when 404 then
# line 2197 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 564
		_goto_level = _again
		next
	end
  end
		end
	when 403 then
# line 528 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 407 then
# line 2191 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 406 then
# line 2197 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 564
		_goto_level = _again
		next
	end
  end
		end
	when 76 then
# line 2197 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  p = p - 1; 	begin
		 @cs = 564
		_goto_level = _again
		next
	end
  end
		end
	when 440 then
# line 2208 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tLAMBDA, '->'.freeze, @ts, @ts + 2)

        @lambda_stack.push @paren_nest
         @cs = 466; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 86 then
# line 2249 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit(:kCLASS, 'class'.freeze, @ts, @ts + 5)
           emit(:tLSHFT, '<<'.freeze,    @te - 2, @te)
            @cs = 803; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 415 then
# line 2385 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        type, delimiter = tok, tok[-1].chr
        	begin
		 @cs = (push_literal(type, delimiter, @ts, nil, false, false, true))
		_goto_level = _again
		next
	end

       end
		end
	when 79 then
# line 2403 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = @ts - 1; 	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 348
		_goto_level = _again
		next
	end
  end
		end
	when 436 then
# line 2410 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_table(PUNCTUATION)
            @cs = 474; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 489 then
# line 2434 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit_table(PUNCTUATION)
         @cs = 803; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 429 then
# line 2443 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit_table(PUNCTUATION);
         @cs = 803; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 434 then
# line 2478 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit(:tOP_ASGN, tok(@ts, @te - 1))
            @cs = 564; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 420 then
# line 2482 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit(:tEH, '?'.freeze)
            @cs = 803; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 417 then
# line 2501 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_table(PUNCTUATION)
            @cs = 564; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 419 then
# line 2514 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit(:tSEMI, ';'.freeze)
           @command_start = true
            @cs = 803; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 494 then
# line 2518 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        diagnostic :error, :bare_backslash, nil, range(@ts, @ts + 1)
        p = p - 1;
       end
		end
	when 414 then
# line 2524 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        diagnostic :fatal, :unexpected, { :character => tok.inspect[1..-2] }
       end
		end
	when 413 then
# line 528 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 505 then
# line 2245 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(KEYWORDS)
            @cs = 353; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 503 then
# line 2249 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:kCLASS, 'class'.freeze, @ts, @ts + 5)
           emit(:tLSHFT, '<<'.freeze,    @te - 2, @te)
            @cs = 803; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 502 then
# line 2260 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(KEYWORDS)
           @command_start = true
            @cs = 803; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 444 then
# line 2335 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        diagnostic :error, :no_dot_digit_literal
       end
		end
	when 491 then
# line 2395 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tCONSTANT)
            @cs = (arg_or_cmdarg(cmd_state)); 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 433 then
# line 2403 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1; 	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 348
		_goto_level = _again
		next
	end
  end
		end
	when 441 then
# line 2410 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(PUNCTUATION)
            @cs = 474; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 497 then
# line 1327 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    emit(:tIDENTIFIER)

    if !@static_env.nil? && @static_env.declared?(tok)
       @cs = 466; 	begin
		p += 1
		_goto_level = _out
		next
	end

    else
       @cs = (arg_or_cmdarg(cmd_state)); 	begin
		p += 1
		_goto_level = _out
		next
	end

    end
   end
		end
	when 439 then
# line 2434 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit_table(PUNCTUATION)
         @cs = 803; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 435 then
# line 2443 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit_table(PUNCTUATION);
         @cs = 803; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 428 then
# line 2449 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(PUNCTUATION)
            @cs = 564; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 442 then
# line 2501 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(PUNCTUATION)
            @cs = 564; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 426 then
# line 2508 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 432 then
# line 2524 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        diagnostic :fatal, :unexpected, { :character => tok.inspect[1..-2] }
       end
		end
	when 84 then
# line 2308 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 80 then
# line 2335 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
        diagnostic :error, :no_dot_digit_literal
       end
		end
	when 83 then
# line 2367 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 78 then
# line 2524 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
        diagnostic :fatal, :unexpected, { :character => tok.inspect[1..-2] }
       end
		end
	when 81 then
# line 1 "NONE"
		begin
	case  @act
	when 145 then
	begin begin p = (( @te))-1; end

        if @lambda_stack.last == @paren_nest
          @lambda_stack.pop

          if tok == '{'.freeze
            emit(:tLAMBEG, '{'.freeze)
          else # 'do'
            emit(:kDO_LAMBDA, 'do'.freeze)
          end
        else
          if tok == '{'.freeze
            emit(:tLCURLY, '{'.freeze)
          else # 'do'
            emit_do
          end
        end
        if tok == '{'.freeze
          @paren_nest += 1
        end
        @command_start = true

         @cs = 803; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 146 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 353; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 147 then
	begin begin p = (( @te))-1; end
 emit(:kCLASS, 'class'.freeze, @ts, @ts + 5)
           emit(:tLSHFT, '<<'.freeze,    @te - 2, @te)
            @cs = 803; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 148 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 564; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 149 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
           @command_start = true
            @cs = 803; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 150 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 540; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 151 then
	begin begin p = (( @te))-1; end

        emit_table(KEYWORDS)

        if version?(18) && tok == 'not'.freeze
           @cs = 564; 	begin
		p += 1
		_goto_level = _out
		next
	end

        else
           @cs = 495; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
      end
	when 152 then
	begin begin p = (( @te))-1; end

        if version?(18)
          emit(:tIDENTIFIER)

          unless !@static_env.nil? && @static_env.declared?(tok)
             @cs = (arg_or_cmdarg(cmd_state));
          end
        else
          emit(:k__ENCODING__, '__ENCODING__'.freeze)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 153 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
           	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 154 then
	begin begin p = (( @te))-1; end

        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 156 then
	begin begin p = (( @te))-1; end

        if version?(18, 19, 20)
          diagnostic :error,
                     :trailing_in_number, { :character => tok(@te - 1, @te) },
                     range(@te - 1, @te)
        else
          emit(:tINTEGER, tok(@ts, @te - 1).to_i, @ts, @te - 1)
          p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
      end
	when 157 then
	begin begin p = (( @te))-1; end

        if version?(18, 19, 20)
          diagnostic :error,
                     :trailing_in_number, { :character => tok(@te - 1, @te) },
                     range(@te - 1, @te)
        else
          emit(:tFLOAT, tok(@ts, @te - 1).to_f, @ts, @te - 1)
          p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
      end
	when 158 then
	begin begin p = (( @te))-1; end

        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 160 then
	begin begin p = (( @te))-1; end
 emit(:tCONSTANT)
            @cs = (arg_or_cmdarg(cmd_state)); 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 164 then
	begin begin p = (( @te))-1; end

    emit(:tIDENTIFIER)

    if !@static_env.nil? && @static_env.declared?(tok)
       @cs = 466; 	begin
		p += 1
		_goto_level = _out
		next
	end

    else
       @cs = (arg_or_cmdarg(cmd_state)); 	begin
		p += 1
		_goto_level = _out
		next
	end

    end
  end
	when 165 then
	begin begin p = (( @te))-1; end

        if tm == @te
          # Suffix was consumed, e.g. foo!
          emit(:tFID)
        else
          # Suffix was not consumed, e.g. foo!=
          emit(:tIDENTIFIER, tok(@ts, tm), @ts, tm)
          p = tm - 1
        end
         @cs = 495; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 167 then
	begin begin p = (( @te))-1; end

        emit_table(PUNCTUATION);
         @cs = 803; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 168 then
	begin begin p = (( @te))-1; end
 emit_table(PUNCTUATION)
            @cs = 564; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
end 
			end
	when 516 then
# line 2565 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tNL, nil, @newline_s, @newline_s + 1)
        if @version < 27
          p = p - 1;  @cs = 187; 	begin
		p += 1
		_goto_level = _out
		next
	end

        else
          emit(:tBDOT3)
           @cs = 564; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
       end
		end
	when 95 then
# line 2576 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = tm - 1; 	begin
		 @cs = 811
		_goto_level = _again
		next
	end
  end
		end
	when 510 then
# line 2579 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit(:tNL, nil, @newline_s, @newline_s + 1)
           p = p - 1;  @cs = 187; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 513 then
# line 2540 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if @version < 27
          # Ruby before 2.7 doesn't support comments before leading dot.
          # If a line after "a" starts with a comment then "a" is a self-contained statement.
          # So in that case we emit a special tNL token and start reading the
          # next line as a separate statement.
          #
          # Note: block comments before leading dot are not supported on any version of Ruby.
          emit(:tNL, nil, @newline_s, @newline_s + 1)
          p = p - 1;  @cs = 187; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
       end
		end
	when 515 then
# line 2554 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tNL, nil, @newline_s, @newline_s + 1)
        if @version < 27
          p = p - 1;  @cs = 187; 	begin
		p += 1
		_goto_level = _out
		next
	end

        else
          emit(:tBDOT2)
           @cs = 564; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
       end
		end
	when 514 then
# line 2576 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = tm - 1; 	begin
		 @cs = 811
		_goto_level = _again
		next
	end
  end
		end
	when 512 then
# line 2579 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tNL, nil, @newline_s, @newline_s + 1)
           p = p - 1;  @cs = 187; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 90 then
# line 2540 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
        if @version < 27
          # Ruby before 2.7 doesn't support comments before leading dot.
          # If a line after "a" starts with a comment then "a" is a self-contained statement.
          # So in that case we emit a special tNL token and start reading the
          # next line as a separate statement.
          #
          # Note: block comments before leading dot are not supported on any version of Ruby.
          emit(:tNL, nil, @newline_s, @newline_s + 1)
          p = p - 1;  @cs = 187; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
       end
		end
	when 87 then
# line 2579 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  emit(:tNL, nil, @newline_s, @newline_s + 1)
           p = p - 1;  @cs = 187; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 91 then
# line 1 "NONE"
		begin
	case  @act
	when 181 then
	begin begin p = (( @te))-1; end

        if @version < 27
          # Ruby before 2.7 doesn't support comments before leading dot.
          # If a line after "a" starts with a comment then "a" is a self-contained statement.
          # So in that case we emit a special tNL token and start reading the
          # next line as a separate statement.
          #
          # Note: block comments before leading dot are not supported on any version of Ruby.
          emit(:tNL, nil, @newline_s, @newline_s + 1)
          p = p - 1;  @cs = 187; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
      end
	when 185 then
	begin begin p = (( @te))-1; end
 emit(:tNL, nil, @newline_s, @newline_s + 1)
           p = p - 1;  @cs = 187; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
end 
			end
	when 519 then
# line 2589 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit_comment(@eq_begin_s, @te)
        	begin
		 @cs = (@cs_before_block_comment)
		_goto_level = _again
		next
	end

       end
		end
	when 518 then
# line 2597 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        diagnostic :fatal, :embedded_document, nil,
                   range(@eq_begin_s, @eq_begin_s + '=begin'.length)
       end
		end
	when 106 then
# line 2607 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  @eq_begin_s = @ts
           	begin
		 @cs = 999
		_goto_level = _again
		next
	end
  end
		end
	when 2 then
# line 2611 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = pe - 3  end
		end
	when 98 then
# line 2614 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  cmd_state = true; p = p - 1; 	begin
		 @cs = 803
		_goto_level = _again
		next
	end
  end
		end
	when 99 then
# line 528 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 100 then
# line 2604 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 105 then
# line 2607 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  @eq_begin_s = @ts
           	begin
		 @cs = 999
		_goto_level = _again
		next
	end
  end
		end
	when 104 then
# line 2614 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  cmd_state = true; p = p - 1; 	begin
		 @cs = 803
		_goto_level = _again
		next
	end
  end
		end
	when 1 then
# line 2614 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  cmd_state = true; p = p - 1; 	begin
		 @cs = 803
		_goto_level = _again
		next
	end
  end
		end
	when 67 then
# line 501 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 1232 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
	when 110 then
# line 501 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 957 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 143 then
# line 501 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 957 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 174 then
# line 501 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 957 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 180 then
# line 501 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 957 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 186 then
# line 501 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 957 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 193 then
# line 501 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 957 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 196 then
# line 501 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 957 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 204 then
# line 501 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 957 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 23 then
# line 501 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 1446 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        if @version >= 31
          emit(:tBDOT3, '...'.freeze, @ts, @te - 1)
          emit(:tNL, "\n".freeze, @te - 1, @te)
           @cs = 811; 	begin
		p += 1
		_goto_level = _out
		next
	end

        else
          p -= 4;
          p = p - 1; 	begin
		 @cs = 811
		_goto_level = _again
		next
	end

        end
       end
		end
	when 275 then
# line 501 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 1552 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        # Unlike expr_beg as invoked in the next rule, do not warn
        p = @ts - 1
        	begin
		 @cs = 811
		_goto_level = _again
		next
	end

       end
		end
	when 266 then
# line 501 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 1615 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = tm - 1; 	begin
		 @cs = 811
		_goto_level = _again
		next
	end
  end
		end
	when 258 then
# line 501 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 1626 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        p = @ts - 1
        	begin
		 @cs = 811
		_goto_level = _again
		next
	end

       end
		end
	when 358 then
# line 501 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 1934 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        escape = { " "  => '\s', "\r" => '\r', "\n" => '\n', "\t" => '\t',
                   "\v" => '\v', "\f" => '\f' }[@source_buffer.slice(@ts + 1)]
        diagnostic :warning, :invalid_escape_use, { :escape => escape }, range

        p = @ts - 1
        	begin
		 @cs = 811
		_goto_level = _again
		next
	end

       end
		end
	when 333 then
# line 501 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 2062 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        # Here we scan and conditionally emit "\n":
        # + if it's there
        #   + and emitted we do nothing
        #   + and not emitted we return `p` to "\n" to process it on the next scan
        # + if it's not there we do nothing
        followed_by_nl = @te - 1 == @newline_s
        nl_emitted = false
        dots_te = followed_by_nl ? @te - 1 : @te

        if @version >= 30
          if @lambda_stack.any? && @lambda_stack.last + 1 == @paren_nest
            # To reject `->(...)` like `->...`
            emit(:tDOT3, '...'.freeze, @ts, dots_te)
          else
            emit(:tBDOT3, '...'.freeze, @ts, dots_te)

            if @version >= 31 && followed_by_nl && @context.in_def_open_args?
              emit(:tNL, @te - 1, @te)
              nl_emitted = true
            end
          end
        elsif @version >= 27
          emit(:tBDOT3, '...'.freeze, @ts, dots_te)
        else
          emit(:tDOT3, '...'.freeze, @ts, dots_te)
        end

        if followed_by_nl && !nl_emitted
          # return "\n" to process it on the next scan
          p = p - 1;
        end

         @cs = 564; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 321 then
# line 501 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 2136 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        p = @ts - 1
        @cs_before_block_comment = @cs
        	begin
		 @cs = 187
		_goto_level = _again
		next
	end

       end
		end
	when 443 then
# line 501 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 2490 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        if @paren_nest == 0
          diagnostic :warning, :triple_dot_at_eol, nil, range(@ts, @te - 1)
        end

        emit(:tDOT3, '...'.freeze, @ts, @te - 1)
        p = p - 1;
         @cs = 564; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 520 then
# line 501 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 2589 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit_comment(@eq_begin_s, @te)
        	begin
		 @cs = (@cs_before_block_comment)
		_goto_level = _again
		next
	end

       end
		end
	when 517 then
# line 501 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 2594 "lib/parser/lexer.rl"
		begin
 @te = p+1
		end
	when 107 then
# line 501 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 2607 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  @eq_begin_s = @ts
           	begin
		 @cs = 999
		_goto_level = _again
		next
	end
  end
		end
	when 3 then
# line 501 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 2611 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = pe - 3  end
		end
	when 465 then
# line 636 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tRATIONAL,  Rational(chars)) } 		end
# line 2308 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 463 then
# line 637 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tIMAGINARY, Complex(0, chars)) } 		end
# line 2308 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 468 then
# line 638 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tIMAGINARY, Complex(0, Rational(chars))) } 		end
# line 2308 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 466 then
# line 639 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars, @ts, @te - 2); p -= 2 } 		end
# line 2308 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 464 then
# line 640 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars, @ts, @te - 2); p -= 2 } 		end
# line 2308 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 467 then
# line 641 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars, @ts, @te - 6); p -= 6 } 		end
# line 2308 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 456 then
# line 645 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tIMAGINARY, Complex(0, Float(chars))) } 		end
# line 2367 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 457 then
# line 646 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tFLOAT,     Float(chars), @ts, @te - 2); p -= 2 } 		end
# line 2367 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 458 then
# line 650 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tRATIONAL,  Rational(chars)) } 		end
# line 2367 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 460 then
# line 651 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tIMAGINARY, Complex(0, Rational(chars))) } 		end
# line 2367 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 459 then
# line 652 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tFLOAT,     Float(chars), @ts, @te - 6); p -= 6 } 		end
# line 2367 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 137 then
# line 667 "lib/parser/lexer.rl"
		begin

    @escape = ""

    codepoints  = tok(@escape_s + 2, p - 1)
    codepoint_s = @escape_s + 2

    if @version < 24
      if codepoints.start_with?(" ") || codepoints.start_with?("\t")
        diagnostic :fatal, :invalid_unicode_escape, nil,
          range(@escape_s + 2, @escape_s + 3)
      end

      if spaces_p = codepoints.index(/[ \t]{2}/)
        diagnostic :fatal, :invalid_unicode_escape, nil,
          range(codepoint_s + spaces_p + 1, codepoint_s + spaces_p + 2)
      end

      if codepoints.end_with?(" ") || codepoints.end_with?("\t")
        diagnostic :fatal, :invalid_unicode_escape, nil, range(p - 1, p)
      end
    end

    codepoints.scan(/([0-9a-fA-F]+)|([ \t]+)/).each do |(codepoint_str, spaces)|
      if spaces
        codepoint_s += spaces.length
      else
        codepoint = codepoint_str.to_i(16)

        if codepoint >= 0x110000
          diagnostic :error, :unicode_point_too_large, nil,
                     range(codepoint_s, codepoint_s + codepoint_str.length)
          break
        end

        @escape     += codepoint.chr(Encoding::UTF_8)
        codepoint_s += codepoint_str.length
      end
    end
  		end
# line 898 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 168 then
# line 667 "lib/parser/lexer.rl"
		begin

    @escape = ""

    codepoints  = tok(@escape_s + 2, p - 1)
    codepoint_s = @escape_s + 2

    if @version < 24
      if codepoints.start_with?(" ") || codepoints.start_with?("\t")
        diagnostic :fatal, :invalid_unicode_escape, nil,
          range(@escape_s + 2, @escape_s + 3)
      end

      if spaces_p = codepoints.index(/[ \t]{2}/)
        diagnostic :fatal, :invalid_unicode_escape, nil,
          range(codepoint_s + spaces_p + 1, codepoint_s + spaces_p + 2)
      end

      if codepoints.end_with?(" ") || codepoints.end_with?("\t")
        diagnostic :fatal, :invalid_unicode_escape, nil, range(p - 1, p)
      end
    end

    codepoints.scan(/([0-9a-fA-F]+)|([ \t]+)/).each do |(codepoint_str, spaces)|
      if spaces
        codepoint_s += spaces.length
      else
        codepoint = codepoint_str.to_i(16)

        if codepoint >= 0x110000
          diagnostic :error, :unicode_point_too_large, nil,
                     range(codepoint_s, codepoint_s + codepoint_str.length)
          break
        end

        @escape     += codepoint.chr(Encoding::UTF_8)
        codepoint_s += codepoint_str.length
      end
    end
  		end
# line 898 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 382 then
# line 667 "lib/parser/lexer.rl"
		begin

    @escape = ""

    codepoints  = tok(@escape_s + 2, p - 1)
    codepoint_s = @escape_s + 2

    if @version < 24
      if codepoints.start_with?(" ") || codepoints.start_with?("\t")
        diagnostic :fatal, :invalid_unicode_escape, nil,
          range(@escape_s + 2, @escape_s + 3)
      end

      if spaces_p = codepoints.index(/[ \t]{2}/)
        diagnostic :fatal, :invalid_unicode_escape, nil,
          range(codepoint_s + spaces_p + 1, codepoint_s + spaces_p + 2)
      end

      if codepoints.end_with?(" ") || codepoints.end_with?("\t")
        diagnostic :fatal, :invalid_unicode_escape, nil, range(p - 1, p)
      end
    end

    codepoints.scan(/([0-9a-fA-F]+)|([ \t]+)/).each do |(codepoint_str, spaces)|
      if spaces
        codepoint_s += spaces.length
      else
        codepoint = codepoint_str.to_i(16)

        if codepoint >= 0x110000
          diagnostic :error, :unicode_point_too_large, nil,
                     range(codepoint_s, codepoint_s + codepoint_str.length)
          break
        end

        @escape     += codepoint.chr(Encoding::UTF_8)
        codepoint_s += codepoint_str.length
      end
    end
  		end
# line 1921 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 811; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 118 then
# line 707 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]

    if @version >= 30 && (codepoint == 117 || codepoint == 85) # 'u' or 'U'
      diagnostic :fatal, :invalid_escape
    end

    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 898 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 149 then
# line 707 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]

    if @version >= 30 && (codepoint == 117 || codepoint == 85) # 'u' or 'U'
      diagnostic :fatal, :invalid_escape
    end

    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 898 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 363 then
# line 707 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]

    if @version >= 30 && (codepoint == 117 || codepoint == 85) # 'u' or 'U'
      diagnostic :fatal, :invalid_escape
    end

    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 1921 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 811; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 121 then
# line 719 "lib/parser/lexer.rl"
		begin

    diagnostic :fatal, :invalid_escape
  		end
# line 898 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 152 then
# line 719 "lib/parser/lexer.rl"
		begin

    diagnostic :fatal, :invalid_escape
  		end
# line 898 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 366 then
# line 719 "lib/parser/lexer.rl"
		begin

    diagnostic :fatal, :invalid_escape
  		end
# line 1921 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 811; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 123 then
# line 747 "lib/parser/lexer.rl"
		begin
 @escape = "\x7f" 		end
# line 898 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 154 then
# line 747 "lib/parser/lexer.rl"
		begin
 @escape = "\x7f" 		end
# line 898 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 368 then
# line 747 "lib/parser/lexer.rl"
		begin
 @escape = "\x7f" 		end
# line 1921 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 811; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 120 then
# line 755 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(@escape_s, p).to_i(8) % 0x100) 		end
# line 898 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 151 then
# line 755 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(@escape_s, p).to_i(8) % 0x100) 		end
# line 898 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 365 then
# line 755 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(@escape_s, p).to_i(8) % 0x100) 		end
# line 1921 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 811; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 140 then
# line 759 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(@escape_s + 1, p).to_i(16)) 		end
# line 898 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 171 then
# line 759 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(@escape_s + 1, p).to_i(16)) 		end
# line 898 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 385 then
# line 759 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(@escape_s + 1, p).to_i(16)) 		end
# line 1921 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 811; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 139 then
# line 763 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_hex_escape, nil, range(@escape_s - 1, p + 2)
      		end
# line 898 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 170 then
# line 763 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_hex_escape, nil, range(@escape_s - 1, p + 2)
      		end
# line 898 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 384 then
# line 763 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_hex_escape, nil, range(@escape_s - 1, p + 2)
      		end
# line 1921 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 811; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 134 then
# line 769 "lib/parser/lexer.rl"
		begin
 @escape = tok(@escape_s + 1, p).to_i(16).chr(Encoding::UTF_8) 		end
# line 898 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 165 then
# line 769 "lib/parser/lexer.rl"
		begin
 @escape = tok(@escape_s + 1, p).to_i(16).chr(Encoding::UTF_8) 		end
# line 898 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 379 then
# line 769 "lib/parser/lexer.rl"
		begin
 @escape = tok(@escape_s + 1, p).to_i(16).chr(Encoding::UTF_8) 		end
# line 1921 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 811; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 133 then
# line 773 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
      		end
# line 898 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 164 then
# line 773 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
      		end
# line 898 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 378 then
# line 773 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
      		end
# line 1921 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 811; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 138 then
# line 779 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
      		end
# line 898 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 169 then
# line 779 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
      		end
# line 898 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 383 then
# line 779 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
      		end
# line 1921 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 811; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 135 then
# line 793 "lib/parser/lexer.rl"
		begin

          diagnostic :fatal, :unterminated_unicode, nil, range(p - 1, p)
        		end
# line 898 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 166 then
# line 793 "lib/parser/lexer.rl"
		begin

          diagnostic :fatal, :unterminated_unicode, nil, range(p - 1, p)
        		end
# line 898 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 380 then
# line 793 "lib/parser/lexer.rl"
		begin

          diagnostic :fatal, :unterminated_unicode, nil, range(p - 1, p)
        		end
# line 1921 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 811; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 119 then
# line 819 "lib/parser/lexer.rl"
		begin

      diagnostic :fatal, :escape_eof, nil, range(p - 1, p)
    		end
# line 898 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 150 then
# line 819 "lib/parser/lexer.rl"
		begin

      diagnostic :fatal, :escape_eof, nil, range(p - 1, p)
    		end
# line 898 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 364 then
# line 819 "lib/parser/lexer.rl"
		begin

      diagnostic :fatal, :escape_eof, nil, range(p - 1, p)
    		end
# line 1921 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 811; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 177 then
# line 825 "lib/parser/lexer.rl"
		begin

    @escape_s = p
    @escape   = nil
  		end
# line 898 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 182 then
# line 825 "lib/parser/lexer.rl"
		begin

    @escape_s = p
    @escape   = nil
  		end
# line 898 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 58 then
# line 865 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 501 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
	when 31 then
# line 865 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1566 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 33 then
# line 865 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1586 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 35 then
# line 865 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1614 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 219 then
# line 865 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1427 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 238 then
# line 865 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1457 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 246 then
# line 865 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1489 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 34 then
# line 865 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1626 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        p = @ts - 1
        	begin
		 @cs = 811
		_goto_level = _again
		next
	end

       end
		end
	when 277 then
# line 865 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1631 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 269 then
# line 865 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1637 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 811
		_goto_level = _again
		next
	end
  end
		end
	when 288 then
# line 865 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1715 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 300 then
# line 865 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1736 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 296 then
# line 865 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1739 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 811
		_goto_level = _again
		next
	end
  end
		end
	when 59 then
# line 865 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1757 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tUNARY_NUM, tok(@ts, @ts + 1), @ts, @ts + 1)
        p = p - 1;  @cs = 811; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 50 then
# line 865 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 2117 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tIDENTIFIER, ident_tok, ident_ts, ident_te)
        p = ident_te - 1

        if !@static_env.nil? && @static_env.declared?(ident_tok) && @version < 25
           @cs = 466;
        else
           @cs = 526;
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 318 then
# line 865 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 2133 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 402 then
# line 865 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 2160 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 398 then
# line 865 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 2163 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
      if @in_kwarg
        p = p - 1; 	begin
		 @cs = 811
		_goto_level = _again
		next
	end

      else
        	begin
		 @cs = 187
		_goto_level = _again
		next
	end

      end
     end
		end
	when 411 then
# line 865 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 2191 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 408 then
# line 865 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 2194 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  	begin
		 @cs = 187
		_goto_level = _again
		next
	end
  end
		end
	when 495 then
# line 865 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 2508 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 427 then
# line 865 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 2511 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  	begin
		 @cs = 991
		_goto_level = _again
		next
	end
  end
		end
	when 101 then
# line 865 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 2604 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 268 then
# line 1071 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    current_literal = literal
    if current_literal
      current_literal.start_interp_brace
    end
  		end
# line 1533 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if @lambda_stack.last == @paren_nest
          @lambda_stack.pop
          emit(:tLAMBEG, '{'.freeze, @te - 1, @te)
        else
          emit(:tLCURLY, '{'.freeze, @te - 1, @te)
        end
        @command_start = true
        @paren_nest += 1
         @cs = 803; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 290 then
# line 1071 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    current_literal = literal
    if current_literal
      current_literal.start_interp_brace
    end
  		end
# line 1699 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if @lambda_stack.last == @paren_nest
          @lambda_stack.pop
          emit(:tLAMBEG, '{'.freeze)
        else
          emit(:tLBRACE_ARG, '{'.freeze)
        end
        @paren_nest += 1
        @command_start = true
         @cs = 803; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 393 then
# line 1071 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    current_literal = literal
    if current_literal
      current_literal.start_interp_brace
    end
  		end
# line 1979 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if @lambda_stack.last == @paren_nest
          @lambda_stack.pop
          @command_start = true
          emit(:tLAMBEG, '{'.freeze)
        else
          emit(:tLBRACE, '{'.freeze)
        end
        @paren_nest += 1
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 508 then
# line 1071 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    current_literal = literal
    if current_literal
      current_literal.start_interp_brace
    end
  		end
# line 2216 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if @lambda_stack.last == @paren_nest
          @lambda_stack.pop

          if tok == '{'.freeze
            emit(:tLAMBEG, '{'.freeze)
          else # 'do'
            emit(:kDO_LAMBDA, 'do'.freeze)
          end
        else
          if tok == '{'.freeze
            emit(:tLCURLY, '{'.freeze)
          else # 'do'
            emit_do
          end
        end
        if tok == '{'.freeze
          @paren_nest += 1
        end
        @command_start = true

         @cs = 803; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 509 then
# line 1080 "lib/parser/lexer.rl"
		begin

    current_literal = literal
    if current_literal
      if current_literal.end_interp_brace_and_try_closing
        if version?(18, 19)
          emit(:tRCURLY, '}'.freeze, p - 1, p)
          @cond.lexpop
          @cmdarg.lexpop
        else
          emit(:tSTRING_DEND, '}'.freeze, p - 1, p)
        end

        if current_literal.saved_herebody_s
          @herebody_s = current_literal.saved_herebody_s
        end


        p = p - 1;
         @cs = (next_state_for_literal(current_literal));
        	begin
		p += 1
		_goto_level = _out
		next
	end

      end
    end

    @paren_nest -= 1
  		end
# line 2453 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit_table(PUNCTUATION)

        if @version < 24
          @cond.lexpop
          @cmdarg.lexpop
        else
          @cond.pop
          @cmdarg.pop
        end

        if tok == '}'.freeze || tok == ']'.freeze
          if @version >= 25
             @cs = 811;
          else
             @cs = 532;
          end
        else # )
          # fnext expr_endfn; ?
        end

        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 61 then
# line 1229 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1232 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
	when 65 then
# line 1232 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 501 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
	when 222 then
# line 1232 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1427 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 237 then
# line 1232 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1457 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 249 then
# line 1232 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1489 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 271 then
# line 1232 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1634 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  	begin
		 @cs = 811
		_goto_level = _again
		next
	end
  end
		end
	when 286 then
# line 1232 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1715 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 298 then
# line 1232 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1736 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 324 then
# line 1232 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2133 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 400 then
# line 1232 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2160 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 410 then
# line 1232 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2191 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 431 then
# line 1232 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2508 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 103 then
# line 1232 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2604 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 243 then
# line 1273 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1479 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tFID, tok(@ts, tm), @ts, tm)
            @cs = (arg_or_cmdarg(cmd_state)); p = tm - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 338 then
# line 1273 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1885 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 811; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 309 then
# line 1273 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 2106 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
           	begin
		 @cs = 811
		_goto_level = _again
		next
	end
  end
		end
	when 424 then
# line 1273 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1 "NONE"
		begin
	case  @act
	when 145 then
	begin begin p = (( @te))-1; end

        if @lambda_stack.last == @paren_nest
          @lambda_stack.pop

          if tok == '{'.freeze
            emit(:tLAMBEG, '{'.freeze)
          else # 'do'
            emit(:kDO_LAMBDA, 'do'.freeze)
          end
        else
          if tok == '{'.freeze
            emit(:tLCURLY, '{'.freeze)
          else # 'do'
            emit_do
          end
        end
        if tok == '{'.freeze
          @paren_nest += 1
        end
        @command_start = true

         @cs = 803; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 146 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 353; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 147 then
	begin begin p = (( @te))-1; end
 emit(:kCLASS, 'class'.freeze, @ts, @ts + 5)
           emit(:tLSHFT, '<<'.freeze,    @te - 2, @te)
            @cs = 803; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 148 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 564; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 149 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
           @command_start = true
            @cs = 803; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 150 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 540; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 151 then
	begin begin p = (( @te))-1; end

        emit_table(KEYWORDS)

        if version?(18) && tok == 'not'.freeze
           @cs = 564; 	begin
		p += 1
		_goto_level = _out
		next
	end

        else
           @cs = 495; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
      end
	when 152 then
	begin begin p = (( @te))-1; end

        if version?(18)
          emit(:tIDENTIFIER)

          unless !@static_env.nil? && @static_env.declared?(tok)
             @cs = (arg_or_cmdarg(cmd_state));
          end
        else
          emit(:k__ENCODING__, '__ENCODING__'.freeze)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 153 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
           	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 154 then
	begin begin p = (( @te))-1; end

        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 156 then
	begin begin p = (( @te))-1; end

        if version?(18, 19, 20)
          diagnostic :error,
                     :trailing_in_number, { :character => tok(@te - 1, @te) },
                     range(@te - 1, @te)
        else
          emit(:tINTEGER, tok(@ts, @te - 1).to_i, @ts, @te - 1)
          p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
      end
	when 157 then
	begin begin p = (( @te))-1; end

        if version?(18, 19, 20)
          diagnostic :error,
                     :trailing_in_number, { :character => tok(@te - 1, @te) },
                     range(@te - 1, @te)
        else
          emit(:tFLOAT, tok(@ts, @te - 1).to_f, @ts, @te - 1)
          p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
      end
	when 158 then
	begin begin p = (( @te))-1; end

        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 160 then
	begin begin p = (( @te))-1; end
 emit(:tCONSTANT)
            @cs = (arg_or_cmdarg(cmd_state)); 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 164 then
	begin begin p = (( @te))-1; end

    emit(:tIDENTIFIER)

    if !@static_env.nil? && @static_env.declared?(tok)
       @cs = 466; 	begin
		p += 1
		_goto_level = _out
		next
	end

    else
       @cs = (arg_or_cmdarg(cmd_state)); 	begin
		p += 1
		_goto_level = _out
		next
	end

    end
  end
	when 165 then
	begin begin p = (( @te))-1; end

        if tm == @te
          # Suffix was consumed, e.g. foo!
          emit(:tFID)
        else
          # Suffix was not consumed, e.g. foo!=
          emit(:tIDENTIFIER, tok(@ts, tm), @ts, tm)
          p = tm - 1
        end
         @cs = 495; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 167 then
	begin begin p = (( @te))-1; end

        emit_table(PUNCTUATION);
         @cs = 803; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 168 then
	begin begin p = (( @te))-1; end
 emit_table(PUNCTUATION)
            @cs = 564; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
end 
			end
	when 244 then
# line 1274 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1479 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tFID, tok(@ts, tm), @ts, tm)
            @cs = (arg_or_cmdarg(cmd_state)); p = tm - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 339 then
# line 1274 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1885 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 811; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 311 then
# line 1274 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 2106 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
           	begin
		 @cs = 811
		_goto_level = _again
		next
	end
  end
		end
	when 425 then
# line 1274 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 2417 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if tm == @te
          # Suffix was consumed, e.g. foo!
          emit(:tFID)
        else
          # Suffix was not consumed, e.g. foo!=
          emit(:tIDENTIFIER, tok(@ts, tm), @ts, tm)
          p = tm - 1
        end
         @cs = 495; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 340 then
# line 1279 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1885 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 811; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 312 then
# line 1279 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 2106 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
           	begin
		 @cs = 811
		_goto_level = _again
		next
	end
  end
		end
	when 341 then
# line 1280 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1885 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 811; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 313 then
# line 1280 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 2106 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
           	begin
		 @cs = 811
		_goto_level = _again
		next
	end
  end
		end
	when 345 then
# line 1281 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1885 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 811; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 316 then
# line 1281 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 2106 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
           	begin
		 @cs = 811
		_goto_level = _again
		next
	end
  end
		end
	when 344 then
# line 1282 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1885 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 811; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 315 then
# line 1282 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1 "NONE"
		begin
	case  @act
	when 99 then
	begin begin p = (( @te))-1; end

        emit(:tUNARY_NUM, tok(@ts, @ts + 1), @ts, @ts + 1)
        p = p - 1;  @cs = 811; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 106 then
	begin begin p = (( @te))-1; end

        diagnostic :error, :unterminated_heredoc_id, nil, range(@ts, @ts + 1)
      end
	when 117 then
	begin begin p = (( @te))-1; end

        if @version >= 27
          emit(:tPIPE, tok(@ts, @ts + 1), @ts, @ts + 1)
          p = p - 1;
           @cs = 564; 	begin
		p += 1
		_goto_level = _out
		next
	end

        else
          p -= 2
          	begin
		 @cs = 811
		_goto_level = _again
		next
	end

        end
      end
	when 121 then
	begin begin p = (( @te))-1; end
 emit_table(PUNCTUATION_BEGIN)
           	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 122 then
	begin begin p = (( @te))-1; end
 emit(:kRESCUE, 'rescue'.freeze, @ts, tm)
           p = tm - 1
            @cs = 540; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 123 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS_BEGIN)
           @command_start = true
            @cs = 803; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 127 then
	begin begin p = (( @te))-1; end
 p = @ts - 1
           	begin
		 @cs = 811
		_goto_level = _again
		next
	end
 end
	when 128 then
	begin begin p = (( @te))-1; end

    emit(:tIDENTIFIER)

    if !@static_env.nil? && @static_env.declared?(tok)
       @cs = 466; 	begin
		p += 1
		_goto_level = _out
		next
	end

    else
       @cs = (arg_or_cmdarg(cmd_state)); 	begin
		p += 1
		_goto_level = _out
		next
	end

    end
  end
	when 132 then
	begin begin p = (( @te))-1; end
 p = @ts - 1; 	begin
		 @cs = 811
		_goto_level = _again
		next
	end
 end
end 
			end
	when 342 then
# line 1283 "lib/parser/lexer.rl"
		begin
 tm = p - 3 		end
# line 1885 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 811; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 314 then
# line 1283 "lib/parser/lexer.rl"
		begin
 tm = p - 3 		end
# line 2106 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
           	begin
		 @cs = 811
		_goto_level = _again
		next
	end
  end
		end
	when 343 then
# line 1288 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1885 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 811; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 490 then
# line 1293 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 2399 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tCONSTANT, tok(@ts, tm), @ts, tm)
           p = tm - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 267 then
# line 1299 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    @paren_nest += 1
  		end
# line 1527 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tLBRACK, '['.freeze, @te - 1, @te)
            @cs = 564; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 386 then
# line 1299 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    @paren_nest += 1
  		end
# line 1993 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tLBRACK, '['.freeze)
           	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 493 then
# line 1299 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    @paren_nest += 1
  		end
# line 2486 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tLBRACK2, '['.freeze)
            @cs = 564; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 496 then
# line 1305 "lib/parser/lexer.rl"
		begin

    @paren_nest -= 1
  		end
# line 2453 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit_table(PUNCTUATION)

        if @version < 24
          @cond.lexpop
          @cmdarg.lexpop
        else
          @cond.pop
          @cmdarg.pop
        end

        if tok == '}'.freeze || tok == ']'.freeze
          if @version >= 25
             @cs = 811;
          else
             @cs = 532;
          end
        else # )
          # fnext expr_endfn; ?
        end

        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 259 then
# line 1312 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    @paren_nest += 1

    if version?(18)
      @command_start = true
    end
  		end
# line 1508 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if version?(18)
          emit(:tLPAREN2, '('.freeze, @te - 1, @te)
           @cs = 803; 	begin
		p += 1
		_goto_level = _out
		next
	end

        else
          emit(:tLPAREN_ARG, '('.freeze, @te - 1, @te)
           @cs = 564; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
       end
		end
	when 272 then
# line 1312 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    @paren_nest += 1

    if version?(18)
      @command_start = true
    end
  		end
# line 1521 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tLPAREN2, '('.freeze)
            @cs = 564; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 280 then
# line 1312 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    @paren_nest += 1

    if version?(18)
      @command_start = true
    end
  		end
# line 1653 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tLPAREN_ARG, '('.freeze, @te - 1, @te)
        if version?(18)
           @cs = 803; 	begin
		p += 1
		_goto_level = _out
		next
	end

        else
           @cs = 564; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
       end
		end
	when 328 then
# line 1312 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    @paren_nest += 1

    if version?(18)
      @command_start = true
    end
  		end
# line 1998 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tLPAREN, '('.freeze)
           	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 437 then
# line 1312 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    @paren_nest += 1

    if version?(18)
      @command_start = true
    end
  		end
# line 2449 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(PUNCTUATION)
            @cs = 564; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 438 then
# line 1322 "lib/parser/lexer.rl"
		begin

    @paren_nest -= 1
  		end
# line 2453 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit_table(PUNCTUATION)

        if @version < 24
          @cond.lexpop
          @cmdarg.lexpop
        else
          @cond.pop
          @cmdarg.pop
        end

        if tok == '}'.freeze || tok == ']'.freeze
          if @version >= 25
             @cs = 811;
          else
             @cs = 532;
          end
        else # )
          # fnext expr_endfn; ?
        end

        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 72 then
# line 1806 "lib/parser/lexer.rl"
		begin
 heredoc_e      = p 		end
# line 501 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
	when 353 then
# line 1807 "lib/parser/lexer.rl"
		begin
 new_herebody_s = p 		end
# line 1808 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        tok(@ts, heredoc_e) =~ /^<<(-?)(~?)(["'`]?)(.*)\3$/m

        indent      = !$1.empty? || !$2.empty?
        dedent_body = !$2.empty?
        type        =  $3.empty? ? '<<"'.freeze : ('<<'.freeze + $3)
        delimiter   =  $4

        if @version >= 27
          if delimiter.count("\n") > 0 || delimiter.count("\r") > 0
            diagnostic :error, :unterminated_heredoc_id, nil, range(@ts, @ts + 1)
          end
        elsif @version >= 24
          if delimiter.count("\n") > 0
            if delimiter.end_with?("\n")
              diagnostic :warning, :heredoc_id_ends_with_nl, nil, range(@ts, @ts + 1)
              delimiter = delimiter.rstrip
            else
              diagnostic :fatal, :heredoc_id_has_newline, nil, range(@ts, @ts + 1)
            end
          end
        end

        if dedent_body && version?(18, 19, 20, 21, 22)
          emit(:tLSHFT, '<<'.freeze, @ts, @ts + 2)
          p = @ts + 1
           @cs = 564; 	begin
		p += 1
		_goto_level = _out
		next
	end

        else
           @cs = (push_literal(type, delimiter, @ts, heredoc_e, indent, dedent_body));

          @herebody_s ||= new_herebody_s
          p = @herebody_s - 1
        end
       end
		end
	when 348 then
# line 1898 "lib/parser/lexer.rl"
		begin
 tm = p - 1; diag_msg = :ivar_name 		end
# line 1901 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if @version >= 27
          diagnostic :error, diag_msg, { name: tok(tm, @te) }, range(tm, @te)
        else
          emit(:tCOLON, tok(@ts, @ts + 1), @ts, @ts + 1)
          p = @ts
        end

         @cs = 811; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 351 then
# line 1899 "lib/parser/lexer.rl"
		begin
 tm = p - 2; diag_msg = :cvar_name 		end
# line 1901 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if @version >= 27
          diagnostic :error, diag_msg, { name: tok(tm, @te) }, range(tm, @te)
        else
          emit(:tCOLON, tok(@ts, @ts + 1), @ts, @ts + 1)
          p = @ts
        end

         @cs = 811; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 359 then
# line 1919 "lib/parser/lexer.rl"
		begin
 @escape = nil 		end
# line 1921 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 811; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 389 then
# line 2008 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 2009 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:kRESCUE, 'rescue'.freeze, @ts, tm)
           p = tm - 1
            @cs = 540; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 480 then
# line 2301 "lib/parser/lexer.rl"
		begin
 @num_base = 16; @num_digits_s = p 		end
# line 2307 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 474 then
# line 2302 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = p 		end
# line 2307 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 477 then
# line 2303 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = p 		end
# line 2307 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 471 then
# line 2304 "lib/parser/lexer.rl"
		begin
 @num_base = 2;  @num_digits_s = p 		end
# line 2307 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 486 then
# line 2305 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = @ts 		end
# line 2307 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 449 then
# line 2306 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = @ts 		end
# line 2307 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 487 then
# line 2307 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 635 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
	when 8 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 501 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
	when 453 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2365 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 228 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1386 "lib/parser/lexer.rl"
		begin
 @act = 43;		end
	when 215 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1390 "lib/parser/lexer.rl"
		begin
 @act = 44;		end
	when 211 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1394 "lib/parser/lexer.rl"
		begin
 @act = 45;		end
	when 27 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1570 "lib/parser/lexer.rl"
		begin
 @act = 72;		end
	when 261 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1587 "lib/parser/lexer.rl"
		begin
 @act = 73;		end
	when 28 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1626 "lib/parser/lexer.rl"
		begin
 @act = 78;		end
	when 254 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1631 "lib/parser/lexer.rl"
		begin
 @act = 79;		end
	when 281 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1663 "lib/parser/lexer.rl"
		begin
 @act = 85;		end
	when 46 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1676 "lib/parser/lexer.rl"
		begin
 @act = 86;		end
	when 302 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1730 "lib/parser/lexer.rl"
		begin
 @act = 93;		end
	when 291 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1734 "lib/parser/lexer.rl"
		begin
 @act = 94;		end
	when 70 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1854 "lib/parser/lexer.rl"
		begin
 @act = 106;		end
	when 394 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1962 "lib/parser/lexer.rl"
		begin
 @act = 117;		end
	when 305 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2003 "lib/parser/lexer.rl"
		begin
 @act = 121;		end
	when 388 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2009 "lib/parser/lexer.rl"
		begin
 @act = 122;		end
	when 387 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2015 "lib/parser/lexer.rl"
		begin
 @act = 123;		end
	when 75 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2106 "lib/parser/lexer.rl"
		begin
 @act = 127;		end
	when 303 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1327 "lib/parser/lexer.rl"
		begin
 @act = 128;		end
	when 306 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2152 "lib/parser/lexer.rl"
		begin
 @act = 132;		end
	when 504 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2216 "lib/parser/lexer.rl"
		begin
 @act = 145;		end
	when 499 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2245 "lib/parser/lexer.rl"
		begin
 @act = 146;		end
	when 507 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2255 "lib/parser/lexer.rl"
		begin
 @act = 148;		end
	when 500 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2260 "lib/parser/lexer.rl"
		begin
 @act = 149;		end
	when 501 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2265 "lib/parser/lexer.rl"
		begin
 @act = 150;		end
	when 506 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2269 "lib/parser/lexer.rl"
		begin
 @act = 151;		end
	when 498 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2280 "lib/parser/lexer.rl"
		begin
 @act = 152;		end
	when 492 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2294 "lib/parser/lexer.rl"
		begin
 @act = 153;		end
	when 418 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2308 "lib/parser/lexer.rl"
		begin
 @act = 154;		end
	when 451 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2352 "lib/parser/lexer.rl"
		begin
 @act = 157;		end
	when 82 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2367 "lib/parser/lexer.rl"
		begin
 @act = 158;		end
	when 421 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2395 "lib/parser/lexer.rl"
		begin
 @act = 160;		end
	when 412 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1327 "lib/parser/lexer.rl"
		begin
 @act = 164;		end
	when 423 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2417 "lib/parser/lexer.rl"
		begin
 @act = 165;		end
	when 416 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2443 "lib/parser/lexer.rl"
		begin
 @act = 167;		end
	when 422 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2449 "lib/parser/lexer.rl"
		begin
 @act = 168;		end
	when 88 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2540 "lib/parser/lexer.rl"
		begin
 @act = 181;		end
	when 511 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2579 "lib/parser/lexer.rl"
		begin
 @act = 185;		end
	when 183 then
# line 501 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 957 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
# line 825 "lib/parser/lexer.rl"
		begin

    @escape_s = p
    @escape   = nil
  		end
	when 124 then
# line 707 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]

    if @version >= 30 && (codepoint == 117 || codepoint == 85) # 'u' or 'U'
      diagnostic :fatal, :invalid_escape
    end

    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 731 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 898 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 155 then
# line 707 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]

    if @version >= 30 && (codepoint == 117 || codepoint == 85) # 'u' or 'U'
      diagnostic :fatal, :invalid_escape
    end

    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 731 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 898 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 369 then
# line 707 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]

    if @version >= 30 && (codepoint == 117 || codepoint == 85) # 'u' or 'U'
      diagnostic :fatal, :invalid_escape
    end

    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 731 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 1921 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 811; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 131 then
# line 707 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]

    if @version >= 30 && (codepoint == 117 || codepoint == 85) # 'u' or 'U'
      diagnostic :fatal, :invalid_escape
    end

    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 735 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 898 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 162 then
# line 707 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]

    if @version >= 30 && (codepoint == 117 || codepoint == 85) # 'u' or 'U'
      diagnostic :fatal, :invalid_escape
    end

    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 735 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 898 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 376 then
# line 707 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]

    if @version >= 30 && (codepoint == 117 || codepoint == 85) # 'u' or 'U'
      diagnostic :fatal, :invalid_escape
    end

    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 735 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 1921 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 811; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 122 then
# line 723 "lib/parser/lexer.rl"
		begin

    @escape = @source_buffer.slice(p - 1).chr

    if @version >= 27 && ((0..8).include?(@escape.ord) || (14..31).include?(@escape.ord))
      diagnostic :fatal, :invalid_escape
    end
  		end
# line 731 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 898 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 153 then
# line 723 "lib/parser/lexer.rl"
		begin

    @escape = @source_buffer.slice(p - 1).chr

    if @version >= 27 && ((0..8).include?(@escape.ord) || (14..31).include?(@escape.ord))
      diagnostic :fatal, :invalid_escape
    end
  		end
# line 731 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 898 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 367 then
# line 723 "lib/parser/lexer.rl"
		begin

    @escape = @source_buffer.slice(p - 1).chr

    if @version >= 27 && ((0..8).include?(@escape.ord) || (14..31).include?(@escape.ord))
      diagnostic :fatal, :invalid_escape
    end
  		end
# line 731 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 1921 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 811; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 130 then
# line 723 "lib/parser/lexer.rl"
		begin

    @escape = @source_buffer.slice(p - 1).chr

    if @version >= 27 && ((0..8).include?(@escape.ord) || (14..31).include?(@escape.ord))
      diagnostic :fatal, :invalid_escape
    end
  		end
# line 735 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 898 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 161 then
# line 723 "lib/parser/lexer.rl"
		begin

    @escape = @source_buffer.slice(p - 1).chr

    if @version >= 27 && ((0..8).include?(@escape.ord) || (14..31).include?(@escape.ord))
      diagnostic :fatal, :invalid_escape
    end
  		end
# line 735 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 898 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 375 then
# line 723 "lib/parser/lexer.rl"
		begin

    @escape = @source_buffer.slice(p - 1).chr

    if @version >= 27 && ((0..8).include?(@escape.ord) || (14..31).include?(@escape.ord))
      diagnostic :fatal, :invalid_escape
    end
  		end
# line 735 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 1921 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 811; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 126 then
# line 747 "lib/parser/lexer.rl"
		begin
 @escape = "\x7f" 		end
# line 735 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 898 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 157 then
# line 747 "lib/parser/lexer.rl"
		begin
 @escape = "\x7f" 		end
# line 735 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 898 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 371 then
# line 747 "lib/parser/lexer.rl"
		begin
 @escape = "\x7f" 		end
# line 735 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 1921 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 811; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 129 then
# line 748 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(p - 2, p).to_i(16)) 		end
# line 731 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 898 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 160 then
# line 748 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(p - 2, p).to_i(16)) 		end
# line 731 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 898 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 374 then
# line 748 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(p - 2, p).to_i(16)) 		end
# line 731 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 1921 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 811; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 136 then
# line 779 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
      		end
# line 793 "lib/parser/lexer.rl"
		begin

          diagnostic :fatal, :unterminated_unicode, nil, range(p - 1, p)
        		end
# line 898 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 167 then
# line 779 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
      		end
# line 793 "lib/parser/lexer.rl"
		begin

          diagnostic :fatal, :unterminated_unicode, nil, range(p - 1, p)
        		end
# line 898 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 381 then
# line 779 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
      		end
# line 793 "lib/parser/lexer.rl"
		begin

          diagnostic :fatal, :unterminated_unicode, nil, range(p - 1, p)
        		end
# line 1921 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 811; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 116 then
# line 825 "lib/parser/lexer.rl"
		begin

    @escape_s = p
    @escape   = nil
  		end
# line 819 "lib/parser/lexer.rl"
		begin

      diagnostic :fatal, :escape_eof, nil, range(p - 1, p)
    		end
# line 898 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 148 then
# line 825 "lib/parser/lexer.rl"
		begin

    @escape_s = p
    @escape   = nil
  		end
# line 819 "lib/parser/lexer.rl"
		begin

      diagnostic :fatal, :escape_eof, nil, range(p - 1, p)
    		end
# line 898 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 362 then
# line 825 "lib/parser/lexer.rl"
		begin

    @escape_s = p
    @escape   = nil
  		end
# line 819 "lib/parser/lexer.rl"
		begin

      diagnostic :fatal, :escape_eof, nil, range(p - 1, p)
    		end
# line 1921 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 811; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 62 then
# line 1229 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1232 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 501 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
	when 221 then
# line 1229 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1232 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1427 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 236 then
# line 1229 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1232 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1457 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 248 then
# line 1229 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1232 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1489 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 270 then
# line 1229 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1232 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1634 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  	begin
		 @cs = 811
		_goto_level = _again
		next
	end
  end
		end
	when 285 then
# line 1229 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1232 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1715 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 297 then
# line 1229 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1232 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1736 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 323 then
# line 1229 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1232 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2133 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 399 then
# line 1229 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1232 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2160 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 409 then
# line 1229 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1232 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2191 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 430 then
# line 1229 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1232 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2508 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 102 then
# line 1229 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1232 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2604 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 482 then
# line 2305 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = @ts 		end
# line 2307 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 635 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
	when 446 then
# line 2306 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = @ts 		end
# line 2307 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 635 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
	when 461 then
# line 2307 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 635 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2308 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 454 then
# line 2364 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 644 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tFLOAT,     Float(chars)) } 		end
# line 2367 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 450 then
# line 2365 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 644 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tFLOAT,     Float(chars)) } 		end
# line 2367 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 276 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 501 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 1631 "lib/parser/lexer.rl"
		begin
 @act = 79;		end
	when 36 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 865 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1626 "lib/parser/lexer.rl"
		begin
 @act = 78;		end
	when 47 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 865 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1676 "lib/parser/lexer.rl"
		begin
 @act = 86;		end
	when 94 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 865 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 2540 "lib/parser/lexer.rl"
		begin
 @act = 181;		end
	when 66 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1232 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1757 "lib/parser/lexer.rl"
		begin
 @act = 99;		end
	when 85 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1232 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2249 "lib/parser/lexer.rl"
		begin
 @act = 147;		end
	when 93 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1232 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2540 "lib/parser/lexer.rl"
		begin
 @act = 181;		end
	when 38 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1586 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1587 "lib/parser/lexer.rl"
		begin
 @act = 73;		end
	when 391 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2008 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 2106 "lib/parser/lexer.rl"
		begin
 @act = 127;		end
	when 390 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2008 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1327 "lib/parser/lexer.rl"
		begin
 @act = 128;		end
	when 483 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2305 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = @ts 		end
# line 2308 "lib/parser/lexer.rl"
		begin
 @act = 154;		end
	when 127 then
# line 707 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]

    if @version >= 30 && (codepoint == 117 || codepoint == 85) # 'u' or 'U'
      diagnostic :fatal, :invalid_escape
    end

    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 731 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 735 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 898 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 158 then
# line 707 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]

    if @version >= 30 && (codepoint == 117 || codepoint == 85) # 'u' or 'U'
      diagnostic :fatal, :invalid_escape
    end

    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 731 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 735 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 898 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 372 then
# line 707 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]

    if @version >= 30 && (codepoint == 117 || codepoint == 85) # 'u' or 'U'
      diagnostic :fatal, :invalid_escape
    end

    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 731 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 735 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 1921 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 811; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 125 then
# line 723 "lib/parser/lexer.rl"
		begin

    @escape = @source_buffer.slice(p - 1).chr

    if @version >= 27 && ((0..8).include?(@escape.ord) || (14..31).include?(@escape.ord))
      diagnostic :fatal, :invalid_escape
    end
  		end
# line 731 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 735 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 898 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 156 then
# line 723 "lib/parser/lexer.rl"
		begin

    @escape = @source_buffer.slice(p - 1).chr

    if @version >= 27 && ((0..8).include?(@escape.ord) || (14..31).include?(@escape.ord))
      diagnostic :fatal, :invalid_escape
    end
  		end
# line 731 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 735 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 898 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 370 then
# line 723 "lib/parser/lexer.rl"
		begin

    @escape = @source_buffer.slice(p - 1).chr

    if @version >= 27 && ((0..8).include?(@escape.ord) || (14..31).include?(@escape.ord))
      diagnostic :fatal, :invalid_escape
    end
  		end
# line 731 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 735 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 1921 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 811; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 132 then
# line 741 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(p - 2, p).to_i(16)) 		end
# line 731 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 735 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 898 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 163 then
# line 741 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(p - 2, p).to_i(16)) 		end
# line 731 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 735 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 898 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 377 then
# line 741 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(p - 2, p).to_i(16)) 		end
# line 731 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 735 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 1921 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 811; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 128 then
# line 748 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(p - 2, p).to_i(16)) 		end
# line 731 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 735 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 898 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 159 then
# line 748 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(p - 2, p).to_i(16)) 		end
# line 731 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 735 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 898 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 373 then
# line 748 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(p - 2, p).to_i(16)) 		end
# line 731 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 735 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 1921 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 811; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 478 then
# line 2301 "lib/parser/lexer.rl"
		begin
 @num_base = 16; @num_digits_s = p 		end
# line 2307 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 635 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2308 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 472 then
# line 2302 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = p 		end
# line 2307 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 635 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2308 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 475 then
# line 2303 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = p 		end
# line 2307 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 635 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2308 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 469 then
# line 2304 "lib/parser/lexer.rl"
		begin
 @num_base = 2;  @num_digits_s = p 		end
# line 2307 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 635 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2308 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 481 then
# line 2305 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = @ts 		end
# line 2307 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 635 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2308 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 445 then
# line 2306 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = @ts 		end
# line 2307 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 635 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2308 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 32 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 865 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1586 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1587 "lib/parser/lexer.rl"
		begin
 @act = 73;		end
	when 63 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1229 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1232 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1757 "lib/parser/lexer.rl"
		begin
 @act = 99;		end
	when 92 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1229 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1232 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2540 "lib/parser/lexer.rl"
		begin
 @act = 181;		end
	when 488 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2307 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 635 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2340 "lib/parser/lexer.rl"
		begin
 @act = 156;		end
	when 484 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2305 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = @ts 		end
# line 2307 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 635 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2340 "lib/parser/lexer.rl"
		begin
 @act = 156;		end
	when 448 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2306 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = @ts 		end
# line 2307 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 635 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2340 "lib/parser/lexer.rl"
		begin
 @act = 156;		end
# line 24782 "lib/parser/lexer.rb"
	end
	end
	end
	if _goto_level <= _again
	case _lex_to_state_actions[ @cs] 
	when 96 then
# line 1 "NONE"
		begin
 @ts = nil;		end
# line 24792 "lib/parser/lexer.rb"
	end

	if  @cs == 0
		_goto_level = _out
		next
	end
	p += 1
	if p != pe
		_goto_level = _resume
		next
	end
	end
	if _goto_level <= _test_eof
	if p == eof
	if _lex_eof_trans[ @cs] > 0
		_trans = _lex_eof_trans[ @cs] - 1;
		_goto_level = _eof_trans
		next;
	end
	end

	end
	if _goto_level <= _out
		break
	end
end
	end

# line 286 "lib/parser/lexer.rl"
    # %

    # Ragel creates a local variable called `testEof` but it doesn't use
    # it in any assignment. This dead code is here to swallow the warning.
    # It has no runtime cost because Ruby doesn't produce any instructions from it.
    if false
      testEof
    end

    @p = p

    if @token_queue.any?
      @token_queue.shift
    elsif @cs == klass.lex_error
      [ false, [ '$error'.freeze, range(p - 1, p) ] ]
    else
      eof = @source_pts.size
      [ false, [ '$eof'.freeze,   range(eof, eof) ] ]
    end
  end

  protected

  def eof_codepoint?(point)
    [0x04, 0x1a, 0x00].include? point
  end

  def version?(*versions)
    versions.include?(@version)
  end

  def stack_pop
    @top -= 1
    @stack[@top]
  end

  def encode_escape(ord)
    ord.chr.force_encoding(@source_buffer.source.encoding)
  end

  def tok(s = @ts, e = @te)
    @source_buffer.slice(s...e)
  end

  def range(s = @ts, e = @te)
    Parser::Source::Range.new(@source_buffer, s, e)
  end

  def emit(type, value = tok, s = @ts, e = @te)
    token = [ type, [ value, range(s, e) ] ]

    @token_queue.push(token)

    @tokens.push(token) if @tokens

    token
  end

  def emit_table(table, s = @ts, e = @te)
    value = tok(s, e)

    emit(table[value], value, s, e)
  end

  def emit_do(do_block=false)
    if @cond.active?
      emit(:kDO_COND, 'do'.freeze)
    elsif @cmdarg.active? || do_block
      emit(:kDO_BLOCK, 'do'.freeze)
    else
      emit(:kDO, 'do'.freeze)
    end
  end

  def arg_or_cmdarg(cmd_state)
    if cmd_state
      self.class.lex_en_expr_cmdarg
    else
      self.class.lex_en_expr_arg
    end
  end

  def emit_comment(s = @ts, e = @te)
    if @comments
      @comments.push(Parser::Source::Comment.new(range(s, e)))
    end

    if @tokens
      @tokens.push([ :tCOMMENT, [ tok(s, e), range(s, e) ] ])
    end

    nil
  end

  def diagnostic(type, reason, arguments=nil, location=range, highlights=[])
    @diagnostics.process(
        Parser::Diagnostic.new(type, reason, arguments, location, highlights))
  end

  #
  # === LITERAL STACK ===
  #

  def push_literal(*args)
    new_literal = Literal.new(self, *args)
    @literal_stack.push(new_literal)
    next_state_for_literal(new_literal)
  end

  def next_state_for_literal(literal)
    if literal.words? && literal.backslash_delimited?
      if literal.interpolate?
        self.class.lex_en_interp_backslash_delimited_words
      else
        self.class.lex_en_plain_backslash_delimited_words
      end
    elsif literal.words? && !literal.backslash_delimited?
      if literal.interpolate?
        self.class.lex_en_interp_words
      else
        self.class.lex_en_plain_words
      end
    elsif !literal.words? && literal.backslash_delimited?
      if literal.interpolate?
        self.class.lex_en_interp_backslash_delimited
      else
        self.class.lex_en_plain_backslash_delimited
      end
    else
      if literal.interpolate?
        self.class.lex_en_interp_string
      else
        self.class.lex_en_plain_string
      end
    end
  end

  def literal
    @literal_stack.last
  end

  def pop_literal
    old_literal = @literal_stack.pop

    @dedent_level = old_literal.dedent_level

    if old_literal.type == :tREGEXP_BEG
      # Fetch modifiers.
      self.class.lex_en_regexp_modifiers
    else
      self.class.lex_en_expr_end
    end
  end

  # Mapping of strings to parser tokens.

  PUNCTUATION = {
    '='   => :tEQL,     '&'   => :tAMPER2,  '|'   => :tPIPE,
    '!'   => :tBANG,    '^'   => :tCARET,   '+'   => :tPLUS,
    '-'   => :tMINUS,   '*'   => :tSTAR2,   '/'   => :tDIVIDE,
    '%'   => :tPERCENT, '~'   => :tTILDE,   ','   => :tCOMMA,
    ';'   => :tSEMI,    '.'   => :tDOT,     '..'  => :tDOT2,
    '...' => :tDOT3,    '['   => :tLBRACK2, ']'   => :tRBRACK,
    '('   => :tLPAREN2, ')'   => :tRPAREN,  '?'   => :tEH,
    ':'   => :tCOLON,   '&&'  => :tANDOP,   '||'  => :tOROP,
    '-@'  => :tUMINUS,  '+@'  => :tUPLUS,   '~@'  => :tTILDE,
    '**'  => :tPOW,     '->'  => :tLAMBDA,  '=~'  => :tMATCH,
    '!~'  => :tNMATCH,  '=='  => :tEQ,      '!='  => :tNEQ,
    '>'   => :tGT,      '>>'  => :tRSHFT,   '>='  => :tGEQ,
    '<'   => :tLT,      '<<'  => :tLSHFT,   '<='  => :tLEQ,
    '=>'  => :tASSOC,   '::'  => :tCOLON2,  '===' => :tEQQ,
    '<=>' => :tCMP,     '[]'  => :tAREF,    '[]=' => :tASET,
    '{'   => :tLCURLY,  '}'   => :tRCURLY,  '`'   => :tBACK_REF2,
    '!@'  => :tBANG,    '&.'  => :tANDDOT,
  }

  PUNCTUATION_BEGIN = {
    '&'   => :tAMPER,   '*'   => :tSTAR,    '**'  => :tDSTAR,
    '+'   => :tUPLUS,   '-'   => :tUMINUS,  '::'  => :tCOLON3,
    '('   => :tLPAREN,  '{'   => :tLBRACE,  '['   => :tLBRACK,
  }

  KEYWORDS = {
    'if'     => :kIF_MOD,      'unless'   => :kUNLESS_MOD,
    'while'  => :kWHILE_MOD,   'until'    => :kUNTIL_MOD,
    'rescue' => :kRESCUE_MOD,  'defined?' => :kDEFINED,
    'BEGIN'  => :klBEGIN,      'END'      => :klEND,
  }

  KEYWORDS_BEGIN = {
    'if'     => :kIF,          'unless'   => :kUNLESS,
    'while'  => :kWHILE,       'until'    => :kUNTIL,
    'rescue' => :kRESCUE,      'defined?' => :kDEFINED,
    'BEGIN'  => :klBEGIN,      'END'      => :klEND,
  }

  %w(class module def undef begin end then elsif else ensure case when
     for break next redo retry in do return yield super self nil true
     false and or not alias __FILE__ __LINE__ __ENCODING__).each do |keyword|
    KEYWORDS_BEGIN[keyword] = KEYWORDS[keyword] = :"k#{keyword.upcase}"
  end

  
# line 2619 "lib/parser/lexer.rl"

  # %
end
