/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.datalab.plugin.manipulators.columns.merge.ui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.gephi.datalab.plugin.manipulators.columns.merge.CreateTimeInterval;
import org.gephi.datalab.spi.DialogControls;
import org.gephi.datalab.spi.Manipulator;
import org.gephi.datalab.spi.ManipulatorUI;
import org.gephi.graph.api.Column;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXHeader;
import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.Validator;
import org.netbeans.validation.api.ui.ValidationGroup;
import org.netbeans.validation.api.ui.ValidationPanel;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class CreateTimeIntervalUI
extends JPanel
implements ManipulatorUI {
    private static final String PARSE_NUMBERS_SAVED_PARAMETER = "CreateTimeIntervalUI_parseNumbers";
    private static final String START_NUMBER_SAVED_PARAMETER = "CreateTimeIntervalUI_startNumber";
    private static final String END_NUMBER_SAVED_PARAMETER = "CreateTimeIntervalUI_endNumber";
    private static final String DATE_FORMAT_SAVED_PARAMETER = "CreateTimeIntervalUI_dateFormat";
    private static final String DATE_FORMAT_SAVED_PARAMETER_STRING = "CreateTimeIntervalUI_dateFormat_string";
    private static final String START_DATE_SAVED_PARAMETER = "CreateTimeIntervalUI_startDate";
    private static final String END_DATE_SAVED_PARAMETER = "CreateTimeIntervalUI_endDate";
    private CreateTimeInterval manipulator;
    private DialogControls dialogControls;
    private ValidationPanel validationPanel;
    private ColumnWrapper column1;
    private ColumnWrapper column2;
    private ButtonGroup buttonGroup;
    private JLabel dateDefaultEndLabel;
    private JLabel dateDefaultStartLabel;
    private JComboBox dateFormatComboBox;
    private JLabel dateFormatLabel;
    private JXDatePicker defaultEndDatePicker;
    private JLabel defaultEndNumberLabel;
    private JTextField defaultEndNumberText;
    private JXDatePicker defaultStartDatePicker;
    private JLabel defaultStartNumberLabel;
    private JTextField defaultStartNumberText;
    private JComboBox endColumnComboBox;
    private JLabel endColumnLabel;
    private JXHeader header;
    private JRadioButton parseDatesRadioButton;
    private JRadioButton parseNumbersRadioButton;
    private JComboBox startColumnComboBox;
    private JLabel startColumnLabel;

    public CreateTimeIntervalUI() {
        this.initComponents();
        this.defaultStartDatePicker.setFormats(new String[]{"yyyy-MM-dd"});
        this.defaultEndDatePicker.setFormats(new String[]{"yyyy-MM-dd"});
        this.dateFormatComboBox.addItem("yyyy-MM-dd");
        this.dateFormatComboBox.addItem("yyyy/MM/dd");
        this.dateFormatComboBox.addItem("dd-MM-yyyy");
        this.dateFormatComboBox.addItem("dd/MM/yyyy");
        this.dateFormatComboBox.addItem("yyyy-MM-dd HH:mm:ss");
        this.dateFormatComboBox.addItem("yyyy/MM/dd HH:mm:ss");
        this.dateFormatComboBox.addItem("dd-MM-yyyy HH:mm:ss");
        this.dateFormatComboBox.addItem("dd/MM/yyyy HH:mm:ss");
        this.dateFormatComboBox.addItem("yyyy-MM-dd'T'HH:mm:ss");
        this.dateFormatComboBox.addItem("yyyy/MM/dd'T'HH:mm:ss");
        this.dateFormatComboBox.addItem("dd-MM-yyyy'T'HH:mm:ss");
        this.dateFormatComboBox.addItem("dd/MM/yyyy'T'HH:mm:ss");
        this.dateFormatComboBox.setSelectedIndex(0);
    }

    private Column getComboBoxColumn(JComboBox comboBox) {
        return ((ColumnWrapper)comboBox.getSelectedItem()).column;
    }

    private void readSavedParameters() {
        this.parseNumbersRadioButton.setSelected(NbPreferences.forModule(CreateTimeIntervalUI.class).getBoolean(PARSE_NUMBERS_SAVED_PARAMETER, true));
        this.defaultStartNumberText.setText(NbPreferences.forModule(CreateTimeIntervalUI.class).get(START_NUMBER_SAVED_PARAMETER, ""));
        this.defaultEndNumberText.setText(NbPreferences.forModule(CreateTimeIntervalUI.class).get(END_NUMBER_SAVED_PARAMETER, ""));
        this.dateFormatComboBox.setSelectedItem(NbPreferences.forModule(CreateTimeIntervalUI.class).get(DATE_FORMAT_SAVED_PARAMETER_STRING, "yyyy-MM-dd"));
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String date = NbPreferences.forModule(CreateTimeIntervalUI.class).get(START_DATE_SAVED_PARAMETER, "");
            if (!date.isEmpty()) {
                this.defaultStartDatePicker.setDate(sdf.parse(date));
            }
            if (!(date = NbPreferences.forModule(CreateTimeIntervalUI.class).get(END_DATE_SAVED_PARAMETER, "")).isEmpty()) {
                this.defaultEndDatePicker.setDate(sdf.parse(date));
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    private void storeSavedParameters() {
        NbPreferences.forModule(CreateTimeIntervalUI.class).putBoolean(PARSE_NUMBERS_SAVED_PARAMETER, this.parseNumbersRadioButton.isSelected());
        NbPreferences.forModule(CreateTimeIntervalUI.class).put(START_NUMBER_SAVED_PARAMETER, this.defaultStartNumberText.getText());
        NbPreferences.forModule(CreateTimeIntervalUI.class).put(END_NUMBER_SAVED_PARAMETER, this.defaultEndNumberText.getText());
        NbPreferences.forModule(CreateTimeIntervalUI.class).put(DATE_FORMAT_SAVED_PARAMETER_STRING, this.dateFormatComboBox.getSelectedItem().toString());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date date = this.defaultStartDatePicker.getDate();
        if (date != null) {
            NbPreferences.forModule(CreateTimeIntervalUI.class).put(START_DATE_SAVED_PARAMETER, sdf.format(date));
        }
        if ((date = this.defaultEndDatePicker.getDate()) != null) {
            NbPreferences.forModule(CreateTimeIntervalUI.class).put(END_DATE_SAVED_PARAMETER, sdf.format(date));
        }
    }

    public void setup(Manipulator m, DialogControls dialogControls) {
        this.manipulator = (CreateTimeInterval)m;
        this.dialogControls = dialogControls;
        Column[] columns = this.manipulator.getColumns();
        this.column1 = new ColumnWrapper(columns[0]);
        this.column2 = columns.length == 2 ? new ColumnWrapper(columns[1]) : new ColumnWrapper(null);
        this.startColumnComboBox.addItem(this.column1);
        this.startColumnComboBox.addItem(this.column2);
        this.endColumnComboBox.addItem(this.column1);
        this.endColumnComboBox.addItem(this.column2);
        if (columns.length == 2) {
            this.startColumnComboBox.addItem(new ColumnWrapper(null));
            this.endColumnComboBox.addItem(new ColumnWrapper(null));
        }
        this.buildValidationPanel();
        this.readSavedParameters();
        this.refreshTimeParseMode();
        this.refreshOkButton();
    }

    public void unSetup() {
        if (this.dialogControls.isOkButtonEnabled()) {
            boolean parseNumbers = this.parseNumbersRadioButton.isSelected();
            this.manipulator.setParseNumbers(parseNumbers);
            this.manipulator.setStartColumn(this.getComboBoxColumn(this.startColumnComboBox));
            this.manipulator.setEndColumn(this.getComboBoxColumn(this.endColumnComboBox));
            if (parseNumbers) {
                if (this.defaultStartNumberText.getText().trim().isEmpty()) {
                    this.manipulator.setStartNumber(Double.NEGATIVE_INFINITY);
                } else {
                    this.manipulator.setStartNumber(Double.parseDouble(this.defaultStartNumberText.getText().trim()));
                }
                if (this.defaultEndNumberText.getText().trim().isEmpty()) {
                    this.manipulator.setEndNumber(Double.POSITIVE_INFINITY);
                } else {
                    this.manipulator.setEndNumber(Double.parseDouble(this.defaultEndNumberText.getText().trim()));
                }
            } else {
                SimpleDateFormat dateFormat = new SimpleDateFormat(this.dateFormatComboBox.getSelectedItem().toString());
                this.manipulator.setDateFormat(dateFormat);
                this.manipulator.setStartDate(this.defaultStartDatePicker.getDate() != null ? dateFormat.format(this.defaultStartDatePicker.getDate()) : null);
                this.manipulator.setEndDate(this.defaultEndDatePicker.getDate() != null ? dateFormat.format(this.defaultEndDatePicker.getDate()) : null);
            }
        }
        this.storeSavedParameters();
    }

    public String getDisplayName() {
        return this.manipulator.getName();
    }

    private void buildValidationPanel() {
        this.validationPanel = new ValidationPanel();
        this.validationPanel.setInnerComponent((Component)this);
        ValidationGroup group = this.validationPanel.getValidationGroup();
        group.add(this.dateFormatComboBox, new Validator[]{new Validator<String>(){

            public boolean validate(Problems prblms, String string, String t) {
                boolean valid = CreateTimeIntervalUI.this.validateDateFormat(t);
                if (!valid) {
                    prblms.add(NbBundle.getMessage(CreateTimeIntervalUI.class, (String)"CreateTimeIntervalUI.invalid.dateformat"));
                }
                return valid;
            }
        }});
        Validator<String> emptyOrNumberValidator = new Validator<String>(){

            public boolean validate(Problems prblms, String string, String t) {
                boolean valid = CreateTimeIntervalUI.this.validateNumberOrEmpty(t);
                if (!valid) {
                    prblms.add(NbBundle.getMessage(CreateTimeIntervalUI.class, (String)"CreateTimeIntervalUI.invalid.number"));
                }
                return valid;
            }
        };
        group.add((JTextComponent)this.defaultStartNumberText, new Validator[]{emptyOrNumberValidator});
        group.add((JTextComponent)this.defaultEndNumberText, new Validator[]{emptyOrNumberValidator});
        this.validationPanel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                CreateTimeIntervalUI.this.refreshOkButton();
            }
        });
    }

    public JPanel getSettingsPanel() {
        return this.validationPanel;
    }

    public boolean isModal() {
        return true;
    }

    private boolean validateNumberOrEmpty(String text) {
        if ((text = text.trim()).isEmpty()) {
            return true;
        }
        try {
            Double.parseDouble(text);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private boolean validateDateFormat(String dateFormat) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateFormat);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void refreshOkButton() {
        boolean enabled = this.getComboBoxColumn(this.startColumnComboBox) != null || this.getComboBoxColumn(this.endColumnComboBox) != null;
        this.dialogControls.setOkButtonEnabled(enabled &= this.validationPanel != null && !this.validationPanel.isProblem());
    }

    private void refreshTimeParseMode() {
        boolean parseNumbers = this.parseNumbersRadioButton.isSelected();
        this.defaultStartNumberLabel.setEnabled(parseNumbers);
        this.defaultEndNumberLabel.setEnabled(parseNumbers);
        this.defaultStartNumberText.setEnabled(parseNumbers);
        this.defaultEndNumberText.setEnabled(parseNumbers);
        this.dateFormatLabel.setEnabled(!parseNumbers);
        this.dateFormatComboBox.setEnabled(!parseNumbers);
        this.dateDefaultStartLabel.setEnabled(!parseNumbers);
        this.dateDefaultEndLabel.setEnabled(!parseNumbers);
        this.defaultStartDatePicker.setEnabled(!parseNumbers);
        this.defaultEndDatePicker.setEnabled(!parseNumbers);
        this.refreshOkButton();
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.startColumnLabel = new JLabel();
        this.startColumnComboBox = new JComboBox();
        this.endColumnComboBox = new JComboBox();
        this.endColumnLabel = new JLabel();
        this.parseNumbersRadioButton = new JRadioButton();
        this.header = new JXHeader();
        this.parseDatesRadioButton = new JRadioButton();
        this.defaultStartDatePicker = new JXDatePicker();
        this.dateDefaultStartLabel = new JLabel();
        this.defaultEndDatePicker = new JXDatePicker();
        this.dateDefaultEndLabel = new JLabel();
        this.dateFormatLabel = new JLabel();
        this.dateFormatComboBox = new JComboBox();
        this.defaultStartNumberLabel = new JLabel();
        this.defaultEndNumberLabel = new JLabel();
        this.defaultStartNumberText = new JTextField();
        this.defaultEndNumberText = new JTextField();
        this.startColumnLabel.setText(NbBundle.getMessage(CreateTimeIntervalUI.class, (String)"CreateTimeIntervalUI.startColumnLabel.text"));
        this.startColumnComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateTimeIntervalUI.this.startColumnComboBoxActionPerformed(evt);
            }
        });
        this.endColumnComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateTimeIntervalUI.this.endColumnComboBoxActionPerformed(evt);
            }
        });
        this.endColumnLabel.setText(NbBundle.getMessage(CreateTimeIntervalUI.class, (String)"CreateTimeIntervalUI.endColumnLabel.text"));
        this.buttonGroup.add(this.parseNumbersRadioButton);
        this.parseNumbersRadioButton.setSelected(true);
        this.parseNumbersRadioButton.setText(NbBundle.getMessage(CreateTimeIntervalUI.class, (String)"CreateTimeIntervalUI.parseNumbersRadioButton.text"));
        this.parseNumbersRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateTimeIntervalUI.this.parseNumbersRadioButtonActionPerformed(evt);
            }
        });
        this.header.setDescription(NbBundle.getMessage(CreateTimeIntervalUI.class, (String)"CreateTimeIntervalUI.header.description"));
        this.header.setTitle(NbBundle.getMessage(CreateTimeIntervalUI.class, (String)"CreateTimeIntervalUI.header.title"));
        this.buttonGroup.add(this.parseDatesRadioButton);
        this.parseDatesRadioButton.setText(NbBundle.getMessage(CreateTimeIntervalUI.class, (String)"CreateTimeIntervalUI.parseDatesRadioButton.text"));
        this.parseDatesRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateTimeIntervalUI.this.parseDatesRadioButtonActionPerformed(evt);
            }
        });
        this.defaultStartDatePicker.setEnabled(false);
        this.dateDefaultStartLabel.setText(NbBundle.getMessage(CreateTimeIntervalUI.class, (String)"CreateTimeIntervalUI.dateDefaultStartLabel.text"));
        this.dateDefaultStartLabel.setEnabled(false);
        this.defaultEndDatePicker.setEnabled(false);
        this.dateDefaultEndLabel.setText(NbBundle.getMessage(CreateTimeIntervalUI.class, (String)"CreateTimeIntervalUI.dateDefaultEndLabel.text"));
        this.dateDefaultEndLabel.setEnabled(false);
        this.dateFormatLabel.setText(NbBundle.getMessage(CreateTimeIntervalUI.class, (String)"CreateTimeIntervalUI.dateFormatLabel.text"));
        this.dateFormatLabel.setEnabled(false);
        this.dateFormatComboBox.setEditable(true);
        this.dateFormatComboBox.setEnabled(false);
        this.defaultStartNumberLabel.setText(NbBundle.getMessage(CreateTimeIntervalUI.class, (String)"CreateTimeIntervalUI.defaultStartNumberLabel.text"));
        this.defaultEndNumberLabel.setText(NbBundle.getMessage(CreateTimeIntervalUI.class, (String)"CreateTimeIntervalUI.defaultEndNumberLabel.text"));
        this.defaultStartNumberText.setText(NbBundle.getMessage(CreateTimeIntervalUI.class, (String)"CreateTimeIntervalUI.defaultStartNumberText.text"));
        this.defaultEndNumberText.setText(NbBundle.getMessage(CreateTimeIntervalUI.class, (String)"CreateTimeIntervalUI.defaultEndNumberText.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.header, -1, 664, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGap(15, 15, 15).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.dateDefaultStartLabel, -1, -1, Short.MAX_VALUE).addComponent(this.dateDefaultEndLabel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.dateFormatLabel, -1, -1, Short.MAX_VALUE).addGap(6, 6, 6)))).addGroup(layout.createSequentialGroup().addGap(13, 13, 13).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.defaultStartNumberLabel, -1, -1, Short.MAX_VALUE).addComponent(this.defaultEndNumberLabel, -1, -1, Short.MAX_VALUE)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.defaultStartDatePicker, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent((Component)this.defaultEndDatePicker, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.dateFormatComboBox, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE).addComponent(this.defaultStartNumberText).addComponent(this.defaultEndNumberText))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.endColumnLabel, -1, -1, Short.MAX_VALUE).addComponent(this.startColumnLabel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.startColumnComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.endColumnComboBox, 0, -1, Short.MAX_VALUE))).addComponent(this.parseDatesRadioButton).addComponent(this.parseNumbersRadioButton)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent((Component)this.header, -2, 105, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.startColumnLabel).addComponent(this.startColumnComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.endColumnComboBox, -2, -1, -2).addComponent(this.endColumnLabel)).addGap(18, 18, 18).addComponent(this.parseNumbersRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.defaultStartNumberLabel).addComponent(this.defaultStartNumberText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.defaultEndNumberLabel).addComponent(this.defaultEndNumberText, -2, -1, -2)).addGap(33, 33, 33).addComponent(this.parseDatesRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dateFormatComboBox, -2, -1, -2).addComponent(this.dateFormatLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.defaultStartDatePicker, -2, -1, -2).addComponent(this.dateDefaultStartLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dateDefaultEndLabel).addComponent((Component)this.defaultEndDatePicker, -2, -1, -2)).addContainerGap()));
    }

    private void parseNumbersRadioButtonActionPerformed(ActionEvent evt) {
        this.refreshTimeParseMode();
    }

    private void parseDatesRadioButtonActionPerformed(ActionEvent evt) {
        this.refreshTimeParseMode();
    }

    private void startColumnComboBoxActionPerformed(ActionEvent evt) {
        this.refreshOkButton();
    }

    private void endColumnComboBoxActionPerformed(ActionEvent evt) {
        this.refreshOkButton();
    }

    private class ColumnWrapper {
        private final Column column;

        public ColumnWrapper(Column column) {
            this.column = column;
        }

        public String toString() {
            return this.column != null ? this.column.getTitle() : "";
        }
    }
}

