/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.recentfiles;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.gephi.desktop.importer.api.ImportControllerUI;
import org.gephi.desktop.mrufiles.api.MostRecentFiles;
import org.gephi.desktop.project.api.ProjectControllerUI;
import org.openide.awt.DynamicMenuContent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class RecentFiles
extends AbstractAction
implements DynamicMenuContent {
    private static final String GEPHI_EXTENSION = "gephi";

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    public JComponent[] getMenuPresenters() {
        return this.createMenu();
    }

    public JComponent[] synchMenuPresenters(JComponent[] items) {
        return this.createMenu();
    }

    private JComponent[] createMenu() {
        JComponent[] menuItems;
        JMenu menu = new JMenu(NbBundle.getMessage(RecentFiles.class, (String)"CTL_OpenRecentFiles"));
        for (JComponent item : menuItems = this.createSubMenus()) {
            menu.add(item);
        }
        return new JComponent[]{menu};
    }

    private JComponent[] createSubMenus() {
        ArrayList<JMenuItem> items = new ArrayList<JMenuItem>();
        MostRecentFiles mru = (MostRecentFiles)Lookup.getDefault().lookup(MostRecentFiles.class);
        for (String filePath : mru.getMRUFileList()) {
            final File file = new File(filePath);
            if (!file.exists()) continue;
            String fileName = file.getName();
            JMenuItem menuItem = new JMenuItem(new AbstractAction(fileName){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FileObject fileObject = FileUtil.toFileObject((File)file);
                    if (fileObject.hasExt(RecentFiles.GEPHI_EXTENSION)) {
                        ProjectControllerUI pc = (ProjectControllerUI)Lookup.getDefault().lookup(ProjectControllerUI.class);
                        try {
                            pc.openProject(file);
                        }
                        catch (Exception ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    } else {
                        ImportControllerUI importController = (ImportControllerUI)Lookup.getDefault().lookup(ImportControllerUI.class);
                        if (importController.getImportController().isFileSupported(file)) {
                            importController.importFile(fileObject);
                        }
                    }
                }
            });
            items.add(menuItem);
        }
        return items.toArray(new JComponent[0]);
    }
}

