/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.appearance;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import org.gephi.appearance.AttributeFunctionImpl;
import org.gephi.appearance.AttributePartitionImpl;
import org.gephi.appearance.AttributeRankingImpl;
import org.gephi.appearance.DegreeRankingImpl;
import org.gephi.appearance.EdgeTypePartitionImpl;
import org.gephi.appearance.EdgeWeightRankingImpl;
import org.gephi.appearance.FunctionImpl;
import org.gephi.appearance.GraphFunctionImpl;
import org.gephi.appearance.InDegreeRankingImpl;
import org.gephi.appearance.OutDegreeRankingImpl;
import org.gephi.appearance.PartitionImpl;
import org.gephi.appearance.RankingImpl;
import org.gephi.appearance.SimpleFunctionImpl;
import org.gephi.appearance.api.AppearanceModel;
import org.gephi.appearance.api.Function;
import org.gephi.appearance.api.Partition;
import org.gephi.appearance.api.Ranking;
import org.gephi.appearance.spi.PartitionTransformer;
import org.gephi.appearance.spi.RankingTransformer;
import org.gephi.appearance.spi.SimpleTransformer;
import org.gephi.appearance.spi.Transformer;
import org.gephi.appearance.spi.TransformerUI;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.Table;
import org.gephi.project.api.Workspace;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class AppearanceModelImpl
implements AppearanceModel {
    private final Workspace workspace;
    private final GraphModel graphModel;
    private final List<Transformer> nodeTransformers;
    private final List<Transformer> edgeTransformers;
    private final Map<Class, TransformerUI> transformerUIs;
    private final DegreeRankingImpl degreeRanking;
    private final InDegreeRankingImpl inDegreeRanking;
    private final OutDegreeRankingImpl outDegreeRanking;
    private final EdgeWeightRankingImpl edgeWeightRanking;
    private final EdgeTypePartitionImpl edgeTypePartition;
    private final Map<Column, AttributeRankingImpl> nodeAttributeRankings;
    private final Map<Column, AttributeRankingImpl> edgeAttributeRankings;
    private final Map<Column, AttributePartitionImpl> nodeAttributePartitions;
    private final Map<Column, AttributePartitionImpl> edgeAttributePartitions;
    private final List<FunctionImpl> nodeStaticFunctions;
    private final List<FunctionImpl> edgeStaticFunctions;
    private boolean rankingLocalScale = false;
    private boolean partitionLocalScale = false;
    private boolean transformNullValues = false;

    public AppearanceModelImpl(Workspace workspace) {
        this.workspace = workspace;
        this.graphModel = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel(workspace);
        this.transformerUIs = this.initTransformerUIs();
        this.nodeTransformers = this.initNodeTransformers();
        this.edgeTransformers = this.initEdgeTransformers();
        this.degreeRanking = new DegreeRankingImpl(this.graphModel.defaultColumns().degree());
        this.inDegreeRanking = new InDegreeRankingImpl(this.graphModel.defaultColumns().inDegree());
        this.outDegreeRanking = new OutDegreeRankingImpl(this.graphModel.defaultColumns().outDegree());
        this.edgeWeightRanking = new EdgeWeightRankingImpl();
        this.edgeTypePartition = new EdgeTypePartitionImpl(this.graphModel.defaultColumns().edgeType(), this.graphModel.getConfiguration().getEdgeLabelType());
        this.nodeAttributeRankings = new WeakHashMap<Column, AttributeRankingImpl>();
        this.edgeAttributeRankings = new WeakHashMap<Column, AttributeRankingImpl>();
        this.nodeAttributePartitions = new WeakHashMap<Column, AttributePartitionImpl>();
        this.edgeAttributePartitions = new WeakHashMap<Column, AttributePartitionImpl>();
        this.nodeStaticFunctions = this.getNodeSimpleFunctions();
        this.nodeStaticFunctions.addAll(this.getNodeRankingFunctions());
        this.edgeStaticFunctions = this.getEdgeSimpleFunctions();
        this.edgeStaticFunctions.addAll(this.getRankingAndPartitionEdgeFunctions());
        this.initAttributeRankingsAndPartitions();
    }

    protected Graph getRankingGraph() {
        if (this.rankingLocalScale) {
            return this.graphModel.getGraphVisible();
        }
        return this.graphModel.getGraph();
    }

    protected Graph getPartitionGraph() {
        if (this.partitionLocalScale) {
            return this.graphModel.getGraphVisible();
        }
        return this.graphModel.getGraph();
    }

    @Override
    public Function[] getNodeFunctions() {
        ArrayList<FunctionImpl> res = new ArrayList<FunctionImpl>();
        res.addAll(this.nodeStaticFunctions);
        res.addAll(this.getAttributeFunctions(this.graphModel.getNodeTable()));
        return (Function[])res.stream().filter(FunctionImpl::isValid).toArray(Function[]::new);
    }

    @Override
    public Function[] getEdgeFunctions() {
        ArrayList<FunctionImpl> res = new ArrayList<FunctionImpl>();
        res.addAll(this.edgeStaticFunctions);
        res.addAll(this.getAttributeFunctions(this.graphModel.getEdgeTable()));
        return (Function[])res.stream().filter(FunctionImpl::isValid).toArray(Function[]::new);
    }

    @Override
    public Function getNodeFunction(Column column, Class<? extends Transformer> transformer) {
        return this.getFunction(column, transformer);
    }

    @Override
    public Function getEdgeFunction(Column column, Class<? extends Transformer> transformer) {
        return this.getFunction(column, transformer);
    }

    private Function getFunction(Column column, Class<? extends Transformer> transformer) {
        if (column.isProperty()) {
            AppearanceModel.GraphFunction graphFunction = this.convertColumnToGraphFunction(column);
            List<GraphFunctionImpl> funcs = column.getTable().isNodeTable() ? this.getNodeRankingFunctions() : this.getRankingAndPartitionEdgeFunctions();
            return funcs.stream().filter(f -> f.getTransformer().getClass().equals(transformer) && f.getGraphFunction().equals((Object)graphFunction)).filter(FunctionImpl::isValid).findFirst().orElse(null);
        }
        return this.getAttributeFunctions(column.getTable()).stream().filter(f -> f.getTransformer().getClass().equals(transformer) && f.getColumn().equals(column)).filter(FunctionImpl::isValid).findFirst().orElse(null);
    }

    @Override
    public Partition getNodePartition(Column column) {
        return this.initAttributePartition(column);
    }

    @Override
    public Partition getEdgePartition(Column column) {
        return this.initAttributePartition(column);
    }

    protected RankingImpl[] getNodeRankings() {
        ArrayList<RankingImpl> rankings = new ArrayList<RankingImpl>();
        rankings.add(this.degreeRanking);
        rankings.add(this.inDegreeRanking);
        rankings.add(this.outDegreeRanking);
        rankings.addAll(this.nodeAttributeRankings.values());
        return rankings.toArray(new RankingImpl[0]);
    }

    protected RankingImpl[] getEdgeRankings() {
        ArrayList<RankingImpl> rankings = new ArrayList<RankingImpl>();
        rankings.add(this.edgeWeightRanking);
        rankings.addAll(this.edgeAttributeRankings.values());
        return rankings.toArray(new RankingImpl[0]);
    }

    protected PartitionImpl[] getNodePartitions() {
        return this.nodeAttributePartitions.values().toArray(new AttributePartitionImpl[0]);
    }

    protected PartitionImpl[] getEdgePartitions() {
        ArrayList<PartitionImpl> partitions = new ArrayList<PartitionImpl>();
        partitions.add(this.edgeTypePartition);
        partitions.addAll(this.edgeAttributePartitions.values());
        return partitions.toArray(new PartitionImpl[0]);
    }

    protected RankingImpl getDegreeRanking() {
        return this.degreeRanking;
    }

    protected Ranking getInDegreeRanking() {
        return this.inDegreeRanking;
    }

    protected Ranking getOutDegreeRanking() {
        return this.outDegreeRanking;
    }

    protected Ranking getEdgeWeightRanking() {
        return this.edgeWeightRanking;
    }

    protected Partition getEdgeTypePartition() {
        return this.edgeTypePartition;
    }

    protected RankingImpl getNodeRanking(Column column) {
        return this.nodeAttributeRankings.get(column);
    }

    protected Ranking getEdgeRanking(Column column) {
        return this.edgeAttributeRankings.get(column);
    }

    protected int countNodeAttributeRanking() {
        return this.nodeAttributeRankings.size();
    }

    @Override
    public Workspace getWorkspace() {
        return this.workspace;
    }

    @Override
    public boolean isRankingLocalScale() {
        return this.rankingLocalScale;
    }

    public void setRankingLocalScale(boolean localScale) {
        this.rankingLocalScale = localScale;
    }

    @Override
    public boolean isPartitionLocalScale() {
        return this.partitionLocalScale;
    }

    public void setPartitionLocalScale(boolean localScale) {
        this.partitionLocalScale = localScale;
    }

    @Override
    public boolean isTransformNullValues() {
        return this.transformNullValues;
    }

    public void setTransformNullValues(boolean transformNullValues) {
        this.transformNullValues = transformNullValues;
    }

    private List<GraphFunctionImpl> getNodeRankingFunctions() {
        return this.nodeTransformers.stream().filter(t -> t instanceof RankingTransformer).flatMap(t -> this.getDegreeFunctions((Transformer)t).stream()).collect(Collectors.toList());
    }

    private void cleanAttributeRankingsAndPartitions(Table table) {
        if (table.isNodeTable()) {
            this.nodeAttributeRankings.keySet().removeIf(c -> !c.exists());
            this.nodeAttributePartitions.keySet().removeIf(c -> !c.exists());
        } else {
            this.edgeAttributeRankings.keySet().removeIf(c -> !c.exists());
            this.edgeAttributePartitions.keySet().removeIf(c -> !c.exists());
        }
    }

    private List<AttributeFunctionImpl> getAttributeFunctions(Table table) {
        this.cleanAttributeRankingsAndPartitions(table);
        ArrayList<AttributeFunctionImpl> res = new ArrayList<AttributeFunctionImpl>();
        List<Transformer> transformers = table.isNodeTable() ? this.nodeTransformers : this.edgeTransformers;
        for (Column column : table) {
            if (column.isProperty()) continue;
            transformers.forEach(t -> {
                if (column.isNumber() && t instanceof RankingTransformer || t instanceof PartitionTransformer) {
                    res.addAll(this.getAttributeFunctions(column, (Transformer)t));
                }
            });
        }
        return res;
    }

    private List<AttributeFunctionImpl> getAttributeFunctions(Column column, Transformer transformer) {
        ArrayList<AttributeFunctionImpl> res = new ArrayList<AttributeFunctionImpl>();
        if (transformer instanceof RankingTransformer && column.isNumber()) {
            RankingImpl ranking;
            if (transformer.isNode() && column.getTable().isNodeTable()) {
                ranking = this.nodeAttributeRankings.computeIfAbsent(column, k -> new AttributeRankingImpl(column));
                res.add(new AttributeFunctionImpl(this, this.getId("node", transformer, column), column, transformer, this.getTransformerUI(transformer), ranking));
            }
            if (transformer.isEdge() && column.getTable().isEdgeTable()) {
                ranking = this.edgeAttributeRankings.computeIfAbsent(column, k -> new AttributeRankingImpl(column));
                res.add(new AttributeFunctionImpl(this, this.getId("edge", transformer, column), column, transformer, this.getTransformerUI(transformer), ranking));
            }
        }
        if (transformer instanceof PartitionTransformer) {
            PartitionImpl partition;
            if (transformer.isNode() && column.getTable().isNodeTable()) {
                partition = this.nodeAttributePartitions.computeIfAbsent(column, k -> new AttributePartitionImpl(column));
                res.add(new AttributeFunctionImpl(this, this.getId("node", transformer, column), column, transformer, this.getTransformerUI(transformer), partition));
            }
            if (transformer.isEdge() && column.getTable().isEdgeTable()) {
                partition = this.edgeAttributePartitions.computeIfAbsent(column, k -> new AttributePartitionImpl(column));
                res.add(new AttributeFunctionImpl(this, this.getId("edge", transformer, column), column, transformer, this.getTransformerUI(transformer), partition));
            }
        }
        return res;
    }

    private void initAttributeRankingsAndPartitions() {
        for (Column column : this.graphModel.getNodeTable()) {
            if (column.isProperty()) continue;
            if (column.isNumber()) {
                this.nodeAttributeRankings.put(column, new AttributeRankingImpl(column));
            }
            this.nodeAttributePartitions.put(column, new AttributePartitionImpl(column));
        }
        for (Column column : this.graphModel.getEdgeTable()) {
            if (column.isProperty()) continue;
            if (column.isNumber()) {
                this.edgeAttributeRankings.put(column, new AttributeRankingImpl(column));
            }
            this.edgeAttributePartitions.put(column, new AttributePartitionImpl(column));
        }
    }

    private AttributePartitionImpl initAttributePartition(Column column) {
        if (!column.isProperty()) {
            if (column.getTable().isNodeTable()) {
                return this.nodeAttributePartitions.computeIfAbsent(column, k -> new AttributePartitionImpl(column));
            }
            if (column.getTable().isEdgeTable()) {
                return this.edgeAttributePartitions.computeIfAbsent(column, k -> new AttributePartitionImpl(column));
            }
        }
        return null;
    }

    private List<FunctionImpl> getNodeSimpleFunctions() {
        return Lookup.getDefault().lookupAll(Transformer.class).stream().filter(t -> t instanceof SimpleTransformer && t.isNode()).map(t -> new SimpleFunctionImpl(this, this.getId("node", (Transformer)t, "simple"), (Class<? extends Element>)Node.class, (Transformer)t, this.getTransformerUI((Transformer)t))).collect(Collectors.toList());
    }

    private List<FunctionImpl> getEdgeSimpleFunctions() {
        return Lookup.getDefault().lookupAll(Transformer.class).stream().filter(t -> t instanceof SimpleTransformer && t.isEdge()).map(t -> new SimpleFunctionImpl(this, this.getId("edge", (Transformer)t, "simple"), (Class<? extends Element>)Edge.class, (Transformer)t, this.getTransformerUI((Transformer)t))).collect(Collectors.toList());
    }

    private List<GraphFunctionImpl> getDegreeFunctions(Transformer transformer) {
        ArrayList<GraphFunctionImpl> res = new ArrayList<GraphFunctionImpl>();
        TransformerUI transformerUI = this.getTransformerUI(transformer);
        res.add(new GraphFunctionImpl(this, AppearanceModel.GraphFunction.NODE_DEGREE, this.getId("node", transformer, "degree"), NbBundle.getMessage(AppearanceModelImpl.class, (String)"NodeGraphFunction.Degree.name"), Node.class, transformer, transformerUI, (RankingImpl)this.degreeRanking));
        res.add(new GraphFunctionImpl(this, AppearanceModel.GraphFunction.NODE_INDEGREE, this.getId("node", transformer, "indegree"), NbBundle.getMessage(AppearanceModelImpl.class, (String)"NodeGraphFunction.InDegree.name"), Node.class, transformer, transformerUI, (RankingImpl)this.inDegreeRanking));
        res.add(new GraphFunctionImpl(this, AppearanceModel.GraphFunction.NODE_OUTDEGREE, this.getId("node", transformer, "outdegree"), NbBundle.getMessage(AppearanceModelImpl.class, (String)"NodeGraphFunction.OutDegree.name"), Node.class, transformer, transformerUI, (RankingImpl)this.outDegreeRanking));
        return res;
    }

    private List<GraphFunctionImpl> getRankingAndPartitionEdgeFunctions() {
        return this.edgeTransformers.stream().flatMap(t -> {
            ArrayList<GraphFunctionImpl> res = new ArrayList<GraphFunctionImpl>();
            TransformerUI transformerUI = this.getTransformerUI((Transformer)t);
            if (t instanceof RankingTransformer) {
                res.add(new GraphFunctionImpl(this, AppearanceModel.GraphFunction.EDGE_WEIGHT, this.getId("edge", (Transformer)t, "weight"), NbBundle.getMessage(AppearanceModelImpl.class, (String)"EdgeGraphFunction.Weight.name"), (Class<? extends Element>)Edge.class, (Transformer)t, transformerUI, (RankingImpl)this.edgeWeightRanking));
            }
            if (t instanceof PartitionTransformer) {
                res.add(new GraphFunctionImpl(this, AppearanceModel.GraphFunction.EDGE_TYPE, this.getId("edge", (Transformer)t, "type"), NbBundle.getMessage(AppearanceModelImpl.class, (String)"EdgeGraphFunction.Type.name"), (Class<? extends Element>)Edge.class, (Transformer)t, transformerUI, this.edgeTypePartition));
            }
            return res.stream();
        }).collect(Collectors.toList());
    }

    protected TransformerUI getTransformerUI(Transformer transformer) {
        return this.transformerUIs.get(transformer.getClass());
    }

    @Override
    public GraphModel getGraphModel() {
        return this.graphModel;
    }

    private Map<Class, TransformerUI> initTransformerUIs() {
        HashMap<Class, TransformerUI> uis = new HashMap<Class, TransformerUI>();
        for (TransformerUI ui : Lookup.getDefault().lookupAll(TransformerUI.class)) {
            Class transformerClass = ui.getTransformerClass();
            if (transformerClass == null) {
                throw new NullPointerException("Transformer class can' be null");
            }
            if (uis.containsKey(transformerClass)) {
                throw new RuntimeException("A Transformer can't be attach to multiple TransformerUI");
            }
            uis.put(transformerClass, ui);
        }
        return uis;
    }

    private List<Transformer> initNodeTransformers() {
        return Lookup.getDefault().lookupAll(Transformer.class).stream().filter(Transformer::isNode).collect(Collectors.toList());
    }

    private List<Transformer> initEdgeTransformers() {
        return Lookup.getDefault().lookupAll(Transformer.class).stream().filter(Transformer::isEdge).collect(Collectors.toList());
    }

    private AppearanceModel.GraphFunction convertColumnToGraphFunction(Column column) {
        AppearanceModel.GraphFunction graphFunction = null;
        if (column.equals(this.graphModel.defaultColumns().degree())) {
            graphFunction = AppearanceModel.GraphFunction.NODE_DEGREE;
        } else if (column.equals(this.graphModel.defaultColumns().inDegree())) {
            graphFunction = AppearanceModel.GraphFunction.NODE_INDEGREE;
        } else if (column.equals(this.graphModel.defaultColumns().outDegree())) {
            graphFunction = AppearanceModel.GraphFunction.NODE_OUTDEGREE;
        } else if (column.equals(this.graphModel.defaultColumns().edgeType())) {
            graphFunction = AppearanceModel.GraphFunction.EDGE_TYPE;
        } else if (column.getTable().isEdgeTable() && column.getId().equals("weight")) {
            graphFunction = AppearanceModel.GraphFunction.EDGE_WEIGHT;
        }
        return graphFunction;
    }

    private String getId(String prefix, Transformer transformer, Column column) {
        return prefix + "_" + transformer.getClass().getSimpleName() + "_column_" + column.getId();
    }

    private String getId(String prefix, Transformer transformer, String suffix) {
        return prefix + "_" + transformer.getClass().getSimpleName() + "_" + suffix;
    }
}

