/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.exporter.plugin;

import javax.swing.JPanel;
import org.gephi.io.exporter.plugin.ExporterVNA;
import org.gephi.io.exporter.spi.Exporter;
import org.gephi.io.exporter.spi.ExporterUI;
import org.gephi.ui.exporter.plugin.AbstractExporterSettings;
import org.gephi.ui.exporter.plugin.UIExporterVNAPanel;
import org.openide.util.NbBundle;

public class UIExporterVNA
implements ExporterUI {
    UIExporterVNAPanel panel;
    ExporterVNA exporter;
    ExporterVNASettings settings = new ExporterVNASettings();

    public JPanel getPanel() {
        this.panel = new UIExporterVNAPanel();
        return this.panel;
    }

    public void setup(Exporter exporter) {
        this.exporter = (ExporterVNA)exporter;
        this.settings.load(this.exporter);
        this.panel.setup((ExporterVNA)exporter);
    }

    public void unsetup(boolean update) {
        if (update) {
            this.panel.unsetup(this.exporter);
            this.settings.save(this.exporter);
        }
        this.panel = null;
        this.exporter = null;
    }

    public boolean isUIForExporter(Exporter exporter) {
        return exporter instanceof ExporterVNA;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(UIExporterVNA.class, (String)"UIExporterVNA.name");
    }

    private static class ExporterVNASettings
    extends AbstractExporterSettings {
        private static final String EXPORT_EDGE_WEIGHT = "VNA_exportEdgeWeight";
        private static final String EXPORT_COORDINATES = "VNA_exportCoordinates";
        private static final String EXPORT_SIZE = "VNA_exportSize";
        private static final String EXPORT_SHORT_LABEL = "VNA_exportShortLabel";
        private static final String EXPORT_COLOR = "VNA_exportColor";
        private static final String NORMALIZE = "VNA_normalize";
        private static final String EXPORT_ATTRIBUTES = "VNA_exportAttributes";
        private static final ExporterVNA DEFAULT = new ExporterVNA();

        private ExporterVNASettings() {
        }

        private void load(ExporterVNA exporter) {
            exporter.setExportColor(this.get(EXPORT_COLOR, DEFAULT.isExportColor()));
            exporter.setExportCoords(this.get(EXPORT_COORDINATES, DEFAULT.isExportCoords()));
            exporter.setExportEdgeWeight(this.get(EXPORT_EDGE_WEIGHT, DEFAULT.isExportEdgeWeight()));
            exporter.setExportShortLabel(this.get(EXPORT_SHORT_LABEL, DEFAULT.isExportShortLabel()));
            exporter.setExportSize(this.get(EXPORT_SIZE, DEFAULT.isExportSize()));
            exporter.setExportAttributes(this.get(EXPORT_ATTRIBUTES, DEFAULT.isExportAttributes()));
            exporter.setNormalize(this.get(NORMALIZE, DEFAULT.isNormalize()));
        }

        private void save(ExporterVNA exporter) {
            this.put(EXPORT_COLOR, exporter.isExportColor());
            this.put(EXPORT_COORDINATES, exporter.isExportCoords());
            this.put(EXPORT_EDGE_WEIGHT, exporter.isExportEdgeWeight());
            this.put(EXPORT_SHORT_LABEL, exporter.isExportShortLabel());
            this.put(EXPORT_SIZE, exporter.isExportSize());
            this.put(EXPORT_ATTRIBUTES, exporter.isExportAttributes());
            this.put(NORMALIZE, exporter.isNormalize());
        }
    }
}

