/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.exporter.plugin;

import javax.swing.JPanel;
import org.gephi.io.exporter.plugin.ExporterGEXF;
import org.gephi.io.exporter.spi.Exporter;
import org.gephi.io.exporter.spi.ExporterUI;
import org.gephi.ui.exporter.plugin.AbstractExporterSettings;
import org.gephi.ui.exporter.plugin.UIExporterGEXFPanel;
import org.openide.util.NbBundle;

public class UIExporterGEXF
implements ExporterUI {
    private final ExporterGEXFSettings settings = new ExporterGEXFSettings();
    private UIExporterGEXFPanel panel;
    private ExporterGEXF exporterGEXF;

    public void setup(Exporter exporter) {
        this.exporterGEXF = (ExporterGEXF)exporter;
        this.settings.load(this.exporterGEXF);
        this.panel.setup(this.exporterGEXF);
    }

    public void unsetup(boolean update) {
        if (update) {
            this.panel.unsetup(this.exporterGEXF);
            this.settings.save(this.exporterGEXF);
        }
        this.panel = null;
        this.exporterGEXF = null;
    }

    public JPanel getPanel() {
        this.panel = new UIExporterGEXFPanel();
        return this.panel;
    }

    public boolean isUIForExporter(Exporter exporter) {
        return exporter instanceof ExporterGEXF;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(UIExporterGEXF.class, (String)"UIExporterGEXF.name");
    }

    private static class ExporterGEXFSettings
    extends AbstractExporterSettings {
        private static final String NORMALIZE = "GEXF_normalize";
        private static final String EXPORT_COLORS = "GEXF_exportColors";
        private static final String EXPORT_POSITION = "GEXF_exportPosition";
        private static final String EXPORT_ATTRIBUTES = "GEXF_exportAttributes";
        private static final String EXPORT_SIZE = "GEXF_exportSize";
        private static final String EXPORT_DYNAMICS = "GEXF_exportDynamics";
        private static final String EXPORT_META = "GEXF_exportMeta";
        private static final ExporterGEXF DEFAULT = new ExporterGEXF();

        private ExporterGEXFSettings() {
        }

        private void save(ExporterGEXF exporterGEXF) {
            this.put(NORMALIZE, exporterGEXF.isNormalize());
            this.put(EXPORT_COLORS, exporterGEXF.isExportColors());
            this.put(EXPORT_POSITION, exporterGEXF.isExportPosition());
            this.put(EXPORT_SIZE, exporterGEXF.isExportSize());
            this.put(EXPORT_ATTRIBUTES, exporterGEXF.isExportAttributes());
            this.put(EXPORT_DYNAMICS, exporterGEXF.isExportDynamic());
            this.put(EXPORT_META, exporterGEXF.isExportMeta());
        }

        private void load(ExporterGEXF exporterGEXF) {
            exporterGEXF.setNormalize(this.get(NORMALIZE, DEFAULT.isNormalize()));
            exporterGEXF.setExportColors(this.get(EXPORT_COLORS, DEFAULT.isExportColors()));
            exporterGEXF.setExportAttributes(this.get(EXPORT_ATTRIBUTES, DEFAULT.isExportAttributes()));
            exporterGEXF.setExportPosition(this.get(EXPORT_POSITION, DEFAULT.isExportPosition()));
            exporterGEXF.setExportSize(this.get(EXPORT_SIZE, DEFAULT.isExportSize()));
            exporterGEXF.setExportDynamic(this.get(EXPORT_DYNAMICS, DEFAULT.isExportDynamic()));
            exporterGEXF.setExportMeta(this.get(EXPORT_META, DEFAULT.isExportMeta()));
        }
    }
}

