/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.edge;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.features.DashVariant;
import org.freeplane.view.swing.map.MainView;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.NodeView;

public abstract class EdgeView {
    protected static final BasicStroke DEF_STROKE = new BasicStroke();
    static Stroke ECLIPSED_STROKE = null;
    private final NodeView source;
    protected Point start;
    protected Point end;
    private final NodeView target;
    private Color color;
    private Integer width;
    private MainView.ConnectorLocation startConnectorLocation;
    private MainView.ConnectorLocation endConnectorLocation;
    private int[] dash;

    protected static Stroke getEclipsedStroke() {
        if (ECLIPSED_STROKE == null) {
            float[] dash = new float[]{3.0f, 9.0f};
            ECLIPSED_STROKE = new BasicStroke(3.0f, 0, 0, 12.0f, dash, 0.0f);
        }
        return ECLIPSED_STROKE;
    }

    public void setStart(Point start) {
        this.start = start;
    }

    public Point getStart() {
        return this.start;
    }

    public void setEnd(Point end) {
        this.end = end;
    }

    public Point getEnd() {
        return this.end;
    }

    protected void createStart() {
        MainView mainView = this.source.getMainView();
        MainView targetMainView = this.target.getMainView();
        Point relativeLocation = this.source.getRelativeLocation(this.target);
        relativeLocation.x += targetMainView.getWidth() / 2;
        relativeLocation.y += targetMainView.getHeight() / 2;
        this.start = mainView.getConnectorPoint(relativeLocation);
        this.startConnectorLocation = mainView.getConnectorLocation(relativeLocation);
        relativeLocation.x -= targetMainView.getWidth() / 2;
        relativeLocation.y -= targetMainView.getHeight() / 2;
        relativeLocation.x = -relativeLocation.x + mainView.getWidth() / 2;
        relativeLocation.y = -relativeLocation.y + mainView.getHeight() / 2;
        this.end = this.target.getMainView().getConnectorPoint(relativeLocation);
        this.endConnectorLocation = targetMainView.getConnectorLocation(relativeLocation);
    }

    protected MainView.ConnectorLocation getStartConnectorLocation() {
        return this.startConnectorLocation;
    }

    protected MainView.ConnectorLocation getEndConnectorLocation() {
        return this.endConnectorLocation;
    }

    protected Point getControlPoint(MainView.ConnectorLocation startConnectorLocation) {
        int yctrl;
        int xctrl;
        if (MainView.ConnectorLocation.LEFT.equals((Object)startConnectorLocation)) {
            xctrl = -1;
            yctrl = 0;
        } else if (MainView.ConnectorLocation.RIGHT.equals((Object)startConnectorLocation)) {
            xctrl = 1;
            yctrl = 0;
        } else if (MainView.ConnectorLocation.TOP.equals((Object)startConnectorLocation)) {
            xctrl = 0;
            yctrl = -1;
        } else if (MainView.ConnectorLocation.LEFT.equals((Object)startConnectorLocation)) {
            xctrl = 0;
            yctrl = 1;
        } else {
            xctrl = 0;
            yctrl = 0;
        }
        return new Point(xctrl, yctrl);
    }

    protected void align(Point start, Point end) {
        if (1 == Math.abs(start.y - end.y)) {
            end.y = start.y;
        }
    }

    public Color getColor() {
        if (this.color == null) {
            this.color = this.target.getEdgeColor();
        }
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    protected MapView getMap() {
        return this.getTarget().getMap();
    }

    public NodeView getSource() {
        return this.source;
    }

    protected Stroke getStroke() {
        int width = this.getWidth();
        return this.getStroke(width);
    }

    protected Stroke getStroke(float width) {
        int[] dash = this.getDash();
        if (width <= 0.0f && dash == null) {
            return DEF_STROKE;
        }
        int[] dash1 = dash;
        return UITools.createStroke(width * this.getMap().getZoom(), dash1, 1);
    }

    public NodeView getTarget() {
        return this.target;
    }

    public int getWidth() {
        if (this.width != null) {
            return this.width;
        }
        int width = this.target.getEdgeWidth();
        return width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int[] getDash() {
        if (this.dash != null) {
            return this.dash;
        }
        DashVariant dash = this.target.getEdgeDash();
        return dash.variant;
    }

    public void setDash(int[] dash) {
        this.dash = dash;
    }

    protected boolean drawHiddenParentEdge() {
        return false;
    }

    protected abstract void draw(Graphics2D var1);

    public void paint(Graphics2D g) {
        Stroke stroke = g.getStroke();
        Color color = g.getColor();
        this.draw(g);
        g.setStroke(stroke);
        g.setColor(color);
    }

    public EdgeView(NodeView source, NodeView target, Component paintedComponent) {
        this.source = source;
        this.target = target;
        this.createStart();
        UITools.convertPointToAncestor((Component)target.getMainView(), this.end, paintedComponent);
        UITools.convertPointToAncestor((Component)source.getMainView(), this.start, paintedComponent);
        this.align(this.start, this.end);
    }

    public abstract boolean detectCollision(Point var1);
}

