/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.SelectableAction;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.styles.MapStyle;
import org.freeplane.features.styles.MapViewLayout;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.NodeView;

@SelectableAction(checkOnPopup=true)
public class ViewLayoutTypeAction
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;
    private final MapViewLayout layoutType;

    public ViewLayoutTypeAction(MapViewLayout layoutType) {
        super("ViewLayoutTypeAction." + layoutType.toString());
        this.layoutType = layoutType;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        MapView map = (MapView)Controller.getCurrentController().getMapViewManager().getMapViewComponent();
        if (this.isSelected()) {
            map.setLayoutType(MapViewLayout.MAP);
            this.setSelected(false);
        } else {
            map.setLayoutType(this.layoutType);
            this.setSelected(true);
        }
        MapStyle mapStyle = map.getModeController().getExtension(MapStyle.class);
        mapStyle.setMapViewLayout(map.getModel(), map.getLayoutType());
        map.getMapSelection().preserveNodeLocationOnScreen(map.getSelected().getModel(), 0.5f, 0.5f);
        NodeView root = map.getRoot();
        this.invalidate(root);
        root.revalidate();
    }

    private void invalidate(Component c) {
        c.invalidate();
        if (!(c instanceof Container)) {
            return;
        }
        Container c2 = (Container)c;
        for (int i = 0; i < c2.getComponentCount(); ++i) {
            this.invalidate(c2.getComponent(i));
        }
    }

    @Override
    public void setSelected() {
        MapView map = (MapView)Controller.getCurrentController().getMapViewManager().getMapViewComponent();
        this.setSelected(map != null && map.getLayoutType() == this.layoutType);
    }
}

