/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;
import javax.swing.JComponent;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.filter.Filter;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.SummaryLevels;
import org.freeplane.features.nodelocation.LocationModel;
import org.freeplane.view.swing.map.CloudHeightCalculator;
import org.freeplane.view.swing.map.ContentSizeCalculator;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.NodeView;

class VerticalNodeViewLayoutStrategy {
    private static boolean wrongChildComponentsReported = false;
    private int childViewCount;
    private final int spaceAround;
    private final NodeView view;
    private final int[] xCoordinates;
    private final int[] yCoordinates;
    private final boolean[] isChildFreeNode;
    private SummaryLevels viewLevels;
    private int left;
    private int childContentHeight;
    private int top;
    private boolean rightSideCoordinatesAreSet;
    private boolean leftSideCoordinaresAreSet;
    private final boolean allowsCompactLayout;

    public VerticalNodeViewLayoutStrategy(NodeView view, boolean allowsCompactLayout) {
        this.view = view;
        this.childViewCount = view.getComponentCount() - 1;
        this.layoutChildViews(view);
        this.left = 0;
        this.childContentHeight = 0;
        this.top = 0;
        this.rightSideCoordinatesAreSet = false;
        this.leftSideCoordinaresAreSet = false;
        this.xCoordinates = new int[this.childViewCount];
        this.yCoordinates = new int[this.childViewCount];
        this.isChildFreeNode = new boolean[this.childViewCount];
        this.spaceAround = view.getSpaceAround();
        this.allowsCompactLayout = allowsCompactLayout;
    }

    private void layoutChildViews(NodeView view) {
        for (int i = 0; i < this.childViewCount; ++i) {
            Component component = view.getComponent(i);
            if (component instanceof NodeView) {
                ((NodeView)component).validateTree();
                continue;
            }
            this.childViewCount = i;
            if (wrongChildComponentsReported) continue;
            wrongChildComponentsReported = true;
            String wrongChildComponents = Arrays.toString(view.getComponents());
            LogUtils.severe("Unexpected child components:" + wrongChildComponents, new Exception());
        }
    }

    private void setFreeChildNodes(boolean isLeft) {
        for (int i = 0; i < this.childViewCount; ++i) {
            NodeView child = (NodeView)this.view.getComponent(i);
            if (child.isLeft() != isLeft) continue;
            this.isChildFreeNode[i] = child.isFree();
        }
    }

    public void calculateLayoutData() {
        NodeModel node = this.view.getModel();
        MapView map = this.view.getMap();
        Filter filter = map.getFilter();
        NodeModel selectionRoot = map.getRoot().getModel();
        this.viewLevels = this.view.isFolded() ? SummaryLevels.ignoringChildNodes(selectionRoot, node, filter) : SummaryLevels.of(selectionRoot, node, filter);
        for (boolean isLeft : this.viewLevels.sides) {
            this.calculateLayoutData(isLeft);
        }
        this.applyLayoutToChildComponents();
    }

    private void calculateLayoutData(boolean isLeft) {
        this.setFreeChildNodes(isLeft);
        this.calculateLayoutY(isLeft);
        this.calculateLayoutX(isLeft);
    }

    private void calculateLayoutY(boolean isLeft) {
        int minimalDistanceBetweenChildren = this.view.getChildDistanceContainer().getMinimalDistanceBetweenChildren();
        Dimension contentSize = ContentSizeCalculator.INSTANCE.calculateContentSize(this.view);
        int childContentHeightSum = 0;
        int top = 0;
        int level = this.viewLevels.highestSummaryLevel + 1;
        int y = 0;
        int vGap = 0;
        int visibleChildCounter = 0;
        int[] groupStartIndex = new int[level];
        int[] contentHeightSumAtGroupStart = new int[level];
        int[] groupUpperYCoordinate = new int[level];
        int[] groupLowerYCoordinate = new int[level];
        for (int childViewIndex = 0; childViewIndex < this.childViewCount; ++childViewIndex) {
            int childShiftY;
            NodeView child = (NodeView)this.view.getComponent(childViewIndex);
            if (child.isLeft() != isLeft) continue;
            int childHeight = child.getHeight() - 2 * this.spaceAround;
            int oldLevel = level;
            if (childViewIndex >= this.viewLevels.summaryLevels.length) {
                String errorMessage = "Bad node view child components: missing node for component " + childViewIndex;
                UITools.errorMessage(errorMessage);
                System.err.println(errorMessage);
                for (int i = 0; i < this.view.getComponentCount(); ++i) {
                    Component component = this.view.getComponent(i);
                    System.err.println(component);
                }
            }
            level = this.viewLevels.summaryLevels[childViewIndex];
            boolean isFreeNode = child.isFree();
            boolean isItem = level == 0;
            int childCloudHeigth = CloudHeightCalculator.INSTANCE.getAdditionalCloudHeigth(child);
            int childContentHeight = child.getContent().getHeight() + childCloudHeigth;
            int n = childShiftY = child.isContentVisible() ? child.getShift() : 0;
            if (isItem) {
                int childContentShift = child.getContent().getY() - childCloudHeigth / 2 - this.spaceAround;
                if (isFreeNode) {
                    this.yCoordinates[childViewIndex] = childShiftY - childContentShift - childCloudHeigth / 2 - this.spaceAround;
                } else {
                    if (childHeight != 0 && visibleChildCounter > 0) {
                        childContentHeightSum += vGap;
                    }
                    if (!(childShiftY >= 0 && visibleChildCounter != 0 || this.allowsCompactLayout)) {
                        top += childShiftY;
                    }
                    top += -childContentShift + child.getTopOverlap();
                    y -= child.getTopOverlap();
                    if (childShiftY < 0 && !this.allowsCompactLayout) {
                        this.yCoordinates[childViewIndex] = y;
                        y -= childShiftY;
                    } else {
                        if (visibleChildCounter > 0 || this.allowsCompactLayout) {
                            y += childShiftY;
                        }
                        this.yCoordinates[childViewIndex] = y;
                    }
                    int summaryNodeIndex = this.viewLevels.findSummaryNodeIndex(childViewIndex);
                    if (summaryNodeIndex == -1 || summaryNodeIndex - 1 == childViewIndex) {
                        vGap = minimalDistanceBetweenChildren;
                    } else if (childHeight != 0) {
                        vGap = this.summarizedNodeDistance(minimalDistanceBetweenChildren);
                    }
                    if (childHeight != 0) {
                        y += childHeight + vGap - child.getBottomOverlap();
                    }
                    childContentHeightSum += childContentHeight;
                    if (oldLevel > 0) {
                        for (int j = 0; j < oldLevel; ++j) {
                            groupStartIndex[j] = childViewIndex;
                            groupUpperYCoordinate[j] = Integer.MAX_VALUE;
                            groupLowerYCoordinate[j] = Integer.MIN_VALUE;
                            contentHeightSumAtGroupStart[j] = childContentHeightSum;
                        }
                    } else if (child.isFirstGroupNode()) {
                        contentHeightSumAtGroupStart[0] = childContentHeightSum;
                        groupStartIndex[0] = childViewIndex;
                    }
                }
                if (childHeight != 0) {
                    ++visibleChildCounter;
                }
            } else {
                int summaryY;
                int itemLevel = level - 1;
                if (child.isFirstGroupNode()) {
                    contentHeightSumAtGroupStart[level] = contentHeightSumAtGroupStart[itemLevel];
                    groupStartIndex[level] = groupStartIndex[itemLevel];
                }
                if (groupUpperYCoordinate[itemLevel] == Integer.MAX_VALUE) {
                    groupUpperYCoordinate[itemLevel] = y;
                    groupLowerYCoordinate[itemLevel] = y;
                }
                this.yCoordinates[childViewIndex] = summaryY = (groupUpperYCoordinate[itemLevel] + groupLowerYCoordinate[itemLevel]) / 2 - childContentHeight / 2 + childShiftY - (child.getContent().getY() - childCloudHeigth / 2 - this.spaceAround);
                if (!isFreeNode) {
                    int deltaY = summaryY - groupUpperYCoordinate[itemLevel] + child.getTopOverlap();
                    if (deltaY < 0) {
                        top += deltaY;
                        y -= deltaY;
                        summaryY -= deltaY;
                        for (int j = groupStartIndex[itemLevel]; j <= childViewIndex; ++j) {
                            NodeView groupItem = (NodeView)this.view.getComponent(j);
                            if (groupItem.isLeft() != isLeft || this.viewLevels.summaryLevels[j] <= 0 && this.isChildFreeNode[j]) continue;
                            int n2 = j;
                            this.yCoordinates[n2] = this.yCoordinates[n2] - deltaY;
                        }
                    }
                    if (childHeight != 0) {
                        summaryY += childHeight + minimalDistanceBetweenChildren - child.getBottomOverlap();
                    }
                    y = Math.max(y, summaryY);
                }
            }
            if (isItem && isFreeNode) continue;
            int childUpperCoordinate = this.yCoordinates[childViewIndex] + child.getTopOverlap();
            int childBottomCoordinate = this.yCoordinates[childViewIndex] + childHeight - child.getBottomOverlap();
            if (child.isFirstGroupNode()) {
                if (isItem) {
                    groupUpperYCoordinate[level] = Integer.MAX_VALUE;
                    groupLowerYCoordinate[level] = Integer.MIN_VALUE;
                    continue;
                }
                groupUpperYCoordinate[level] = childUpperCoordinate;
                groupLowerYCoordinate[level] = childBottomCoordinate;
                continue;
            }
            if (childHeight == 0 && !this.isNextNodeSummaryNode(childViewIndex)) continue;
            groupUpperYCoordinate[level] = Math.min(groupUpperYCoordinate[level], childUpperCoordinate);
            groupLowerYCoordinate[level] = Math.max(childBottomCoordinate, groupLowerYCoordinate[level]);
        }
        this.calculateRelativeCoordinatesForContentAndBothSides(isLeft, childContentHeightSum, top += (contentSize.height - childContentHeightSum) / 2);
    }

    private boolean isNextNodeSummaryNode(int childViewIndex) {
        return childViewIndex + 1 < this.viewLevels.summaryLevels.length && this.viewLevels.summaryLevels[childViewIndex + 1] > 0;
    }

    private int summarizedNodeDistance(int distance) {
        int defaultVGap = this.view.getMap().getZoomed(LocationModel.DEFAULT_VGAP.toBaseUnits());
        if (defaultVGap >= distance) {
            return distance;
        }
        return defaultVGap + (distance - defaultVGap) / 6;
    }

    private void calculateLayoutX(boolean isLeft) {
        Dimension contentSize = ContentSizeCalculator.INSTANCE.calculateContentSize(this.view);
        int level = this.viewLevels.highestSummaryLevel + 1;
        int[] summaryBaseX = new int[level];
        for (int i = 0; i < this.childViewCount; ++i) {
            int x;
            boolean isItem;
            NodeView child = (NodeView)this.view.getComponent(i);
            if (child.isLeft() != isLeft) continue;
            int oldLevel = level;
            level = this.viewLevels.summaryLevels[i];
            boolean isFreeNode = child.isFree();
            boolean bl = isItem = level == 0;
            int childHGap = child.isContentVisible() ? child.getHGap() : (child.isSummary() ? child.getZoomed(LocationModel.DEFAULT_HGAP_PX * 7 / 12) : 0);
            if (this.view.getModel().isHiddenSummary() && !child.getModel().isHiddenSummary()) {
                childHGap -= child.getZoomed(LocationModel.DEFAULT_HGAP_PX * 7 / 12);
            }
            if (isItem) {
                if (!isFreeNode && (oldLevel > 0 || child.isFirstGroupNode())) {
                    summaryBaseX[0] = 0;
                }
            } else if (child.isFirstGroupNode()) {
                summaryBaseX[level] = 0;
            }
            int baseX = level > 0 ? summaryBaseX[level - 1] : (child.isLeft() != (isItem && isFreeNode) ? 0 : contentSize.width);
            if (child.isLeft()) {
                x = baseX - childHGap - child.getContent().getX() - child.getContent().getWidth();
                summaryBaseX[level] = Math.min(summaryBaseX[level], x + this.spaceAround);
            } else {
                x = baseX + childHGap - child.getContent().getX();
                summaryBaseX[level] = Math.max(summaryBaseX[level], x + child.getWidth() - this.spaceAround);
            }
            this.left = Math.min(this.left, x);
            this.xCoordinates[i] = x;
        }
    }

    private void calculateRelativeCoordinatesForContentAndBothSides(boolean isLeft, int childContentHeightOnSide, int topOnSide) {
        if (!this.leftSideCoordinaresAreSet && !this.rightSideCoordinatesAreSet) {
            this.childContentHeight = childContentHeightOnSide;
            this.top = topOnSide;
        } else {
            boolean changeLeft;
            this.childContentHeight = Math.max(this.childContentHeight, childContentHeightOnSide);
            int deltaTop = topOnSide - this.top;
            if (deltaTop < 0) {
                this.top = topOnSide;
                changeLeft = !isLeft;
                deltaTop = -deltaTop;
            } else {
                changeLeft = isLeft;
            }
            for (int i = 0; i < this.childViewCount; ++i) {
                NodeView child = (NodeView)this.view.getComponent(i);
                if (child.isLeft() != changeLeft || this.viewLevels.summaryLevels[i] <= 0 && this.isChildFreeNode[i]) continue;
                int n = i;
                this.yCoordinates[n] = this.yCoordinates[n] + deltaTop;
            }
        }
        if (isLeft) {
            this.leftSideCoordinaresAreSet = true;
        } else {
            this.rightSideCoordinatesAreSet = true;
        }
    }

    private void applyLayoutToChildComponents() {
        JComponent content = this.view.getContent();
        int spaceAround = this.view.getSpaceAround();
        int contentX = Math.max(spaceAround, -this.left);
        int cloudHeight = CloudHeightCalculator.INSTANCE.getAdditionalCloudHeigth(this.view);
        int contentY = spaceAround + cloudHeight / 2 - Math.min(0, this.top);
        content.setVisible(this.view.isContentVisible());
        int baseY = contentY - spaceAround + this.top;
        int minY = 0;
        for (int i = 0; i < this.childViewCount; ++i) {
            minY = this.viewLevels.summaryLevels[i] == 0 && this.isChildFreeNode[i] ? Math.min(minY, contentY + this.yCoordinates[i]) : Math.min(minY, baseY + this.yCoordinates[i]);
        }
        if (minY < 0) {
            contentY -= minY;
            baseY -= minY;
        }
        Dimension contentSize = ContentSizeCalculator.INSTANCE.calculateContentSize(this.view);
        int width = contentX + contentSize.width + spaceAround;
        int height = contentY + contentSize.height + cloudHeight / 2 + spaceAround;
        content.setBounds(contentX, contentY, contentSize.width, contentSize.height);
        int topOverlap = -minY;
        int heigthWithoutOverlap = height;
        for (int i = 0; i < this.childViewCount; ++i) {
            int y;
            NodeView child = (NodeView)this.view.getComponent(i);
            if (this.viewLevels.summaryLevels[i] == 0 && this.isChildFreeNode[i]) {
                y = contentY + this.yCoordinates[i];
            } else {
                y = baseY + this.yCoordinates[i];
                if (!this.isChildFreeNode[i]) {
                    heigthWithoutOverlap = Math.max(heigthWithoutOverlap, y + child.getHeight() + cloudHeight / 2 - child.getBottomOverlap());
                }
            }
            int x = contentX + this.xCoordinates[i];
            child.setLocation(x, y);
            width = Math.max(width, child.getX() + child.getWidth());
            height = Math.max(height, y + child.getHeight() + cloudHeight / 2);
        }
        this.view.setSize(width, height);
        this.view.setTopOverlap(topOverlap);
        this.view.setBottomOverlap(height - heigthWithoutOverlap);
    }
}

