/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import org.freeplane.features.map.IMapSelection;

enum ScrollingDirective {
    SCROLL_NODE_TO_CENTER(IMapSelection.NodePosition.CENTER),
    SCROLL_NODE_TO_LEFT_MARGIN(IMapSelection.NodePosition.LEFT),
    SCROLL_NODE_TO_RIGHT_MARGIN(IMapSelection.NodePosition.RIGHT),
    SCROLL_NODE_TO_TOP_MARGIN(IMapSelection.NodePosition.TOP),
    SCROLL_NODE_TO_BOTTOM_MARGIN(IMapSelection.NodePosition.BOTTOM),
    SCROLL_NODE_TO_TOP_LEFT_CORNER(IMapSelection.NodePosition.TOP_LEFT),
    SCROLL_NODE_TO_TOP_RIGHT_CORNER(IMapSelection.NodePosition.TOP_RIGHT),
    SCROLL_NODE_TO_BOTTOM_LEFT_CORNER(IMapSelection.NodePosition.BOTTOM_LEFT),
    SCROLL_NODE_TO_BOTTOM_RIGHT_CORNER(IMapSelection.NodePosition.BOTTOM_RIGHT),
    SCROLL_TO_BEST_ROOT_POSITION,
    MAKE_NODE_VISIBLE,
    DONE,
    ANCHOR;


    public static ScrollingDirective of(IMapSelection.NodePosition position) {
        return CompanionObject.positionDirectiveMapping[position.ordinal()];
    }

    private ScrollingDirective() {
    }

    private ScrollingDirective(IMapSelection.NodePosition position) {
        CompanionObject.positionDirectiveMapping[position.ordinal()] = this;
    }

    private static class CompanionObject {
        private static final ScrollingDirective[] positionDirectiveMapping = new ScrollingDirective[IMapSelection.NodePosition.values().length];

        private CompanionObject() {
        }
    }
}

