/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.lang.ref.WeakReference;
import javax.swing.FocusManager;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPopupMenu;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.resources.IFreeplanePropertyListener;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.MouseInsideListener;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.features.map.IMapChangeListener;
import org.freeplane.features.map.INodeSelectionListener;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.NodeDeletionEvent;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.NodeMoveEvent;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.view.swing.map.NodeView;

public class NodeTooltipManager
implements IExtension {
    private static final String TOOL_TIP_MANAGER = "toolTipManager.";
    private static final String TOOL_TIP_MANAGER_INITIAL_DELAY = "toolTipManager.initialDelay";
    private static final String RESOURCES_SHOW_NODE_TOOLTIPS = "show_node_tooltips";
    private final Timer enterTimer = new Timer(750, new insideTimerAction());
    private final Timer exitTimer;
    private String toolTipText;
    private JComponent insideComponent;
    private MouseEvent mouseEvent;
    private JPopupMenu tipPopup;
    private JToolTip tip;
    private final ComponentMouseListener componentMouseListener;
    private WeakReference<Component> focusOwnerRef;
    private boolean mouseOverComponent;
    private MouseInsideListener mouseInsideTooltipListener;

    public static NodeTooltipManager getSharedInstance(ModeController modeController) {
        final NodeTooltipManager instance = modeController.getExtension(NodeTooltipManager.class);
        if (instance != null) {
            return instance;
        }
        instance = new NodeTooltipManager();
        NodeTooltipManager.setTooltipDelays(instance);
        UIManager.put("PopupMenu.consumeEventOnClose", Boolean.FALSE);
        ResourceController.getResourceController().addPropertyChangeListener(new IFreeplanePropertyListener(){

            @Override
            public void propertyChanged(String propertyName, String newValue, String oldValue) {
                if (propertyName.startsWith(NodeTooltipManager.TOOL_TIP_MANAGER)) {
                    NodeTooltipManager.setTooltipDelays(instance);
                }
            }
        });
        IMapChangeListener mapChangeListener = new IMapChangeListener(){

            @Override
            public void onNodeDeleted(NodeDeletionEvent nodeDeletionEvent) {
                instance.hideTipWindow();
            }

            @Override
            public void onNodeInserted(NodeModel parent, NodeModel child, int newIndex) {
                instance.hideTipWindow();
            }

            @Override
            public void onNodeMoved(NodeMoveEvent nodeMoveEvent) {
                instance.hideTipWindow();
            }
        };
        MapController mapController = modeController.getMapController();
        mapController.addUIMapChangeListener(mapChangeListener);
        INodeSelectionListener nodeSelectionListener = new INodeSelectionListener(){

            @Override
            public void onSelect(NodeModel node) {
                NodeView view = (NodeView)SwingUtilities.getAncestorOfClass(NodeView.class, instance.insideComponent);
                if (view != null && node.equals(view.getModel())) {
                    return;
                }
                instance.hideTipWindow();
            }

            @Override
            public void onDeselect(NodeModel node) {
            }
        };
        mapController.addNodeSelectionListener(nodeSelectionListener);
        modeController.addExtension(NodeTooltipManager.class, instance);
        return instance;
    }

    private static void setTooltipDelays(NodeTooltipManager instance) {
        int initialDelay = ResourceController.getResourceController().getIntProperty(TOOL_TIP_MANAGER_INITIAL_DELAY, 0);
        instance.setInitialDelay(initialDelay);
    }

    private NodeTooltipManager() {
        this.enterTimer.setRepeats(false);
        this.exitTimer = new Timer(150, new exitTimerAction());
        this.exitTimer.setRepeats(false);
        this.componentMouseListener = new ComponentMouseListener();
        this.mouseOverComponent = false;
    }

    public void setInitialDelay(int milliseconds) {
        this.enterTimer.setInitialDelay(milliseconds);
    }

    public int getInitialDelay() {
        return this.enterTimer.getInitialDelay();
    }

    private void showTipWindow() {
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (this.insideComponent == null || !this.insideComponent.isShowing() || focusOwner == null) {
            return;
        }
        this.tip = this.insideComponent.createToolTip();
        this.tip.setTipText(this.toolTipText);
        this.focusOwnerRef = new WeakReference<Component>(focusOwner);
        this.tipPopup = new JPopupMenu();
        this.tipPopup.setLayout(new GridLayout(1, 1));
        this.tipPopup.add(this.tip);
        this.mouseInsideTooltipListener = new MouseInsideListener(this.tipPopup);
        Rectangle desktopBounds = UITools.getAvailableScreenBounds(this.insideComponent);
        Dimension popupPreferredSize = this.tipPopup.getPreferredSize();
        Point desiredLocation = new Point(0, this.insideComponent.getHeight());
        SwingUtilities.convertPointToScreen(desiredLocation, this.insideComponent);
        int popupAllowedHeight = desktopBounds.y + desktopBounds.height - desiredLocation.y;
        if (popupAllowedHeight > 0) {
            Dimension popupSize = new Dimension(popupPreferredSize.width, Math.min(popupAllowedHeight, popupPreferredSize.height));
            this.tipPopup.setPreferredSize(popupSize);
            this.tipPopup.show(this.insideComponent, 0, this.insideComponent.getHeight());
            focusOwner.requestFocusInWindow();
            this.exitTimer.start();
        }
    }

    private void hideTipWindow() {
        this.insideComponent = null;
        this.toolTipText = null;
        this.mouseEvent = null;
        if (this.tipPopup != null && this.tip != null) {
            Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            Component component = focusOwner != null && SwingUtilities.isDescendingFrom(focusOwner, this.tip) ? (Component)this.focusOwnerRef.get() : null;
            this.tipPopup.setVisible(false);
            if (component != null) {
                component.requestFocusInWindow();
            }
            this.tipPopup = null;
            this.mouseInsideTooltipListener = null;
            this.tip = null;
            this.focusOwnerRef = null;
            this.enterTimer.stop();
            this.exitTimer.stop();
        }
    }

    public void registerComponent(JComponent component) {
        component.removeMouseListener(this.componentMouseListener);
        component.removeMouseMotionListener(this.componentMouseListener);
        component.addMouseListener(this.componentMouseListener);
        component.addMouseMotionListener(this.componentMouseListener);
    }

    public void unregisterComponent(JComponent component) {
        component.removeMouseListener(this.componentMouseListener);
    }

    private void initiateToolTip(MouseEvent event) {
        JComponent component = (JComponent)event.getSource();
        Window focusedWindow = FocusManager.getCurrentManager().getFocusedWindow();
        if (focusedWindow == null) {
            return;
        }
        ModeController mc = Controller.getCurrentController().getModeController();
        JPopupMenu popupmenu = mc.getUserInputListenerFactory().getNodePopupMenu();
        if (popupmenu.isShowing()) {
            return;
        }
        if (this.insideComponent == component) {
            this.mouseOverComponent = true;
            return;
        }
        this.hideTipWindow();
        this.insideComponent = component;
        this.mouseEvent = event;
        if (ResourceController.getResourceController().getBooleanProperty(RESOURCES_SHOW_NODE_TOOLTIPS)) {
            this.enterTimer.restart();
        }
    }

    protected boolean isMouseOverComponent() {
        return this.mouseOverComponent;
    }

    private class insideTimerAction
    implements ActionListener {
        private insideTimerAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (NodeTooltipManager.this.insideComponent != null) {
                if (NodeTooltipManager.this.isMouseOverComponent() && !this.editorActive()) {
                    if (NodeTooltipManager.this.toolTipText == null && NodeTooltipManager.this.mouseEvent != null) {
                        NodeTooltipManager.this.toolTipText = NodeTooltipManager.this.insideComponent.getToolTipText(NodeTooltipManager.this.mouseEvent);
                    }
                    if (NodeTooltipManager.this.toolTipText != null) {
                        NodeTooltipManager.this.showTipWindow();
                        return;
                    }
                }
                NodeTooltipManager.this.hideTipWindow();
            }
        }

        private boolean editorActive() {
            return KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner() instanceof JTextComponent;
        }
    }

    private class exitTimerAction
    implements ActionListener {
        private exitTimerAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (NodeTooltipManager.this.tip == null || NodeTooltipManager.this.insideComponent == null) {
                return;
            }
            KeyboardFocusManager currentKeyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            Window activeWindow = currentKeyboardFocusManager.getActiveWindow();
            if (activeWindow instanceof JDialog && ((JDialog)activeWindow).isModal() && !this.isCurrentMapWindowActive(activeWindow)) {
                NodeTooltipManager.this.hideTipWindow();
                return;
            }
            if (this.isMouseOverTip() || NodeTooltipManager.this.isMouseOverComponent()) {
                NodeTooltipManager.this.exitTimer.restart();
                return;
            }
            Component focusOwner = currentKeyboardFocusManager.getFocusOwner();
            if (focusOwner != null && SwingUtilities.isDescendingFrom(focusOwner, NodeTooltipManager.this.tip)) {
                NodeTooltipManager.this.exitTimer.restart();
                return;
            }
            NodeTooltipManager.this.hideTipWindow();
        }

        private boolean isCurrentMapWindowActive(Window activeWindow) {
            JComponent mapViewComponent = Controller.getCurrentController().getMapViewManager().getMapViewComponent();
            return mapViewComponent != null && SwingUtilities.isDescendingFrom(mapViewComponent, activeWindow);
        }

        protected boolean isMouseOverTip() {
            return NodeTooltipManager.this.mouseInsideTooltipListener.isMouseInside();
        }
    }

    private class ComponentMouseListener
    extends MouseAdapter
    implements MouseMotionListener {
        private ComponentMouseListener() {
        }

        @Override
        public void mouseEntered(MouseEvent event) {
            NodeTooltipManager.this.initiateToolTip(event);
        }

        @Override
        public void mouseMoved(MouseEvent event) {
            NodeTooltipManager.this.initiateToolTip(event);
        }

        @Override
        public void mouseExited(MouseEvent event) {
            if (NodeTooltipManager.this.insideComponent == event.getComponent()) {
                NodeTooltipManager.this.mouseOverComponent = false;
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            NodeTooltipManager.this.hideTipWindow();
        }
    }
}

