/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.applet;

import javax.swing.JPopupMenu;
import org.freeplane.core.ui.components.FreeplaneToolBar;
import org.freeplane.core.ui.components.resizer.UIComponentVisibilityDispatcher;
import org.freeplane.core.ui.menubuilders.generic.PhaseProcessor;
import org.freeplane.features.attribute.AttributeController;
import org.freeplane.features.clipboard.ClipboardControllers;
import org.freeplane.features.cloud.CloudController;
import org.freeplane.features.edge.EdgeController;
import org.freeplane.features.encrypt.EncryptionController;
import org.freeplane.features.explorer.MapExplorerController;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.filter.hidden.HiddenNodeContoller;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.map.FoldingController;
import org.freeplane.features.map.FreeNode;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.SummaryNode;
import org.freeplane.features.mapio.MapIO;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.nodelocation.LocationController;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.note.NoteController;
import org.freeplane.features.styles.AutomaticLayoutController;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.MapStyle;
import org.freeplane.features.text.TextController;
import org.freeplane.features.url.UrlManager;
import org.freeplane.main.applet.BModeController;
import org.freeplane.main.applet.BToolbarContributor;
import org.freeplane.view.swing.features.filepreview.ViewerController;
import org.freeplane.view.swing.ui.UserInputListenerFactory;

public class BModeControllerFactory {
    private static BModeController modeController;

    public static BModeController createModeController() {
        Controller controller = Controller.getCurrentController();
        modeController = new BModeController(controller);
        UserInputListenerFactory userInputListenerFactory = new UserInputListenerFactory(modeController);
        modeController.setUserInputListenerFactory(userInputListenerFactory);
        controller.addModeController(modeController);
        controller.selectModeForBuild(modeController);
        ClipboardControllers.install(new ClipboardControllers());
        new MapController(modeController);
        new IconController(modeController).install(modeController);
        UrlManager.install(new UrlManager());
        MapIO.install(modeController);
        AttributeController.install(new AttributeController(modeController));
        NodeStyleController.install(new NodeStyleController(modeController));
        EdgeController.install(new EdgeController(modeController));
        CloudController.install(new CloudController(modeController));
        NoteController.install(new NoteController());
        new TextController(modeController).install(modeController);
        MapExplorerController.install(modeController);
        LinkController.install(new LinkController(modeController));
        LogicalStyleController.install(new LogicalStyleController(modeController));
        LocationController.install(new LocationController());
        SummaryNode.install();
        FreeNode.install();
        MapStyle.install(true);
        BToolbarContributor toolbarContributor = new BToolbarContributor();
        modeController.addUiBuilder(PhaseProcessor.Phase.ACTIONS, "main_toolbar_url", toolbarContributor);
        controller.getMapViewManager().addMapViewChangeListener(toolbarContributor);
        userInputListenerFactory.setNodePopupMenu(new JPopupMenu());
        FreeplaneToolBar toolBar = new FreeplaneToolBar("main_toolbar", 0);
        UIComponentVisibilityDispatcher.install(toolBar, "toolbarVisible");
        userInputListenerFactory.addToolBar("/main_toolbar", 0, toolBar);
        userInputListenerFactory.addToolBar("/filter_toolbar", FilterController.TOOLBAR_SIDE, FilterController.getController(controller).getFilterToolbar());
        userInputListenerFactory.addToolBar("/status", 3, controller.getViewController().getStatusBar());
        FoldingController.install(new FoldingController());
        new ViewerController();
        EncryptionController.install(new EncryptionController(modeController));
        new AutomaticLayoutController();
        HiddenNodeContoller.install(modeController);
        return modeController;
    }
}

