/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.text;

import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.XmlUtils;

public class RichTextModel {
    private String contentType = null;
    private String text = null;
    private String xml = null;

    public RichTextModel() {
    }

    public RichTextModel(String contentType, String text, String xml) {
        this.contentType = contentType;
        this.text = text;
        this.xml = xml;
    }

    public String getText() {
        return this.text;
    }

    public String getXml() {
        return this.xml;
    }

    public final void setText(String newText) {
        if (newText == null) {
            this.xml = null;
            this.text = null;
            return;
        }
        try {
            this.text = XmlUtils.replaceAscii0BySpace(newText);
            this.xml = HtmlUtils.toXhtml(this.text);
            if (this.xml != null && !this.xml.startsWith("<")) {
                this.text = this.xml;
            }
        }
        catch (Exception e) {
            this.text = this.xml = HtmlUtils.unescapeHTMLUnicodeEntity(newText);
        }
    }

    public final void setXml(String pXmlNoteText) {
        if (pXmlNoteText == null) {
            this.xml = null;
            this.text = null;
            return;
        }
        this.xml = XmlUtils.replaceAscii0BySpace(pXmlNoteText);
        this.text = HtmlUtils.toHtml(this.xml);
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String format) {
        this.contentType = format;
    }

    public boolean isEmpty() {
        return this.contentType == null && this.text == null && this.xml == null;
    }

    public String getTextOr(String fallback) {
        return this.text == null ? fallback : this.text;
    }
}

